"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from typing import Literal, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


CnameStatus = Literal[
    "unknown",
    "verified",
    "failed",
]
r"""Whether all of the required CNAME records are set. Possible values: \"unknown\", \"verified\", \"failed\" """


DNSResults = Literal[
    "verified",
    "failed",
]
r"""Verification statuses for the domain and CNAME records. Possible types: \"verified\", \"failed\" """


DomainVerificationStatus = Literal[
    "unknown",
    "verified",
    "failed",
]
r"""Whether the domain verification record is valid. Possible values: \"unknown\", \"verified\", \"failed\" """


ForwardingStatus = Literal[
    "unknown",
    "waiting",
    "verified",
    "failed",
]
r"""Status of email forwarding. Possible values: \"unknown\", \"waiting\", \"verified\", or \"failed\" """


SpfStatus = Literal[
    "unknown",
    "verified",
    "failed",
]
r"""Whether the SPF record is set up correctly. Possible values: \"unknown\", \"verified\", \"failed\" """


class SupportAddressObjectTypedDict(TypedDict):
    email: str
    r"""The email address. You can't change the email address of an existing support address."""
    brand_id: NotRequired[int]
    r"""The ID of the [brand](/api-reference/ticketing/account-configuration/brands/)"""
    cname_status: NotRequired[CnameStatus]
    r"""Whether all of the required CNAME records are set. Possible values: \"unknown\", \"verified\", \"failed\" """
    created_at: NotRequired[datetime]
    r"""When the address was created"""
    default: NotRequired[bool]
    r"""Whether the address is the account's default support address"""
    dns_results: NotRequired[DNSResults]
    r"""Verification statuses for the domain and CNAME records. Possible types: \"verified\", \"failed\" """
    domain_verification_code: NotRequired[str]
    r"""Verification string to be added as a TXT record to the domain. Possible types: string or null."""
    domain_verification_status: NotRequired[DomainVerificationStatus]
    r"""Whether the domain verification record is valid. Possible values: \"unknown\", \"verified\", \"failed\" """
    forwarding_status: NotRequired[ForwardingStatus]
    r"""Status of email forwarding. Possible values: \"unknown\", \"waiting\", \"verified\", or \"failed\" """
    id: NotRequired[int]
    r"""Automatically assigned when created"""
    name: NotRequired[str]
    r"""The name for the address"""
    spf_status: NotRequired[SpfStatus]
    r"""Whether the SPF record is set up correctly. Possible values: \"unknown\", \"verified\", \"failed\" """
    updated_at: NotRequired[datetime]
    r"""When the address was updated"""


class SupportAddressObject(BaseModel):
    email: str
    r"""The email address. You can't change the email address of an existing support address."""

    brand_id: Optional[int] = None
    r"""The ID of the [brand](/api-reference/ticketing/account-configuration/brands/)"""

    cname_status: Optional[CnameStatus] = None
    r"""Whether all of the required CNAME records are set. Possible values: \"unknown\", \"verified\", \"failed\" """

    created_at: Optional[datetime] = None
    r"""When the address was created"""

    default: Optional[bool] = None
    r"""Whether the address is the account's default support address"""

    dns_results: Optional[DNSResults] = None
    r"""Verification statuses for the domain and CNAME records. Possible types: \"verified\", \"failed\" """

    domain_verification_code: Optional[str] = None
    r"""Verification string to be added as a TXT record to the domain. Possible types: string or null."""

    domain_verification_status: Optional[DomainVerificationStatus] = None
    r"""Whether the domain verification record is valid. Possible values: \"unknown\", \"verified\", \"failed\" """

    forwarding_status: Optional[ForwardingStatus] = None
    r"""Status of email forwarding. Possible values: \"unknown\", \"waiting\", \"verified\", or \"failed\" """

    id: Optional[int] = None
    r"""Automatically assigned when created"""

    name: Optional[str] = None
    r"""The name for the address"""

    spf_status: Optional[SpfStatus] = None
    r"""Whether the SPF record is set up correctly. Possible values: \"unknown\", \"verified\", \"failed\" """

    updated_at: Optional[datetime] = None
    r"""When the address was updated"""
