"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .attachmentobject import AttachmentObject, AttachmentObjectTypedDict
from .viaobject import ViaObject, ViaObjectTypedDict
from datetime import datetime
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


class SuspendedTicketObjectAuthorTypedDict(TypedDict):
    r"""The author id (if available), name and email"""

    email: NotRequired[str]
    r"""The author email"""
    id: NotRequired[int]
    r"""The author id"""
    name: NotRequired[str]
    r"""The author name"""


class SuspendedTicketObjectAuthor(BaseModel):
    r"""The author id (if available), name and email"""

    email: Optional[str] = None
    r"""The author email"""

    id: Optional[int] = None
    r"""The author id"""

    name: Optional[str] = None
    r"""The author name"""


class ErrorMessageTypedDict(TypedDict):
    pass


class ErrorMessage(BaseModel):
    pass


class SuspendedTicketObjectTypedDict(TypedDict):
    attachments: NotRequired[Nullable[List[AttachmentObjectTypedDict]]]
    r"""The attachments, if any associated to this suspended ticket. See [Attachments](/api-reference/ticketing/tickets/ticket-attachments/)"""
    author: NotRequired[SuspendedTicketObjectAuthorTypedDict]
    r"""The author id (if available), name and email"""
    brand_id: NotRequired[int]
    r"""The id of the brand this ticket is associated with. Only applicable for Enterprise accounts"""
    cause: NotRequired[str]
    r"""Why the ticket was suspended"""
    cause_id: NotRequired[int]
    r"""The ID of the cause"""
    content: NotRequired[str]
    r"""The content that was flagged"""
    created_at: NotRequired[datetime]
    r"""The ticket ID this suspended email is associated with, if available"""
    error_messages: NotRequired[Nullable[List[ErrorMessageTypedDict]]]
    r"""The error messages if any associated to this suspended ticket"""
    id: NotRequired[int]
    r"""Automatically assigned"""
    message_id: NotRequired[str]
    r"""The ID of the email, if available"""
    recipient: NotRequired[str]
    r"""The original recipient e-mail address of the ticket"""
    subject: NotRequired[str]
    r"""The value of the subject field for this ticket"""
    ticket_id: NotRequired[int]
    r"""The ticket ID this suspended email is associated with, if available"""
    updated_at: NotRequired[datetime]
    r"""When the ticket was assigned"""
    url: NotRequired[str]
    r"""The API url of this ticket"""
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """


class SuspendedTicketObject(BaseModel):
    attachments: OptionalNullable[List[AttachmentObject]] = UNSET
    r"""The attachments, if any associated to this suspended ticket. See [Attachments](/api-reference/ticketing/tickets/ticket-attachments/)"""

    author: Optional[SuspendedTicketObjectAuthor] = None
    r"""The author id (if available), name and email"""

    brand_id: Optional[int] = None
    r"""The id of the brand this ticket is associated with. Only applicable for Enterprise accounts"""

    cause: Optional[str] = None
    r"""Why the ticket was suspended"""

    cause_id: Optional[int] = None
    r"""The ID of the cause"""

    content: Optional[str] = None
    r"""The content that was flagged"""

    created_at: Optional[datetime] = None
    r"""The ticket ID this suspended email is associated with, if available"""

    error_messages: OptionalNullable[List[ErrorMessage]] = UNSET
    r"""The error messages if any associated to this suspended ticket"""

    id: Optional[int] = None
    r"""Automatically assigned"""

    message_id: Optional[str] = None
    r"""The ID of the email, if available"""

    recipient: Optional[str] = None
    r"""The original recipient e-mail address of the ticket"""

    subject: Optional[str] = None
    r"""The value of the subject field for this ticket"""

    ticket_id: Optional[int] = None
    r"""The ticket ID this suspended email is associated with, if available"""

    updated_at: Optional[datetime] = None
    r"""When the ticket was assigned"""

    url: Optional[str] = None
    r"""The API url of this ticket"""

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "attachments",
            "author",
            "brand_id",
            "cause",
            "cause_id",
            "content",
            "created_at",
            "error_messages",
            "id",
            "message_id",
            "recipient",
            "subject",
            "ticket_id",
            "updated_at",
            "url",
            "via",
        ]
        nullable_fields = ["attachments", "error_messages"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
