"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class TicketFormObjectTypedDict(TypedDict):
    name: str
    r"""The name of the form"""
    active: NotRequired[bool]
    r"""If the form is set as active"""
    agent_conditions: NotRequired[List[Dict[str, Any]]]
    r"""Array of condition sets for agent workspaces"""
    created_at: NotRequired[datetime]
    r"""The time the ticket form was created"""
    default: NotRequired[bool]
    r"""Is the form the default form for this account"""
    deleted_at: NotRequired[datetime]
    r"""The time the ticket form was deleted"""
    display_name: NotRequired[str]
    r"""The name of the form that is displayed to an end user"""
    end_user_conditions: NotRequired[List[Dict[str, Any]]]
    r"""Array of condition sets for end user products. Sending an empty array `[]`
    removes the end user conditions from the form.

    """
    end_user_visible: NotRequired[bool]
    r"""Is the form visible to the end user"""
    id: NotRequired[int]
    r"""Automatically assigned when creating ticket form"""
    in_all_brands: NotRequired[bool]
    r"""Is the form available for use in all brands on this account"""
    position: NotRequired[int]
    r"""The position of this form among other forms in the account, i.e. dropdown"""
    raw_display_name: NotRequired[str]
    r"""The dynamic content placeholder, if present, or the \"display_name\" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)"""
    raw_name: NotRequired[str]
    r"""The dynamic content placeholder, if present, or the \"name\" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)"""
    restricted_brand_ids: NotRequired[List[int]]
    r"""ids of all brands that this ticket form is restricted to"""
    ticket_field_ids: NotRequired[List[int]]
    r"""ids of all ticket fields which are in this ticket form. The products use the order of the ids to show the field values in the tickets"""
    updated_at: NotRequired[datetime]
    r"""The time of the last update of the ticket form"""
    url: NotRequired[str]
    r"""URL of the ticket form"""


class TicketFormObject(BaseModel):
    name: str
    r"""The name of the form"""

    active: Optional[bool] = None
    r"""If the form is set as active"""

    agent_conditions: Optional[List[Dict[str, Any]]] = None
    r"""Array of condition sets for agent workspaces"""

    created_at: Optional[datetime] = None
    r"""The time the ticket form was created"""

    default: Optional[bool] = None
    r"""Is the form the default form for this account"""

    deleted_at: Optional[datetime] = None
    r"""The time the ticket form was deleted"""

    display_name: Optional[str] = None
    r"""The name of the form that is displayed to an end user"""

    end_user_conditions: Optional[List[Dict[str, Any]]] = None
    r"""Array of condition sets for end user products. Sending an empty array `[]`
    removes the end user conditions from the form.

    """

    end_user_visible: Optional[bool] = None
    r"""Is the form visible to the end user"""

    id: Optional[int] = None
    r"""Automatically assigned when creating ticket form"""

    in_all_brands: Optional[bool] = None
    r"""Is the form available for use in all brands on this account"""

    position: Optional[int] = None
    r"""The position of this form among other forms in the account, i.e. dropdown"""

    raw_display_name: Optional[str] = None
    r"""The dynamic content placeholder, if present, or the \"display_name\" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)"""

    raw_name: Optional[str] = None
    r"""The dynamic content placeholder, if present, or the \"name\" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)"""

    restricted_brand_ids: Optional[List[int]] = None
    r"""ids of all brands that this ticket form is restricted to"""

    ticket_field_ids: Optional[List[int]] = None
    r"""ids of all ticket fields which are in this ticket form. The products use the order of the ids to show the field values in the tickets"""

    updated_at: Optional[datetime] = None
    r"""The time of the last update of the ticket form"""

    url: Optional[str] = None
    r"""URL of the ticket form"""
