"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from typing import Literal, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


Metric = Literal[
    "agent_work_time",
    "pausable_update_time",
    "periodic_update_time",
    "reply_time",
    "requester_wait_time",
    "resolution_time",
    "group_ownership_time",
]
r"""The metric being tracked"""


TicketMetricEventBaseObjectType = Literal[
    "activate",
    "pause",
    "fulfill",
    "apply_sla",
    "apply_group_sla",
    "breach",
    "update_status",
    "measure",
]
r"""The type of the metric event. See [Ticket metric event types reference](/documentation/ticketing/reference-guides/ticket-metric-event-types-reference)"""


class TicketMetricEventBaseObjectTypedDict(TypedDict):
    deleted: NotRequired[bool]
    r"""If true, the event has been deleted"""
    id: NotRequired[int]
    r"""Automatically assigned when the record is created"""
    instance_id: NotRequired[int]
    r"""The instance of the metric associated with the event. See [instance_id](#instance_id)"""
    metric: NotRequired[Metric]
    r"""The metric being tracked"""
    ticket_id: NotRequired[int]
    r"""Id of the associated ticket"""
    time: NotRequired[datetime]
    r"""The time the event occurred"""
    type: NotRequired[TicketMetricEventBaseObjectType]
    r"""The type of the metric event. See [Ticket metric event types reference](/documentation/ticketing/reference-guides/ticket-metric-event-types-reference)"""


class TicketMetricEventBaseObject(BaseModel):
    deleted: Optional[bool] = None
    r"""If true, the event has been deleted"""

    id: Optional[int] = None
    r"""Automatically assigned when the record is created"""

    instance_id: Optional[int] = None
    r"""The instance of the metric associated with the event. See [instance_id](#instance_id)"""

    metric: Optional[Metric] = None
    r"""The metric being tracked"""

    ticket_id: Optional[int] = None
    r"""Id of the associated ticket"""

    time: Optional[datetime] = None
    r"""The time the event occurred"""

    type: Optional[TicketMetricEventBaseObjectType] = None
    r"""The type of the metric event. See [Ticket metric event types reference](/documentation/ticketing/reference-guides/ticket-metric-event-types-reference)"""
