"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
import pydantic
from pydantic import model_serializer
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


UserIdentityObjectType = Literal[
    "email",
    "twitter",
    "facebook",
    "google",
    "phone_number",
    "agent_forwarding",
    "any_channel",
    "foreign",
    "sdk",
]
r"""The type of this identity"""


VerificationMethod = Literal[
    "none",
    "low",
    "sso",
    "embed",
    "full",
]
r"""Indicates the state of user identity verification. See [Verification method](#verification-method)."""


class UserIdentityObjectTypedDict(TypedDict):
    type: UserIdentityObjectType
    r"""The type of this identity"""
    user_id: int
    r"""The id of the user"""
    value: str
    r"""The identifier for this identity, such as an email address"""
    created_at: NotRequired[datetime]
    r"""The time the identity was created"""
    deliverable_state: NotRequired[str]
    r"""Email identity type only. Indicates if Zendesk sends notifications to the email address. See [Deliverable state](#deliverable-state)"""
    id: NotRequired[int]
    r"""Automatically assigned on creation"""
    primary: NotRequired[bool]
    r"""If the identity is the primary identity. *Writable only when creating, not when updating. Use the [Make Identity Primary](#make-identity-primary) endpoint instead"""
    undeliverable_count: NotRequired[int]
    r"""The number of times a soft-bounce response was received at that address"""
    updated_at: NotRequired[datetime]
    r"""The time the identity was updated"""
    url: NotRequired[str]
    r"""The API url of this identity"""
    verification_method: NotRequired[VerificationMethod]
    r"""Indicates the state of user identity verification. See [Verification method](#verification-method)."""
    verified: NotRequired[bool]
    r"""If the identity has been verified. Deprecated. Use `verification_method` as a more accurate representation of a user's state of verification."""
    verified_at: NotRequired[Nullable[datetime]]
    r"""The last time a full verification flow was completed for the identity"""


class UserIdentityObject(BaseModel):
    type: UserIdentityObjectType
    r"""The type of this identity"""

    user_id: int
    r"""The id of the user"""

    value: str
    r"""The identifier for this identity, such as an email address"""

    created_at: Optional[datetime] = None
    r"""The time the identity was created"""

    deliverable_state: Optional[str] = None
    r"""Email identity type only. Indicates if Zendesk sends notifications to the email address. See [Deliverable state](#deliverable-state)"""

    id: Optional[int] = None
    r"""Automatically assigned on creation"""

    primary: Optional[bool] = None
    r"""If the identity is the primary identity. *Writable only when creating, not when updating. Use the [Make Identity Primary](#make-identity-primary) endpoint instead"""

    undeliverable_count: Optional[int] = None
    r"""The number of times a soft-bounce response was received at that address"""

    updated_at: Optional[datetime] = None
    r"""The time the identity was updated"""

    url: Optional[str] = None
    r"""The API url of this identity"""

    verification_method: Optional[VerificationMethod] = None
    r"""Indicates the state of user identity verification. See [Verification method](#verification-method)."""

    verified: Annotated[
        Optional[bool],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ] = None
    r"""If the identity has been verified. Deprecated. Use `verification_method` as a more accurate representation of a user's state of verification."""

    verified_at: OptionalNullable[datetime] = UNSET
    r"""The last time a full verification flow was completed for the identity"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "created_at",
            "deliverable_state",
            "id",
            "primary",
            "undeliverable_count",
            "updated_at",
            "url",
            "verification_method",
            "verified",
            "verified_at",
        ]
        nullable_fields = ["verified_at"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
