"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import pydantic
from pydantic import ConfigDict
from typing import Any, Dict, List, Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict
from zendesk.types import BaseModel


class UserMergeByIDInputTypedDict(TypedDict):
    id: NotRequired[int]


class UserMergeByIDInput(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    id: Optional[int] = None

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]


class UserMergePropertiesInputTypedDict(TypedDict):
    email: NotRequired[str]
    name: NotRequired[str]
    organization_id: NotRequired[int]
    password: NotRequired[str]


class UserMergePropertiesInput(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    email: Optional[str] = None

    name: Optional[str] = None

    organization_id: Optional[int] = None

    password: Optional[str] = None

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]


class IdentityTypedDict(TypedDict):
    type: str
    value: str


class Identity(BaseModel):
    type: str

    value: str


class OrganizationTypedDict(TypedDict):
    name: str


class Organization(BaseModel):
    name: str


class UserCreateInputTypedDict(TypedDict):
    email: str
    name: str
    agent_brand_ids: NotRequired[List[int]]
    custom_role_id: NotRequired[int]
    external_id: NotRequired[str]
    identities: NotRequired[List[IdentityTypedDict]]
    organization: NotRequired[OrganizationTypedDict]
    organization_id: NotRequired[int]
    role: NotRequired[str]


class UserCreateInput(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    email: str

    name: str

    agent_brand_ids: Optional[List[int]] = None

    custom_role_id: Optional[int] = None

    external_id: Optional[str] = None

    identities: Optional[List[Identity]] = None

    organization: Optional[Organization] = None

    organization_id: Optional[int] = None

    role: Optional[str] = None

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]


UserInputTypedDict = TypeAliasType(
    "UserInputTypedDict",
    Union[
        UserMergeByIDInputTypedDict,
        UserMergePropertiesInputTypedDict,
        UserCreateInputTypedDict,
    ],
)


UserInput = TypeAliasType(
    "UserInput", Union[UserMergeByIDInput, UserMergePropertiesInput, UserCreateInput]
)
