"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .apikeyauthentication import APIKeyAuthentication, APIKeyAuthenticationTypedDict
from .basicauthauthentication import (
    BasicAuthAuthentication,
    BasicAuthAuthenticationTypedDict,
)
from .bearertokenauthentication import (
    BearerTokenAuthentication,
    BearerTokenAuthenticationTypedDict,
)
from .webhooksigningsecret import WebhookSigningSecret, WebhookSigningSecretTypedDict
from pydantic import Discriminator, Tag
from typing import Dict, List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import get_discriminator


WebhookCreateRequestHTTPMethod = Literal[
    "GET",
    "POST",
    "PUT",
    "PATCH",
    "DELETE",
]
r"""HTTP method used for the webhook's requests. To subscribe the webhook to Zendesk events, this must be \"POST\" """


WebhookCreateRequestRequestFormat = Literal[
    "json",
    "xml",
    "form_encoded",
]
r"""The format of the data that the webhook will send. To subscribe the webhook to Zendesk events, this must be \"json\" """


WebhookCreateRequestStatus = Literal[
    "active",
    "inactive",
]
r"""Current status of the webhook"""


WebhookCreateRequestAuthenticationTypedDict = TypeAliasType(
    "WebhookCreateRequestAuthenticationTypedDict",
    Union[
        BasicAuthAuthenticationTypedDict,
        BearerTokenAuthenticationTypedDict,
        APIKeyAuthenticationTypedDict,
    ],
)
r"""Adds authentication to the webhook's HTTP requests, if not specified, the webhook will be unauthenticated"""


WebhookCreateRequestAuthentication = Annotated[
    Union[
        Annotated[BasicAuthAuthentication, Tag("basic_auth")],
        Annotated[BearerTokenAuthentication, Tag("bearer_token")],
        Annotated[APIKeyAuthentication, Tag("api_key")],
    ],
    Discriminator(lambda m: get_discriminator(m, "type", "type")),
]
r"""Adds authentication to the webhook's HTTP requests, if not specified, the webhook will be unauthenticated"""


class WebhookCreateRequestExternalSourceTypedDict(TypedDict):
    r"""External source by which a webhook is created, e.g. Zendesk Marketplace"""

    name: NotRequired[str]
    r"""Name of the external source"""
    version: NotRequired[str]
    r"""Version of the external source"""


class WebhookCreateRequestExternalSource(BaseModel):
    r"""External source by which a webhook is created, e.g. Zendesk Marketplace"""

    name: Optional[str] = None
    r"""Name of the external source"""

    version: Optional[str] = None
    r"""Version of the external source"""


class WebhookCreateRequestWebhookTypedDict(TypedDict):
    name: str
    r"""Webhook name"""
    endpoint: str
    r"""The destination URL that the webhook notifies when Zendesk events occur"""
    http_method: WebhookCreateRequestHTTPMethod
    r"""HTTP method used for the webhook's requests. To subscribe the webhook to Zendesk events, this must be \"POST\" """
    request_format: WebhookCreateRequestRequestFormat
    r"""The format of the data that the webhook will send. To subscribe the webhook to Zendesk events, this must be \"json\" """
    status: WebhookCreateRequestStatus
    r"""Current status of the webhook"""
    description: NotRequired[str]
    r"""Webhook description"""
    subscriptions: NotRequired[List[str]]
    r"""Event subscriptions for the webhook. To subscribe the webhook to Zendesk events, specify one or more event types.
    To connect the webhook to a trigger or automation, specify only \"conditional_ticket_events\" in the array

    """
    authentication: NotRequired[WebhookCreateRequestAuthenticationTypedDict]
    r"""Adds authentication to the webhook's HTTP requests, if not specified, the webhook will be unauthenticated"""
    custom_headers: NotRequired[Dict[str, str]]
    r"""Custom headers to deliver additional non-credential info to destinations"""
    signing_secret: NotRequired[WebhookSigningSecretTypedDict]
    r"""Signing secret used to verify webhook requests"""
    external_source: NotRequired[WebhookCreateRequestExternalSourceTypedDict]
    r"""External source by which a webhook is created, e.g. Zendesk Marketplace"""


class WebhookCreateRequestWebhook(BaseModel):
    name: str
    r"""Webhook name"""

    endpoint: str
    r"""The destination URL that the webhook notifies when Zendesk events occur"""

    http_method: WebhookCreateRequestHTTPMethod
    r"""HTTP method used for the webhook's requests. To subscribe the webhook to Zendesk events, this must be \"POST\" """

    request_format: WebhookCreateRequestRequestFormat
    r"""The format of the data that the webhook will send. To subscribe the webhook to Zendesk events, this must be \"json\" """

    status: WebhookCreateRequestStatus
    r"""Current status of the webhook"""

    description: Optional[str] = None
    r"""Webhook description"""

    subscriptions: Optional[List[str]] = None
    r"""Event subscriptions for the webhook. To subscribe the webhook to Zendesk events, specify one or more event types.
    To connect the webhook to a trigger or automation, specify only \"conditional_ticket_events\" in the array

    """

    authentication: Optional[WebhookCreateRequestAuthentication] = None
    r"""Adds authentication to the webhook's HTTP requests, if not specified, the webhook will be unauthenticated"""

    custom_headers: Optional[Dict[str, str]] = None
    r"""Custom headers to deliver additional non-credential info to destinations"""

    signing_secret: Optional[WebhookSigningSecret] = None
    r"""Signing secret used to verify webhook requests"""

    external_source: Optional[WebhookCreateRequestExternalSource] = None
    r"""External source by which a webhook is created, e.g. Zendesk Marketplace"""


class WebhookCreateRequestTypedDict(TypedDict):
    webhook: WebhookCreateRequestWebhookTypedDict


class WebhookCreateRequest(BaseModel):
    webhook: WebhookCreateRequestWebhook
