"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from typing import Literal, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


WebhookInvocationStatus = Literal[
    "unknown",
    "accepted",
    "success",
    "failed",
    "timeout",
    "circuit broken",
    "throttled",
    "client error",
    "server error",
]
r"""Status of the webhook invocation"""


class WebhookInvocationTypedDict(TypedDict):
    id: NotRequired[str]
    r"""Unique invocation identifier"""
    webhook_id: NotRequired[str]
    r"""ID of the webhook that was invoked"""
    status: NotRequired[WebhookInvocationStatus]
    r"""Status of the webhook invocation"""
    created_at: NotRequired[datetime]
    r"""When the invocation was created"""
    latest_completed_at: NotRequired[datetime]
    r"""When the invocation was last completed"""
    event_type: NotRequired[str]
    r"""Type of event that triggered the webhook"""
    attempts_count: NotRequired[int]
    r"""Number of delivery attempts made"""


class WebhookInvocation(BaseModel):
    id: Optional[str] = None
    r"""Unique invocation identifier"""

    webhook_id: Optional[str] = None
    r"""ID of the webhook that was invoked"""

    status: Optional[WebhookInvocationStatus] = None
    r"""Status of the webhook invocation"""

    created_at: Optional[datetime] = None
    r"""When the invocation was created"""

    latest_completed_at: Optional[datetime] = None
    r"""When the invocation was last completed"""

    event_type: Optional[str] = None
    r"""Type of event that triggered the webhook"""

    attempts_count: Optional[int] = None
    r"""Number of delivery attempts made"""
