"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .apikeyauthentication import APIKeyAuthentication, APIKeyAuthenticationTypedDict
from .basicauthauthentication import (
    BasicAuthAuthentication,
    BasicAuthAuthenticationTypedDict,
)
from .bearertokenauthentication import (
    BearerTokenAuthentication,
    BearerTokenAuthenticationTypedDict,
)
from pydantic import Discriminator, Tag
from typing import Dict, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import get_discriminator


WebhookTestRequestHTTPMethod = Literal[
    "GET",
    "POST",
    "PUT",
    "PATCH",
    "DELETE",
]


WebhookTestRequestRequestFormat = Literal[
    "json",
    "xml",
    "form_encoded",
]


WebhookTestRequestAuthenticationTypedDict = TypeAliasType(
    "WebhookTestRequestAuthenticationTypedDict",
    Union[
        BasicAuthAuthenticationTypedDict,
        BearerTokenAuthenticationTypedDict,
        APIKeyAuthenticationTypedDict,
    ],
)


WebhookTestRequestAuthentication = Annotated[
    Union[
        Annotated[BasicAuthAuthentication, Tag("basic_auth")],
        Annotated[BearerTokenAuthentication, Tag("bearer_token")],
        Annotated[APIKeyAuthentication, Tag("api_key")],
    ],
    Discriminator(lambda m: get_discriminator(m, "type", "type")),
]


class WebhookTestRequestWebhookTypedDict(TypedDict):
    r"""Webhook configuration for testing"""

    endpoint: str
    r"""The test endpoint URL"""
    http_method: NotRequired[WebhookTestRequestHTTPMethod]
    request_format: NotRequired[WebhookTestRequestRequestFormat]
    authentication: NotRequired[WebhookTestRequestAuthenticationTypedDict]
    custom_headers: NotRequired[Dict[str, str]]


class WebhookTestRequestWebhook(BaseModel):
    r"""Webhook configuration for testing"""

    endpoint: str
    r"""The test endpoint URL"""

    http_method: Optional[WebhookTestRequestHTTPMethod] = "POST"

    request_format: Optional[WebhookTestRequestRequestFormat] = "json"

    authentication: Optional[WebhookTestRequestAuthentication] = None

    custom_headers: Optional[Dict[str, str]] = None


class WebhookTestRequestTypedDict(TypedDict):
    webhook: WebhookTestRequestWebhookTypedDict
    r"""Webhook configuration for testing"""


class WebhookTestRequest(BaseModel):
    webhook: WebhookTestRequestWebhook
    r"""Webhook configuration for testing"""
