"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from .httpclient import AsyncHttpClient, ClientOwner, HttpClient, close_clients
from .sdkconfiguration import SDKConfiguration
from .utils.logger import Logger, get_default_logger
from .utils.retries import RetryConfig
import httpx
import importlib
import sys
from typing import Callable, Dict, List, Optional, TYPE_CHECKING, Union, cast
import weakref
from zendesk import models, utils
from zendesk._hooks import SDKHooks
from zendesk.types import OptionalNullable, UNSET

if TYPE_CHECKING:
    from zendesk.account_settings import AccountSettings
    from zendesk.activity_stream import ActivityStream
    from zendesk.approval_requests import ApprovalRequests
    from zendesk.approval_workflow_instances import ApprovalWorkflowInstances
    from zendesk.assigneefieldassignableagents import AssigneeFieldAssignableAgents
    from zendesk.assigneefieldassignablegroups import AssigneeFieldAssignableGroups
    from zendesk.attachments import Attachments
    from zendesk.audit_logs import AuditLogs
    from zendesk.automations import Automations
    from zendesk.basics import Basics
    from zendesk.bookmarks import Bookmarks
    from zendesk.brand_agents import BrandAgents
    from zendesk.brands import Brands
    from zendesk.channel_framework import ChannelFramework
    from zendesk.conversation_log import ConversationLog
    from zendesk.custom_object_fields import CustomObjectFields
    from zendesk.custom_object_records import CustomObjectRecords
    from zendesk.custom_objects import CustomObjects
    from zendesk.custom_roles import CustomRoles
    from zendesk.custom_ticket_statuses import CustomTicketStatuses
    from zendesk.deletion_schedules import DeletionSchedules
    from zendesk.dynamic_content import DynamicContent
    from zendesk.dynamic_content_item_variants import DynamicContentItemVariants
    from zendesk.email_notifications import EmailNotifications
    from zendesk.essentials_card import EssentialsCard
    from zendesk.global_clients import GlobalClients
    from zendesk.grant_type_tokens import GrantTypeTokens
    from zendesk.group_memberships import GroupMemberships
    from zendesk.group_sla_policies import GroupSLAPolicies
    from zendesk.groups import Groups
    from zendesk.incremental_export import IncrementalExport
    from zendesk.incremental_skill_based_routing_sdk import (
        IncrementalSkillBasedRoutingSDK,
    )
    from zendesk.job_statuses import JobStatuses
    from zendesk.locales import Locales
    from zendesk.lookup_relationships import LookupRelationships
    from zendesk.macros import Macros
    from zendesk.oauth_clients import OAuthClients
    from zendesk.oauth_tokens import OAuthTokens
    from zendesk.object_triggers import ObjectTriggers
    from zendesk.omnichannel_routing_queues import OmnichannelRoutingQueues
    from zendesk.organization_fields_sdk import OrganizationFieldsSDK
    from zendesk.organization_memberships import OrganizationMemberships
    from zendesk.organization_subscriptions import OrganizationSubscriptions
    from zendesk.organizations import Organizations
    from zendesk.push_notification_devices import PushNotificationDevices
    from zendesk.requests import Requests
    from zendesk.reseller import Reseller
    from zendesk.resource_collections import ResourceCollections
    from zendesk.satisfaction_ratings import SatisfactionRatings
    from zendesk.satisfaction_reasons import SatisfactionReasons
    from zendesk.search import Search
    from zendesk.sessions import Sessions
    from zendesk.sharing_agreements import SharingAgreements
    from zendesk.skill_based_routing import SkillBasedRouting
    from zendesk.sla_policies import SLAPolicies
    from zendesk.support_addresses import SupportAddresses
    from zendesk.suspended_tickets import SuspendedTickets
    from zendesk.tags import Tags
    from zendesk.target_failures import TargetFailures
    from zendesk.targets import Targets
    from zendesk.ticket_audits import TicketAudits
    from zendesk.ticket_comments import TicketComments
    from zendesk.ticket_fields import TicketFields
    from zendesk.ticket_form_statuses import TicketFormStatuses
    from zendesk.ticket_forms import TicketForms
    from zendesk.ticket_import import TicketImport
    from zendesk.ticket_metric_events import TicketMetricEvents
    from zendesk.ticket_metrics import TicketMetrics
    from zendesk.ticket_skips import TicketSkips
    from zendesk.tickets import Tickets
    from zendesk.trigger_categories import TriggerCategories
    from zendesk.triggers import Triggers
    from zendesk.user_fields import UserFields
    from zendesk.user_identities import UserIdentities
    from zendesk.user_passwords import UserPasswords
    from zendesk.users_sdk import UsersSDK
    from zendesk.views import Views
    from zendesk.webhook_invocations import WebhookInvocations
    from zendesk.webhooks import Webhooks
    from zendesk.workspaces import Workspaces
    from zendesk.x_channel import XChannel


class Zendesk(BaseSDK):
    r"""Support API: Zendesk Support API endpoints"""

    assignee_field_assignable_groups: "AssigneeFieldAssignableGroups"
    assignee_field_assignable_agents: "AssigneeFieldAssignableAgents"
    lookup_relationships: "LookupRelationships"
    account_settings: "AccountSettings"
    reseller: "Reseller"
    activity_stream: "ActivityStream"
    channel_framework: "ChannelFramework"
    approval_workflow_instances: "ApprovalWorkflowInstances"
    approval_requests: "ApprovalRequests"
    attachments: "Attachments"
    audit_logs: "AuditLogs"
    tags: "Tags"
    automations: "Automations"
    bookmarks: "Bookmarks"
    brand_agents: "BrandAgents"
    brands: "Brands"
    x_channel: "XChannel"
    basics: "Basics"
    ticket_comments: "TicketComments"
    custom_objects: "CustomObjects"
    custom_object_fields: "CustomObjectFields"
    custom_object_records: "CustomObjectRecords"
    object_triggers: "ObjectTriggers"
    custom_roles: "CustomRoles"
    custom_ticket_statuses: "CustomTicketStatuses"
    ticket_form_statuses: "TicketFormStatuses"
    tickets: "Tickets"
    users: "UsersSDK"
    deletion_schedules: "DeletionSchedules"
    dynamic_content: "DynamicContent"
    dynamic_content_item_variants: "DynamicContentItemVariants"
    email_notifications: "EmailNotifications"
    group_memberships: "GroupMemberships"
    group_sla_policies: "GroupSLAPolicies"
    groups: "Groups"
    ticket_import: "TicketImport"
    incremental_export: "IncrementalExport"
    incremental_skill_based_routing: "IncrementalSkillBasedRoutingSDK"
    ticket_metric_events: "TicketMetricEvents"
    job_statuses: "JobStatuses"
    locales: "Locales"
    macros: "Macros"
    o_auth_clients: "OAuthClients"
    global_clients: "GlobalClients"
    o_auth_tokens: "OAuthTokens"
    essentials_card: "EssentialsCard"
    organization_fields: "OrganizationFieldsSDK"
    organization_memberships: "OrganizationMemberships"
    organizations: "Organizations"
    organization_subscriptions: "OrganizationSubscriptions"
    push_notification_devices: "PushNotificationDevices"
    omnichannel_routing_queues: "OmnichannelRoutingQueues"
    support_addresses: "SupportAddresses"
    requests: "Requests"
    resource_collections: "ResourceCollections"
    skill_based_routing: "SkillBasedRouting"
    satisfaction_ratings: "SatisfactionRatings"
    satisfaction_reasons: "SatisfactionReasons"
    search: "Search"
    sessions: "Sessions"
    sharing_agreements: "SharingAgreements"
    ticket_skips: "TicketSkips"
    sla_policies: "SLAPolicies"
    suspended_tickets: "SuspendedTickets"
    target_failures: "TargetFailures"
    targets: "Targets"
    ticket_audits: "TicketAudits"
    ticket_fields: "TicketFields"
    ticket_forms: "TicketForms"
    ticket_metrics: "TicketMetrics"
    conversation_log: "ConversationLog"
    trigger_categories: "TriggerCategories"
    triggers: "Triggers"
    user_fields: "UserFields"
    user_identities: "UserIdentities"
    user_passwords: "UserPasswords"
    views: "Views"
    workspaces: "Workspaces"
    grant_type_tokens: "GrantTypeTokens"
    webhooks: "Webhooks"
    webhook_invocations: "WebhookInvocations"
    _sub_sdk_map = {
        "assignee_field_assignable_groups": (
            "zendesk.assigneefieldassignablegroups",
            "AssigneeFieldAssignableGroups",
        ),
        "assignee_field_assignable_agents": (
            "zendesk.assigneefieldassignableagents",
            "AssigneeFieldAssignableAgents",
        ),
        "lookup_relationships": ("zendesk.lookup_relationships", "LookupRelationships"),
        "account_settings": ("zendesk.account_settings", "AccountSettings"),
        "reseller": ("zendesk.reseller", "Reseller"),
        "activity_stream": ("zendesk.activity_stream", "ActivityStream"),
        "channel_framework": ("zendesk.channel_framework", "ChannelFramework"),
        "approval_workflow_instances": (
            "zendesk.approval_workflow_instances",
            "ApprovalWorkflowInstances",
        ),
        "approval_requests": ("zendesk.approval_requests", "ApprovalRequests"),
        "attachments": ("zendesk.attachments", "Attachments"),
        "audit_logs": ("zendesk.audit_logs", "AuditLogs"),
        "tags": ("zendesk.tags", "Tags"),
        "automations": ("zendesk.automations", "Automations"),
        "bookmarks": ("zendesk.bookmarks", "Bookmarks"),
        "brand_agents": ("zendesk.brand_agents", "BrandAgents"),
        "brands": ("zendesk.brands", "Brands"),
        "x_channel": ("zendesk.x_channel", "XChannel"),
        "basics": ("zendesk.basics", "Basics"),
        "ticket_comments": ("zendesk.ticket_comments", "TicketComments"),
        "custom_objects": ("zendesk.custom_objects", "CustomObjects"),
        "custom_object_fields": ("zendesk.custom_object_fields", "CustomObjectFields"),
        "custom_object_records": (
            "zendesk.custom_object_records",
            "CustomObjectRecords",
        ),
        "object_triggers": ("zendesk.object_triggers", "ObjectTriggers"),
        "custom_roles": ("zendesk.custom_roles", "CustomRoles"),
        "custom_ticket_statuses": (
            "zendesk.custom_ticket_statuses",
            "CustomTicketStatuses",
        ),
        "ticket_form_statuses": ("zendesk.ticket_form_statuses", "TicketFormStatuses"),
        "tickets": ("zendesk.tickets", "Tickets"),
        "users": ("zendesk.users_sdk", "UsersSDK"),
        "deletion_schedules": ("zendesk.deletion_schedules", "DeletionSchedules"),
        "dynamic_content": ("zendesk.dynamic_content", "DynamicContent"),
        "dynamic_content_item_variants": (
            "zendesk.dynamic_content_item_variants",
            "DynamicContentItemVariants",
        ),
        "email_notifications": ("zendesk.email_notifications", "EmailNotifications"),
        "group_memberships": ("zendesk.group_memberships", "GroupMemberships"),
        "group_sla_policies": ("zendesk.group_sla_policies", "GroupSLAPolicies"),
        "groups": ("zendesk.groups", "Groups"),
        "ticket_import": ("zendesk.ticket_import", "TicketImport"),
        "incremental_export": ("zendesk.incremental_export", "IncrementalExport"),
        "incremental_skill_based_routing": (
            "zendesk.incremental_skill_based_routing_sdk",
            "IncrementalSkillBasedRoutingSDK",
        ),
        "ticket_metric_events": ("zendesk.ticket_metric_events", "TicketMetricEvents"),
        "job_statuses": ("zendesk.job_statuses", "JobStatuses"),
        "locales": ("zendesk.locales", "Locales"),
        "macros": ("zendesk.macros", "Macros"),
        "o_auth_clients": ("zendesk.oauth_clients", "OAuthClients"),
        "global_clients": ("zendesk.global_clients", "GlobalClients"),
        "o_auth_tokens": ("zendesk.oauth_tokens", "OAuthTokens"),
        "essentials_card": ("zendesk.essentials_card", "EssentialsCard"),
        "organization_fields": (
            "zendesk.organization_fields_sdk",
            "OrganizationFieldsSDK",
        ),
        "organization_memberships": (
            "zendesk.organization_memberships",
            "OrganizationMemberships",
        ),
        "organizations": ("zendesk.organizations", "Organizations"),
        "organization_subscriptions": (
            "zendesk.organization_subscriptions",
            "OrganizationSubscriptions",
        ),
        "push_notification_devices": (
            "zendesk.push_notification_devices",
            "PushNotificationDevices",
        ),
        "omnichannel_routing_queues": (
            "zendesk.omnichannel_routing_queues",
            "OmnichannelRoutingQueues",
        ),
        "support_addresses": ("zendesk.support_addresses", "SupportAddresses"),
        "requests": ("zendesk.requests", "Requests"),
        "resource_collections": ("zendesk.resource_collections", "ResourceCollections"),
        "skill_based_routing": ("zendesk.skill_based_routing", "SkillBasedRouting"),
        "satisfaction_ratings": ("zendesk.satisfaction_ratings", "SatisfactionRatings"),
        "satisfaction_reasons": ("zendesk.satisfaction_reasons", "SatisfactionReasons"),
        "search": ("zendesk.search", "Search"),
        "sessions": ("zendesk.sessions", "Sessions"),
        "sharing_agreements": ("zendesk.sharing_agreements", "SharingAgreements"),
        "ticket_skips": ("zendesk.ticket_skips", "TicketSkips"),
        "sla_policies": ("zendesk.sla_policies", "SLAPolicies"),
        "suspended_tickets": ("zendesk.suspended_tickets", "SuspendedTickets"),
        "target_failures": ("zendesk.target_failures", "TargetFailures"),
        "targets": ("zendesk.targets", "Targets"),
        "ticket_audits": ("zendesk.ticket_audits", "TicketAudits"),
        "ticket_fields": ("zendesk.ticket_fields", "TicketFields"),
        "ticket_forms": ("zendesk.ticket_forms", "TicketForms"),
        "ticket_metrics": ("zendesk.ticket_metrics", "TicketMetrics"),
        "conversation_log": ("zendesk.conversation_log", "ConversationLog"),
        "trigger_categories": ("zendesk.trigger_categories", "TriggerCategories"),
        "triggers": ("zendesk.triggers", "Triggers"),
        "user_fields": ("zendesk.user_fields", "UserFields"),
        "user_identities": ("zendesk.user_identities", "UserIdentities"),
        "user_passwords": ("zendesk.user_passwords", "UserPasswords"),
        "views": ("zendesk.views", "Views"),
        "workspaces": ("zendesk.workspaces", "Workspaces"),
        "grant_type_tokens": ("zendesk.grant_type_tokens", "GrantTypeTokens"),
        "webhooks": ("zendesk.webhooks", "Webhooks"),
        "webhook_invocations": ("zendesk.webhook_invocations", "WebhookInvocations"),
    }

    def __init__(
        self,
        security: Optional[
            Union[models.Security, Callable[[], models.Security]]
        ] = None,
        domain: Optional[str] = None,
        subdomain: Optional[str] = None,
        server_idx: Optional[int] = None,
        server_url: Optional[str] = None,
        url_params: Optional[Dict[str, str]] = None,
        client: Optional[HttpClient] = None,
        async_client: Optional[AsyncHttpClient] = None,
        retry_config: OptionalNullable[RetryConfig] = UNSET,
        timeout_ms: Optional[int] = None,
        debug_logger: Optional[Logger] = None,
    ) -> None:
        r"""Instantiates the SDK configuring it with the provided parameters.

        :param security: The security details required for authentication
        :param domain: Allows setting the domain variable for url substitution
        :param subdomain: Allows setting the subdomain variable for url substitution
        :param server_idx: The index of the server to use for all methods
        :param server_url: The server URL to use for all methods
        :param url_params: Parameters to optionally template the server URL with
        :param client: The HTTP client to use for all synchronous methods
        :param async_client: The Async HTTP client to use for all asynchronous methods
        :param retry_config: The retry configuration to use for all supported methods
        :param timeout_ms: Optional request timeout applied to each operation in milliseconds
        """
        client_supplied = True
        if client is None:
            client = httpx.Client(follow_redirects=True)
            client_supplied = False

        assert issubclass(
            type(client), HttpClient
        ), "The provided client must implement the HttpClient protocol."

        async_client_supplied = True
        if async_client is None:
            async_client = httpx.AsyncClient(follow_redirects=True)
            async_client_supplied = False

        if debug_logger is None:
            debug_logger = get_default_logger()

        assert issubclass(
            type(async_client), AsyncHttpClient
        ), "The provided async_client must implement the AsyncHttpClient protocol."

        if server_url is not None:
            if url_params is not None:
                server_url = utils.template_url(server_url, url_params)
        server_defaults: List[Dict[str, str]] = [
            {
                "domain": domain or "zendesk",
                "subdomain": subdomain or "example",
            },
        ]

        BaseSDK.__init__(
            self,
            SDKConfiguration(
                client=client,
                client_supplied=client_supplied,
                async_client=async_client,
                async_client_supplied=async_client_supplied,
                security=security,
                server_url=server_url,
                server_idx=server_idx,
                server_defaults=server_defaults,
                retry_config=retry_config,
                timeout_ms=timeout_ms,
                debug_logger=debug_logger,
            ),
            parent_ref=self,
        )

        hooks = SDKHooks()

        # pylint: disable=protected-access
        self.sdk_configuration.__dict__["_hooks"] = hooks

        self.sdk_configuration = hooks.sdk_init(self.sdk_configuration)

        weakref.finalize(
            self,
            close_clients,
            cast(ClientOwner, self.sdk_configuration),
            self.sdk_configuration.client,
            self.sdk_configuration.client_supplied,
            self.sdk_configuration.async_client,
            self.sdk_configuration.async_client_supplied,
        )

    def dynamic_import(self, modname, retries=3):
        for attempt in range(retries):
            try:
                return importlib.import_module(modname)
            except KeyError:
                # Clear any half-initialized module and retry
                sys.modules.pop(modname, None)
                if attempt == retries - 1:
                    break
        raise KeyError(f"Failed to import module '{modname}' after {retries} attempts")

    def __getattr__(self, name: str):
        if name in self._sub_sdk_map:
            module_path, class_name = self._sub_sdk_map[name]
            try:
                module = self.dynamic_import(module_path)
                klass = getattr(module, class_name)
                instance = klass(self.sdk_configuration, parent_ref=self)
                setattr(self, name, instance)
                return instance
            except ImportError as e:
                raise AttributeError(
                    f"Failed to import module {module_path} for attribute {name}: {e}"
                ) from e
            except AttributeError as e:
                raise AttributeError(
                    f"Failed to find class {class_name} in module {module_path} for attribute {name}: {e}"
                ) from e

        raise AttributeError(
            f"'{type(self).__name__}' object has no attribute '{name}'"
        )

    def __dir__(self):
        default_attrs = list(super().__dir__())
        lazy_attrs = list(self._sub_sdk_map.keys())
        return sorted(list(set(default_attrs + lazy_attrs)))

    def __enter__(self):
        return self

    async def __aenter__(self):
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        if (
            self.sdk_configuration.client is not None
            and not self.sdk_configuration.client_supplied
        ):
            self.sdk_configuration.client.close()
        self.sdk_configuration.client = None

    async def __aexit__(self, exc_type, exc_val, exc_tb):
        if (
            self.sdk_configuration.async_client is not None
            and not self.sdk_configuration.async_client_supplied
        ):
            await self.sdk_configuration.async_client.aclose()
        self.sdk_configuration.async_client = None
