# coding: utf-8

"""
    Residential Electrification Model API

    An API for REM, the Residential Electrification Model.

    The version of the OpenAPI document: 1.3.2
    Contact: datascience@rewiringamerica.org
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Union
from typing import Optional, Set
from typing_extensions import Self

class AddressComponentRequest(BaseModel):
    """
    A class representing the request body to retrieve a building profile by address components.
    """ # noqa: E501
    full_address: StrictStr = Field(description="The full mailing address of the home.")
    street_number: StrictStr = Field(description="The street number in the home's mailing address.")
    street_name: StrictStr = Field(description="The all-caps street name in the home's mailing address including directions that may occur             before or after the name and the abbreviate street type like ST or BLVD")
    city: StrictStr = Field(description="The all-caps city in the home's mailing address.")
    state_abbr: StrictStr = Field(description="The two-letter state abbreviation of the state in the home's mailing address.")
    zip: StrictStr = Field(description="The five digit zip code in the home's mailing address.")
    latitude: Union[StrictFloat, StrictInt] = Field(description="The geocoded latitude of the home's location, specified to at least             5 significant digits after the decimal.")
    longitude: Union[StrictFloat, StrictInt] = Field(description="The geocoded longitude of the home's location, specified to at least             5 significant digits after the decimal.")
    __properties: ClassVar[List[str]] = ["full_address", "street_number", "street_name", "city", "state_abbr", "zip", "latitude", "longitude"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddressComponentRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddressComponentRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "full_address": obj.get("full_address"),
            "street_number": obj.get("street_number"),
            "street_name": obj.get("street_name"),
            "city": obj.get("city"),
            "state_abbr": obj.get("state_abbr"),
            "zip": obj.get("zip"),
            "latitude": obj.get("latitude"),
            "longitude": obj.get("longitude")
        })
        return _obj


