from dingo.model.model import Model
from dingo.model.prompt.base import BasePrompt


@Model.prompt_register("Html_Extract_Compare_V2", ['html_extract_compare'], ['LLMHtmlExtractCompareV2'])
class PromptHtmlExtractCompareV2(BasePrompt):
    _metric_info = {
        'category': 'Pretrain Text Quality Assessment Metrics',
        'metric_name': 'PromptHtmlExtractCompareV2',
        'description': 'Compares HTML extraction results using diff-match-patch algorithm to identify unique and common content, then evaluates core informational content differences',
        'paper_title': '',
        'paper_url': '',
        'paper_authors': '',
        'evaluation_results': ''
    }

    content_en = r"""Please compare the following two texts, each extracted from the same webpage using different HTML parsing methods. Your task is to determine whether there is a difference in the core informational content between them.

Guidelines:

Core informational content refers to: main facts, key ideas, central explanations, important data, and the primary textual body of the page.

DO NOT consider the following as core content:

Related questions
Related topics
Recommended articles
"You might also like" sections
Titles or section headings
Author names, credentials, affiliations, or bylines
Reference lists, citations, or bibliographies (e.g., "[1] Smith, J. 2020…")
Hyperlinks, URLs, or navigation elements (e.g., "Back to homepage", "Related articles", "Next/Previous")

Other autogenerated content
These elements are considered supplementary and should not influence your assessment of content differences.

You should ignore differences in formatting, word order, or minor stylistic variations unless they affect the actual meaning or presence of important information.

content 1:
{text_unique_tool_a}

content 2:
{text_unique_tool_b}

content 3:
{text_common}

Text A contains content 1 + content 3
Text B contains content 2 + content 3
You should focus on the intrinsic logic between the unique content (content 1, content 2) and the common content (content 3) as the crucial basis for judging whether there is significant informational content.
Explain your reasoning briefly. Then judge the compare result as one of:
A. Text A contains more core informational content than Text B
B. Text A contains the same amount of core informational content as Text B
C. Text A contains less core informational content than Text B

Return the judgment using this format:
<Judgement>A</Judgement> or <Judgement>B</Judgement> or <Judgement>C</Judgement>
Please output your thought process first, and then provide your final judgement.
"""

    content_cn = r"""请比较以下两段文本，它们是使用不同的 HTML 解析方法从同一网页中提取的。你的任务是判断这两段文本在核心信息内容上是否存在差异。

评判指南：

"核心信息内容"是指：主要事实、关键信息、核心解释、重要数据以及网页的主要正文内容。

请不要将以下内容视为核心信息：

- 相关问题
- 相关主题
- 推荐文章
- "你可能还喜欢" 类内容
- 标题或章节标题
- 作者姓名、资历、机构或署名
- 参考文献、引用或文献列表
- 超链接、网址或导航元素
- 其他自动生成的内容
- 主题总结

这些元素被视为附加信息，不应影响你对信息差异的判断。

除非会影响实际含义或重要信息的存在，否则请忽略格式、措辞顺序或轻微风格差异。

content 1:
{text_unique_tool_a}

content 2:
{text_unique_tool_b}

content 3:
{text_common}

Text A 由 content 1 + content 3 构成
Text B 由 content 2 + content 3 构成
你应重点关注"独有内容（content 1、content 2）"与"共同内容（content 3）"之间的内在逻辑，作为判断是否存在重要信息差异的关键依据。

请简要说明你的推理过程。然后给出如下三种判断之一：

A. Text A 包含的核心信息内容多于 Text B
B. Text A 与 Text B 包含相同量的核心信息内容
C. Text A 包含的核心信息内容少于 Text B

请按以下格式返回你的判断：
<Judgement>A</Judgement> 或 <Judgement>B</Judgement> 或 <Judgement>C</Judgement>
请首先输出思考过程，最后再输出你的答案。
"""
