"""FileInfo Query."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python.services.file_info.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.file_info import FileInfoService

log = logging.getLogger(__name__)


class TaegisSDKFileInfoQuery:
    """Taegis File_info Query operations."""

    def __init__(self, service: FileInfoService):
        self.service = service

    def file_info(self, file_hash: str) -> File:
        """None."""
        endpoint = "fileInfo"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "fileHash": prepare_input(file_hash),
            },
            output=build_output_string(File),
        )
        if result.get(endpoint) is not None:
            return File.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query fileInfo")

    def file_info_counts(self, file_hash: str) -> FileCounts:
        """None."""
        endpoint = "fileInfoCounts"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "fileHash": prepare_input(file_hash),
            },
            output=build_output_string(FileCounts),
        )
        if result.get(endpoint) is not None:
            return FileCounts.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query fileInfoCounts")

    def search_file_info(self, query: str) -> List[File]:
        """None."""
        endpoint = "searchFileInfo"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "query": prepare_input(query),
            },
            output=build_output_string(File),
        )
        if result.get(endpoint) is not None:
            return File.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query searchFileInfo")

    def file_info_exists(self, file_hash: str) -> bool:
        """None."""
        endpoint = "fileInfoExists"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "fileHash": prepare_input(file_hash),
            },
            output="",
        )
        if result.get(endpoint) is not None:
            return result.get(endpoint)
        raise GraphQLNoRowsInResultSetError("for query fileInfoExists")
