"""Tenants Types and Enums."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from typing import Optional, List, Dict, Union, Any, Tuple


from enum import Enum


from dataclasses import dataclass, field
from dataclasses_json import dataclass_json, config


class CheckAlias(str, Enum):
    """CheckAlias."""

    TENANT_UPDATE = "TenantUpdate"
    TENANT_MANAGER_UPDATE = "TenantManagerUpdate"
    TENANT_CREATE = "TenantCreate"


class AuthzObject(str, Enum):
    """AuthzObject."""

    TENANT = "Tenant"
    TENANT_HIERARCHY = "TenantHierarchy"
    TENANT_MANAGER = "TenantManager"
    ENTERPRISE_SSO_CONNECTION = "EnterpriseSSOConnection"
    TENANT_DECOMMISSION = "TenantDecommission"


class AuthzAction(str, Enum):
    """AuthzAction."""

    UPDATE = "Update"
    READ = "Read"
    CREATE = "Create"
    DELETE = "Delete"
    APPROVE = "Approve"
    EXECUTE = "Execute"


class TenantType(str, Enum):
    """TenantType."""

    INTERNAL_TENANT = "InternalTenant"
    CONNECTION_OWNER = "ConnectionOwner"
    SERVICE_OWNER = "ServiceOwner"
    INTERNAL_SERVICE_OWNER = "InternalServiceOwner"
    PARENT_TENANT_INPUT = "ParentTenantInput"
    PARTNER_TENANT = "PartnerTenant"


class TenantOrderField(str, Enum):
    """TenantOrderField."""

    ID = "Id"
    NAME = "Name"
    CREATED_AT = "CreatedAt"
    UPDATED_AT = "UpdatedAt"


class OrderDir(str, Enum):
    """OrderDir."""

    ASC = "asc"
    DESC = "desc"


class TenantEnvironment(str, Enum):
    """TenantEnvironment."""

    PILOT = "pilot"
    CHARLIE = "charlie"
    ECHO = "echo"
    DELTA = "delta"
    FOXTROT = "foxtrot"


class SSOEnvironment(str, Enum):
    """SSOEnvironment."""

    PILOT = "pilot"
    PRODUCTION = "production"


class SSOConnectionType(str, Enum):
    """SSOConnectionType."""

    UNKNOWN = "unknown"
    SAML = "saml"
    AZURE_AD = "azure_ad"


class SSOConnectionStatus(str, Enum):
    """SSOConnectionStatus."""

    DRAFT = "Draft"
    TESTING = "Testing"
    ENABLED = "Enabled"
    DISABLED = "Disabled"


class Auth0DomainType(str, Enum):
    """Auth0DomainType."""

    PRIVATE = "PRIVATE"
    CUSTOM = "CUSTOM"


class AuditAction(str, Enum):
    """AuditAction."""

    ADD_LABEL_TO_TENANT = "add_label_to_tenant"
    ADD_SERVICE_TO_TENANT = "add_service_to_tenant"
    CREATE_SSO_CONNECTION = "create_sso_connection"
    CREATE_TENANT = "create_tenant"
    DELETE_LABEL_FROM_TENANT = "delete_label_from_tenant"
    DELETE_SSO_CONNECTION = "delete_sso_connection"
    DISABLED_SUPPORT_STATUS = "disabled_support_status"
    ENABLE_TENANT = "enable_tenant"
    ENABLED_SUPPORT_STATUS = "enabled_support_status"
    REMOVE_SERVICE_TO_TENANT = "remove_service_to_tenant"
    TENANT_ADDED = "tenant_added"
    TENANT_DISABLED = "tenant_disabled"
    TENANT_REMOVED = "tenant_removed"
    TENANT_UPDATED = "tenant_updated"
    UPDATE_LABEL_FOR_TENANT = "update_label_for_tenant"
    UPDATE_SSO_CONNECTION = "update_sso_connection"
    CREATE_SERVICE = "create_service"
    DELETE_SERVICE = "delete_service"
    UPDATE_SERVICE = "update_service"


class TenantDecommissionRequestStatus(str, Enum):
    """TenantDecommissionRequestStatus."""

    CREATED = "CREATED"
    IN_REVIEW = "IN_REVIEW"
    APPROVED = "APPROVED"
    PROCESSING = "PROCESSING"
    ERROR_STATE = "ERROR_STATE"
    COMPLETED = "COMPLETED"
    CANCELLED = "CANCELLED"


class TenantDecommissionTaskStatus(str, Enum):
    """TenantDecommissionTaskStatus."""

    PENDING = "PENDING"
    DEFERRED = "DEFERRED"
    SCHEDULED = "SCHEDULED"
    ERROR = "ERROR"
    COMPLETED = "COMPLETED"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Audit:
    """Audit."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="created_at")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updated_at")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenant_id")
    )
    action: Optional[str] = field(default=None, metadata=config(field_name="action"))
    who: Optional[str] = field(default=None, metadata=config(field_name="who"))
    event_name: Optional[str] = field(
        default=None, metadata=config(field_name="event_name")
    )
    before: Optional[str] = field(default=None, metadata=config(field_name="before"))
    after: Optional[str] = field(default=None, metadata=config(field_name="after"))
    owner_tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="owner_tenant_id")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Environment:
    """Environment."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="created_at")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updated_at")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenant_id")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Service:
    """Service."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="created_at")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updated_at")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    owner_tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="owner_tenant_id")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantService:
    """TenantService."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    service_id: Optional[str] = field(
        default=None, metadata=config(field_name="service_id")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    service_owner_id: Optional[str] = field(
        default=None, metadata=config(field_name="service_owner_id")
    )
    owned_by_partner: Optional[bool] = field(
        default=None, metadata=config(field_name="owned_by_partner")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="created_at")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updated_at")
    )
    requested_at: Optional[str] = field(
        default=None, metadata=config(field_name="requested_at")
    )
    granted_at: Optional[str] = field(
        default=None, metadata=config(field_name="granted_at")
    )
    revoked_at: Optional[str] = field(
        default=None, metadata=config(field_name="revoked_at")
    )
    requested_by: Optional[str] = field(
        default=None, metadata=config(field_name="requested_by")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ServiceEvents:
    """ServiceEvents."""

    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantID")
    )
    service_name: Optional[str] = field(
        default=None, metadata=config(field_name="serviceName")
    )
    added_timestamp: Optional[str] = field(
        default=None, metadata=config(field_name="addedTimestamp")
    )
    removed_timestamp: Optional[str] = field(
        default=None, metadata=config(field_name="removedTimestamp")
    )
    added_event: Optional[str] = field(
        default=None, metadata=config(field_name="addedEvent")
    )
    removed_event: Optional[str] = field(
        default=None, metadata=config(field_name="removedEvent")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantLabel:
    """TenantLabel."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenant_id")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    value: Optional[str] = field(default=None, metadata=config(field_name="value"))
    owner_partner_tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="owner_partner_tenant_id")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UniqueLabelValues:
    """UniqueLabelValues."""

    results: Optional[List[str]] = field(
        default=None, metadata=config(field_name="results")
    )
    count: Optional[int] = field(default=None, metadata=config(field_name="count"))
    has_more: Optional[bool] = field(
        default=None, metadata=config(field_name="hasMore")
    )
    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ChildTenant:
    """ChildTenant."""

    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenant_id")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PartnerSubscription:
    """PartnerSubscription."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    service_id: Optional[str] = field(
        default=None, metadata=config(field_name="service_id")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="created_at")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updated_at")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SSOConnectionParameters:
    """SSOConnectionParameters."""

    post_back_url: Optional[str] = field(
        default=None, metadata=config(field_name="postBackURL")
    )
    entity_id: Optional[str] = field(
        default=None, metadata=config(field_name="entityID")
    )
    metadata_url: Optional[str] = field(
        default=None, metadata=config(field_name="metadataURL")
    )
    callback_url: Optional[str] = field(
        default=None, metadata=config(field_name="callbackURL")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SAMLConnectionParameters:
    """SAMLConnectionParameters."""

    signing_cert: Optional[str] = field(
        default=None, metadata=config(field_name="signingCert")
    )
    sign_in_endpoint: Optional[str] = field(
        default=None, metadata=config(field_name="signInEndpoint")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AzureADConnectionParameters:
    """AzureADConnectionParameters."""

    client_id: Optional[str] = field(
        default=None, metadata=config(field_name="clientID")
    )
    client_secret: Optional[str] = field(
        default=None, metadata=config(field_name="clientSecret")
    )
    domain: Optional[str] = field(default=None, metadata=config(field_name="domain"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantDecommissionAgentSummary:
    """TenantDecommissionAgentSummary."""

    agent_type: Optional[str] = field(
        default=None, metadata=config(field_name="agentType")
    )
    count: Optional[int] = field(default=None, metadata=config(field_name="count"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class NewService:
    """NewService."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class NewSubscription:
    """NewSubscription."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    owner_tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="owner_tenant_id")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SubscriptionUpdate:
    """SubscriptionUpdate."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InputTenantLabel:
    """InputTenantLabel."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    value: Optional[str] = field(default=None, metadata=config(field_name="value"))
    owner_partner_tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="owner_partner_tenant_id")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class LabelsForTenantUpdate:
    """LabelsForTenantUpdate."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    value: Optional[str] = field(default=None, metadata=config(field_name="value"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InputTenantEnvironment:
    """InputTenantEnvironment."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantEnvironmentFilter:
    """TenantEnvironmentFilter."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantLabelFilter:
    """TenantLabelFilter."""

    label_name: Optional[str] = field(
        default=None, metadata=config(field_name="label_name")
    )
    label_value: Optional[str] = field(
        default=None, metadata=config(field_name="label_value")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ServiceFilter:
    """ServiceFilter."""

    service_name: Optional[str] = field(
        default=None, metadata=config(field_name="service_name")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PartnershipFilter:
    """PartnershipFilter."""

    with_subscription: Optional[str] = field(
        default=None, metadata=config(field_name="withSubscription")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ServiceEventQuery:
    """ServiceEventQuery."""

    updated_after: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAfter")
    )
    service_names: Optional[List[str]] = field(
        default=None, metadata=config(field_name="serviceNames")
    )
    tenant_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="tenantIDs")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TimeFilter:
    """TimeFilter."""

    start_time: Optional[str] = field(
        default=None, metadata=config(field_name="startTime")
    )
    end_time: Optional[str] = field(default=None, metadata=config(field_name="endTime"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SAMLSSOConfiguration:
    """SAMLSSOConfiguration."""

    metadata_url: Optional[str] = field(
        default=None, metadata=config(field_name="metadataURL")
    )
    signing_cert_name: Optional[str] = field(
        default=None, metadata=config(field_name="signingCertName")
    )
    signing_cert: Optional[str] = field(
        default=None, metadata=config(field_name="signingCert")
    )
    sign_in_endpoint: Optional[str] = field(
        default=None, metadata=config(field_name="signInEndpoint")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AzureSSOConfiguration:
    """AzureSSOConfiguration."""

    client_id: Optional[str] = field(
        default=None, metadata=config(field_name="clientID")
    )
    client_secret: Optional[str] = field(
        default=None, metadata=config(field_name="clientSecret")
    )
    domain: Optional[str] = field(default=None, metadata=config(field_name="domain"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantServiceInput:
    """TenantServiceInput."""

    service_id: Optional[str] = field(
        default=None, metadata=config(field_name="serviceID")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantID")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantDecommissionCreateRequestInput:
    """TenantDecommissionCreateRequestInput."""

    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantID")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    point_of_contact: Optional[str] = field(
        default=None, metadata=config(field_name="pointOfContact")
    )
    notes: Optional[str] = field(default=None, metadata=config(field_name="notes"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantDecommissionUpdateRequestInput:
    """TenantDecommissionUpdateRequestInput."""

    request_id: Optional[str] = field(
        default=None, metadata=config(field_name="requestID")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    point_of_contact: Optional[str] = field(
        default=None, metadata=config(field_name="pointOfContact")
    )
    notes: Optional[str] = field(default=None, metadata=config(field_name="notes"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantDecommissionTaskDeferInput:
    """TenantDecommissionTaskDeferInput."""

    task_id: Optional[str] = field(default=None, metadata=config(field_name="taskID"))
    defer_days: Optional[int] = field(
        default=None, metadata=config(field_name="deferDays")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AuditResults:
    """AuditResults."""

    cursor_pos: Optional[str] = field(
        default=None, metadata=config(field_name="cursorPos")
    )
    count: Optional[int] = field(default=None, metadata=config(field_name="count"))
    has_more: Optional[bool] = field(
        default=None, metadata=config(field_name="hasMore")
    )
    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )
    results: Optional[List[Audit]] = field(
        default=None, metadata=config(field_name="results")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Partnership:
    """Partnership."""

    parent: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "Use `tenant.parent`"},
            field_name="parent",
        ),
    )
    is_partner: Optional[bool] = field(
        default=None,
        metadata=config(
            metadata={
                "deprecated": True,
                "deprecation_reason": "Use `tenant.is_partner`",
            },
            field_name="is_partner",
        ),
    )
    child_tenants: Optional[List[str]] = field(
        default=None, metadata=config(field_name="child_tenants")
    )
    subscriptions: Optional[List[PartnerSubscription]] = field(
        default=None, metadata=config(field_name="subscriptions")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantDecommissionTask:
    """TenantDecommissionTask."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    error_text: Optional[str] = field(
        default=None, metadata=config(field_name="errorText")
    )
    defer_days: Optional[int] = field(
        default=None, metadata=config(field_name="deferDays")
    )
    status: Optional[TenantDecommissionTaskStatus] = field(
        default=None, metadata=config(field_name="status")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantDecommissionConfigReport:
    """TenantDecommissionConfigReport."""

    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantID")
    )
    tenant_name: Optional[str] = field(
        default=None, metadata=config(field_name="tenantName")
    )
    active_environments: Optional[str] = field(
        default=None, metadata=config(field_name="activeEnvironments")
    )
    is_partner: Optional[bool] = field(
        default=None, metadata=config(field_name="isPartner")
    )
    is_partner_tenant: Optional[bool] = field(
        default=None, metadata=config(field_name="isPartnerTenant")
    )
    is_organization: Optional[bool] = field(
        default=None, metadata=config(field_name="isOrganization")
    )
    is_organization_tenant: Optional[bool] = field(
        default=None, metadata=config(field_name="isOrganizationTenant")
    )
    number_of_active_users: Optional[int] = field(
        default=None, metadata=config(field_name="numberOfActiveUsers")
    )
    number_of_application_clients: Optional[int] = field(
        default=None, metadata=config(field_name="numberOfApplicationClients")
    )
    custom_roles: Optional[List[str]] = field(
        default=None, metadata=config(field_name="CustomRoles")
    )
    number_of_sso_connections: Optional[int] = field(
        default=None, metadata=config(field_name="numberOfSSOConnections")
    )
    current_data_retention_months: Optional[int] = field(
        default=None, metadata=config(field_name="CurrentDataRetentionMonths")
    )
    estimated_ingest_data_amount: Optional[str] = field(
        default=None, metadata=config(field_name="EstimatedIngestDataAmount")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    agent_summary: Optional[List[TenantDecommissionAgentSummary]] = field(
        default=None, metadata=config(field_name="AgentSummary")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class NewTenant:
    """NewTenant."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    initial_tenant_email: Optional[str] = field(
        default=None, metadata=config(field_name="initial_tenant_email")
    )
    environments: Optional[List[str]] = field(
        default=None, metadata=config(field_name="environments")
    )
    expires_at: Optional[int] = field(
        default=None, metadata=config(field_name="expires_at")
    )
    parent_tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="parentTenantID")
    )
    is_partner: Optional[bool] = field(
        default=None, metadata=config(field_name="isPartner")
    )
    is_organization: Optional[bool] = field(
        default=None, metadata=config(field_name="isOrganization")
    )
    labels: Optional[List[InputTenantLabel]] = field(
        default=None, metadata=config(field_name="labels")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantEnvironmentUpdateInput:
    """TenantEnvironmentUpdateInput."""

    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))
    name: Optional[TenantEnvironment] = field(
        default=None, metadata=config(field_name="name")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantUpdateInput:
    """TenantUpdateInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    disable: Optional[bool] = field(default=None, metadata=config(field_name="disable"))
    expires_at: Optional[str] = field(
        default=None, metadata=config(field_name="expiresAt")
    )
    clear_expiration: Optional[bool] = field(
        default=None, metadata=config(field_name="clearExpiration")
    )
    parent_tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="parentTenantID")
    )
    environments: Optional[List[TenantEnvironmentUpdateInput]] = field(
        default=None, metadata=config(field_name="environments")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SSOConnectionConfiguration:
    """SSOConnectionConfiguration."""

    saml_connection_configuration: Optional[SAMLConnectionParameters] = field(
        default=None, metadata=config(field_name="samlConnectionConfiguration")
    )
    azure_ad_connection_configuration: Optional[AzureADConnectionParameters] = field(
        default=None, metadata=config(field_name="azureADConnectionConfiguration")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateTenant:
    """UpdateTenant."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))
    allow_response_actions: Optional[bool] = field(
        default=None, metadata=config(field_name="allow_response_actions")
    )
    expires_at: Optional[int] = field(
        default=None, metadata=config(field_name="expires_at")
    )
    parent_tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="parentTenantID")
    )
    environments: Optional[List[InputTenantEnvironment]] = field(
        default=None, metadata=config(field_name="environments")
    )
    labels: Optional[List[LabelsForTenantUpdate]] = field(
        default=None, metadata=config(field_name="labels")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class InternalSearchInputs:
    """InternalSearchInputs."""

    with_domains: Optional[List[str]] = field(
        default=None, metadata=config(field_name="withDomains")
    )
    environment: Optional[SSOEnvironment] = field(
        default=None, metadata=config(field_name="environment")
    )
    with_auth0_domain_type: Optional[Auth0DomainType] = field(
        default=None, metadata=config(field_name="withAuth0DomainType")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ConnectionConfiguration:
    """ConnectionConfiguration."""

    saml_configuration: Optional[SAMLSSOConfiguration] = field(
        default=None, metadata=config(field_name="samlConfiguration")
    )
    azure_ad_configuration: Optional[AzureSSOConfiguration] = field(
        default=None, metadata=config(field_name="azureAdConfiguration")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantAuditsQuery:
    """TenantAuditsQuery."""

    for_tenants: Optional[List[str]] = field(
        default=None, metadata=config(field_name="forTenants")
    )
    for_hierarchies: Optional[List[str]] = field(
        default=None, metadata=config(field_name="forHierarchies")
    )
    ids: Optional[List[str]] = field(default=None, metadata=config(field_name="ids"))
    for_subjects: Optional[List[str]] = field(
        default=None, metadata=config(field_name="forSubjects")
    )
    with_event_name: Optional[str] = field(
        default=None, metadata=config(field_name="withEventName")
    )
    cursor_pos: Optional[str] = field(
        default=None, metadata=config(field_name="cursorPos")
    )
    max_results: Optional[int] = field(
        default=None, metadata=config(field_name="maxResults")
    )
    for_actions: Optional[List[AuditAction]] = field(
        default=None, metadata=config(field_name="forActions")
    )
    created_at_filter: Optional[TimeFilter] = field(
        default=None, metadata=config(field_name="createdAtFilter")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantCreateInput:
    """TenantCreateInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    partner_tenant_id: Optional[str] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "Use parentTenantID"},
            field_name="partnerTenantID",
        ),
    )
    parent_tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="parentTenantID")
    )
    is_partner: Optional[bool] = field(
        default=None, metadata=config(field_name="isPartner")
    )
    is_organization: Optional[bool] = field(
        default=None, metadata=config(field_name="isOrganization")
    )
    expires_at: Optional[str] = field(
        default=None, metadata=config(field_name="expiresAt")
    )
    environments: Optional[List[TenantEnvironment]] = field(
        default=None, metadata=config(field_name="environments")
    )
    labels: Optional[List[InputTenantLabel]] = field(
        default=None, metadata=config(field_name="labels")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantDecommissionRequestsInput:
    """TenantDecommissionRequestsInput."""

    for_tenants: Optional[List[str]] = field(
        default=None, metadata=config(field_name="forTenants")
    )
    for_status: Optional[TenantDecommissionRequestStatus] = field(
        default=None, metadata=config(field_name="forStatus")
    )
    for_time_period: Optional[TimeFilter] = field(
        default=None, metadata=config(field_name="forTimePeriod")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantDecommissionRequest:
    """TenantDecommissionRequest."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    created_by: Optional[str] = field(
        default=None, metadata=config(field_name="createdBy")
    )
    approved_by: Optional[str] = field(
        default=None, metadata=config(field_name="approvedBy")
    )
    executed_by: Optional[str] = field(
        default=None, metadata=config(field_name="executedBy")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantID")
    )
    tenant_name: Optional[str] = field(
        default=None, metadata=config(field_name="tenantName")
    )
    point_of_contact: Optional[str] = field(
        default=None, metadata=config(field_name="pointOfContact")
    )
    notes: Optional[str] = field(default=None, metadata=config(field_name="notes"))
    status: Optional[TenantDecommissionRequestStatus] = field(
        default=None, metadata=config(field_name="status")
    )
    tenant_configuration: Optional[TenantDecommissionConfigReport] = field(
        default=None, metadata=config(field_name="tenantConfiguration")
    )
    ordered_decommission_task_list: Optional[List[TenantDecommissionTask]] = field(
        default=None, metadata=config(field_name="orderedDecommissionTaskList")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class NewSSOConnectionInput:
    """NewSSOConnectionInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    domains: Optional[List[str]] = field(
        default=None, metadata=config(field_name="domains")
    )
    testers: Optional[List[str]] = field(
        default=None, metadata=config(field_name="testers")
    )
    type: Optional[SSOConnectionType] = field(
        default=None, metadata=config(field_name="type")
    )
    connection_configuration: Optional[ConnectionConfiguration] = field(
        default=None, metadata=config(field_name="connectionConfiguration")
    )
    auth0_domain_type: Optional[Auth0DomainType] = field(
        default=None, metadata=config(field_name="auth0DomainType")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateSSOConnectionInput:
    """UpdateSSOConnectionInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    add_domains: Optional[List[str]] = field(
        default=None, metadata=config(field_name="addDomains")
    )
    remove_domains: Optional[List[str]] = field(
        default=None, metadata=config(field_name="removeDomains")
    )
    add_testers: Optional[List[str]] = field(
        default=None, metadata=config(field_name="addTesters")
    )
    remove_testers: Optional[List[str]] = field(
        default=None, metadata=config(field_name="removeTesters")
    )
    status: Optional[SSOConnectionStatus] = field(
        default=None, metadata=config(field_name="status")
    )
    connection_configuration: Optional[ConnectionConfiguration] = field(
        default=None, metadata=config(field_name="connectionConfiguration")
    )
    auth0_domain_type: Optional[Auth0DomainType] = field(
        default=None, metadata=config(field_name="auth0DomainType")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PermissionCheck:
    """PermissionCheck."""

    if_internal: Optional[bool] = field(
        default=None, metadata=config(field_name="ifInternal")
    )
    alias: Optional[CheckAlias] = field(
        default=None, metadata=config(field_name="alias")
    )
    object: Optional[AuthzObject] = field(
        default=None, metadata=config(field_name="object")
    )
    action: Optional[AuthzAction] = field(
        default=None, metadata=config(field_name="action")
    )
    on: Optional[TenantType] = field(default=None, metadata=config(field_name="on"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantSSOConnectionQueryInput:
    """TenantSSOConnectionQueryInput."""

    with_connection_id: Optional[str] = field(
        default=None, metadata=config(field_name="withConnectionID")
    )
    with_domain: Optional[str] = field(
        default=None, metadata=config(field_name="withDomain")
    )
    include_expired: Optional[bool] = field(
        default=None, metadata=config(field_name="includeExpired")
    )
    environment: Optional[SSOEnvironment] = field(
        default=None, metadata=config(field_name="environment")
    )
    with_status: Optional[List[SSOConnectionStatus]] = field(
        default=None, metadata=config(field_name="withStatus")
    )
    exclude_status: Optional[List[SSOConnectionStatus]] = field(
        default=None, metadata=config(field_name="excludeStatus")
    )
    with_auth0_domain_type: Optional[Auth0DomainType] = field(
        default=None, metadata=config(field_name="withAuth0DomainType")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SSOConnection:
    """SSOConnection."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    external_name: Optional[str] = field(
        default=None, metadata=config(field_name="externalName")
    )
    external_id: Optional[str] = field(
        default=None, metadata=config(field_name="externalID")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantID")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    cert_name: Optional[str] = field(
        default=None, metadata=config(field_name="certName")
    )
    expires_at: Optional[str] = field(
        default=None, metadata=config(field_name="expiresAt")
    )
    not_before: Optional[str] = field(
        default=None, metadata=config(field_name="notBefore")
    )
    issuer: Optional[str] = field(default=None, metadata=config(field_name="issuer"))
    subject: Optional[str] = field(default=None, metadata=config(field_name="subject"))
    domains: Optional[List[str]] = field(
        default=None, metadata=config(field_name="domains")
    )
    testers: Optional[List[str]] = field(
        default=None, metadata=config(field_name="testers")
    )
    type: Optional[SSOConnectionType] = field(
        default=None, metadata=config(field_name="type")
    )
    status: Optional[SSOConnectionStatus] = field(
        default=None, metadata=config(field_name="status")
    )
    environment: Optional[SSOEnvironment] = field(
        default=None, metadata=config(field_name="environment")
    )
    sso_connection_parameters: Optional[SSOConnectionParameters] = field(
        default=None, metadata=config(field_name="ssoConnectionParameters")
    )
    sso_connection_idp_config: Optional[SSOConnectionConfiguration] = field(
        default=None, metadata=config(field_name="ssoConnectionIDPConfig")
    )
    auth0_domain_type: Optional[Auth0DomainType] = field(
        default=None, metadata=config(field_name="auth0DomainType")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Tenant:
    """Tenant."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="created_at")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updated_at")
    )
    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    name_normalized: Optional[str] = field(
        default=None, metadata=config(field_name="name_normalized")
    )
    domain: Optional[str] = field(default=None, metadata=config(field_name="domain"))
    domain_normalized: Optional[str] = field(
        default=None, metadata=config(field_name="domain_normalized")
    )
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    allow_response_actions: Optional[bool] = field(
        default=None, metadata=config(field_name="allow_response_actions")
    )
    actions_approver: Optional[str] = field(
        default=None, metadata=config(field_name="actions_approver")
    )
    expires_at: Optional[str] = field(
        default=None, metadata=config(field_name="expires_at")
    )
    parent: Optional[str] = field(default=None, metadata=config(field_name="parent"))
    partner: Optional[str] = field(default=None, metadata=config(field_name="partner"))
    organization: Optional[str] = field(
        default=None, metadata=config(field_name="organization")
    )
    is_partner: Optional[bool] = field(
        default=None, metadata=config(field_name="is_partner")
    )
    is_organization: Optional[bool] = field(
        default=None, metadata=config(field_name="is_organization")
    )
    support_enabled: Optional[bool] = field(
        default=None, metadata=config(field_name="support_enabled")
    )
    enabled_in_production: Optional[bool] = field(
        default=None, metadata=config(field_name="enabled_in_production")
    )
    enabled_in_pilot: Optional[bool] = field(
        default=None, metadata=config(field_name="enabled_in_pilot")
    )
    post_disablement_complete: Optional[bool] = field(
        default=None, metadata=config(field_name="post_disablement_complete")
    )
    data_retention_months: Optional[int] = field(
        default=None, metadata=config(field_name="data_retention_months")
    )
    labels: Optional[List[TenantLabel]] = field(
        default=None, metadata=config(field_name="labels")
    )
    environments: Optional[List[Environment]] = field(
        default=None, metadata=config(field_name="environments")
    )
    services: Optional[List[Service]] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "use all services"},
            field_name="services",
        ),
    )
    granted_services: Optional[List[TenantService]] = field(
        default=None, metadata=config(field_name="granted_services")
    )
    requested_services: Optional[List[TenantService]] = field(
        default=None, metadata=config(field_name="requested_services")
    )
    all_services: Optional[List[TenantService]] = field(
        default=None, metadata=config(field_name="all_services")
    )
    partnership: Optional[Partnership] = field(
        default=None,
        metadata=config(
            metadata={"deprecated": True, "deprecation_reason": "No longer supported"},
            field_name="partnership",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantsQuery:
    """TenantsQuery."""

    cursor_pos: Optional[str] = field(
        default=None, metadata=config(field_name="cursorPos")
    )
    max_results: Optional[int] = field(
        default=None, metadata=config(field_name="maxResults")
    )
    page_num: Optional[int] = field(default=None, metadata=config(field_name="pageNum"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    ids: Optional[List[str]] = field(default=None, metadata=config(field_name="ids"))
    for_hierarchies: Optional[List[str]] = field(
        default=None, metadata=config(field_name="forHierarchies")
    )
    with_service: Optional[str] = field(
        default=None, metadata=config(field_name="withService")
    )
    with_services: Optional[List[str]] = field(
        default=None, metadata=config(field_name="withServices")
    )
    with_requested_services: Optional[List[str]] = field(
        default=None, metadata=config(field_name="withRequestedServices")
    )
    with_partner_subscription: Optional[str] = field(
        default=None, metadata=config(field_name="withPartnerSubscription")
    )
    with_partner_subscriptions: Optional[List[str]] = field(
        default=None, metadata=config(field_name="withPartnerSubscriptions")
    )
    is_partner: Optional[bool] = field(
        default=None, metadata=config(field_name="isPartner")
    )
    is_organization: Optional[bool] = field(
        default=None, metadata=config(field_name="isOrganization")
    )
    with_support: Optional[bool] = field(
        default=None, metadata=config(field_name="withSupport")
    )
    with_pending_post_disablement: Optional[bool] = field(
        default=None, metadata=config(field_name="withPendingPostDisablement")
    )
    enabled_in_production: Optional[bool] = field(
        default=None, metadata=config(field_name="enabledInProduction")
    )
    enabled_in_pilot: Optional[bool] = field(
        default=None, metadata=config(field_name="enabledInPilot")
    )
    with_data_retention_months: Optional[List[int]] = field(
        default=None, metadata=config(field_name="withDataRetentionMonths")
    )
    environment_filter: Optional[TenantEnvironmentFilter] = field(
        default=None, metadata=config(field_name="environmentFilter")
    )
    label_filter: Optional[TenantLabelFilter] = field(
        default=None, metadata=config(field_name="labelFilter")
    )
    partnership: Optional[PartnershipFilter] = field(
        default=None, metadata=config(field_name="partnership")
    )
    created_time_filter: Optional[TimeFilter] = field(
        default=None, metadata=config(field_name="createdTimeFilter")
    )
    modified_time_filter: Optional[TimeFilter] = field(
        default=None, metadata=config(field_name="modifiedTimeFilter")
    )
    order_by: Optional[TenantOrderField] = field(
        default=None, metadata=config(field_name="orderBy")
    )
    order_dir: Optional[OrderDir] = field(
        default=None, metadata=config(field_name="orderDir")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class TenantResults:
    """TenantResults."""

    cursor_pos: Optional[str] = field(
        default=None, metadata=config(field_name="cursorPos")
    )
    count: Optional[int] = field(default=None, metadata=config(field_name="count"))
    has_more: Optional[bool] = field(
        default=None, metadata=config(field_name="hasMore")
    )
    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )
    results: Optional[List[Tenant]] = field(
        default=None, metadata=config(field_name="results")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SSOConnectionConfigResponse:
    """SSOConnectionConfigResponse."""

    expires_at: Optional[str] = field(
        default=None, metadata=config(field_name="expiresAt")
    )
    not_before: Optional[str] = field(
        default=None, metadata=config(field_name="notBefore")
    )
    issuer: Optional[str] = field(default=None, metadata=config(field_name="issuer"))
    subject: Optional[str] = field(default=None, metadata=config(field_name="subject"))
    sso_connection_configuration: Optional[SSOConnectionConfiguration] = field(
        default=None, metadata=config(field_name="ssoConnectionConfiguration")
    )
