"""Trip Types and Enums."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from typing import Optional, List, Dict, Union, Any, Tuple


from enum import Enum


from dataclasses import dataclass, field
from dataclasses_json import dataclass_json, config


class ApiProductGroup(str, Enum):
    """ApiProductGroup."""

    TRIP = "Trip"
    CROWDSTRIKE = "Crowdstrike"


class ApiProductStatus(str, Enum):
    """ApiProductStatus."""

    ACTIVE = "Active"
    INACTIVE = "Inactive"
    LEGACY = "Legacy"
    API_ONLY = "ApiOnly"


class ApiIntegrationStatus(str, Enum):
    """ApiIntegrationStatus."""

    PROVISIONING = "Provisioning"
    ACTIVE = "Active"
    DISABLED = "Disabled"
    PAUSED = "Paused"


class ApiIntegrationHealthStatus(str, Enum):
    """ApiIntegrationHealthStatus."""

    PENDING = "Pending"
    HEALTHY = "Healthy"
    UNHEALTHY = "Unhealthy"
    PROVISIONING_FAILED = "ProvisioningFailed"


class ApiIntegrationHistoryStatus(str, Enum):
    """ApiIntegrationHistoryStatus."""

    RUNNING = "Running"
    SUCCESS = "Success"
    FAILURE = "Failure"
    RETRYING = "Retrying"


class ApiFormItemType(str, Enum):
    """ApiFormItemType."""

    TEXT = "Text"
    TEXT_INPUT = "TextInput"
    OPTION = "Option"


class ApiFormItemValidatorType(str, Enum):
    """ApiFormItemValidatorType."""

    PATTERN = "Pattern"
    JSON = "Json"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ApiIntegrationParameterInput:
    """ApiIntegrationParameterInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    value: Optional[str] = field(default=None, metadata=config(field_name="value"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ApiIntegrationUpdateResponse:
    """ApiIntegrationUpdateResponse."""

    success: Optional[bool] = field(default=None, metadata=config(field_name="success"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ApiIntegrationParameter:
    """ApiIntegrationParameter."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    value: Optional[str] = field(default=None, metadata=config(field_name="value"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ApiFormItemOption:
    """ApiFormItemOption."""

    order: Optional[int] = field(default=None, metadata=config(field_name="order"))
    code: Optional[str] = field(default=None, metadata=config(field_name="code"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ApiFormItemValidator:
    """ApiFormItemValidator."""

    parameter: Optional[str] = field(
        default=None, metadata=config(field_name="parameter")
    )
    type: Optional[ApiFormItemValidatorType] = field(
        default=None, metadata=config(field_name="type")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ApiIntegrationHistory:
    """ApiIntegrationHistory."""

    id: Optional[int] = field(default=None, metadata=config(field_name="id"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    start_time: Optional[str] = field(
        default=None, metadata=config(field_name="startTime")
    )
    heartbeat_time: Optional[str] = field(
        default=None, metadata=config(field_name="heartbeatTime")
    )
    end_time: Optional[str] = field(default=None, metadata=config(field_name="endTime"))
    start_checkpoint: Optional[str] = field(
        default=None, metadata=config(field_name="startCheckpoint")
    )
    end_checkpoint: Optional[str] = field(
        default=None, metadata=config(field_name="endCheckpoint")
    )
    summary: Optional[str] = field(default=None, metadata=config(field_name="summary"))
    status: Optional[ApiIntegrationHistoryStatus] = field(
        default=None, metadata=config(field_name="status")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ApiProduct:
    """ApiProduct."""

    id: Optional[int] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    product_group: Optional[ApiProductGroup] = field(
        default=None, metadata=config(field_name="productGroup")
    )
    status: Optional[ApiProductStatus] = field(
        default=None, metadata=config(field_name="status")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ApiIntegrationSummary:
    """ApiIntegrationSummary."""

    id: Optional[int] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    product: Optional[ApiProduct] = field(
        default=None, metadata=config(field_name="product")
    )
    status: Optional[ApiIntegrationHealthStatus] = field(
        default=None, metadata=config(field_name="status")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ApiFormItem:
    """ApiFormItem."""

    order: Optional[int] = field(default=None, metadata=config(field_name="order"))
    label: Optional[str] = field(default=None, metadata=config(field_name="label"))
    caption: Optional[str] = field(default=None, metadata=config(field_name="caption"))
    content: Optional[str] = field(default=None, metadata=config(field_name="content"))
    secret: Optional[bool] = field(default=None, metadata=config(field_name="secret"))
    type: Optional[ApiFormItemType] = field(
        default=None, metadata=config(field_name="type")
    )
    options: Optional[List[ApiFormItemOption]] = field(
        default=None, metadata=config(field_name="options")
    )
    validators: Optional[List[ApiFormItemValidator]] = field(
        default=None, metadata=config(field_name="validators")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ApiIntegration:
    """ApiIntegration."""

    id: Optional[int] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    integration_uuid: Optional[str] = field(
        default=None, metadata=config(field_name="integrationUuid")
    )
    start_date_time: Optional[str] = field(
        default=None, metadata=config(field_name="startDateTime")
    )
    start_checkpoint: Optional[str] = field(
        default=None, metadata=config(field_name="startCheckpoint")
    )
    product: Optional[ApiProduct] = field(
        default=None, metadata=config(field_name="product")
    )
    parent_integration: Optional["ApiIntegration"] = field(
        default=None, metadata=config(field_name="parentIntegration")
    )
    status: Optional[ApiIntegrationStatus] = field(
        default=None, metadata=config(field_name="status")
    )
    parameters: Optional[List[ApiIntegrationParameter]] = field(
        default=None, metadata=config(field_name="parameters")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ApiForm:
    """ApiForm."""

    id: Optional[int] = field(default=None, metadata=config(field_name="id"))
    active: Optional[bool] = field(default=None, metadata=config(field_name="active"))
    title: Optional[str] = field(default=None, metadata=config(field_name="title"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    product_id: Optional[int] = field(
        default=None, metadata=config(field_name="productId")
    )
    items: Optional[List[ApiFormItem]] = field(
        default=None, metadata=config(field_name="Items")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ApiIntegrationHistoryPage:
    """ApiIntegrationHistoryPage."""

    start_time: Optional[str] = field(
        default=None, metadata=config(field_name="startTime")
    )
    end_time: Optional[str] = field(default=None, metadata=config(field_name="endTime"))
    page_number: Optional[int] = field(
        default=None, metadata=config(field_name="pageNumber")
    )
    page_size: Optional[int] = field(
        default=None, metadata=config(field_name="pageSize")
    )
    total_pages: Optional[int] = field(
        default=None, metadata=config(field_name="totalPages")
    )
    total_rows: Optional[int] = field(
        default=None, metadata=config(field_name="totalRows")
    )
    results: Optional[List[ApiIntegrationHistory]] = field(
        default=None, metadata=config(field_name="results")
    )
