# This file was autogenerated by some hot garbage in the `uniffi` crate.
# Trust me, you don't want to mess with it!

# Common helper code.
#
# Ideally this would live in a separate .py file where it can be unittested etc
# in isolation, and perhaps even published as a re-useable package.
#
# However, it's important that the details of how this helper code works (e.g. the
# way that different builtin types are passed across the FFI) exactly match what's
# expected by the rust code on the other side of the interface. In practice right
# now that means coming from the exact some version of `uniffi` that was used to
# compile the rust component. The easiest way to ensure this is to bundle the Python
# helpers directly inline like we're doing here.

import os
import sys
import ctypes
import enum
import struct
import contextlib
import datetime
import typing
import platform

# Used for default argument values
DEFAULT = object()


class RustBuffer(ctypes.Structure):
    _fields_ = [
        ("capacity", ctypes.c_int32),
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    @staticmethod
    def alloc(size):
        return rust_call(_UniFFILib.ffi_c2pa_rustbuffer_alloc, size)

    @staticmethod
    def reserve(rbuf, additional):
        return rust_call(_UniFFILib.ffi_c2pa_rustbuffer_reserve, rbuf, additional)

    def free(self):
        return rust_call(_UniFFILib.ffi_c2pa_rustbuffer_free, self)

    def __str__(self):
        return "RustBuffer(capacity={}, len={}, data={})".format(
            self.capacity,
            self.len,
            self.data[0:self.len]
        )

    @contextlib.contextmanager
    def allocWithBuilder(*args):
        """Context-manger to allocate a buffer using a RustBufferBuilder.

        The allocated buffer will be automatically freed if an error occurs, ensuring that
        we don't accidentally leak it.
        """
        builder = RustBufferBuilder()
        try:
            yield builder
        except:
            builder.discard()
            raise

    @contextlib.contextmanager
    def consumeWithStream(self):
        """Context-manager to consume a buffer using a RustBufferStream.

        The RustBuffer will be freed once the context-manager exits, ensuring that we don't
        leak it even if an error occurs.
        """
        try:
            s = RustBufferStream.from_rust_buffer(self)
            yield s
            if s.remaining() != 0:
                raise RuntimeError("junk data left in buffer at end of consumeWithStream")
        finally:
            self.free()

    @contextlib.contextmanager
    def readWithStream(self):
        """Context-manager to read a buffer using a RustBufferStream.

        This is like consumeWithStream, but doesn't free the buffer afterwards.
        It should only be used with borrowed `RustBuffer` data.
        """
        s = RustBufferStream.from_rust_buffer(self)
        yield s
        if s.remaining() != 0:
            raise RuntimeError("junk data left in buffer at end of readWithStream")

class ForeignBytes(ctypes.Structure):
    _fields_ = [
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    def __str__(self):
        return "ForeignBytes(len={}, data={})".format(self.len, self.data[0:self.len])


class RustBufferStream:
    """
    Helper for structured reading of bytes from a RustBuffer
    """

    def __init__(self, data, len):
        self.data = data
        self.len = len
        self.offset = 0

    @classmethod
    def from_rust_buffer(cls, buf):
        return cls(buf.data, buf.len)

    def remaining(self):
        return self.len - self.offset

    def _unpack_from(self, size, format):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        value = struct.unpack(format, self.data[self.offset:self.offset+size])[0]
        self.offset += size
        return value

    def read(self, size):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        data = self.data[self.offset:self.offset+size]
        self.offset += size
        return data

    def readI8(self):
        return self._unpack_from(1, ">b")

    def readU8(self):
        return self._unpack_from(1, ">B")

    def readI16(self):
        return self._unpack_from(2, ">h")

    def readU16(self):
        return self._unpack_from(2, ">H")

    def readI32(self):
        return self._unpack_from(4, ">i")

    def readU32(self):
        return self._unpack_from(4, ">I")

    def readI64(self):
        return self._unpack_from(8, ">q")

    def readU64(self):
        return self._unpack_from(8, ">Q")

    def readFloat(self):
        v = self._unpack_from(4, ">f")
        return v

    def readDouble(self):
        return self._unpack_from(8, ">d")

    def readCSizeT(self):
        return self._unpack_from(ctypes.sizeof(ctypes.c_size_t) , "@N")

class RustBufferBuilder:
    """
    Helper for structured writing of bytes into a RustBuffer.
    """

    def __init__(self):
        self.rbuf = RustBuffer.alloc(16)
        self.rbuf.len = 0

    def finalize(self):
        rbuf = self.rbuf
        self.rbuf = None
        return rbuf

    def discard(self):
        if self.rbuf is not None:
            rbuf = self.finalize()
            rbuf.free()

    @contextlib.contextmanager
    def _reserve(self, numBytes):
        if self.rbuf.len + numBytes > self.rbuf.capacity:
            self.rbuf = RustBuffer.reserve(self.rbuf, numBytes)
        yield None
        self.rbuf.len += numBytes

    def _pack_into(self, size, format, value):
        with self._reserve(size):
            # XXX TODO: I feel like I should be able to use `struct.pack_into` here but can't figure it out.
            for i, byte in enumerate(struct.pack(format, value)):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write(self, value):
        with self._reserve(len(value)):
            for i, byte in enumerate(value):
                self.rbuf.data[self.rbuf.len + i] = byte

    def writeI8(self, v):
        self._pack_into(1, ">b", v)

    def writeU8(self, v):
        self._pack_into(1, ">B", v)

    def writeI16(self, v):
        self._pack_into(2, ">h", v)

    def writeU16(self, v):
        self._pack_into(2, ">H", v)

    def writeI32(self, v):
        self._pack_into(4, ">i", v)

    def writeU32(self, v):
        self._pack_into(4, ">I", v)

    def writeI64(self, v):
        self._pack_into(8, ">q", v)

    def writeU64(self, v):
        self._pack_into(8, ">Q", v)

    def writeFloat(self, v):
        self._pack_into(4, ">f", v)

    def writeDouble(self, v):
        self._pack_into(8, ">d", v)

    def writeCSizeT(self, v):
        self._pack_into(ctypes.sizeof(ctypes.c_size_t) , "@N", v)
# A handful of classes and functions to support the generated data structures.
# This would be a good candidate for isolating in its own ffi-support lib.

class InternalError(Exception):
    pass

class RustCallStatus(ctypes.Structure):
    """
    Error runtime.
    """
    _fields_ = [
        ("code", ctypes.c_int8),
        ("error_buf", RustBuffer),
    ]

    # These match the values from the uniffi::rustcalls module
    CALL_SUCCESS = 0
    CALL_ERROR = 1
    CALL_PANIC = 2

    def __str__(self):
        if self.code == RustCallStatus.CALL_SUCCESS:
            return "RustCallStatus(CALL_SUCCESS)"
        elif self.code == RustCallStatus.CALL_ERROR:
            return "RustCallStatus(CALL_ERROR)"
        elif self.code == RustCallStatus.CALL_PANIC:
            return "RustCallStatus(CALL_PANIC)"
        else:
            return "RustCallStatus(<invalid code>)"

def rust_call(fn, *args):
    # Call a rust function
    return rust_call_with_error(None, fn, *args)

def rust_call_with_error(error_ffi_converter, fn, *args):
    # Call a rust function and handle any errors
    #
    # This function is used for rust calls that return Result<> and therefore can set the CALL_ERROR status code.
    # error_ffi_converter must be set to the FfiConverter for the error class that corresponds to the result.
    call_status = RustCallStatus(code=RustCallStatus.CALL_SUCCESS, error_buf=RustBuffer(0, 0, None))

    args_with_error = args + (ctypes.byref(call_status),)
    result = fn(*args_with_error)
    uniffi_check_call_status(error_ffi_converter, call_status)
    return result

def rust_call_async(scaffolding_fn, callback_fn, *args):
    # Call the scaffolding function, passing it a callback handler for `AsyncTypes.py` and a pointer
    # to a python Future object.  The async function then awaits the Future.
    uniffi_eventloop = asyncio.get_running_loop()
    uniffi_py_future = uniffi_eventloop.create_future()
    uniffi_call_status = RustCallStatus(code=RustCallStatus.CALL_SUCCESS, error_buf=RustBuffer(0, 0, None))
    scaffolding_fn(*args,
       FfiConverterForeignExecutor._pointer_manager.new_pointer(uniffi_eventloop),
       callback_fn,
       # Note: It's tempting to skip the pointer manager and just use a `py_object` pointing to a
       # local variable like we do in Swift.  However, Python doesn't use cooperative cancellation
       # -- asyncio can cancel a task at anytime.  This means if we use a local variable, the Rust
       # callback could fire with a dangling pointer.
       UniFfiPyFuturePointerManager.new_pointer(uniffi_py_future),
       ctypes.byref(uniffi_call_status),
    )
    uniffi_check_call_status(None, uniffi_call_status)
    return uniffi_py_future

def uniffi_check_call_status(error_ffi_converter, call_status):
    if call_status.code == RustCallStatus.CALL_SUCCESS:
        pass
    elif call_status.code == RustCallStatus.CALL_ERROR:
        if error_ffi_converter is None:
            call_status.error_buf.free()
            raise InternalError("rust_call_with_error: CALL_ERROR, but error_ffi_converter is None")
        else:
            raise error_ffi_converter.lift(call_status.error_buf)
    elif call_status.code == RustCallStatus.CALL_PANIC:
        # When the rust code sees a panic, it tries to construct a RustBuffer
        # with the message.  But if that code panics, then it just sends back
        # an empty buffer.
        if call_status.error_buf.len > 0:
            msg = FfiConverterString.lift(call_status.error_buf)
        else:
            msg = "Unknown rust panic"
        raise InternalError(msg)
    else:
        raise InternalError("Invalid RustCallStatus code: {}".format(
            call_status.code))

# A function pointer for a callback as defined by UniFFI.
# Rust definition `fn(handle: u64, method: u32, args: RustBuffer, buf_ptr: *mut RustBuffer) -> int`
FOREIGN_CALLBACK_T = ctypes.CFUNCTYPE(ctypes.c_int, ctypes.c_ulonglong, ctypes.c_ulong, ctypes.POINTER(ctypes.c_char), ctypes.c_int, ctypes.POINTER(RustBuffer))
class UniFfiPointerManagerCPython:
    """
    Manage giving out pointers to Python objects on CPython

    This class is used to generate opaque pointers that reference Python objects to pass to Rust.
    It assumes a CPython platform.  See UniFfiPointerManagerGeneral for the alternative.
    """

    def new_pointer(self, obj):
        """
        Get a pointer for an object as a ctypes.c_size_t instance

        Each call to new_pointer() must be balanced with exactly one call to release_pointer()

        This returns a ctypes.c_size_t.  This is always the same size as a pointer and can be
        interchanged with pointers for FFI function arguments and return values.
        """
        # IncRef the object since we're going to pass a pointer to Rust
        ctypes.pythonapi.Py_IncRef(ctypes.py_object(obj))
        # id() is the object address on CPython
        # (https://docs.python.org/3/library/functions.html#id)
        return id(obj)

    def release_pointer(self, address):
        py_obj = ctypes.cast(address, ctypes.py_object)
        obj = py_obj.value
        ctypes.pythonapi.Py_DecRef(py_obj)
        return obj

    def lookup(self, address):
        return ctypes.cast(address, ctypes.py_object).value

class UniFfiPointerManagerGeneral:
    """
    Manage giving out pointers to Python objects on non-CPython platforms

    This has the same API as UniFfiPointerManagerCPython, but doesn't assume we're running on
    CPython and is slightly slower.

    Instead of using real pointers, it maps integer values to objects and returns the keys as
    c_size_t values.
    """

    def __init__(self):
        self._map = {}
        self._lock = threading.Lock()
        self._current_handle = 0

    def new_pointer(self, obj):
        with self._lock:
            handle = self._current_handle
            self._current_handle += 1
            self._map[handle] = obj
        return handle

    def release_pointer(self, handle):
        with self._lock:
            return self._map.pop(handle)

    def lookup(self, handle):
        with self._lock:
            return self._map[handle]

# Pick an pointer manager implementation based on the platform
if platform.python_implementation() == 'CPython':
    UniFfiPointerManager = UniFfiPointerManagerCPython  # type: ignore
else:
    UniFfiPointerManager = UniFfiPointerManagerGeneral  # type: ignore
# Types conforming to `FfiConverterPrimitive` pass themselves directly over the FFI.
class FfiConverterPrimitive:
    @classmethod
    def check(cls, value):
        return value

    @classmethod
    def lift(cls, value):
        return value

    @classmethod
    def lower(cls, value):
        return cls.lowerUnchecked(cls.check(value))

    @classmethod
    def lowerUnchecked(cls, value):
        return value

    @classmethod
    def write(cls, value, buf):
        cls.writeUnchecked(cls.check(value), buf)

class FfiConverterPrimitiveInt(FfiConverterPrimitive):
    @classmethod
    def check(cls, value):
        try:
            value = value.__index__()
        except Exception:
            raise TypeError("'{}' object cannot be interpreted as an integer".format(type(value).__name__))
        if not isinstance(value, int):
            raise TypeError("__index__ returned non-int (type {})".format(type(value).__name__))
        if not cls.VALUE_MIN <= value < cls.VALUE_MAX:
            raise ValueError("{} requires {} <= value < {}".format(cls.CLASS_NAME, cls.VALUE_MIN, cls.VALUE_MAX))
        return super().check(value)

class FfiConverterPrimitiveFloat(FfiConverterPrimitive):
    @classmethod
    def check(cls, value):
        try:
            value = value.__float__()
        except Exception:
            raise TypeError("must be real number, not {}".format(type(value).__name__))
        if not isinstance(value, float):
            raise TypeError("__float__ returned non-float (type {})".format(type(value).__name__))
        return super().check(value)

# Helper class for wrapper types that will always go through a RustBuffer.
# Classes should inherit from this and implement the `read` and `write` static methods.
class FfiConverterRustBuffer:
    @classmethod
    def lift(cls, rbuf):
        with rbuf.consumeWithStream() as stream:
            return cls.read(stream)

    @classmethod
    def lower(cls, value):
        with RustBuffer.allocWithBuilder() as builder:
            cls.write(value, builder)
            return builder.finalize()

# Contains loading, initialization code,
# and the FFI Function declarations in a com.sun.jna.Library.
# Define some ctypes FFI types that we use in the library

"""
ctypes type for the foreign executor callback.  This is a built-in interface for scheduling
tasks

Args:
  executor: opaque c_size_t value representing the eventloop
  delay: delay in ms
  task: function pointer to the task callback
  task_data: void pointer to the task callback data

Normally we should call task(task_data) after the detail.
However, when task is NULL this indicates that Rust has dropped the ForeignExecutor and we should
decrease the EventLoop refcount.
"""
UNIFFI_FOREIGN_EXECUTOR_CALLBACK_T = ctypes.CFUNCTYPE(None, ctypes.c_size_t, ctypes.c_uint32, ctypes.c_void_p, ctypes.c_void_p)

"""
Function pointer for a Rust task, which a callback function that takes a opaque pointer
"""
UNIFFI_RUST_TASK = ctypes.CFUNCTYPE(None, ctypes.c_void_p)

def uniffi_future_callback_t(return_type):
    """
    Factory function to create callback function types for async functions
    """
    return ctypes.CFUNCTYPE(None, ctypes.c_size_t, return_type, RustCallStatus)

from pathlib import Path

def loadIndirect():
    """
    This is how we find and load the dynamic library provided by the component.
    For now we just look it up by name.
    """
    if sys.platform == "darwin":
        libname = "lib{}.dylib"
    elif sys.platform.startswith("win"):
        # As of python3.8, ctypes does not seem to search $PATH when loading DLLs.
        # We could use `os.add_dll_directory` to configure the search path, but
        # it doesn't feel right to mess with application-wide settings. Let's
        # assume that the `.dll` is next to the `.py` file and load by full path.
        libname = os.path.join(
            os.path.dirname(__file__),
            "{}.dll",
        )
    else:
        # Anything else must be an ELF platform - Linux, *BSD, Solaris/illumos
        libname = "lib{}.so"

    libname = libname.format("uniffi_c2pa")
    path = str(Path(__file__).parent / libname)
    lib = ctypes.cdll.LoadLibrary(path)
    return lib

def uniffi_check_contract_api_version(lib):
    # Get the bindings contract version from our ComponentInterface
    bindings_contract_version = 22
    # Get the scaffolding contract version by calling the into the dylib
    scaffolding_contract_version = lib.ffi_c2pa_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version:
        raise InternalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")

def uniffi_check_api_checksums(lib):
    if lib.uniffi_c2pa_checksum_func_version() != 31632:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_c2pa_checksum_func_sdk_version() != 32199:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_c2pa_checksum_method_reader_from_stream() != 50669:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_c2pa_checksum_method_reader_json() != 18261:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_c2pa_checksum_method_reader_resource_to_stream() != 29142:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_c2pa_checksum_method_builder_with_json() != 29835:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_c2pa_checksum_method_builder_add_resource() != 29891:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_c2pa_checksum_method_builder_add_ingredient() != 50859:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_c2pa_checksum_method_builder_to_archive() != 6987:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_c2pa_checksum_method_builder_from_archive() != 56644:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_c2pa_checksum_method_builder_sign() != 63732:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_c2pa_checksum_constructor_reader_new() != 39952:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_c2pa_checksum_constructor_callbacksigner_new() != 15795:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_c2pa_checksum_constructor_builder_new() != 6168:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")

# A ctypes library to expose the extern-C FFI definitions.
# This is an implementation detail which will be called internally by the public API.

_UniFFILib = loadIndirect()
_UniFFILib.uniffi_c2pa_fn_free_reader.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_free_reader.restype = None
_UniFFILib.uniffi_c2pa_fn_constructor_reader_new.argtypes = (
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_constructor_reader_new.restype = ctypes.c_void_p
_UniFFILib.uniffi_c2pa_fn_method_reader_from_stream.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.c_uint64,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_method_reader_from_stream.restype = RustBuffer
_UniFFILib.uniffi_c2pa_fn_method_reader_json.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_method_reader_json.restype = RustBuffer
_UniFFILib.uniffi_c2pa_fn_method_reader_resource_to_stream.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.c_uint64,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_method_reader_resource_to_stream.restype = ctypes.c_uint64
_UniFFILib.uniffi_c2pa_fn_free_callbacksigner.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_free_callbacksigner.restype = None
_UniFFILib.uniffi_c2pa_fn_constructor_callbacksigner_new.argtypes = (
    ctypes.c_uint64,
    RustBuffer,
    RustBuffer,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_constructor_callbacksigner_new.restype = ctypes.c_void_p
_UniFFILib.uniffi_c2pa_fn_free_builder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_free_builder.restype = None
_UniFFILib.uniffi_c2pa_fn_constructor_builder_new.argtypes = (
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_constructor_builder_new.restype = ctypes.c_void_p
_UniFFILib.uniffi_c2pa_fn_method_builder_with_json.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_method_builder_with_json.restype = None
_UniFFILib.uniffi_c2pa_fn_method_builder_add_resource.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.c_uint64,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_method_builder_add_resource.restype = None
_UniFFILib.uniffi_c2pa_fn_method_builder_add_ingredient.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    RustBuffer,
    ctypes.c_uint64,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_method_builder_add_ingredient.restype = None
_UniFFILib.uniffi_c2pa_fn_method_builder_to_archive.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_method_builder_to_archive.restype = None
_UniFFILib.uniffi_c2pa_fn_method_builder_from_archive.argtypes = (
    ctypes.c_void_p,
    ctypes.c_uint64,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_method_builder_from_archive.restype = None
_UniFFILib.uniffi_c2pa_fn_method_builder_sign.argtypes = (
    ctypes.c_void_p,
    RustBuffer,
    ctypes.c_uint64,
    ctypes.c_uint64,
    ctypes.c_void_p,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_method_builder_sign.restype = RustBuffer
_UniFFILib.uniffi_c2pa_fn_init_callback_stream.argtypes = (
    FOREIGN_CALLBACK_T,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_init_callback_stream.restype = None
_UniFFILib.uniffi_c2pa_fn_init_callback_signercallback.argtypes = (
    FOREIGN_CALLBACK_T,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_init_callback_signercallback.restype = None
_UniFFILib.uniffi_c2pa_fn_func_version.argtypes = (
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_func_version.restype = RustBuffer
_UniFFILib.uniffi_c2pa_fn_func_sdk_version.argtypes = (
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.uniffi_c2pa_fn_func_sdk_version.restype = RustBuffer
_UniFFILib.ffi_c2pa_rustbuffer_alloc.argtypes = (
    ctypes.c_int32,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_c2pa_rustbuffer_alloc.restype = RustBuffer
_UniFFILib.ffi_c2pa_rustbuffer_from_bytes.argtypes = (
    ForeignBytes,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_c2pa_rustbuffer_from_bytes.restype = RustBuffer
_UniFFILib.ffi_c2pa_rustbuffer_free.argtypes = (
    RustBuffer,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_c2pa_rustbuffer_free.restype = None
_UniFFILib.ffi_c2pa_rustbuffer_reserve.argtypes = (
    RustBuffer,
    ctypes.c_int32,
    ctypes.POINTER(RustCallStatus),
)
_UniFFILib.ffi_c2pa_rustbuffer_reserve.restype = RustBuffer
_UniFFILib.uniffi_c2pa_checksum_func_version.argtypes = (
)
_UniFFILib.uniffi_c2pa_checksum_func_version.restype = ctypes.c_uint16
_UniFFILib.uniffi_c2pa_checksum_func_sdk_version.argtypes = (
)
_UniFFILib.uniffi_c2pa_checksum_func_sdk_version.restype = ctypes.c_uint16
_UniFFILib.uniffi_c2pa_checksum_method_reader_from_stream.argtypes = (
)
_UniFFILib.uniffi_c2pa_checksum_method_reader_from_stream.restype = ctypes.c_uint16
_UniFFILib.uniffi_c2pa_checksum_method_reader_json.argtypes = (
)
_UniFFILib.uniffi_c2pa_checksum_method_reader_json.restype = ctypes.c_uint16
_UniFFILib.uniffi_c2pa_checksum_method_reader_resource_to_stream.argtypes = (
)
_UniFFILib.uniffi_c2pa_checksum_method_reader_resource_to_stream.restype = ctypes.c_uint16
_UniFFILib.uniffi_c2pa_checksum_method_builder_with_json.argtypes = (
)
_UniFFILib.uniffi_c2pa_checksum_method_builder_with_json.restype = ctypes.c_uint16
_UniFFILib.uniffi_c2pa_checksum_method_builder_add_resource.argtypes = (
)
_UniFFILib.uniffi_c2pa_checksum_method_builder_add_resource.restype = ctypes.c_uint16
_UniFFILib.uniffi_c2pa_checksum_method_builder_add_ingredient.argtypes = (
)
_UniFFILib.uniffi_c2pa_checksum_method_builder_add_ingredient.restype = ctypes.c_uint16
_UniFFILib.uniffi_c2pa_checksum_method_builder_to_archive.argtypes = (
)
_UniFFILib.uniffi_c2pa_checksum_method_builder_to_archive.restype = ctypes.c_uint16
_UniFFILib.uniffi_c2pa_checksum_method_builder_from_archive.argtypes = (
)
_UniFFILib.uniffi_c2pa_checksum_method_builder_from_archive.restype = ctypes.c_uint16
_UniFFILib.uniffi_c2pa_checksum_method_builder_sign.argtypes = (
)
_UniFFILib.uniffi_c2pa_checksum_method_builder_sign.restype = ctypes.c_uint16
_UniFFILib.uniffi_c2pa_checksum_constructor_reader_new.argtypes = (
)
_UniFFILib.uniffi_c2pa_checksum_constructor_reader_new.restype = ctypes.c_uint16
_UniFFILib.uniffi_c2pa_checksum_constructor_callbacksigner_new.argtypes = (
)
_UniFFILib.uniffi_c2pa_checksum_constructor_callbacksigner_new.restype = ctypes.c_uint16
_UniFFILib.uniffi_c2pa_checksum_constructor_builder_new.argtypes = (
)
_UniFFILib.uniffi_c2pa_checksum_constructor_builder_new.restype = ctypes.c_uint16
_UniFFILib.ffi_c2pa_uniffi_contract_version.argtypes = (
)
_UniFFILib.ffi_c2pa_uniffi_contract_version.restype = ctypes.c_uint32
uniffi_check_contract_api_version(_UniFFILib)
uniffi_check_api_checksums(_UniFFILib)

# Public interface members begin here.


class FfiConverterUInt64(FfiConverterPrimitiveInt):
    CLASS_NAME = "u64"
    VALUE_MIN = 0
    VALUE_MAX = 2**64

    @staticmethod
    def read(buf):
        return buf.readU64()

    @staticmethod
    def writeUnchecked(value, buf):
        buf.writeU64(value)

class FfiConverterInt64(FfiConverterPrimitiveInt):
    CLASS_NAME = "i64"
    VALUE_MIN = -2**63
    VALUE_MAX = 2**63

    @staticmethod
    def read(buf):
        return buf.readI64()

    @staticmethod
    def writeUnchecked(value, buf):
        buf.writeI64(value)

class FfiConverterString:
    @staticmethod
    def check(value):
        if not isinstance(value, str):
            raise TypeError("argument must be str, not {}".format(type(value).__name__))
        return value

    @staticmethod
    def read(buf):
        size = buf.readI32()
        if size < 0:
            raise InternalError("Unexpected negative string length")
        utf8Bytes = buf.read(size)
        return utf8Bytes.decode("utf-8")

    @staticmethod
    def write(value, buf):
        value = FfiConverterString.check(value)
        utf8Bytes = value.encode("utf-8")
        buf.writeI32(len(utf8Bytes))
        buf.write(utf8Bytes)

    @staticmethod
    def lift(buf):
        with buf.consumeWithStream() as stream:
            return stream.read(stream.remaining()).decode("utf-8")

    @staticmethod
    def lower(value):
        value = FfiConverterString.check(value)
        with RustBuffer.allocWithBuilder() as builder:
            builder.write(value.encode("utf-8"))
            return builder.finalize()

class FfiConverterBytes(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        size = buf.readI32()
        if size < 0:
            raise InternalError("Unexpected negative byte string length")
        return buf.read(size)

    @staticmethod
    def write(value, buf):
        try:
            memoryview(value)
        except TypeError:
            raise TypeError("a bytes-like object is required, not {!r}".format(type(value).__name__))
        buf.writeI32(len(value))
        buf.write(value)



class Builder:
    _pointer: ctypes.c_void_p
    def __init__(self, ):
        self._pointer = rust_call(_UniFFILib.uniffi_c2pa_fn_constructor_builder_new,)

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.uniffi_c2pa_fn_free_builder, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def with_json(self, json: "str"):
        
        rust_call_with_error(
    FfiConverterTypeError,_UniFFILib.uniffi_c2pa_fn_method_builder_with_json,self._pointer,
        FfiConverterString.lower(json))







    def add_resource(self, uri: "str",stream: "Stream"):
        
        
        rust_call_with_error(
    FfiConverterTypeError,_UniFFILib.uniffi_c2pa_fn_method_builder_add_resource,self._pointer,
        FfiConverterString.lower(uri),
        FfiConverterCallbackInterfaceStream.lower(stream))







    def add_ingredient(self, ingredient_json: "str",format: "str",stream: "Stream"):
        
        
        
        rust_call_with_error(
    FfiConverterTypeError,_UniFFILib.uniffi_c2pa_fn_method_builder_add_ingredient,self._pointer,
        FfiConverterString.lower(ingredient_json),
        FfiConverterString.lower(format),
        FfiConverterCallbackInterfaceStream.lower(stream))







    def to_archive(self, stream: "Stream"):
        
        rust_call_with_error(
    FfiConverterTypeError,_UniFFILib.uniffi_c2pa_fn_method_builder_to_archive,self._pointer,
        FfiConverterCallbackInterfaceStream.lower(stream))







    def from_archive(self, stream: "Stream"):
        
        rust_call_with_error(
    FfiConverterTypeError,_UniFFILib.uniffi_c2pa_fn_method_builder_from_archive,self._pointer,
        FfiConverterCallbackInterfaceStream.lower(stream))







    def sign(self, format: "str",input: "Stream",output: "Stream",signer: "CallbackSigner") -> "bytes":
        
        
        
        
        return FfiConverterBytes.lift(
            rust_call_with_error(
    FfiConverterTypeError,_UniFFILib.uniffi_c2pa_fn_method_builder_sign,self._pointer,
        FfiConverterString.lower(format),
        FfiConverterCallbackInterfaceStream.lower(input),
        FfiConverterCallbackInterfaceStream.lower(output),
        FfiConverterTypeCallbackSigner.lower(signer))
        )






class FfiConverterTypeBuilder:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, Builder):
            raise TypeError("Expected Builder instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return Builder._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class CallbackSigner:
    _pointer: ctypes.c_void_p
    def __init__(self, callback: "SignerCallback",alg: "SigningAlg",certs: "bytes",ta_url: "typing.Optional[str]"):
        
        
        
        
        self._pointer = rust_call(_UniFFILib.uniffi_c2pa_fn_constructor_callbacksigner_new,
        FfiConverterCallbackInterfaceSignerCallback.lower(callback),
        FfiConverterTypeSigningAlg.lower(alg),
        FfiConverterBytes.lower(certs),
        FfiConverterOptionalString.lower(ta_url))

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.uniffi_c2pa_fn_free_callbacksigner, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


class FfiConverterTypeCallbackSigner:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, CallbackSigner):
            raise TypeError("Expected CallbackSigner instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return CallbackSigner._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer



class Reader:
    _pointer: ctypes.c_void_p
    def __init__(self, ):
        self._pointer = rust_call(_UniFFILib.uniffi_c2pa_fn_constructor_reader_new,)

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            rust_call(_UniFFILib.uniffi_c2pa_fn_free_reader, pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def from_stream(self, format: "str",reader: "Stream") -> "str":
        
        
        return FfiConverterString.lift(
            rust_call_with_error(
    FfiConverterTypeError,_UniFFILib.uniffi_c2pa_fn_method_reader_from_stream,self._pointer,
        FfiConverterString.lower(format),
        FfiConverterCallbackInterfaceStream.lower(reader))
        )






    def json(self, ) -> "str":
        return FfiConverterString.lift(
            rust_call_with_error(
    FfiConverterTypeError,_UniFFILib.uniffi_c2pa_fn_method_reader_json,self._pointer,)
        )






    def resource_to_stream(self, uri: "str",stream: "Stream") -> "int":
        
        
        return FfiConverterUInt64.lift(
            rust_call_with_error(
    FfiConverterTypeError,_UniFFILib.uniffi_c2pa_fn_method_reader_resource_to_stream,self._pointer,
        FfiConverterString.lower(uri),
        FfiConverterCallbackInterfaceStream.lower(stream))
        )






class FfiConverterTypeReader:
    @classmethod
    def read(cls, buf):
        ptr = buf.readU64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value, buf):
        if not isinstance(value, Reader):
            raise TypeError("Expected Reader instance, {} found".format(value.__class__.__name__))
        buf.writeU64(cls.lower(value))

    @staticmethod
    def lift(value):
        return Reader._make_instance_(value)

    @staticmethod
    def lower(value):
        return value._pointer


# Error
# We want to define each variant as a nested class that's also a subclass,
# which is tricky in Python.  To accomplish this we're going to create each
# class separately, then manually add the child classes to the base class's
# __dict__.  All of this happens in dummy class to avoid polluting the module
# namespace.
class Error(Exception):
    pass

UniFFITempError = Error

class Error:  # type: ignore
    class Assertion(UniFFITempError):
        def __init__(self, reason):
            super().__init__(", ".join([
                "reason={!r}".format(reason),
            ]))
            self.reason = reason
        def __repr__(self):
            return "Error.Assertion({})".format(str(self))
    UniFFITempError.Assertion = Assertion  # type: ignore
    class AssertionNotFound(UniFFITempError):
        def __init__(self, reason):
            super().__init__(", ".join([
                "reason={!r}".format(reason),
            ]))
            self.reason = reason
        def __repr__(self):
            return "Error.AssertionNotFound({})".format(str(self))
    UniFFITempError.AssertionNotFound = AssertionNotFound  # type: ignore
    class Decoding(UniFFITempError):
        def __init__(self, reason):
            super().__init__(", ".join([
                "reason={!r}".format(reason),
            ]))
            self.reason = reason
        def __repr__(self):
            return "Error.Decoding({})".format(str(self))
    UniFFITempError.Decoding = Decoding  # type: ignore
    class Encoding(UniFFITempError):
        def __init__(self, reason):
            super().__init__(", ".join([
                "reason={!r}".format(reason),
            ]))
            self.reason = reason
        def __repr__(self):
            return "Error.Encoding({})".format(str(self))
    UniFFITempError.Encoding = Encoding  # type: ignore
    class FileNotFound(UniFFITempError):
        def __init__(self, reason):
            super().__init__(", ".join([
                "reason={!r}".format(reason),
            ]))
            self.reason = reason
        def __repr__(self):
            return "Error.FileNotFound({})".format(str(self))
    UniFFITempError.FileNotFound = FileNotFound  # type: ignore
    class Io(UniFFITempError):
        def __init__(self, reason):
            super().__init__(", ".join([
                "reason={!r}".format(reason),
            ]))
            self.reason = reason
        def __repr__(self):
            return "Error.Io({})".format(str(self))
    UniFFITempError.Io = Io  # type: ignore
    class Json(UniFFITempError):
        def __init__(self, reason):
            super().__init__(", ".join([
                "reason={!r}".format(reason),
            ]))
            self.reason = reason
        def __repr__(self):
            return "Error.Json({})".format(str(self))
    UniFFITempError.Json = Json  # type: ignore
    class Manifest(UniFFITempError):
        def __init__(self, reason):
            super().__init__(", ".join([
                "reason={!r}".format(reason),
            ]))
            self.reason = reason
        def __repr__(self):
            return "Error.Manifest({})".format(str(self))
    UniFFITempError.Manifest = Manifest  # type: ignore
    class ManifestNotFound(UniFFITempError):
        def __init__(self, reason):
            super().__init__(", ".join([
                "reason={!r}".format(reason),
            ]))
            self.reason = reason
        def __repr__(self):
            return "Error.ManifestNotFound({})".format(str(self))
    UniFFITempError.ManifestNotFound = ManifestNotFound  # type: ignore
    class NotSupported(UniFFITempError):
        def __init__(self, reason):
            super().__init__(", ".join([
                "reason={!r}".format(reason),
            ]))
            self.reason = reason
        def __repr__(self):
            return "Error.NotSupported({})".format(str(self))
    UniFFITempError.NotSupported = NotSupported  # type: ignore
    class Other(UniFFITempError):
        def __init__(self, reason):
            super().__init__(", ".join([
                "reason={!r}".format(reason),
            ]))
            self.reason = reason
        def __repr__(self):
            return "Error.Other({})".format(str(self))
    UniFFITempError.Other = Other  # type: ignore
    class RemoteManifest(UniFFITempError):
        def __init__(self, reason):
            super().__init__(", ".join([
                "reason={!r}".format(reason),
            ]))
            self.reason = reason
        def __repr__(self):
            return "Error.RemoteManifest({})".format(str(self))
    UniFFITempError.RemoteManifest = RemoteManifest  # type: ignore
    class ResourceNotFound(UniFFITempError):
        def __init__(self, reason):
            super().__init__(", ".join([
                "reason={!r}".format(reason),
            ]))
            self.reason = reason
        def __repr__(self):
            return "Error.ResourceNotFound({})".format(str(self))
    UniFFITempError.ResourceNotFound = ResourceNotFound  # type: ignore
    class RwLock(UniFFITempError):
        def __init__(self):
            pass
        def __repr__(self):
            return "Error.RwLock({})".format(str(self))
    UniFFITempError.RwLock = RwLock  # type: ignore
    class Signature(UniFFITempError):
        def __init__(self, reason):
            super().__init__(", ".join([
                "reason={!r}".format(reason),
            ]))
            self.reason = reason
        def __repr__(self):
            return "Error.Signature({})".format(str(self))
    UniFFITempError.Signature = Signature  # type: ignore
    class Verify(UniFFITempError):
        def __init__(self, reason):
            super().__init__(", ".join([
                "reason={!r}".format(reason),
            ]))
            self.reason = reason
        def __repr__(self):
            return "Error.Verify({})".format(str(self))
    UniFFITempError.Verify = Verify  # type: ignore

Error = UniFFITempError  # type: ignore
del UniFFITempError


class FfiConverterTypeError(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return Error.Assertion(
                reason=FfiConverterString.read(buf),
            )
        if variant == 2:
            return Error.AssertionNotFound(
                reason=FfiConverterString.read(buf),
            )
        if variant == 3:
            return Error.Decoding(
                reason=FfiConverterString.read(buf),
            )
        if variant == 4:
            return Error.Encoding(
                reason=FfiConverterString.read(buf),
            )
        if variant == 5:
            return Error.FileNotFound(
                reason=FfiConverterString.read(buf),
            )
        if variant == 6:
            return Error.Io(
                reason=FfiConverterString.read(buf),
            )
        if variant == 7:
            return Error.Json(
                reason=FfiConverterString.read(buf),
            )
        if variant == 8:
            return Error.Manifest(
                reason=FfiConverterString.read(buf),
            )
        if variant == 9:
            return Error.ManifestNotFound(
                reason=FfiConverterString.read(buf),
            )
        if variant == 10:
            return Error.NotSupported(
                reason=FfiConverterString.read(buf),
            )
        if variant == 11:
            return Error.Other(
                reason=FfiConverterString.read(buf),
            )
        if variant == 12:
            return Error.RemoteManifest(
                reason=FfiConverterString.read(buf),
            )
        if variant == 13:
            return Error.ResourceNotFound(
                reason=FfiConverterString.read(buf),
            )
        if variant == 14:
            return Error.RwLock(
            )
        if variant == 15:
            return Error.Signature(
                reason=FfiConverterString.read(buf),
            )
        if variant == 16:
            return Error.Verify(
                reason=FfiConverterString.read(buf),
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def write(value, buf):
        if isinstance(value, Error.Assertion):
            buf.writeI32(1)
            FfiConverterString.write(value.reason, buf)
        if isinstance(value, Error.AssertionNotFound):
            buf.writeI32(2)
            FfiConverterString.write(value.reason, buf)
        if isinstance(value, Error.Decoding):
            buf.writeI32(3)
            FfiConverterString.write(value.reason, buf)
        if isinstance(value, Error.Encoding):
            buf.writeI32(4)
            FfiConverterString.write(value.reason, buf)
        if isinstance(value, Error.FileNotFound):
            buf.writeI32(5)
            FfiConverterString.write(value.reason, buf)
        if isinstance(value, Error.Io):
            buf.writeI32(6)
            FfiConverterString.write(value.reason, buf)
        if isinstance(value, Error.Json):
            buf.writeI32(7)
            FfiConverterString.write(value.reason, buf)
        if isinstance(value, Error.Manifest):
            buf.writeI32(8)
            FfiConverterString.write(value.reason, buf)
        if isinstance(value, Error.ManifestNotFound):
            buf.writeI32(9)
            FfiConverterString.write(value.reason, buf)
        if isinstance(value, Error.NotSupported):
            buf.writeI32(10)
            FfiConverterString.write(value.reason, buf)
        if isinstance(value, Error.Other):
            buf.writeI32(11)
            FfiConverterString.write(value.reason, buf)
        if isinstance(value, Error.RemoteManifest):
            buf.writeI32(12)
            FfiConverterString.write(value.reason, buf)
        if isinstance(value, Error.ResourceNotFound):
            buf.writeI32(13)
            FfiConverterString.write(value.reason, buf)
        if isinstance(value, Error.RwLock):
            buf.writeI32(14)
        if isinstance(value, Error.Signature):
            buf.writeI32(15)
            FfiConverterString.write(value.reason, buf)
        if isinstance(value, Error.Verify):
            buf.writeI32(16)
            FfiConverterString.write(value.reason, buf)





class SeekMode(enum.Enum):
    START = 1
    END = 2
    CURRENT = 3
    


class FfiConverterTypeSeekMode(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return SeekMode.START
        if variant == 2:
            return SeekMode.END
        if variant == 3:
            return SeekMode.CURRENT
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value == SeekMode.START:
            buf.writeI32(1)
        if value == SeekMode.END:
            buf.writeI32(2)
        if value == SeekMode.CURRENT:
            buf.writeI32(3)






class SigningAlg(enum.Enum):
    ES256 = 1
    ES384 = 2
    ES512 = 3
    PS256 = 4
    PS384 = 5
    PS512 = 6
    ED25519 = 7
    


class FfiConverterTypeSigningAlg(FfiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.readI32()
        if variant == 1:
            return SigningAlg.ES256
        if variant == 2:
            return SigningAlg.ES384
        if variant == 3:
            return SigningAlg.ES512
        if variant == 4:
            return SigningAlg.PS256
        if variant == 5:
            return SigningAlg.PS384
        if variant == 6:
            return SigningAlg.PS512
        if variant == 7:
            return SigningAlg.ED25519
        raise InternalError("Raw enum value doesn't match any cases")

    def write(value, buf):
        if value == SigningAlg.ES256:
            buf.writeI32(1)
        if value == SigningAlg.ES384:
            buf.writeI32(2)
        if value == SigningAlg.ES512:
            buf.writeI32(3)
        if value == SigningAlg.PS256:
            buf.writeI32(4)
        if value == SigningAlg.PS384:
            buf.writeI32(5)
        if value == SigningAlg.PS512:
            buf.writeI32(6)
        if value == SigningAlg.ED25519:
            buf.writeI32(7)




import threading

class ConcurrentHandleMap:
    """
    A map where inserting, getting and removing data is synchronized with a lock.
    """

    def __init__(self):
        # type Handle = int
        self._left_map = {}  # type: Dict[Handle, Any]
        self._right_map = {}  # type: Dict[Any, Handle]

        self._lock = threading.Lock()
        self._current_handle = 0
        self._stride = 1


    def insert(self, obj):
        with self._lock:
            if obj in self._right_map:
                return self._right_map[obj]
            else:
                handle = self._current_handle
                self._current_handle += self._stride
                self._left_map[handle] = obj
                self._right_map[obj] = handle
                return handle

    def get(self, handle):
        with self._lock:
            return self._left_map.get(handle)

    def remove(self, handle):
        with self._lock:
            if handle in self._left_map:
                obj = self._left_map.pop(handle)
                del self._right_map[obj]
                return obj

# Magic number for the Rust proxy to call using the same mechanism as every other method,
# to free the callback once it's dropped by Rust.
IDX_CALLBACK_FREE = 0
# Return codes for callback calls
UNIFFI_CALLBACK_SUCCESS = 0
UNIFFI_CALLBACK_ERROR = 1
UNIFFI_CALLBACK_UNEXPECTED_ERROR = 2

class FfiConverterCallbackInterface:
    _handle_map = ConcurrentHandleMap()

    def __init__(self, cb):
        self._foreign_callback = cb

    def drop(self, handle):
        self.__class__._handle_map.remove(handle)

    @classmethod
    def lift(cls, handle):
        obj = cls._handle_map.get(handle)
        if not obj:
            raise InternalError("The object in the handle map has been dropped already")

        return obj

    @classmethod
    def read(cls, buf):
        handle = buf.readU64()
        cls.lift(handle)

    @classmethod
    def lower(cls, cb):
        handle = cls._handle_map.insert(cb)
        return handle

    @classmethod
    def write(cls, cb, buf):
        buf.writeU64(cls.lower(cb))

# Declaration and FfiConverters for SignerCallback Callback Interface

class SignerCallback:
    def sign(self, data: "bytes"):
        raise NotImplementedError

    

def py_foreignCallbackCallbackInterfaceSignerCallback(handle, method, args_data, args_len, buf_ptr):
    
    def invoke_sign(python_callback, args_stream, buf_ptr):
        def makeCall():return python_callback.sign(
                FfiConverterBytes.read(args_stream)
                )

        def makeCallAndHandleReturn():
            rval = makeCall()
            with RustBuffer.allocWithBuilder() as builder:
                FfiConverterBytes.write(rval, builder)
                buf_ptr[0] = builder.finalize()
            return UNIFFI_CALLBACK_SUCCESS
        try:
            return makeCallAndHandleReturn()
        except Error as e:
            # Catch errors declared in the UDL file
            with RustBuffer.allocWithBuilder() as builder:
                FfiConverterTypeError.write(e, builder)
                buf_ptr[0] = builder.finalize()
            return UNIFFI_CALLBACK_ERROR

    

    cb = FfiConverterCallbackInterfaceSignerCallback.lift(handle)
    if not cb:
        raise InternalError("No callback in handlemap; this is a Uniffi bug")

    if method == IDX_CALLBACK_FREE:
        FfiConverterCallbackInterfaceSignerCallback.drop(handle)
        # Successfull return
        # See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
        return UNIFFI_CALLBACK_SUCCESS

    if method == 1:
        # Call the method and handle any errors
        # See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for details
        try:
            return invoke_sign(cb, RustBufferStream(args_data, args_len), buf_ptr)
        except BaseException as e:
            # Catch unexpected errors
            try:
                # Try to serialize the exception into a String
                buf_ptr[0] = FfiConverterString.lower(repr(e))
            except:
                # If that fails, just give up
                pass
            return UNIFFI_CALLBACK_UNEXPECTED_ERROR
    

    # This should never happen, because an out of bounds method index won't
    # ever be used. Once we can catch errors, we should return an InternalException.
    # https://github.com/mozilla/uniffi-rs/issues/351

    # An unexpected error happened.
    # See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
    return UNIFFI_CALLBACK_UNEXPECTED_ERROR

# We need to keep this function reference alive:
# if they get GC'd while in use then UniFFI internals could attempt to call a function
# that is in freed memory.
# That would be...uh...bad. Yeah, that's the word. Bad.
foreignCallbackCallbackInterfaceSignerCallback = FOREIGN_CALLBACK_T(py_foreignCallbackCallbackInterfaceSignerCallback)
rust_call(lambda err: _UniFFILib.uniffi_c2pa_fn_init_callback_signercallback(foreignCallbackCallbackInterfaceSignerCallback, err))

# The FfiConverter which transforms the Callbacks in to Handles to pass to Rust.
FfiConverterCallbackInterfaceSignerCallback = FfiConverterCallbackInterface(foreignCallbackCallbackInterfaceSignerCallback)





# Declaration and FfiConverters for Stream Callback Interface

class Stream:
    def read_stream(self, length: "int"):
        raise NotImplementedError

    def seek_stream(self, pos: "int",mode: "SeekMode"):
        raise NotImplementedError

    def write_stream(self, data: "bytes"):
        raise NotImplementedError

    

def py_foreignCallbackCallbackInterfaceStream(handle, method, args_data, args_len, buf_ptr):
    
    def invoke_read_stream(python_callback, args_stream, buf_ptr):
        def makeCall():return python_callback.read_stream(
                FfiConverterUInt64.read(args_stream)
                )

        def makeCallAndHandleReturn():
            rval = makeCall()
            with RustBuffer.allocWithBuilder() as builder:
                FfiConverterBytes.write(rval, builder)
                buf_ptr[0] = builder.finalize()
            return UNIFFI_CALLBACK_SUCCESS
        try:
            return makeCallAndHandleReturn()
        except Error as e:
            # Catch errors declared in the UDL file
            with RustBuffer.allocWithBuilder() as builder:
                FfiConverterTypeError.write(e, builder)
                buf_ptr[0] = builder.finalize()
            return UNIFFI_CALLBACK_ERROR

    
    def invoke_seek_stream(python_callback, args_stream, buf_ptr):
        def makeCall():return python_callback.seek_stream(
                FfiConverterInt64.read(args_stream), 
                FfiConverterTypeSeekMode.read(args_stream)
                )

        def makeCallAndHandleReturn():
            rval = makeCall()
            with RustBuffer.allocWithBuilder() as builder:
                FfiConverterUInt64.write(rval, builder)
                buf_ptr[0] = builder.finalize()
            return UNIFFI_CALLBACK_SUCCESS
        try:
            return makeCallAndHandleReturn()
        except Error as e:
            # Catch errors declared in the UDL file
            with RustBuffer.allocWithBuilder() as builder:
                FfiConverterTypeError.write(e, builder)
                buf_ptr[0] = builder.finalize()
            return UNIFFI_CALLBACK_ERROR

    
    def invoke_write_stream(python_callback, args_stream, buf_ptr):
        def makeCall():return python_callback.write_stream(
                FfiConverterBytes.read(args_stream)
                )

        def makeCallAndHandleReturn():
            rval = makeCall()
            with RustBuffer.allocWithBuilder() as builder:
                FfiConverterUInt64.write(rval, builder)
                buf_ptr[0] = builder.finalize()
            return UNIFFI_CALLBACK_SUCCESS
        try:
            return makeCallAndHandleReturn()
        except Error as e:
            # Catch errors declared in the UDL file
            with RustBuffer.allocWithBuilder() as builder:
                FfiConverterTypeError.write(e, builder)
                buf_ptr[0] = builder.finalize()
            return UNIFFI_CALLBACK_ERROR

    

    cb = FfiConverterCallbackInterfaceStream.lift(handle)
    if not cb:
        raise InternalError("No callback in handlemap; this is a Uniffi bug")

    if method == IDX_CALLBACK_FREE:
        FfiConverterCallbackInterfaceStream.drop(handle)
        # Successfull return
        # See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
        return UNIFFI_CALLBACK_SUCCESS

    if method == 1:
        # Call the method and handle any errors
        # See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for details
        try:
            return invoke_read_stream(cb, RustBufferStream(args_data, args_len), buf_ptr)
        except BaseException as e:
            # Catch unexpected errors
            try:
                # Try to serialize the exception into a String
                buf_ptr[0] = FfiConverterString.lower(repr(e))
            except:
                # If that fails, just give up
                pass
            return UNIFFI_CALLBACK_UNEXPECTED_ERROR
    if method == 2:
        # Call the method and handle any errors
        # See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for details
        try:
            return invoke_seek_stream(cb, RustBufferStream(args_data, args_len), buf_ptr)
        except BaseException as e:
            # Catch unexpected errors
            try:
                # Try to serialize the exception into a String
                buf_ptr[0] = FfiConverterString.lower(repr(e))
            except:
                # If that fails, just give up
                pass
            return UNIFFI_CALLBACK_UNEXPECTED_ERROR
    if method == 3:
        # Call the method and handle any errors
        # See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for details
        try:
            return invoke_write_stream(cb, RustBufferStream(args_data, args_len), buf_ptr)
        except BaseException as e:
            # Catch unexpected errors
            try:
                # Try to serialize the exception into a String
                buf_ptr[0] = FfiConverterString.lower(repr(e))
            except:
                # If that fails, just give up
                pass
            return UNIFFI_CALLBACK_UNEXPECTED_ERROR
    

    # This should never happen, because an out of bounds method index won't
    # ever be used. Once we can catch errors, we should return an InternalException.
    # https://github.com/mozilla/uniffi-rs/issues/351

    # An unexpected error happened.
    # See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
    return UNIFFI_CALLBACK_UNEXPECTED_ERROR

# We need to keep this function reference alive:
# if they get GC'd while in use then UniFFI internals could attempt to call a function
# that is in freed memory.
# That would be...uh...bad. Yeah, that's the word. Bad.
foreignCallbackCallbackInterfaceStream = FOREIGN_CALLBACK_T(py_foreignCallbackCallbackInterfaceStream)
rust_call(lambda err: _UniFFILib.uniffi_c2pa_fn_init_callback_stream(foreignCallbackCallbackInterfaceStream, err))

# The FfiConverter which transforms the Callbacks in to Handles to pass to Rust.
FfiConverterCallbackInterfaceStream = FfiConverterCallbackInterface(foreignCallbackCallbackInterfaceStream)



class FfiConverterOptionalString(FfiConverterRustBuffer):
    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.writeU8(0)
            return

        buf.writeU8(1)
        FfiConverterString.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.readU8()
        if flag == 0:
            return None
        elif flag == 1:
            return FfiConverterString.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")

def version():
    return FfiConverterString.lift(rust_call(_UniFFILib.uniffi_c2pa_fn_func_version,))


def sdk_version():
    return FfiConverterString.lift(rust_call(_UniFFILib.uniffi_c2pa_fn_func_sdk_version,))


__all__ = [
    "InternalError",
    "Error",
    "SeekMode",
    "SigningAlg",
    "version",
    "sdk_version",
    "Reader",
    "CallbackSigner",
    "Builder",
    "Stream",
    "SignerCallback",
]

