from pathlib import Path

from . import rstparser
from .parser import JSONVisitor, parse_rst
from .types import ProjectConfig
from .util_test import check_ast_testing_string

ROOT_PATH = Path("test_data")


def test_openapi() -> None:
    path = ROOT_PATH.joinpath(Path("test.rst"))
    project_config = ProjectConfig(ROOT_PATH, "", default_domain="mongodb", source="./")
    parser = rstparser.Parser(project_config, JSONVisitor)

    # Test a simple literally-included code block
    page, diagnostics = parse_rst(
        parser,
        path,
        """
.. openapi:: /test_parser/openapi-admin-v3.yaml
""",
    )
    page.finish(diagnostics)
    assert diagnostics == []
    check_ast_testing_string(
        page.ast,
        """
<root fileid="test.rst"><directive domain="mongodb" name="openapi"><text>/test_parser/openapi-admin-v3.yaml</text><section><heading id="base-url"><text>Base URL</text></heading><code lang="none" copyable="True">https://realm.mongodb.com/api/admin/v3.0</code><paragraph><text>The root API resource and starting point for the Realm API.</text></paragraph></section><section><heading id="api-key-apis"><text>API Key APIs</text></heading><directive domain="mongodb" name="operation" hash="get-/groups/{groupid}/apps/{appid}/api_keys" method="get" path="/groups/{groupId}/apps/{appId}/api_keys"><paragraph><text>List </text><ref_role domain="std" name="doc" fileid="['/authentication/api-key', '']"><text>API keys</text></ref_role><text> associated with a Realm app.</text></paragraph><section><heading id="path-parameters"><text>Path Parameters</text></heading><directive name="list-table" header-rows="1" widths="20 15 15 50"><list enumtype="unordered"><listItem><list enumtype="unordered"><listItem><paragraph><text>Name</text></paragraph></listItem><listItem><paragraph><text>Type</text></paragraph></listItem><listItem><paragraph><text>Necessity</text></paragraph></listItem><listItem><paragraph><text>Description</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>groupId</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>An </text><substitution_reference name="atlas"></substitution_reference><text> </text><reference refuri="https://docs.atlas.mongodb.com/tutorial/manage-projects/"><text>Project/Group ID</text></reference><text>.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>appId</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>The ObjectID of your application.</text></paragraph></listItem></list><paragraph><ref_role domain="std" name="label" target="realm-api-project-and-application-ids"></ref_role><text> demonstrates how
to find this value.</text></paragraph></listItem></list></directive></section><section><heading id="header-parameters"><text>Header Parameters</text></heading><directive name="list-table" header-rows="1" widths="20 15 15 50"><list enumtype="unordered"><listItem><list enumtype="unordered"><listItem><paragraph><text>Name</text></paragraph></listItem><listItem><paragraph><text>Type</text></paragraph></listItem><listItem><paragraph><text>Necessity</text></paragraph></listItem><listItem><paragraph><text>Description</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>Authorization</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>The authorization token provided in the </text><literal><text>access_token</text></literal><text> field of</text></paragraph></listItem></list><paragraph><text>the </text><ref_role domain="std" name="label" target="post-/auth/providers/{provider}/login"></ref_role><text> and
</text><ref_role domain="std" name="label" target="post-/auth/session"></ref_role><text> API endpoints.</text></paragraph></listItem></list></directive></section><section><heading id="responses"><text>Responses</text></heading><paragraph><literal><text>200</text></literal><text>: The API keys were successfully listed.</text></paragraph><code lang="json" copyable="True">[
  {
    "_id": "string",
    "name": "string",
    "disabled": "boolean"
  }
]</code><directive name="list-table" header-rows="1" widths="35 15 50"><list enumtype="unordered"><listItem><list enumtype="unordered"><listItem><paragraph><text>Field</text></paragraph></listItem><listItem><paragraph><text>Type</text></paragraph></listItem><listItem><paragraph><text>Description</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>[]</text></literal></paragraph></listItem><listItem><paragraph><text>array of objects</text></paragraph></listItem><listItem></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>[]._id</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>[].name</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>[].disabled</text></literal></paragraph></listItem><listItem><paragraph><text>boolean</text></paragraph></listItem><listItem></listItem></list></listItem></list></directive></section></directive><directive domain="mongodb" name="operation" hash="post-/groups/{groupid}/apps/{appid}/api_keys" method="post" path="/groups/{groupId}/apps/{appId}/api_keys"><paragraph><text>Create a new </text><ref_role domain="std" name="doc" fileid="['/authentication/api-key', '']"><text>API key</text></ref_role><text>.</text></paragraph><section><heading id="path-parameters"><text>Path Parameters</text></heading><directive name="list-table" header-rows="1" widths="20 15 15 50"><list enumtype="unordered"><listItem><list enumtype="unordered"><listItem><paragraph><text>Name</text></paragraph></listItem><listItem><paragraph><text>Type</text></paragraph></listItem><listItem><paragraph><text>Necessity</text></paragraph></listItem><listItem><paragraph><text>Description</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>groupId</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>An </text><substitution_reference name="atlas"></substitution_reference><text> </text><reference refuri="https://docs.atlas.mongodb.com/tutorial/manage-projects/"><text>Project/Group ID</text></reference><text>.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>appId</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>The ObjectID of your application.</text></paragraph></listItem></list><paragraph><ref_role domain="std" name="label" target="realm-api-project-and-application-ids"></ref_role><text> demonstrates how
to find this value.</text></paragraph></listItem></list></directive></section><section><heading id="header-parameters"><text>Header Parameters</text></heading><directive name="list-table" header-rows="1" widths="20 15 15 50"><list enumtype="unordered"><listItem><list enumtype="unordered"><listItem><paragraph><text>Name</text></paragraph></listItem><listItem><paragraph><text>Type</text></paragraph></listItem><listItem><paragraph><text>Necessity</text></paragraph></listItem><listItem><paragraph><text>Description</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>Authorization</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>The authorization token provided in the </text><literal><text>access_token</text></literal><text> field of</text></paragraph></listItem></list><paragraph><text>the </text><ref_role domain="std" name="label" target="post-/auth/providers/{provider}/login"></ref_role><text> and
</text><ref_role domain="std" name="label" target="post-/auth/session"></ref_role><text> API endpoints.</text></paragraph></listItem></list></directive></section><section><heading id="request-body"><text>Request Body </text><role domain="mongodb" name="required" target="True"></role></heading><paragraph><text>The API key to create.</text></paragraph><code lang="json" copyable="True">{
  "name": "string"
}</code><directive name="list-table" header-rows="1" widths="20 15 15 50"><list enumtype="unordered"><listItem><list enumtype="unordered"><listItem><paragraph><text>Field</text></paragraph></listItem><listItem><paragraph><text>Type</text></paragraph></listItem><listItem><paragraph><text>Necessity</text></paragraph></listItem><listItem><paragraph><text>Description</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>name</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem></listItem></list></listItem></list></directive></section><section><heading id="responses"><text>Responses</text></heading><paragraph><literal><text>201</text></literal><text>: The API key was successfully created.</text></paragraph><code lang="json" copyable="True">{
  "_id": "string",
  "key": "string",
  "name": "string",
  "disabled": "string"
}</code><directive name="list-table" header-rows="1" widths="35 15 50"><list enumtype="unordered"><listItem><list enumtype="unordered"><listItem><paragraph><text>Field</text></paragraph></listItem><listItem><paragraph><text>Type</text></paragraph></listItem><listItem><paragraph><text>Description</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>_id</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>key</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>name</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>disabled</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem></listItem></list></listItem></list></directive></section></directive></section><section><heading id="billing-apis"><text>Billing APIs</text></heading><directive domain="mongodb" name="operation" hash="get-/groups/{groupid}/apps/{appid}/measurements/" method="get" path="/groups/{groupId}/apps/{appId}/measurements/"><paragraph><text>List the request, compute, sync, data transfer, and memory usage of a specific app in a given period for </text><ref_role domain="std" name="doc" fileid="['/billing', '']"><text>billing</text></ref_role><text> purposes.</text></paragraph><section><heading id="path-parameters"><text>Path Parameters</text></heading><directive name="list-table" header-rows="1" widths="20 15 15 50"><list enumtype="unordered"><listItem><list enumtype="unordered"><listItem><paragraph><text>Name</text></paragraph></listItem><listItem><paragraph><text>Type</text></paragraph></listItem><listItem><paragraph><text>Necessity</text></paragraph></listItem><listItem><paragraph><text>Description</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>groupId</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>An </text><substitution_reference name="atlas"></substitution_reference><text> </text><reference refuri="https://docs.atlas.mongodb.com/tutorial/manage-projects/"><text>Project/Group ID</text></reference><text>.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>appId</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>The ObjectID of your application.</text></paragraph></listItem></list><paragraph><ref_role domain="std" name="label" target="realm-api-project-and-application-ids"></ref_role><text> demonstrates how
to find this value.</text></paragraph></listItem></list></directive></section><section><heading id="query-parameters"><text>Query Parameters</text></heading><directive name="list-table" header-rows="1" widths="20 15 15 50"><list enumtype="unordered"><listItem><list enumtype="unordered"><listItem><paragraph><text>Name</text></paragraph></listItem><listItem><paragraph><text>Type</text></paragraph></listItem><listItem><paragraph><text>Necessity</text></paragraph></listItem><listItem><paragraph><text>Description</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>start</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>optional</text></paragraph></listItem><listItem><paragraph><text>The ISO 8601 date and time of the start of the query period. Default is 00:00:00 UTC on the first day of the current month.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>end</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>optional</text></paragraph></listItem><listItem><paragraph><text>The ISO 8601 date and time of the end of the query period. Default is 23:59:59 UTC on the the last day of the current month.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>granularity</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>optional</text></paragraph></listItem><listItem><paragraph><text>Specifies the granularity of the query period, either P31D (31 day) or PT1H (1 hour). Default is P31D.</text></paragraph><paragraph><text>Possible Values:</text></paragraph><list enumtype="unordered"><listItem><paragraph><literal><text>P31D</text></literal></paragraph></listItem><listItem><paragraph><literal><text>PT1H</text></literal></paragraph></listItem></list></listItem></list></listItem></list></directive></section><section><heading id="header-parameters"><text>Header Parameters</text></heading><directive name="list-table" header-rows="1" widths="20 15 15 50"><list enumtype="unordered"><listItem><list enumtype="unordered"><listItem><paragraph><text>Name</text></paragraph></listItem><listItem><paragraph><text>Type</text></paragraph></listItem><listItem><paragraph><text>Necessity</text></paragraph></listItem><listItem><paragraph><text>Description</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>Authorization</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>The authorization token provided in the </text><literal><text>access_token</text></literal><text> field of</text></paragraph></listItem></list><paragraph><text>the </text><ref_role domain="std" name="label" target="post-/auth/providers/{provider}/login"></ref_role><text> and
</text><ref_role domain="std" name="label" target="post-/auth/session"></ref_role><text> API endpoints.</text></paragraph></listItem></list></directive></section><section><heading id="responses"><text>Responses</text></heading><paragraph><literal><text>200</text></literal><text>: The measurements were successfully returned.</text></paragraph><code lang="json" copyable="True">{
  "start": "string",
  "end": "string",
  "granularity": "string",
  "group_id": "string",
  "appId": "string",
  "appName": "string",
  "measurements": [
    {
      "name": "string",
      "units": "string",
      "data_points": [
        {
          "timestamp": "string",
          "value": "number"
        }
      ]
    }
  ]
}</code><directive name="list-table" header-rows="1" widths="35 15 50"><list enumtype="unordered"><listItem><list enumtype="unordered"><listItem><paragraph><text>Field</text></paragraph></listItem><listItem><paragraph><text>Type</text></paragraph></listItem><listItem><paragraph><text>Description</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>start</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>The RFC 3339 date and time of the start of the query period, which can be specified with the </text><literal><text>start</text></literal><text> query parameter.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>end</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>The RFC 3339 date and time of the end of the query period, which can be specified with the </text><literal><text>end</text></literal><text> query parameter.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>granularity</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>The granularity, which can be specified with the </text><literal><text>granularity</text></literal><text> query parameter.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>group_id</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>The </text><substitution_reference name="atlas"></substitution_reference><text> </text><reference refuri="https://docs.atlas.mongodb.com/tutorial/manage-projects/"><text>Group ID</text></reference><text>.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>appId</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>The Realm app ID specified by the </text><literal><text>appId</text></literal><text> path parameter.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>appName</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>The name of the Realm app specified by the </text><literal><text>appId</text></literal><text> path parameter.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>measurements</text></literal></paragraph></listItem><listItem><paragraph><text>array</text></paragraph></listItem><listItem><paragraph><text>The array of measurements.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>measurements.[].name</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>The usage metric represented by each data point. See </text><ref_role domain="std" name="doc" fileid="['/billing', '']"><text>billing</text></ref_role><text>.</text></paragraph><paragraph><text>Possible Values:</text></paragraph><list enumtype="unordered"><listItem><paragraph><literal><text>request_count</text></literal></paragraph></listItem><listItem><paragraph><literal><text>compute_time</text></literal></paragraph></listItem><listItem><paragraph><literal><text>data_out</text></literal></paragraph></listItem><listItem><paragraph><literal><text>sync_time</text></literal></paragraph></listItem><listItem><paragraph><literal><text>mem_usage</text></literal></paragraph></listItem></list></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>measurements.[].units</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>The unit of the </text><literal><text>value</text></literal><text> of each data point.</text></paragraph><paragraph><text>Possible Values:</text></paragraph><list enumtype="unordered"><listItem><paragraph><literal><text>&lt;empty string&gt;</text></literal></paragraph></listItem><listItem><paragraph><literal><text>HOURS</text></literal></paragraph></listItem><listItem><paragraph><literal><text>GIGABYTES</text></literal></paragraph></listItem><listItem><paragraph><literal><text>GIGABYTE_SECONDS</text></literal></paragraph></listItem></list></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>measurements.[].data_points</text></literal></paragraph></listItem><listItem><paragraph><text>array</text></paragraph></listItem><listItem><paragraph><text>The array of data points for this measurement. A finer </text><literal><text>granularity</text></literal><text> results in more data points.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>measurements.[].data_points.[].timestamp</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>The ISO 8601 date and time of the data point.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>measurements.[].data_points.[].value</text></literal></paragraph></listItem><listItem><paragraph><text>number</text></paragraph></listItem><listItem><paragraph><text>The value at the time in the </text><literal><text>unit</text></literal><text> of the measurement.</text></paragraph></listItem></list></listItem></list></directive><paragraph><literal><text>400</text></literal><text>: There is an error in the request.</text></paragraph><code lang="json" copyable="True">{
  "error": "string"
}</code><directive name="list-table" header-rows="1" widths="35 15 50"><list enumtype="unordered"><listItem><list enumtype="unordered"><listItem><paragraph><text>Field</text></paragraph></listItem><listItem><paragraph><text>Type</text></paragraph></listItem><listItem><paragraph><text>Description</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>error</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>A message describing the error.</text></paragraph></listItem></list></listItem></list></directive></section></directive></section><section><heading id="logging-apis"><text>Logging APIs</text></heading><directive domain="mongodb" name="operation" hash="get-/groups/{groupid}/apps/{appid}/logs" method="get" path="/groups/{groupId}/apps/{appId}/logs"><paragraph><text>Retrieve MongoDB Realm logs.</text></paragraph><section><heading id="path-parameters"><text>Path Parameters</text></heading><directive name="list-table" header-rows="1" widths="20 15 15 50"><list enumtype="unordered"><listItem><list enumtype="unordered"><listItem><paragraph><text>Name</text></paragraph></listItem><listItem><paragraph><text>Type</text></paragraph></listItem><listItem><paragraph><text>Necessity</text></paragraph></listItem><listItem><paragraph><text>Description</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>groupId</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>An </text><substitution_reference name="atlas"></substitution_reference><text> </text><reference refuri="https://docs.atlas.mongodb.com/tutorial/manage-projects/"><text>Project/Group ID</text></reference><text>.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>appId</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>The ObjectID of your application.</text></paragraph></listItem></list><paragraph><ref_role domain="std" name="label" target="realm-api-project-and-application-ids"></ref_role><text> demonstrates how
to find this value.</text></paragraph></listItem></list></directive></section><section><heading id="query-parameters"><text>Query Parameters</text></heading><directive name="list-table" header-rows="1" widths="20 15 15 50"><list enumtype="unordered"><listItem><list enumtype="unordered"><listItem><paragraph><text>Name</text></paragraph></listItem><listItem><paragraph><text>Type</text></paragraph></listItem><listItem><paragraph><text>Necessity</text></paragraph></listItem><listItem><paragraph><text>Description</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>co_id</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>optional</text></paragraph></listItem><listItem><paragraph><text>Return only log messages associated with the given request ID.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>errors_only</text></literal></paragraph></listItem><listItem><paragraph><text>boolean</text></paragraph></listItem><listItem><paragraph><text>optional</text></paragraph></listItem><listItem><paragraph><text>Whether to only return errors.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>user_id</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>optional</text></paragraph></listItem><listItem><paragraph><text>Return only log messages associated with the given </text><literal><text>user_id</text></literal><text>.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>start_date</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>optional</text></paragraph></listItem><listItem><paragraph><text>The date and time in ISO 8601 at which to begin returning results, exclusive.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>end_date</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>optional</text></paragraph></listItem><listItem><paragraph><text>The date and time in ISO 8601 at which to cease returning results, inclusive.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>skip</text></literal></paragraph></listItem><listItem><paragraph><text>integer</text></paragraph></listItem><listItem><paragraph><text>optional</text></paragraph></listItem><listItem><paragraph><text>The offset number of matching log entries to skip before including them in the response.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>limit</text></literal></paragraph></listItem><listItem><paragraph><text>integer</text></paragraph></listItem><listItem><paragraph><text>optional</text></paragraph></listItem><listItem><paragraph><text>The maximum number of log entries to include in the response. If the</text></paragraph></listItem></list><paragraph><text>query matches more than this many logs, it returns documents in
ascending order by date until the limit is reached.</text></paragraph></listItem></list></directive></section><section><heading id="header-parameters"><text>Header Parameters</text></heading><directive name="list-table" header-rows="1" widths="20 15 15 50"><list enumtype="unordered"><listItem><list enumtype="unordered"><listItem><paragraph><text>Name</text></paragraph></listItem><listItem><paragraph><text>Type</text></paragraph></listItem><listItem><paragraph><text>Necessity</text></paragraph></listItem><listItem><paragraph><text>Description</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>Authorization</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>The authorization token provided in the </text><literal><text>access_token</text></literal><text> field of</text></paragraph></listItem></list><paragraph><text>the </text><ref_role domain="std" name="label" target="post-/auth/providers/{provider}/login"></ref_role><text> and
</text><ref_role domain="std" name="label" target="post-/auth/session"></ref_role><text> API endpoints.</text></paragraph></listItem></list></directive></section><section><heading id="responses"><text>Responses</text></heading><paragraph><literal><text>200</text></literal><text>: Successfully retrieved.</text></paragraph><code lang="json" copyable="True">{
  "logs": [
    {
      "_id": "string",
      "co_id": "string",
      "domain_id": "string",
      "app_id": "string",
      "group_id": "string",
      "request_url": "string",
      "request_method": "string",
      "started": "string",
      "completed": "string",
      "error": "string",
      "error_code": "string",
      "status": "integer"
    }
  ],
  "nextEndDate": "string",
  "nextSkip": "integer"
}</code><directive name="list-table" header-rows="1" widths="35 15 50"><list enumtype="unordered"><listItem><list enumtype="unordered"><listItem><paragraph><text>Field</text></paragraph></listItem><listItem><paragraph><text>Type</text></paragraph></listItem><listItem><paragraph><text>Description</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>logs</text></literal></paragraph></listItem><listItem><paragraph><text>array</text></paragraph></listItem><listItem></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>logs.[]._id</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>logs.[].co_id</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>logs.[].domain_id</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>logs.[].app_id</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>The ObjectID of your application.</text></paragraph></listItem></list><paragraph><ref_role domain="std" name="label" target="realm-api-project-and-application-ids"></ref_role><text> demonstrates how
to find this value.</text></paragraph></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>logs.[].group_id</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>An </text><substitution_reference name="atlas"></substitution_reference><text> </text><reference refuri="https://docs.atlas.mongodb.com/tutorial/manage-projects/"><text>Project/Group ID</text></reference><text>.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>logs.[].request_url</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>logs.[].request_method</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>logs.[].started</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>logs.[].completed</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>logs.[].error</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>logs.[].error_code</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>logs.[].status</text></literal></paragraph></listItem><listItem><paragraph><text>integer</text></paragraph></listItem><listItem></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>nextEndDate</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>The end date and time of the next page of log entries in ISO 8601 format. MongoDB Realm paginates the result sets of queries that match more than 100 log entries and includes this field in paginated responses. To get the next page of up to 100 entries, pass this value as the </text><literal><text>end_date</text></literal><text> parameter in a subsequent request.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>nextSkip</text></literal></paragraph></listItem><listItem><paragraph><text>integer</text></paragraph></listItem><listItem><paragraph><text>The offset into the next page of log entries in ISO 8601 format. MongoDB Realm paginates the result sets of queries that match more than 100 log entries and includes this field in paginated responses where the first entry on the next page has the same timestamp as the last entry on this page. To get the next page of up to 100 entries, pass this value, if it is present, as the </text><literal><text>skip</text></literal><text> parameter in a subsequent request.</text></paragraph></listItem></list></listItem></list></directive></section></directive></section><section><heading id="services-apis"><text>Services APIs</text></heading><directive domain="mongodb" name="operation" hash="get-/groups/{groupid}/apps/{appid}/services/{serviceid}" method="get" path="/groups/{groupId}/apps/{appId}/services/{serviceId}"><paragraph><text>Retrieve a </text><ref_role domain="std" name="label" target="services"><text>service</text></ref_role><text>.</text></paragraph><section><heading id="description"><text>Description</text></heading><paragraph><text>Test description here.</text></paragraph></section><section><heading id="path-parameters"><text>Path Parameters</text></heading><directive name="list-table" header-rows="1" widths="20 15 15 50"><list enumtype="unordered"><listItem><list enumtype="unordered"><listItem><paragraph><text>Name</text></paragraph></listItem><listItem><paragraph><text>Type</text></paragraph></listItem><listItem><paragraph><text>Necessity</text></paragraph></listItem><listItem><paragraph><text>Description</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>groupId</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>An </text><substitution_reference name="atlas"></substitution_reference><text> </text><reference refuri="https://docs.atlas.mongodb.com/tutorial/manage-projects/"><text>Project/Group ID</text></reference><text>.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>appId</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>The ObjectID of your application.</text></paragraph></listItem></list><paragraph><ref_role domain="std" name="label" target="realm-api-project-and-application-ids"></ref_role><text> demonstrates how
to find this value.</text></paragraph></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>serviceId</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>Service ID</text></paragraph></listItem></list></listItem></list></directive></section><section><heading id="header-parameters"><text>Header Parameters</text></heading><directive name="list-table" header-rows="1" widths="20 15 15 50"><list enumtype="unordered"><listItem><list enumtype="unordered"><listItem><paragraph><text>Name</text></paragraph></listItem><listItem><paragraph><text>Type</text></paragraph></listItem><listItem><paragraph><text>Necessity</text></paragraph></listItem><listItem><paragraph><text>Description</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>Authorization</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>The authorization token provided in the </text><literal><text>access_token</text></literal><text> field of</text></paragraph></listItem></list><paragraph><text>the </text><ref_role domain="std" name="label" target="post-/auth/providers/{provider}/login"></ref_role><text> and
</text><ref_role domain="std" name="label" target="post-/auth/session"></ref_role><text> API endpoints.</text></paragraph></listItem></list></directive></section><section><heading id="responses"><text>Responses</text></heading><paragraph><literal><text>200</text></literal><text>: The service was successfully deleted.</text></paragraph><code lang="json" copyable="True">{
  "_id": "string",
  "name": "string",
  "type": "string",
  "version": "integer"
}</code><directive name="list-table" header-rows="1" widths="35 15 50"><list enumtype="unordered"><listItem><list enumtype="unordered"><listItem><paragraph><text>Field</text></paragraph></listItem><listItem><paragraph><text>Type</text></paragraph></listItem><listItem><paragraph><text>Description</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>_id</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>name</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>type</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>version</text></literal></paragraph></listItem><listItem><paragraph><text>integer</text></paragraph></listItem><listItem></listItem></list></listItem></list></directive></section></directive><directive domain="mongodb" name="operation" hash="delete-/groups/{groupid}/apps/{appid}/services/{serviceid}" method="delete" path="/groups/{groupId}/apps/{appId}/services/{serviceId}"><paragraph><text>Delete a </text><ref_role domain="std" name="label" target="services"><text>service</text></ref_role><text>.</text></paragraph><section><heading id="path-parameters"><text>Path Parameters</text></heading><directive name="list-table" header-rows="1" widths="20 15 15 50"><list enumtype="unordered"><listItem><list enumtype="unordered"><listItem><paragraph><text>Name</text></paragraph></listItem><listItem><paragraph><text>Type</text></paragraph></listItem><listItem><paragraph><text>Necessity</text></paragraph></listItem><listItem><paragraph><text>Description</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>groupId</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>An </text><substitution_reference name="atlas"></substitution_reference><text> </text><reference refuri="https://docs.atlas.mongodb.com/tutorial/manage-projects/"><text>Project/Group ID</text></reference><text>.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>appId</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>The ObjectID of your application.</text></paragraph></listItem></list><paragraph><ref_role domain="std" name="label" target="realm-api-project-and-application-ids"></ref_role><text> demonstrates how
to find this value.</text></paragraph></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>serviceId</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>Service ID</text></paragraph></listItem></list></listItem></list></directive></section><section><heading id="header-parameters"><text>Header Parameters</text></heading><directive name="list-table" header-rows="1" widths="20 15 15 50"><list enumtype="unordered"><listItem><list enumtype="unordered"><listItem><paragraph><text>Name</text></paragraph></listItem><listItem><paragraph><text>Type</text></paragraph></listItem><listItem><paragraph><text>Necessity</text></paragraph></listItem><listItem><paragraph><text>Description</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>Authorization</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>The authorization token provided in the </text><literal><text>access_token</text></literal><text> field of</text></paragraph></listItem></list><paragraph><text>the </text><ref_role domain="std" name="label" target="post-/auth/providers/{provider}/login"></ref_role><text> and
</text><ref_role domain="std" name="label" target="post-/auth/session"></ref_role><text> API endpoints.</text></paragraph></listItem></list></directive></section><section><heading id="responses"><text>Responses</text></heading><paragraph><literal><text>204</text></literal><text>: The service was successfully deleted.</text></paragraph></section></directive><directive domain="mongodb" name="operation" hash="patch-/groups/{groupid}/apps/{appid}/services/{serviceid}" method="patch" path="/groups/{groupId}/apps/{appId}/services/{serviceId}"><paragraph><text>Update a </text><ref_role domain="std" name="label" target="services"><text>service</text></ref_role><text>.</text></paragraph><section><heading id="path-parameters"><text>Path Parameters</text></heading><directive name="list-table" header-rows="1" widths="20 15 15 50"><list enumtype="unordered"><listItem><list enumtype="unordered"><listItem><paragraph><text>Name</text></paragraph></listItem><listItem><paragraph><text>Type</text></paragraph></listItem><listItem><paragraph><text>Necessity</text></paragraph></listItem><listItem><paragraph><text>Description</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>groupId</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>An </text><substitution_reference name="atlas"></substitution_reference><text> </text><reference refuri="https://docs.atlas.mongodb.com/tutorial/manage-projects/"><text>Project/Group ID</text></reference><text>.</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>appId</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>The ObjectID of your application.</text></paragraph></listItem></list><paragraph><ref_role domain="std" name="label" target="realm-api-project-and-application-ids"></ref_role><text> demonstrates how
to find this value.</text></paragraph></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>serviceId</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>Service ID</text></paragraph></listItem></list></listItem></list></directive></section><section><heading id="header-parameters"><text>Header Parameters</text></heading><directive name="list-table" header-rows="1" widths="20 15 15 50"><list enumtype="unordered"><listItem><list enumtype="unordered"><listItem><paragraph><text>Name</text></paragraph></listItem><listItem><paragraph><text>Type</text></paragraph></listItem><listItem><paragraph><text>Necessity</text></paragraph></listItem><listItem><paragraph><text>Description</text></paragraph></listItem></list></listItem><listItem><list enumtype="unordered"><listItem><paragraph><literal><text>Authorization</text></literal></paragraph></listItem><listItem><paragraph><text>string</text></paragraph></listItem><listItem><paragraph><text>required</text></paragraph></listItem><listItem><paragraph><text>The authorization token provided in the </text><literal><text>access_token</text></literal><text> field of</text></paragraph></listItem></list><paragraph><text>the </text><ref_role domain="std" name="label" target="post-/auth/providers/{provider}/login"></ref_role><text> and
</text><ref_role domain="std" name="label" target="post-/auth/session"></ref_role><text> API endpoints.</text></paragraph></listItem></list></directive></section><section><heading id="responses"><text>Responses</text></heading><paragraph><literal><text>200</text></literal><text>: Successfully updated.</text></paragraph></section></directive></section></directive></root>
        """,
    )
