# This file is automatically generated by pyo3_stub_gen
# ruff: noqa: E501, F401

import builtins
import typing

class PyAgentClass:
    r"""
    agent class
    """
    def __new__(cls,agent_org:builtins.str, agent_ns:builtins.str, agent_class:builtins.str): ...
    ...

class PyAgentSource:
    r"""
    packet source with encoded agent information
    plus incoming connection
    """
    def __new__(cls,org:builtins.int, ns:builtins.int, class:builtins.int, id:builtins.int, connection:builtins.int): ...
    ...

class PyGatewayConfig:
    r"""
    gatewayconfig class
    """
    def __new__(cls,endpoint:builtins.str, insecure:builtins.bool=False, insecure_skip_verify:builtins.bool=False, tls_ca_path:typing.Optional[builtins.str]=None, tls_ca_pem:typing.Optional[builtins.str]=None, tls_cert_path:typing.Optional[builtins.str]=None, tls_key_path:typing.Optional[builtins.str]=None, tls_cert_pem:typing.Optional[builtins.str]=None, tls_key_pem:typing.Optional[builtins.str]=None, basic_auth_username:typing.Optional[builtins.str]=None, basic_auth_password:typing.Optional[builtins.str]=None): ...
    ...

class PyService:
    def __new__(cls,id:builtins.str): ...
    def configure(self, config:PyGatewayConfig) -> None:
        ...


def connect(svc:PyService) -> typing.Any:
    ...

def create_agent(svc:PyService, agent_org:builtins.str, agent_ns:builtins.str, agent_class:builtins.str, agent_id:typing.Optional[builtins.int]=None) -> typing.Any:
    ...

def disconnect(svc:PyService, conn:builtins.int) -> typing.Any:
    ...

def publish(svc:PyService, fanout:builtins.int, blob:typing.Sequence[builtins.int], name:typing.Optional[PyAgentClass]=None, id:typing.Optional[builtins.int]=None, agent:typing.Optional[PyAgentSource]=None) -> typing.Any:
    ...

def receive(svc:PyService) -> typing.Any:
    ...

def remove_route(svc:PyService, conn:builtins.int, name:PyAgentClass, id:typing.Optional[builtins.int]=None) -> typing.Any:
    ...

def serve(svc:PyService) -> typing.Any:
    ...

def set_route(svc:PyService, conn:builtins.int, name:PyAgentClass, id:typing.Optional[builtins.int]=None) -> typing.Any:
    ...

def subscribe(svc:PyService, conn:builtins.int, name:PyAgentClass, id:typing.Optional[builtins.int]=None) -> typing.Any:
    ...

def unsubscribe(svc:PyService, conn:builtins.int, name:PyAgentClass, id:typing.Optional[builtins.int]=None) -> typing.Any:
    ...

