# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""`OpenQL` is a C++/Python framework for high-level quantum programming. The framework provides a compiler for compiling and optimizing quantum code. The compiler produces the intermediate quantum assembly language in cQASM (Common QASM) and the compiled eQASM (executable QASM) for various target platforms. While the eQASM is platform-specific, the quantum assembly code (QASM) is hardware-agnostic and can be simulated on the QX simulator."""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _openql
else:
    import _openql

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    r"""Proxy of C++ swig::SwigPyIterator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _openql.delete_SwigPyIterator

    def value(self):
        r"""value(SwigPyIterator self) -> PyObject *"""
        return _openql.SwigPyIterator_value(self)

    def incr(self, n=1):
        r"""incr(SwigPyIterator self, size_t n=1) -> SwigPyIterator"""
        return _openql.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        r"""decr(SwigPyIterator self, size_t n=1) -> SwigPyIterator"""
        return _openql.SwigPyIterator_decr(self, n)

    def distance(self, x):
        r"""distance(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t"""
        return _openql.SwigPyIterator_distance(self, x)

    def equal(self, x):
        r"""equal(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _openql.SwigPyIterator_equal(self, x)

    def copy(self):
        r"""copy(SwigPyIterator self) -> SwigPyIterator"""
        return _openql.SwigPyIterator_copy(self)

    def next(self):
        r"""next(SwigPyIterator self) -> PyObject *"""
        return _openql.SwigPyIterator_next(self)

    def __next__(self):
        r"""__next__(SwigPyIterator self) -> PyObject *"""
        return _openql.SwigPyIterator___next__(self)

    def previous(self):
        r"""previous(SwigPyIterator self) -> PyObject *"""
        return _openql.SwigPyIterator_previous(self)

    def advance(self, n):
        r"""advance(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _openql.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        r"""__eq__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _openql.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        r"""__ne__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _openql.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        r"""__iadd__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _openql.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        r"""__isub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _openql.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        r"""__add__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _openql.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        r"""
        __sub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator
        __sub__(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t
        """
        return _openql.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _openql:
_openql.SwigPyIterator_swigregister(SwigPyIterator)

class vectori(object):
    r"""Proxy of C++ std::vector< int > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(vectori self) -> SwigPyIterator"""
        return _openql.vectori_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(vectori self) -> bool"""
        return _openql.vectori___nonzero__(self)

    def __bool__(self):
        r"""__bool__(vectori self) -> bool"""
        return _openql.vectori___bool__(self)

    def __len__(self):
        r"""__len__(vectori self) -> std::vector< int >::size_type"""
        return _openql.vectori___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(vectori self, std::vector< int >::difference_type i, std::vector< int >::difference_type j) -> vectori"""
        return _openql.vectori___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(vectori self, std::vector< int >::difference_type i, std::vector< int >::difference_type j)
        __setslice__(vectori self, std::vector< int >::difference_type i, std::vector< int >::difference_type j, vectori v)
        """
        return _openql.vectori___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(vectori self, std::vector< int >::difference_type i, std::vector< int >::difference_type j)"""
        return _openql.vectori___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(vectori self, std::vector< int >::difference_type i)
        __delitem__(vectori self, PySliceObject * slice)
        """
        return _openql.vectori___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(vectori self, PySliceObject * slice) -> vectori
        __getitem__(vectori self, std::vector< int >::difference_type i) -> std::vector< int >::value_type const &
        """
        return _openql.vectori___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(vectori self, PySliceObject * slice, vectori v)
        __setitem__(vectori self, PySliceObject * slice)
        __setitem__(vectori self, std::vector< int >::difference_type i, std::vector< int >::value_type const & x)
        """
        return _openql.vectori___setitem__(self, *args)

    def pop(self):
        r"""pop(vectori self) -> std::vector< int >::value_type"""
        return _openql.vectori_pop(self)

    def append(self, x):
        r"""append(vectori self, std::vector< int >::value_type const & x)"""
        return _openql.vectori_append(self, x)

    def empty(self):
        r"""empty(vectori self) -> bool"""
        return _openql.vectori_empty(self)

    def size(self):
        r"""size(vectori self) -> std::vector< int >::size_type"""
        return _openql.vectori_size(self)

    def swap(self, v):
        r"""swap(vectori self, vectori v)"""
        return _openql.vectori_swap(self, v)

    def begin(self):
        r"""begin(vectori self) -> std::vector< int >::iterator"""
        return _openql.vectori_begin(self)

    def end(self):
        r"""end(vectori self) -> std::vector< int >::iterator"""
        return _openql.vectori_end(self)

    def rbegin(self):
        r"""rbegin(vectori self) -> std::vector< int >::reverse_iterator"""
        return _openql.vectori_rbegin(self)

    def rend(self):
        r"""rend(vectori self) -> std::vector< int >::reverse_iterator"""
        return _openql.vectori_rend(self)

    def clear(self):
        r"""clear(vectori self)"""
        return _openql.vectori_clear(self)

    def get_allocator(self):
        r"""get_allocator(vectori self) -> std::vector< int >::allocator_type"""
        return _openql.vectori_get_allocator(self)

    def pop_back(self):
        r"""pop_back(vectori self)"""
        return _openql.vectori_pop_back(self)

    def erase(self, *args):
        r"""
        erase(vectori self, std::vector< int >::iterator pos) -> std::vector< int >::iterator
        erase(vectori self, std::vector< int >::iterator first, std::vector< int >::iterator last) -> std::vector< int >::iterator
        """
        return _openql.vectori_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(vectori self) -> vectori
        __init__(vectori self, vectori other) -> vectori
        __init__(vectori self, std::vector< int >::size_type size) -> vectori
        __init__(vectori self, std::vector< int >::size_type size, std::vector< int >::value_type const & value) -> vectori
        """
        _openql.vectori_swiginit(self, _openql.new_vectori(*args))

    def push_back(self, x):
        r"""push_back(vectori self, std::vector< int >::value_type const & x)"""
        return _openql.vectori_push_back(self, x)

    def front(self):
        r"""front(vectori self) -> std::vector< int >::value_type const &"""
        return _openql.vectori_front(self)

    def back(self):
        r"""back(vectori self) -> std::vector< int >::value_type const &"""
        return _openql.vectori_back(self)

    def assign(self, n, x):
        r"""assign(vectori self, std::vector< int >::size_type n, std::vector< int >::value_type const & x)"""
        return _openql.vectori_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(vectori self, std::vector< int >::size_type new_size)
        resize(vectori self, std::vector< int >::size_type new_size, std::vector< int >::value_type const & x)
        """
        return _openql.vectori_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(vectori self, std::vector< int >::iterator pos, std::vector< int >::value_type const & x) -> std::vector< int >::iterator
        insert(vectori self, std::vector< int >::iterator pos, std::vector< int >::size_type n, std::vector< int >::value_type const & x)
        """
        return _openql.vectori_insert(self, *args)

    def reserve(self, n):
        r"""reserve(vectori self, std::vector< int >::size_type n)"""
        return _openql.vectori_reserve(self, n)

    def capacity(self):
        r"""capacity(vectori self) -> std::vector< int >::size_type"""
        return _openql.vectori_capacity(self)
    __swig_destroy__ = _openql.delete_vectori

# Register vectori in _openql:
_openql.vectori_swigregister(vectori)

class vectorui(object):
    r"""Proxy of C++ std::vector< size_t > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(vectorui self) -> SwigPyIterator"""
        return _openql.vectorui_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(vectorui self) -> bool"""
        return _openql.vectorui___nonzero__(self)

    def __bool__(self):
        r"""__bool__(vectorui self) -> bool"""
        return _openql.vectorui___bool__(self)

    def __len__(self):
        r"""__len__(vectorui self) -> std::vector< size_t >::size_type"""
        return _openql.vectorui___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(vectorui self, std::vector< size_t >::difference_type i, std::vector< size_t >::difference_type j) -> vectorui"""
        return _openql.vectorui___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(vectorui self, std::vector< size_t >::difference_type i, std::vector< size_t >::difference_type j)
        __setslice__(vectorui self, std::vector< size_t >::difference_type i, std::vector< size_t >::difference_type j, vectorui v)
        """
        return _openql.vectorui___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(vectorui self, std::vector< size_t >::difference_type i, std::vector< size_t >::difference_type j)"""
        return _openql.vectorui___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(vectorui self, std::vector< size_t >::difference_type i)
        __delitem__(vectorui self, PySliceObject * slice)
        """
        return _openql.vectorui___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(vectorui self, PySliceObject * slice) -> vectorui
        __getitem__(vectorui self, std::vector< size_t >::difference_type i) -> std::vector< size_t >::value_type const &
        """
        return _openql.vectorui___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(vectorui self, PySliceObject * slice, vectorui v)
        __setitem__(vectorui self, PySliceObject * slice)
        __setitem__(vectorui self, std::vector< size_t >::difference_type i, std::vector< size_t >::value_type const & x)
        """
        return _openql.vectorui___setitem__(self, *args)

    def pop(self):
        r"""pop(vectorui self) -> std::vector< size_t >::value_type"""
        return _openql.vectorui_pop(self)

    def append(self, x):
        r"""append(vectorui self, std::vector< size_t >::value_type const & x)"""
        return _openql.vectorui_append(self, x)

    def empty(self):
        r"""empty(vectorui self) -> bool"""
        return _openql.vectorui_empty(self)

    def size(self):
        r"""size(vectorui self) -> std::vector< size_t >::size_type"""
        return _openql.vectorui_size(self)

    def swap(self, v):
        r"""swap(vectorui self, vectorui v)"""
        return _openql.vectorui_swap(self, v)

    def begin(self):
        r"""begin(vectorui self) -> std::vector< size_t >::iterator"""
        return _openql.vectorui_begin(self)

    def end(self):
        r"""end(vectorui self) -> std::vector< size_t >::iterator"""
        return _openql.vectorui_end(self)

    def rbegin(self):
        r"""rbegin(vectorui self) -> std::vector< size_t >::reverse_iterator"""
        return _openql.vectorui_rbegin(self)

    def rend(self):
        r"""rend(vectorui self) -> std::vector< size_t >::reverse_iterator"""
        return _openql.vectorui_rend(self)

    def clear(self):
        r"""clear(vectorui self)"""
        return _openql.vectorui_clear(self)

    def get_allocator(self):
        r"""get_allocator(vectorui self) -> std::vector< size_t >::allocator_type"""
        return _openql.vectorui_get_allocator(self)

    def pop_back(self):
        r"""pop_back(vectorui self)"""
        return _openql.vectorui_pop_back(self)

    def erase(self, *args):
        r"""
        erase(vectorui self, std::vector< size_t >::iterator pos) -> std::vector< size_t >::iterator
        erase(vectorui self, std::vector< size_t >::iterator first, std::vector< size_t >::iterator last) -> std::vector< size_t >::iterator
        """
        return _openql.vectorui_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(vectorui self) -> vectorui
        __init__(vectorui self, vectorui other) -> vectorui
        __init__(vectorui self, std::vector< size_t >::size_type size) -> vectorui
        __init__(vectorui self, std::vector< size_t >::size_type size, std::vector< size_t >::value_type const & value) -> vectorui
        """
        _openql.vectorui_swiginit(self, _openql.new_vectorui(*args))

    def push_back(self, x):
        r"""push_back(vectorui self, std::vector< size_t >::value_type const & x)"""
        return _openql.vectorui_push_back(self, x)

    def front(self):
        r"""front(vectorui self) -> std::vector< size_t >::value_type const &"""
        return _openql.vectorui_front(self)

    def back(self):
        r"""back(vectorui self) -> std::vector< size_t >::value_type const &"""
        return _openql.vectorui_back(self)

    def assign(self, n, x):
        r"""assign(vectorui self, std::vector< size_t >::size_type n, std::vector< size_t >::value_type const & x)"""
        return _openql.vectorui_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(vectorui self, std::vector< size_t >::size_type new_size)
        resize(vectorui self, std::vector< size_t >::size_type new_size, std::vector< size_t >::value_type const & x)
        """
        return _openql.vectorui_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(vectorui self, std::vector< size_t >::iterator pos, std::vector< size_t >::value_type const & x) -> std::vector< size_t >::iterator
        insert(vectorui self, std::vector< size_t >::iterator pos, std::vector< size_t >::size_type n, std::vector< size_t >::value_type const & x)
        """
        return _openql.vectorui_insert(self, *args)

    def reserve(self, n):
        r"""reserve(vectorui self, std::vector< size_t >::size_type n)"""
        return _openql.vectorui_reserve(self, n)

    def capacity(self):
        r"""capacity(vectorui self) -> std::vector< size_t >::size_type"""
        return _openql.vectorui_capacity(self)
    __swig_destroy__ = _openql.delete_vectorui

# Register vectorui in _openql:
_openql.vectorui_swigregister(vectorui)

class vectorf(object):
    r"""Proxy of C++ std::vector< float > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(vectorf self) -> SwigPyIterator"""
        return _openql.vectorf_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(vectorf self) -> bool"""
        return _openql.vectorf___nonzero__(self)

    def __bool__(self):
        r"""__bool__(vectorf self) -> bool"""
        return _openql.vectorf___bool__(self)

    def __len__(self):
        r"""__len__(vectorf self) -> std::vector< float >::size_type"""
        return _openql.vectorf___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(vectorf self, std::vector< float >::difference_type i, std::vector< float >::difference_type j) -> vectorf"""
        return _openql.vectorf___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(vectorf self, std::vector< float >::difference_type i, std::vector< float >::difference_type j)
        __setslice__(vectorf self, std::vector< float >::difference_type i, std::vector< float >::difference_type j, vectorf v)
        """
        return _openql.vectorf___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(vectorf self, std::vector< float >::difference_type i, std::vector< float >::difference_type j)"""
        return _openql.vectorf___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(vectorf self, std::vector< float >::difference_type i)
        __delitem__(vectorf self, PySliceObject * slice)
        """
        return _openql.vectorf___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(vectorf self, PySliceObject * slice) -> vectorf
        __getitem__(vectorf self, std::vector< float >::difference_type i) -> std::vector< float >::value_type const &
        """
        return _openql.vectorf___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(vectorf self, PySliceObject * slice, vectorf v)
        __setitem__(vectorf self, PySliceObject * slice)
        __setitem__(vectorf self, std::vector< float >::difference_type i, std::vector< float >::value_type const & x)
        """
        return _openql.vectorf___setitem__(self, *args)

    def pop(self):
        r"""pop(vectorf self) -> std::vector< float >::value_type"""
        return _openql.vectorf_pop(self)

    def append(self, x):
        r"""append(vectorf self, std::vector< float >::value_type const & x)"""
        return _openql.vectorf_append(self, x)

    def empty(self):
        r"""empty(vectorf self) -> bool"""
        return _openql.vectorf_empty(self)

    def size(self):
        r"""size(vectorf self) -> std::vector< float >::size_type"""
        return _openql.vectorf_size(self)

    def swap(self, v):
        r"""swap(vectorf self, vectorf v)"""
        return _openql.vectorf_swap(self, v)

    def begin(self):
        r"""begin(vectorf self) -> std::vector< float >::iterator"""
        return _openql.vectorf_begin(self)

    def end(self):
        r"""end(vectorf self) -> std::vector< float >::iterator"""
        return _openql.vectorf_end(self)

    def rbegin(self):
        r"""rbegin(vectorf self) -> std::vector< float >::reverse_iterator"""
        return _openql.vectorf_rbegin(self)

    def rend(self):
        r"""rend(vectorf self) -> std::vector< float >::reverse_iterator"""
        return _openql.vectorf_rend(self)

    def clear(self):
        r"""clear(vectorf self)"""
        return _openql.vectorf_clear(self)

    def get_allocator(self):
        r"""get_allocator(vectorf self) -> std::vector< float >::allocator_type"""
        return _openql.vectorf_get_allocator(self)

    def pop_back(self):
        r"""pop_back(vectorf self)"""
        return _openql.vectorf_pop_back(self)

    def erase(self, *args):
        r"""
        erase(vectorf self, std::vector< float >::iterator pos) -> std::vector< float >::iterator
        erase(vectorf self, std::vector< float >::iterator first, std::vector< float >::iterator last) -> std::vector< float >::iterator
        """
        return _openql.vectorf_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(vectorf self) -> vectorf
        __init__(vectorf self, vectorf other) -> vectorf
        __init__(vectorf self, std::vector< float >::size_type size) -> vectorf
        __init__(vectorf self, std::vector< float >::size_type size, std::vector< float >::value_type const & value) -> vectorf
        """
        _openql.vectorf_swiginit(self, _openql.new_vectorf(*args))

    def push_back(self, x):
        r"""push_back(vectorf self, std::vector< float >::value_type const & x)"""
        return _openql.vectorf_push_back(self, x)

    def front(self):
        r"""front(vectorf self) -> std::vector< float >::value_type const &"""
        return _openql.vectorf_front(self)

    def back(self):
        r"""back(vectorf self) -> std::vector< float >::value_type const &"""
        return _openql.vectorf_back(self)

    def assign(self, n, x):
        r"""assign(vectorf self, std::vector< float >::size_type n, std::vector< float >::value_type const & x)"""
        return _openql.vectorf_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(vectorf self, std::vector< float >::size_type new_size)
        resize(vectorf self, std::vector< float >::size_type new_size, std::vector< float >::value_type const & x)
        """
        return _openql.vectorf_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(vectorf self, std::vector< float >::iterator pos, std::vector< float >::value_type const & x) -> std::vector< float >::iterator
        insert(vectorf self, std::vector< float >::iterator pos, std::vector< float >::size_type n, std::vector< float >::value_type const & x)
        """
        return _openql.vectorf_insert(self, *args)

    def reserve(self, n):
        r"""reserve(vectorf self, std::vector< float >::size_type n)"""
        return _openql.vectorf_reserve(self, n)

    def capacity(self):
        r"""capacity(vectorf self) -> std::vector< float >::size_type"""
        return _openql.vectorf_capacity(self)
    __swig_destroy__ = _openql.delete_vectorf

# Register vectorf in _openql:
_openql.vectorf_swigregister(vectorf)

class vectord(object):
    r"""Proxy of C++ std::vector< double > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(vectord self) -> SwigPyIterator"""
        return _openql.vectord_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(vectord self) -> bool"""
        return _openql.vectord___nonzero__(self)

    def __bool__(self):
        r"""__bool__(vectord self) -> bool"""
        return _openql.vectord___bool__(self)

    def __len__(self):
        r"""__len__(vectord self) -> std::vector< double >::size_type"""
        return _openql.vectord___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(vectord self, std::vector< double >::difference_type i, std::vector< double >::difference_type j) -> vectord"""
        return _openql.vectord___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(vectord self, std::vector< double >::difference_type i, std::vector< double >::difference_type j)
        __setslice__(vectord self, std::vector< double >::difference_type i, std::vector< double >::difference_type j, vectord v)
        """
        return _openql.vectord___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(vectord self, std::vector< double >::difference_type i, std::vector< double >::difference_type j)"""
        return _openql.vectord___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(vectord self, std::vector< double >::difference_type i)
        __delitem__(vectord self, PySliceObject * slice)
        """
        return _openql.vectord___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(vectord self, PySliceObject * slice) -> vectord
        __getitem__(vectord self, std::vector< double >::difference_type i) -> std::vector< double >::value_type const &
        """
        return _openql.vectord___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(vectord self, PySliceObject * slice, vectord v)
        __setitem__(vectord self, PySliceObject * slice)
        __setitem__(vectord self, std::vector< double >::difference_type i, std::vector< double >::value_type const & x)
        """
        return _openql.vectord___setitem__(self, *args)

    def pop(self):
        r"""pop(vectord self) -> std::vector< double >::value_type"""
        return _openql.vectord_pop(self)

    def append(self, x):
        r"""append(vectord self, std::vector< double >::value_type const & x)"""
        return _openql.vectord_append(self, x)

    def empty(self):
        r"""empty(vectord self) -> bool"""
        return _openql.vectord_empty(self)

    def size(self):
        r"""size(vectord self) -> std::vector< double >::size_type"""
        return _openql.vectord_size(self)

    def swap(self, v):
        r"""swap(vectord self, vectord v)"""
        return _openql.vectord_swap(self, v)

    def begin(self):
        r"""begin(vectord self) -> std::vector< double >::iterator"""
        return _openql.vectord_begin(self)

    def end(self):
        r"""end(vectord self) -> std::vector< double >::iterator"""
        return _openql.vectord_end(self)

    def rbegin(self):
        r"""rbegin(vectord self) -> std::vector< double >::reverse_iterator"""
        return _openql.vectord_rbegin(self)

    def rend(self):
        r"""rend(vectord self) -> std::vector< double >::reverse_iterator"""
        return _openql.vectord_rend(self)

    def clear(self):
        r"""clear(vectord self)"""
        return _openql.vectord_clear(self)

    def get_allocator(self):
        r"""get_allocator(vectord self) -> std::vector< double >::allocator_type"""
        return _openql.vectord_get_allocator(self)

    def pop_back(self):
        r"""pop_back(vectord self)"""
        return _openql.vectord_pop_back(self)

    def erase(self, *args):
        r"""
        erase(vectord self, std::vector< double >::iterator pos) -> std::vector< double >::iterator
        erase(vectord self, std::vector< double >::iterator first, std::vector< double >::iterator last) -> std::vector< double >::iterator
        """
        return _openql.vectord_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(vectord self) -> vectord
        __init__(vectord self, vectord other) -> vectord
        __init__(vectord self, std::vector< double >::size_type size) -> vectord
        __init__(vectord self, std::vector< double >::size_type size, std::vector< double >::value_type const & value) -> vectord
        """
        _openql.vectord_swiginit(self, _openql.new_vectord(*args))

    def push_back(self, x):
        r"""push_back(vectord self, std::vector< double >::value_type const & x)"""
        return _openql.vectord_push_back(self, x)

    def front(self):
        r"""front(vectord self) -> std::vector< double >::value_type const &"""
        return _openql.vectord_front(self)

    def back(self):
        r"""back(vectord self) -> std::vector< double >::value_type const &"""
        return _openql.vectord_back(self)

    def assign(self, n, x):
        r"""assign(vectord self, std::vector< double >::size_type n, std::vector< double >::value_type const & x)"""
        return _openql.vectord_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(vectord self, std::vector< double >::size_type new_size)
        resize(vectord self, std::vector< double >::size_type new_size, std::vector< double >::value_type const & x)
        """
        return _openql.vectord_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(vectord self, std::vector< double >::iterator pos, std::vector< double >::value_type const & x) -> std::vector< double >::iterator
        insert(vectord self, std::vector< double >::iterator pos, std::vector< double >::size_type n, std::vector< double >::value_type const & x)
        """
        return _openql.vectord_insert(self, *args)

    def reserve(self, n):
        r"""reserve(vectord self, std::vector< double >::size_type n)"""
        return _openql.vectord_reserve(self, n)

    def capacity(self):
        r"""capacity(vectord self) -> std::vector< double >::size_type"""
        return _openql.vectord_capacity(self)
    __swig_destroy__ = _openql.delete_vectord

# Register vectord in _openql:
_openql.vectord_swigregister(vectord)

class vectorc(object):
    r"""Proxy of C++ std::vector< std::complex< double > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(vectorc self) -> SwigPyIterator"""
        return _openql.vectorc_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(vectorc self) -> bool"""
        return _openql.vectorc___nonzero__(self)

    def __bool__(self):
        r"""__bool__(vectorc self) -> bool"""
        return _openql.vectorc___bool__(self)

    def __len__(self):
        r"""__len__(vectorc self) -> std::vector< std::complex< double > >::size_type"""
        return _openql.vectorc___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(vectorc self, std::vector< std::complex< double > >::difference_type i, std::vector< std::complex< double > >::difference_type j) -> vectorc"""
        return _openql.vectorc___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(vectorc self, std::vector< std::complex< double > >::difference_type i, std::vector< std::complex< double > >::difference_type j)
        __setslice__(vectorc self, std::vector< std::complex< double > >::difference_type i, std::vector< std::complex< double > >::difference_type j, vectorc v)
        """
        return _openql.vectorc___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(vectorc self, std::vector< std::complex< double > >::difference_type i, std::vector< std::complex< double > >::difference_type j)"""
        return _openql.vectorc___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(vectorc self, std::vector< std::complex< double > >::difference_type i)
        __delitem__(vectorc self, PySliceObject * slice)
        """
        return _openql.vectorc___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(vectorc self, PySliceObject * slice) -> vectorc
        __getitem__(vectorc self, std::vector< std::complex< double > >::difference_type i) -> std::vector< std::complex< double > >::value_type const &
        """
        return _openql.vectorc___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(vectorc self, PySliceObject * slice, vectorc v)
        __setitem__(vectorc self, PySliceObject * slice)
        __setitem__(vectorc self, std::vector< std::complex< double > >::difference_type i, std::vector< std::complex< double > >::value_type const & x)
        """
        return _openql.vectorc___setitem__(self, *args)

    def pop(self):
        r"""pop(vectorc self) -> std::vector< std::complex< double > >::value_type"""
        return _openql.vectorc_pop(self)

    def append(self, x):
        r"""append(vectorc self, std::vector< std::complex< double > >::value_type const & x)"""
        return _openql.vectorc_append(self, x)

    def empty(self):
        r"""empty(vectorc self) -> bool"""
        return _openql.vectorc_empty(self)

    def size(self):
        r"""size(vectorc self) -> std::vector< std::complex< double > >::size_type"""
        return _openql.vectorc_size(self)

    def swap(self, v):
        r"""swap(vectorc self, vectorc v)"""
        return _openql.vectorc_swap(self, v)

    def begin(self):
        r"""begin(vectorc self) -> std::vector< std::complex< double > >::iterator"""
        return _openql.vectorc_begin(self)

    def end(self):
        r"""end(vectorc self) -> std::vector< std::complex< double > >::iterator"""
        return _openql.vectorc_end(self)

    def rbegin(self):
        r"""rbegin(vectorc self) -> std::vector< std::complex< double > >::reverse_iterator"""
        return _openql.vectorc_rbegin(self)

    def rend(self):
        r"""rend(vectorc self) -> std::vector< std::complex< double > >::reverse_iterator"""
        return _openql.vectorc_rend(self)

    def clear(self):
        r"""clear(vectorc self)"""
        return _openql.vectorc_clear(self)

    def get_allocator(self):
        r"""get_allocator(vectorc self) -> std::vector< std::complex< double > >::allocator_type"""
        return _openql.vectorc_get_allocator(self)

    def pop_back(self):
        r"""pop_back(vectorc self)"""
        return _openql.vectorc_pop_back(self)

    def erase(self, *args):
        r"""
        erase(vectorc self, std::vector< std::complex< double > >::iterator pos) -> std::vector< std::complex< double > >::iterator
        erase(vectorc self, std::vector< std::complex< double > >::iterator first, std::vector< std::complex< double > >::iterator last) -> std::vector< std::complex< double > >::iterator
        """
        return _openql.vectorc_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(vectorc self) -> vectorc
        __init__(vectorc self, vectorc other) -> vectorc
        __init__(vectorc self, std::vector< std::complex< double > >::size_type size) -> vectorc
        __init__(vectorc self, std::vector< std::complex< double > >::size_type size, std::vector< std::complex< double > >::value_type const & value) -> vectorc
        """
        _openql.vectorc_swiginit(self, _openql.new_vectorc(*args))

    def push_back(self, x):
        r"""push_back(vectorc self, std::vector< std::complex< double > >::value_type const & x)"""
        return _openql.vectorc_push_back(self, x)

    def front(self):
        r"""front(vectorc self) -> std::vector< std::complex< double > >::value_type const &"""
        return _openql.vectorc_front(self)

    def back(self):
        r"""back(vectorc self) -> std::vector< std::complex< double > >::value_type const &"""
        return _openql.vectorc_back(self)

    def assign(self, n, x):
        r"""assign(vectorc self, std::vector< std::complex< double > >::size_type n, std::vector< std::complex< double > >::value_type const & x)"""
        return _openql.vectorc_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(vectorc self, std::vector< std::complex< double > >::size_type new_size)
        resize(vectorc self, std::vector< std::complex< double > >::size_type new_size, std::vector< std::complex< double > >::value_type const & x)
        """
        return _openql.vectorc_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(vectorc self, std::vector< std::complex< double > >::iterator pos, std::vector< std::complex< double > >::value_type const & x) -> std::vector< std::complex< double > >::iterator
        insert(vectorc self, std::vector< std::complex< double > >::iterator pos, std::vector< std::complex< double > >::size_type n, std::vector< std::complex< double > >::value_type const & x)
        """
        return _openql.vectorc_insert(self, *args)

    def reserve(self, n):
        r"""reserve(vectorc self, std::vector< std::complex< double > >::size_type n)"""
        return _openql.vectorc_reserve(self, n)

    def capacity(self):
        r"""capacity(vectorc self) -> std::vector< std::complex< double > >::size_type"""
        return _openql.vectorc_capacity(self)
    __swig_destroy__ = _openql.delete_vectorc

# Register vectorc in _openql:
_openql.vectorc_swigregister(vectorc)

class mapss(object):
    r"""Proxy of C++ std::map< std::string,std::string > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(mapss self) -> SwigPyIterator"""
        return _openql.mapss_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(mapss self) -> bool"""
        return _openql.mapss___nonzero__(self)

    def __bool__(self):
        r"""__bool__(mapss self) -> bool"""
        return _openql.mapss___bool__(self)

    def __len__(self):
        r"""__len__(mapss self) -> std::map< std::string,std::string >::size_type"""
        return _openql.mapss___len__(self)
    def __iter__(self):
        return self.key_iterator()
    def iterkeys(self):
        return self.key_iterator()
    def itervalues(self):
        return self.value_iterator()
    def iteritems(self):
        return self.iterator()

    def __getitem__(self, key):
        r"""__getitem__(mapss self, std::map< std::string,std::string >::key_type const & key) -> std::map< std::string,std::string >::mapped_type const &"""
        return _openql.mapss___getitem__(self, key)

    def __delitem__(self, key):
        r"""__delitem__(mapss self, std::map< std::string,std::string >::key_type const & key)"""
        return _openql.mapss___delitem__(self, key)

    def has_key(self, key):
        r"""has_key(mapss self, std::map< std::string,std::string >::key_type const & key) -> bool"""
        return _openql.mapss_has_key(self, key)

    def keys(self):
        r"""keys(mapss self) -> PyObject *"""
        return _openql.mapss_keys(self)

    def values(self):
        r"""values(mapss self) -> PyObject *"""
        return _openql.mapss_values(self)

    def items(self):
        r"""items(mapss self) -> PyObject *"""
        return _openql.mapss_items(self)

    def __contains__(self, key):
        r"""__contains__(mapss self, std::map< std::string,std::string >::key_type const & key) -> bool"""
        return _openql.mapss___contains__(self, key)

    def key_iterator(self):
        r"""key_iterator(mapss self) -> SwigPyIterator"""
        return _openql.mapss_key_iterator(self)

    def value_iterator(self):
        r"""value_iterator(mapss self) -> SwigPyIterator"""
        return _openql.mapss_value_iterator(self)

    def __setitem__(self, *args):
        r"""
        __setitem__(mapss self, std::map< std::string,std::string >::key_type const & key)
        __setitem__(mapss self, std::map< std::string,std::string >::key_type const & key, std::map< std::string,std::string >::mapped_type const & x)
        """
        return _openql.mapss___setitem__(self, *args)

    def asdict(self):
        r"""asdict(mapss self) -> PyObject *"""
        return _openql.mapss_asdict(self)

    def __init__(self, *args):
        r"""
        __init__(mapss self, std::less< std::string > const & other) -> mapss
        __init__(mapss self) -> mapss
        __init__(mapss self, mapss other) -> mapss
        """
        _openql.mapss_swiginit(self, _openql.new_mapss(*args))

    def empty(self):
        r"""empty(mapss self) -> bool"""
        return _openql.mapss_empty(self)

    def size(self):
        r"""size(mapss self) -> std::map< std::string,std::string >::size_type"""
        return _openql.mapss_size(self)

    def swap(self, v):
        r"""swap(mapss self, mapss v)"""
        return _openql.mapss_swap(self, v)

    def begin(self):
        r"""begin(mapss self) -> std::map< std::string,std::string >::iterator"""
        return _openql.mapss_begin(self)

    def end(self):
        r"""end(mapss self) -> std::map< std::string,std::string >::iterator"""
        return _openql.mapss_end(self)

    def rbegin(self):
        r"""rbegin(mapss self) -> std::map< std::string,std::string >::reverse_iterator"""
        return _openql.mapss_rbegin(self)

    def rend(self):
        r"""rend(mapss self) -> std::map< std::string,std::string >::reverse_iterator"""
        return _openql.mapss_rend(self)

    def clear(self):
        r"""clear(mapss self)"""
        return _openql.mapss_clear(self)

    def get_allocator(self):
        r"""get_allocator(mapss self) -> std::map< std::string,std::string >::allocator_type"""
        return _openql.mapss_get_allocator(self)

    def count(self, x):
        r"""count(mapss self, std::map< std::string,std::string >::key_type const & x) -> std::map< std::string,std::string >::size_type"""
        return _openql.mapss_count(self, x)

    def erase(self, *args):
        r"""
        erase(mapss self, std::map< std::string,std::string >::key_type const & x) -> std::map< std::string,std::string >::size_type
        erase(mapss self, std::map< std::string,std::string >::iterator position)
        erase(mapss self, std::map< std::string,std::string >::iterator first, std::map< std::string,std::string >::iterator last)
        """
        return _openql.mapss_erase(self, *args)

    def find(self, x):
        r"""find(mapss self, std::map< std::string,std::string >::key_type const & x) -> std::map< std::string,std::string >::iterator"""
        return _openql.mapss_find(self, x)

    def lower_bound(self, x):
        r"""lower_bound(mapss self, std::map< std::string,std::string >::key_type const & x) -> std::map< std::string,std::string >::iterator"""
        return _openql.mapss_lower_bound(self, x)

    def upper_bound(self, x):
        r"""upper_bound(mapss self, std::map< std::string,std::string >::key_type const & x) -> std::map< std::string,std::string >::iterator"""
        return _openql.mapss_upper_bound(self, x)
    __swig_destroy__ = _openql.delete_mapss

# Register mapss in _openql:
_openql.mapss_swigregister(mapss)


def initialize():
    r"""
    initialize()

    Initializes the OpenQL library, for as far as this must be done. This should
    ideally be called by the user (in Python) before anything else, but
    set_option() and the constructors of Compiler and Platform will automatically
    call this when it hasn't been done yet as well.

    Currently this just resets the options to their default values to give the
    user a clean slate to work with in terms of global variables (in case someone
    else has used the library in the same interpreter before them, for instance,
    as might happen with ipython/Jupyter in a shared notebook server, or during
    test suites), but it may initialize more things in the future.

    Parameters
    ----------
    None

    Returns
    -------
    None

    """
    return _openql.initialize()

def ensure_initialized():
    r"""
    ensure_initialized()

    Calls initialize() if it hasn't been called yet.

    Parameters
    ----------
    None

    Returns
    -------
    None

    """
    return _openql.ensure_initialized()

def get_version():
    r"""
    get_version() -> std::string

    Returns the compiler's version string.

    Parameters
    ----------
    None

    Returns
    -------
    str
        version number as a string

    """
    return _openql.get_version()

def set_option(option, value):
    r"""
    set_option(std::string const & option, std::string const & value)

    Sets a global option for the compiler. Use print_options() to get a list of
    all available options.

    Parameters
    ----------
    option : str
        Name of the option to set.
    value : str
        The value to set the option to.

    Returns
    -------
    None

    """
    return _openql.set_option(option, value)

def get_option(option):
    r"""
    get_option(std::string const & option) -> std::string

    Returns the current value for a global option. Use print_options() to get a
    list of all available options.

    Parameters
    ----------
    option : str
        Name of the option to retrieve the value of.

    Returns
    -------
    str
        The value that the option has been set to, or its default value if the
        option has not been set yet.

    """
    return _openql.get_option(option)

def print_options():
    r"""
    print_options()

    Prints the documentation for all available global options.

    Parameters
    ----------
    None

    Returns
    -------
    None

    """
    return _openql.print_options()

def dump_options():
    r"""
    dump_options() -> std::string

    Returns the result of print_options() as a string.

    Parameters
    ----------
    None

    Returns
    -------
    str
        The documentation for the options.

    """
    return _openql.dump_options()

def print_architectures():
    r"""
    print_architectures()

    Prints the documentation for all available target architectures.

    Parameters
    ----------
    None

    Returns
    -------
    None

    """
    return _openql.print_architectures()

def dump_architectures():
    r"""
    dump_architectures() -> std::string

    Returns the result of print_architectures() as a string.

    Parameters
    ----------
    None

    Returns
    -------
    str
        The documentation for the supported architectures.

    """
    return _openql.dump_architectures()

def print_passes():
    r"""
    print_passes()

    Prints the documentation for all available passes.

    Parameters
    ----------
    None

    Returns
    -------
    None

    """
    return _openql.print_passes()

def dump_passes():
    r"""
    dump_passes() -> std::string

    Returns the result of print_passes() as a string.

    Parameters
    ----------
    None

    Returns
    -------
    str
        The documentation for the supported passes.

    """
    return _openql.dump_passes()

def print_resources():
    r"""
    print_resources()

    Prints the documentation for all available scheduler resources.

    Parameters
    ----------
    None

    Returns
    -------
    None

    """
    return _openql.print_resources()

def dump_resources():
    r"""
    dump_resources() -> std::string

    Returns the result of print_resources() as a string.

    Parameters
    ----------
    None

    Returns
    -------
    str
        The documentation for the supported scheduler resources.

    """
    return _openql.dump_resources()

def print_platform_docs():
    r"""
    print_platform_docs()

    Prints the documentation for platform configuration files.

    Parameters
    ----------
    None

    Returns
    -------
    None

    """
    return _openql.print_platform_docs()

def dump_platform_docs():
    r"""
    dump_platform_docs() -> std::string

    Returns the result of print_platform_docs() as a string.

    Parameters
    ----------
    None

    Returns
    -------
    str
        The documentation for the platform configuration file.

    """
    return _openql.dump_platform_docs()

def print_compiler_docs():
    r"""
    print_compiler_docs()

    Prints the documentation for compiler configuration files.

    Parameters
    ----------
    None

    Returns
    -------
    None

    """
    return _openql.print_compiler_docs()

def dump_compiler_docs():
    r"""
    dump_compiler_docs() -> std::string

    Returns the result of print_compiler_docs() as a string.

    Parameters
    ----------
    None

    Returns
    -------
    str
        The documentation for the compiler configuration file.

    """
    return _openql.dump_compiler_docs()
class Pass(object):
    r"""

    Wrapper for a pass that belongs to some pass manager.

    NOTE: while it's possible to construct a pass manually, the resulting object
    cannot be used in any way. The only way to obtain a valid pass object is through
    a Compiler object.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(Pass self) -> Pass"""
        _openql.Pass_swiginit(self, _openql.new_Pass())

    def get_type(self):
        r"""
        get_type(Pass self) -> std::string const &

        Returns the full, desugared type name that this pass was constructed with.

        Parameters
        ----------
        None

        Returns
        -------
        str
            The type name.

        """
        return _openql.Pass_get_type(self)

    def get_name(self):
        r"""
        get_name(Pass self) -> std::string const &

        Returns the instance name of the pass within the surrounding group.

        Parameters
        ----------
        None

        Returns
        -------
        str
            The instance name.

        """
        return _openql.Pass_get_name(self)

    def print_pass_documentation(self):
        r"""
        print_pass_documentation(Pass self)

        Prints the documentation for this pass.

        Parameters
        ----------
        None

        Returns
        -------
        None

        """
        return _openql.Pass_print_pass_documentation(self)

    def dump_pass_documentation(self):
        r"""
        dump_pass_documentation(Pass self) -> std::string

        Returns the documentation for this pass as a string.

        Parameters
        ----------
        None

        Returns
        -------
        str
            The documentation for this pass as a multiline string.

        """
        return _openql.Pass_dump_pass_documentation(self)

    def print_options(self, only_set=False):
        r"""
        print_options(Pass self, bool only_set=False)

        Prints the current state of the options.

        Parameters
        ----------
        only_set : bool
            When set, only the options that were explicitly configured are dumped.

        Returns
        -------
        None

        """
        return _openql.Pass_print_options(self, only_set)

    def dump_options(self, only_set=False):
        r"""
        dump_options(Pass self, bool only_set=False) -> std::string

        Returns the string printed by print_options().

        Parameters
        ----------
        only_set : bool
            When set, only the options that were explicitly configured are dumped.

        Returns
        -------
        str
            The option documentation as a multiline string.

        """
        return _openql.Pass_dump_options(self, only_set)

    def set_option(self, option, value):
        r"""
        set_option(Pass self, std::string const & option, std::string const & value)

        Sets an option.

        Parameters
        ----------
        option : str
            The option name.
        value : str
            The value to set the option to.

        Returns
        -------
        None

        """
        return _openql.Pass_set_option(self, option, value)

    def get_option(self, option):
        r"""
        get_option(Pass self, std::string const & option) -> std::string

        Returns the current value of an option.

        Parameters
        ----------
        path : str
            The path to the option.

        Returns
        -------
        str
            The value of the option. If the option has not been set, the default value
            is returned.

        """
        return _openql.Pass_get_option(self, option)
    __swig_destroy__ = _openql.delete_Pass

# Register Pass in _openql:
_openql.Pass_swigregister(Pass)

class Compiler(object):
    r"""

    Wrapper for the compiler/pass manager.

    This allows you to change the compilation strategy, if the defaults are
    insufficient for your application. You can get access to a Compiler via
    several methods:

     - using Platform.get_compiler();
     - using Program.get_compiler();
     - using one of the constructors.

    Using the constructors, you can get an empty compiler (by specifying no
    arguments or only specifying name), a default compiler for a given platform
    (by specifying a name and a platform), or a compiler based on a compiler
    configuration JSON file (by specifying a name and a filename). For the structure
    of this JSON file, refer to the configuration section of the ReadTheDocs
    documentation or, equivalently, the result of `openql.print_compiler_docs()`.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    name = property(_openql.Compiler_name_get, _openql.Compiler_name_set, doc=r"""
    name : std::string

    User-given name for this compiler.

    NOTE: not actually used for anything. It's only here for consistency with
    the rest of the API objects.

    """)

    def __init__(self, *args):
        r"""
        __init__(Compiler self, std::string const & name="") -> Compiler
        __init__(Compiler self, std::string const & name, std::string const & filename) -> Compiler
        __init__(Compiler self, std::string const & name, Platform platform) -> Compiler
        """
        _openql.Compiler_swiginit(self, _openql.new_Compiler(*args))

    def print_pass_types(self):
        r"""
        print_pass_types(Compiler self)

        Prints documentation for all available pass types, as well as the option
        documentation for the passes.

        Parameters
        ----------
        None

        Returns
        -------
        None

        """
        return _openql.Compiler_print_pass_types(self)

    def dump_pass_types(self):
        r"""
        dump_pass_types(Compiler self) -> std::string

        Returns documentation for all available pass types, as well as the option
        documentation for the passes.

        Parameters
        ----------
        None

        Returns
        -------
        str
            The list of pass types and their documentation as a multiline string.

        """
        return _openql.Compiler_dump_pass_types(self)

    def print_strategy(self):
        r"""
        print_strategy(Compiler self)

        Prints the currently configured compilation strategy.

        Parameters
        ----------
        None

        Returns
        -------
        None

        """
        return _openql.Compiler_print_strategy(self)

    def dump_strategy(self):
        r"""
        dump_strategy(Compiler self) -> std::string

        Returns the currently configured compilation strategy as a string.

        Parameters
        ----------
        None

        Returns
        -------
        str
            The current compilation strategy as a multiline string.

        """
        return _openql.Compiler_dump_strategy(self)

    def set_option(self, path, value, must_exist=True):
        r"""
        set_option(Compiler self, std::string const & path, std::string const & value, bool must_exist=True) -> size_t

        Sets a pass option. The path must consist of the target pass instance name
        and the option name, separated by a period. The former may include * or ?
        wildcards. If must_exist is set an exception will be thrown if none of the
        passes were affected, otherwise 0 will be returned.

        Parameters
        ----------
        path : str
            The path to the option, consisting of the pass name and the option name
            separated by a period.
        value : str
            The value to set the option to.
        must_exist : bool
            When set, an exception will be thrown when no options matched the path.

        Returns
        -------
        int
            The number of pass options affected.

        """
        return _openql.Compiler_set_option(self, path, value, must_exist)

    def get_option(self, path):
        r"""
        get_option(Compiler self, std::string const & path) -> std::string

        Returns the current value of an option.

        Parameters
        ----------
        path : str
            The path to the option, consisting of pass name and the actual option name
            separated by a period.

        Returns
        -------
        str
            The value of the option. If the option has not been set, the default value
            is returned.

        """
        return _openql.Compiler_get_option(self, path)

    def append_pass(self, *args):
        r"""
        append_pass(Compiler self, std::string const & type_name, std::string const & instance_name="", mapss options={}) -> Pass

        Appends a pass to the end of the pass list. Returns a reference to the
        constructed pass.

        Parameters
        ----------
        type_name : str
            The type of the pass to add.
        instance_name : str
            A unique name for the pass instance. If empty or unspecified, a name will
            be generated.
        options : dict[str, str]
            A list of initial options to set for the pass. This is just shorthand
            notation for calling set_option() on the returned Pass object.

        Returns
        -------
        Pass
            A reference to the added pass.

        """
        return _openql.Compiler_append_pass(self, *args)

    def prefix_pass(self, *args):
        r"""
        prefix_pass(Compiler self, std::string const & type_name, std::string const & instance_name="", mapss options={}) -> Pass

        Appends a pass to the beginning of the pass list. Returns a reference to the
        constructed pass.

        Parameters
        ----------
        type_name : str
            The type of the pass to add.
        instance_name : str
            A unique name for the pass instance. If empty or unspecified, a name will
            be generated.
        options : dict[str, str]
            A list of initial options to set for the pass. This is just shorthand
            notation for calling set_option() on the returned Pass object.

        Returns
        -------
        Pass
            A reference to the added pass.

        """
        return _openql.Compiler_prefix_pass(self, *args)

    def insert_pass_after(self, *args):
        r"""
        insert_pass_after(Compiler self, std::string const & target, std::string const & type_name, std::string const & instance_name="", mapss options={}) -> Pass

        Inserts a pass immediately after the target pass (named by instance). If
        target does not exist, an exception is thrown. Returns a reference to the
        constructed pass.

        Parameters
        ----------
        target : str
            The name of the pass to insert the new pass after.
        type_name : str
            The type of the pass to add.
        instance_name : str
            A unique name for the pass instance. If empty or unspecified, a name will
            be generated.
        options : dict[str, str]
            A list of initial options to set for the pass. This is just shorthand
            notation for calling set_option() on the returned Pass object.

        Returns
        -------
        Pass
            A reference to the added pass.

        """
        return _openql.Compiler_insert_pass_after(self, *args)

    def insert_pass_before(self, *args):
        r"""
        insert_pass_before(Compiler self, std::string const & target, std::string const & type_name, std::string const & instance_name="", mapss options={}) -> Pass

        Inserts a pass immediately before the target pass (named by instance). If
        target does not exist, an exception is thrown. Returns a reference to the
        constructed pass.

        Parameters
        ----------
        target : str
            The name of the pass to insert the new pass before.
        type_name : str
            The type of the pass to add.
        instance_name : str
            A unique name for the pass instance. If empty or unspecified, a name will
            be generated.
        options : dict[str, str]
            A list of initial options to set for the pass. This is just shorthand
            notation for calling set_option() on the returned Pass object.

        Returns
        -------
        Pass
            A reference to the added pass.

        """
        return _openql.Compiler_insert_pass_before(self, *args)

    def get_pass(self, target):
        r"""
        get_pass(Compiler self, std::string const & target) -> Pass

        Returns a reference to the pass with the given instance name. If no such
        pass exists, an exception is thrown.

        Parameters
        ----------
        target : str
            The name of the pass to retrieve a reference to.

        Returns
        -------
        Pass
            A reference to the targeted pass.

        """
        return _openql.Compiler_get_pass(self, target)

    def does_pass_exist(self, target):
        r"""
        does_pass_exist(Compiler self, std::string const & target) -> bool

        Returns whether a pass with the target instance name exists.

        Parameters
        ----------
        target : str
            The name of the pass to query existence of.

        Returns
        -------
        bool
            Whether a pass with the target name exists.

        """
        return _openql.Compiler_does_pass_exist(self, target)

    def get_num_passes(self):
        r"""
        get_num_passes(Compiler self) -> size_t

        Returns the total number of passes in the root hierarchy.

        Parameters
        ----------
        None

        Returns
        -------
        int
            The number of passes (or groups) within the root pass list.

        """
        return _openql.Compiler_get_num_passes(self)

    def get_passes(self):
        r"""
        get_passes(Compiler self) -> vectorp

        Returns a list with references to all passes in the root hierarchy.

        Parameters
        ----------
        None

        Returns
        -------
        list[Pass]
            The list of all passes in the root hierarchy.

        """
        return _openql.Compiler_get_passes(self)

    def get_passes_by_type(self, target):
        r"""
        get_passes_by_type(Compiler self, std::string const & target) -> vectorp

        Returns a list with references to all passes in the root hierarchy with the
        given type.

        Parameters
        ----------
        target : str
            The target pass type name.

        Returns
        -------
        list[Pass]
            The list of all passes in the root hierarchy with the given type.

        """
        return _openql.Compiler_get_passes_by_type(self, target)

    def remove_pass(self, target):
        r"""
        remove_pass(Compiler self, std::string const & target)

        Removes the pass with the given target instance name, or throws an
        exception if no such pass exists.

        Parameters
        ----------
        target : str
            The name of the pass to remove.

        Returns
        -------
        None

        """
        return _openql.Compiler_remove_pass(self, target)

    def clear_passes(self):
        r"""
        clear_passes(Compiler self)

        Clears the entire pass list.

        Parameters
        ----------
        None

        Returns
        -------
        None

        """
        return _openql.Compiler_clear_passes(self)

    def compile(self, program):
        r"""
        compile(Compiler self, Program program)

        Ensures that all passes have been constructed, and then runs the passes
        on the given program. This is the same as Program.compile() when the
        program is referencing the same compiler.

        Parameters
        ----------
        program : Program
            The program to compile.

        Returns
        -------
        None

        """
        return _openql.Compiler_compile(self, program)
    __swig_destroy__ = _openql.delete_Compiler

# Register Compiler in _openql:
_openql.Compiler_swigregister(Compiler)

class Platform(object):
    r"""

    Quantum platform description. This describes everything that the compiler
    needs to know about the target quantum chip, instruments, etc. Platforms are
    created from either the default configuration for a particular architecture
    variant or from JSON (+ comments) configuration files: there is no way to modify
    a platform using the API, and introspection is limited. Instead, if you want to
    use a custom configuration, you will need to write a JSON configuration file
    for it, or use get_platform_json() and from_json() to modify an existing one
    from within Python.

    The syntax of the platform configuration file is too extensive to describe here.
    It has its own section in the manual.

    In addition to the platform itself, the Platform object provides an interface
    for obtaining a Compiler object. This object describes the *strategy* for
    transforming the quantum algorithm to something that can be executed on the
    device described by the platform. You can think of the difference between
    them as the difference between a verb and a noun: the platform describes
    something that just exists, while the compilation strategy describes how to
    get there.

    The (initial) strategy can be set using a separate configuration file
    (compiler_config), directly from within the platform configuration file,
    or one can be inferred based on the previously hardcoded defaults. Unlike the
    platform itself however, an extensive API is available for adjusting the
    strategy as you see fit; just use get_compiler() to get a reference to a
    Compiler object that may be used for this purpose. If you don't do anything
    with the compiler methods and object, don't specify the compiler_config_file
    parameter, and the "eqasm_compiler" key of the platform configuration file
    refers to one of the previously-hardcoded compiler, a strategy will be
    generated to mimic the old logic for backward compatibility.

    Eight constructors are provided:

     - Platform(): shorthand for Platform('none', 'none').
     - Platform(name): shorthand for Platform(name, name).
     - Platform(name, platform_config): builds a platform with the given name (only
       used for log messages) and platform configuration, the latter of which can
       be either a recognized platform name with or without variant suffix (for
       example "cc" or "cc_light.s7"), or a path to a JSON configuration
       filename.
     - Platform(name, platform_config, compiler_config): as above, but specifies a
       custom compiler configuration file in addition.
     - Platform.from_json(name, platform_config_json): instead of loading the
       platform JSON data from a file, it is taken from its Python object
       representation (as per json.loads()/dumps()).
     - Platform.from_json(name, platform_config_json, compiler_config): as above,
       with compiler JSON file override.
     - Platform.from_json_string(name, platform_config_json): as from_json, but
       loads the data from a string rather than a Python object.
     - Platform.from_json_string(name, platform_config_json, compiler_config): as
       from_json, but loads the data from a string rather than a Python object.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    name = property(_openql.Platform_name_get, _openql.Platform_name_set, doc=r"""
    name : std::string

    The user-given name of the platform.

    """)
    config_file = property(_openql.Platform_config_file_get, _openql.Platform_config_file_set, doc=r"""
    config_file : std::string

    The configuration file that the platform was loaded from.

    """)

    def __init__(self, *args):
        r"""
        __init__(Platform self, std::string const & name, std::string const & platform_config, std::string const & compiler_config="") -> Platform
        __init__(Platform self, std::string const & name="none") -> Platform
        """
        _openql.Platform_swiginit(self, _openql.new_Platform(*args))

    @staticmethod
    def from_json_string(*args):
        r"""
        from_json_string(std::string const & name, std::string const & platform_config_json, std::string const & compiler_config="") -> Platform

        Alternative constructor. Instead of the platform JSON data being loaded from a
        file, they are loaded from the given string. See also from_json().

        Parameters
        ----------
        name : str
            The name for the platform.
        platform_config_json : str
            The platform JSON configuration data as a string. This will accept anything
            that the normal constructor accepts when it reads the configuration from a
            file.
        compiler_config : str
            Optional compiler configuration JSON filename. This is *NOT* JSON data.

        Returns
        -------
        Platform
            The constructed platform.

        """
        return _openql.Platform_from_json_string(*args)

    @staticmethod
    def get_platform_json_string(*args):
        r"""
        get_platform_json_string(std::string const & platform_config="none") -> std::string

        Returns the default platform configuration data as a JSON + comments string.
        The comments use double-slash syntax. Note that JSON itself does not support
        such comments (or comments of any kind), so these comments need to be removed
        from the data before the JSON data can be parsed.

        Parameters
        ----------
        platform_config : str
            The platform configuration. Same syntax as the platform constructor, so this
            supports architecture names, architecture variant names, or JSON filenames.
            In the latter case, this function just loads the file contents into a string
            and returns it.

        Returns
        -------
        str
            The JSON + comments data for the given platform configuration string.

        """
        return _openql.Platform_get_platform_json_string(*args)

    def get_qubit_number(self):
        r"""
        get_qubit_number(Platform self) -> size_t

        Returns the number of qubits in the platform.

        Parameters
        ----------
        None

        Returns
        -------
        int
            The number of qubits in the platform.

        """
        return _openql.Platform_get_qubit_number(self)

    def print_info(self):
        r"""
        print_info(Platform self)

        Prints some basic information about the platform.

        Parameters
        ----------
        None

        Returns
        -------
        None

        """
        return _openql.Platform_print_info(self)

    def dump_info(self):
        r"""
        dump_info(Platform self) -> std::string

        Returns the result of print_info() as a string.

        Parameters
        ----------
        None

        Returns
        -------
        str
            The result of print_info() as a string.

        """
        return _openql.Platform_dump_info(self)

    def get_info(self):
        r"""
        get_info(Platform self) -> std::string

        Old alias for dump_info(). Deprecated.

        Parameters
        ----------
        None

        Returns
        -------
        str
            The result of print_info() as a string.

        """
        return _openql.Platform_get_info(self)

    def has_compiler(self):
        r"""
        has_compiler(Platform self) -> bool

        Returns whether a custom compiler configuration has been attached to this
        platform. When this is the case, programs constructed from this platform
        will use it to implement Program.compile(), rather than generating the
        compiler in-place from defaults and global options during the call.

        Parameters
        ----------
        None

        Returns
        -------
        bool
            Whether a custom compiler configuration has been attached to this platform.

        """
        return _openql.Platform_has_compiler(self)

    def get_compiler(self):
        r"""
        get_compiler(Platform self) -> Compiler

        Returns the custom compiler configuration associated with this platform.
        If no such configuration exists yet, the default one is created,
        attached, and returned.

        Parameters
        ----------
        None

        Returns
        -------
        Compiler
            A Compiler object that may be used to introspect or modify the compilation
            strategy associated with this platform.

        """
        return _openql.Platform_get_compiler(self)

    def set_compiler(self, compiler):
        r"""
        set_compiler(Platform self, Compiler compiler)

        Sets the compiler associated with this platform. Any programs constructed
        from this platform after this call will use the given compiler.

        Parameters
        ----------
        compiler : Compiler
            The new compiler configuration.

        Returns
        -------
        None

        """
        return _openql.Platform_set_compiler(self, compiler)
    __swig_destroy__ = _openql.delete_Platform

# Register Platform in _openql:
_openql.Platform_swigregister(Platform)

def Platform_from_json_string(*args):
    r"""
    Platform_from_json_string(std::string const & name, std::string const & platform_config_json, std::string const & compiler_config="") -> Platform

    Alternative constructor. Instead of the platform JSON data being loaded from a
    file, they are loaded from the given string. See also from_json().

    Parameters
    ----------
    name : str
        The name for the platform.
    platform_config_json : str
        The platform JSON configuration data as a string. This will accept anything
        that the normal constructor accepts when it reads the configuration from a
        file.
    compiler_config : str
        Optional compiler configuration JSON filename. This is *NOT* JSON data.

    Returns
    -------
    Platform
        The constructed platform.

    """
    return _openql.Platform_from_json_string(*args)

def Platform_get_platform_json_string(*args):
    r"""
    Platform_get_platform_json_string(std::string const & platform_config="none") -> std::string

    Returns the default platform configuration data as a JSON + comments string.
    The comments use double-slash syntax. Note that JSON itself does not support
    such comments (or comments of any kind), so these comments need to be removed
    from the data before the JSON data can be parsed.

    Parameters
    ----------
    platform_config : str
        The platform configuration. Same syntax as the platform constructor, so this
        supports architecture names, architecture variant names, or JSON filenames.
        In the latter case, this function just loads the file contents into a string
        and returns it.

    Returns
    -------
    str
        The JSON + comments data for the given platform configuration string.

    """
    return _openql.Platform_get_platform_json_string(*args)

class CReg(object):
    r"""

    Wrapper for a classical integer register with the given index.

    NOTE: classical logic is on the list to be completely revised. This interface
    may change in the (near) future.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, id):
        r"""__init__(CReg self, size_t id) -> CReg"""
        _openql.CReg_swiginit(self, _openql.new_CReg(id))
    __swig_destroy__ = _openql.delete_CReg

# Register CReg in _openql:
_openql.CReg_swigregister(CReg)

class Operation(object):
    r"""

    Wrapper for a classical operation.

    A classical operation acts as a simple expression that returns an integer or a
    boolean. The expression can be a literal number (val), a single CReg (lop,
    primarily used for assignments), a unary function applied to one CReg (op/rop),
    or a binary function applied to two CRegs (lop/op/rop).

    Function selection is done via strings. The following unary functions are
    recognized:

     - '~': bitwise NOT.

    The following binary functions are recognized:

     - '+': addition.
     - '-': subtraction.
     - '&': bitwise AND.
     - '|': bitwise OR.
     - '^': bitwise XOR.
     - '==': equality.
     - '!=': inequality.
     - '>': greater-than.
     - '>=': greater-or-equal.
     - '<': less-than.
     - '<=': less-or-equal.

    NOTE: classical logic is on the list to be completely revised. This interface
    may change in the (near) future.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(Operation self, CReg lop, std::string const & op, CReg rop) -> Operation
        __init__(Operation self, std::string const & op, CReg rop) -> Operation
        __init__(Operation self, CReg lop) -> Operation
        __init__(Operation self, int val) -> Operation
        """
        _openql.Operation_swiginit(self, _openql.new_Operation(*args))
    __swig_destroy__ = _openql.delete_Operation

# Register Operation in _openql:
_openql.Operation_swigregister(Operation)

class Unitary(object):
    r"""

    Unitary matrix interface.

    The constructor creates a unitary gate from the given row-major, square,
    unitary matrix.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    name = property(_openql.Unitary_name_get, doc=r"""
    name : q(const).std::string

    The name given to the unitary gate.

    """)

    def __init__(self, name, matrix):
        r"""__init__(Unitary self, std::string const & name, vectorc matrix) -> Unitary"""
        _openql.Unitary_swiginit(self, _openql.new_Unitary(name, matrix))

    def decompose(self):
        r"""
        decompose(Unitary self)

        Explicitly decomposes the gate. Does not need to be called; it will be
        called automatically when the gate is added to the kernel.

        Parameters
        ----------
        None

        Returns
        -------
        None

        """
        return _openql.Unitary_decompose(self)

    @staticmethod
    def is_decompose_support_enabled():
        r"""
        is_decompose_support_enabled() -> bool

        Returns whether OpenQL was built with unitary decomposition support enabled.

        Parameters
        ----------
        None

        Returns
        -------
        bool
            Whether OpenQL was built with unitary decomposition support enabled.

        """
        return _openql.Unitary_is_decompose_support_enabled()
    __swig_destroy__ = _openql.delete_Unitary

# Register Unitary in _openql:
_openql.Unitary_swigregister(Unitary)

def Unitary_is_decompose_support_enabled():
    r"""
    Unitary_is_decompose_support_enabled() -> bool

    Returns whether OpenQL was built with unitary decomposition support enabled.

    Parameters
    ----------
    None

    Returns
    -------
    bool
        Whether OpenQL was built with unitary decomposition support enabled.

    """
    return _openql.Unitary_is_decompose_support_enabled()

class Kernel(object):
    r"""

    Represents a kernel of a quantum program, a.k.a. a basic block. Kernels are
    just sequences of gates with no classical control-flow in between: they may
    end in a (conditional) branch to the start of another kernel, but otherwise,
    they may only consist of quantum gates and mixed quantum-classical data flow
    operations.

    The constructor creates a new kernel with the given name, using the given
    platform. The third, fourth, and fifth arguments optionally specify the
    desired number of qubits, classical integer registers, and classical bit
    registers. If not specified, the number of qubits is taken from the
    platform, and no classical or bit registers will be allocated.

    Currently, the contents of a kernel can only be constructed by adding gates
    and classical data flow instructions in the order in which they are to be
    executed, and there is no way to get information about which gates are in the
    kernel after the fact. If you need this kind of bookkeeping, you will have to
    wrap OpenQL's kernels for now.

    Classical flow-control is configured when a completed kernel is added to a
    program, via basic structured control-flow paradigms (if-else, do-while, and
    loops with a fixed iteration count).

    NOTE: the way gates are represented in OpenQL is on the list to be completely
    revised. Currently OpenQL works using a mixture of "default gates" and the
    "custom gates" that you can specify in the platform configuration file, but
    these two things are not orthogonal and largely incompatible with each other,
    yet are currently used interchangeably. Furthermore, there is no proper way
    to specify lists of generic arguments to a gate, leading to lots of code
    duplication inside OpenQL and long gate() argument lists. Finally, the
    semantics of gates are largely derived by undocumented and somewhat heuristic
    string comparisons with the names of gates, which is terrible design in
    combination with user-specified instruction sets via the platform
    configuration file. The interface for adding simple *quantum* gates to a
    kernel is something we want to keep 100% backward compatible, but the more
    advanced gate() signatures may change in the (near) future.

    NOTE: classical logic is on the list to be completely revised. This interface
    may change in the (near) future.

    NOTE: the higher-order functions for constructing controlled kernels and
    conjugating kernels have not been maintained for a while and thus probably
    won't work right. They may be removed entirely in a later version of OpenQL.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    name = property(_openql.Kernel_name_get, doc=r"""
    name : q(const).std::string

    The name of the kernel as given by the user.

    """)
    platform = property(_openql.Kernel_platform_get, doc=r"""
    platform : q(const).ql::api::Platform

    The platform that the kernel was built for.

    """)
    qubit_count = property(_openql.Kernel_qubit_count_get, doc=r"""
    qubit_count : q(const).size_t

    The number of (virtual) qubits allocated for the kernel.

    """)
    creg_count = property(_openql.Kernel_creg_count_get, doc=r"""
    creg_count : q(const).size_t

    The number of classical integer registers allocated for the kernel.

    """)
    breg_count = property(_openql.Kernel_breg_count_get, doc=r"""
    breg_count : q(const).size_t

    The number of classical bit registers allocated for the kernel.

    """)

    def __init__(self, name, platform, qubit_count=0, creg_count=0, breg_count=0):
        r"""__init__(Kernel self, std::string const & name, Platform platform, size_t qubit_count=0, size_t creg_count=0, size_t breg_count=0) -> Kernel"""
        _openql.Kernel_swiginit(self, _openql.new_Kernel(name, platform, qubit_count, creg_count, breg_count))

    def get_custom_instructions(self):
        r"""
        get_custom_instructions(Kernel self) -> std::string

        Old alias for dump_custom_instructions(). Deprecated.

        Parameters
        ----------
        None

        Returns
        -------
        str
            A newline-separated list of all custom gates supported by the platform.

        """
        return _openql.Kernel_get_custom_instructions(self)

    def print_custom_instructions(self):
        r"""
        print_custom_instructions(Kernel self)

        Prints a list of all custom gates supported by the platform.

        Parameters
        ----------
        None

        Returns
        -------
        None

        """
        return _openql.Kernel_print_custom_instructions(self)

    def dump_custom_instructions(self):
        r"""
        dump_custom_instructions(Kernel self) -> std::string

        Returns the result of print_custom_instructions() as a string.

        Parameters
        ----------
        None

        Returns
        -------
        str
            A newline-separated list of all custom gates supported by the platform.

        """
        return _openql.Kernel_dump_custom_instructions(self)

    def gate_preset_condition(self, condstring, condregs):
        r"""
        gate_preset_condition(Kernel self, std::string const & condstring, vectorui condregs)

        Sets the condition for all gates subsequently added to this kernel.
        Thus, essentially shorthand notation. Reset with gate_clear_condition().

        Parameters
        ----------
        condstring : str
            Must be one of:

             - "COND_ALWAYS" or "1": no condition; gate is always executed.
             - "COND_NEVER" or "0": no condition; gate is never executed.
             - "COND_UNARY" or "" (empty): gate is executed if the single bit
               specified via condregs is 1.
             - "COND_NOT" or "!": gate is executed if the single bit specified via
               condregs is 0.
             - "COND_AND" or "&": gate is executed if the two bits specified via
               condregs are both 1.
             - "COND_NAND" or "!&": gate is executed if either of the two bits
               specified via condregs is zero.
             - "COND_OR" or "|": gate is executed if either of the two bits specified
               via condregs is one.
             - "COND_NOR" or "!|": no condition; gate is always executed.

        condregs : List[int]
            Depending on condstring, must be a list of 0, 1, or 2 breg indices.

        Returns
        -------
        None

        """
        return _openql.Kernel_gate_preset_condition(self, condstring, condregs)

    def gate_clear_condition(self):
        r"""
        gate_clear_condition(Kernel self)

        Clears a condition previously set via gate_preset_condition().

        Parameters
        ----------
        None

        Returns
        -------
        None

        """
        return _openql.Kernel_gate_clear_condition(self)

    def gate(self, *args):
        r"""
        gate(Kernel self, std::string const & name, size_t q0)
        gate(Kernel self, std::string const & name, size_t q0, size_t q1)
        gate(Kernel self, std::string const & name, vectorui qubits, size_t duration=0, double angle=0.0, vectorui bregs={}, std::string const & condstring="COND_ALWAYS", vectorui condregs={})
        gate(Kernel self, std::string const & name, vectorui qubits, CReg destination)
        gate(Kernel self, Unitary u, vectorui qubits)

        Main function for appending arbitrary quantum gates.

        Parameters
        ----------
        name : str
            The name of the gate. Note that OpenQL currently uses string comparisons
            with these names all over the place to derive functionality, and to derive
            what the actual arguments do. This is inherently a bad idea and something
            we want to move away from, so documenting it all would not be worthwhile.
            For now, just use common sense, and you'll probably be okay.

        q0 : int
            Index of the first qubit to apply the gate to. For controlled gates, this
            is the control qubit.

        q1 : int
            Index of the second qubit to apply the gate to. For controlled gates, this
            is the target qubit.

        qubits : List[int]
            The full list of qubit indices to apply the gate to.

        duration : int
            Gate duration in nanoseconds, or 0 to use the default value from the
            platform configuration file. This is primarily intended to be used for wait
            gates.

        angle : float
            Rotation angle in radians for gates that use it (rx, ry, rz, etc). Ignored
            for all other gates.

        bregs : List[int]
            The full list of bit register argument indices for the gate, excluding
            any bit registers used for conditional execution. Currently only used for
            the measure gate, which may be given an explicit bit register index to
            return its result in. If no such register is specified, the result is
            assumed to implicitly go to the bit register with the same index as the
            qubit being measured. Ignored for gates that don't use bit registers.

        condstring : str
            If specified, must be one of:

             - "COND_ALWAYS" or "1": no condition; gate is always executed.
             - "COND_NEVER" or "0": no condition; gate is never executed.
             - "COND_UNARY" or "" (empty): gate is executed if the single bit
               specified via condregs is 1.
             - "COND_NOT" or "!": gate is executed if the single bit specified via
               condregs is 0.
             - "COND_AND" or "&": gate is executed if the two bits specified via
               condregs are both 1.
             - "COND_NAND" or "!&": gate is executed if either of the two bits
               specified via condregs is zero.
             - "COND_OR" or "|": gate is executed if either of the two bits specified
               via condregs is one.
             - "COND_NOR" or "!|": no condition; gate is always executed.

        condregs : List[int]
            Depending on condstring, must be a list of 0, 1, or 2 breg indices.

        destination : CReg
            An integer control register that receives the result of the mixed
            quantum-classical gate identified by name.

        u : Unitary
            The unitary gate to insert.

        Returns
        -------
        None

        """
        return _openql.Kernel_gate(self, *args)

    def condgate(self, name, qubits, condstring, condregs):
        r"""
        condgate(Kernel self, std::string const & name, vectorui qubits, std::string const & condstring, vectorui condregs)

        Alternative function for appending normal conditional quantum gates. Avoids
        having to specify duration, angle, and bregs for gates that don't need it.

        Parameters
        ----------
        name : str
            The name of the gate. Note that OpenQL currently uses string comparisons
            with these names all over the place to derive functionality, and to derive
            what the actual arguments do. This is inherently a bad idea and something
            we want to move away from, so documenting it all would not be worthwhile.
            For now, just use common sense, and you'll probably be okay.

        qubits : List[int]
            The full list of qubit indices to apply the gate to.

        condstring : str
            If specified, must be one of:

             - "COND_ALWAYS" or "1": no condition; gate is always executed.
             - "COND_NEVER" or "0": no condition; gate is never executed.
             - "COND_UNARY" or "" (empty): gate is executed if the single bit
               specified via condregs is 1.
             - "COND_NOT" or "!": gate is executed if the single bit specified via
               condregs is 0.
             - "COND_AND" or "&": gate is executed if the two bits specified via
               condregs are both 1.
             - "COND_NAND" or "!&": gate is executed if either of the two bits
               specified via condregs is zero.
             - "COND_OR" or "|": gate is executed if either of the two bits specified
               via condregs is one.
             - "COND_NOR" or "!|": no condition; gate is always executed.

        condregs : List[int]
            Depending on condstring, must be a list of 0, 1, or 2 breg indices.

        Returns
        -------
        None

        """
        return _openql.Kernel_condgate(self, name, qubits, condstring, condregs)

    def classical(self, *args):
        r"""
        classical(Kernel self, CReg destination, Operation operation)
        classical(Kernel self, std::string const & operation)

        Appends a classical assignment gate to the circuit. The classical integer
        register is assigned to the result of the given operation.

        Parameters
        ----------
        destination : CReg
            An integer control register at the left-hand side of the classical
            assignment gate.

        operation : Operation
            The expression to evaluate on the right-hand side of the classical
            assignment gate.

        Returns
        -------
        None

        """
        return _openql.Kernel_classical(self, *args)

    def identity(self, q0):
        r"""
        identity(Kernel self, size_t q0)

        Shorthand for an "identity" gate with a single qubit.

        Parameters
        ----------
        q0 : int
            The qubit to apply the gate to.

        Returns
        -------
        None

        """
        return _openql.Kernel_identity(self, q0)

    def hadamard(self, q0):
        r"""
        hadamard(Kernel self, size_t q0)

        Shorthand for appending a "hadamard" gate with a single qubit.

        Parameters
        ----------
        q0 : int
            The qubit to apply the gate to.

        Returns
        -------
        None

        """
        return _openql.Kernel_hadamard(self, q0)

    def s(self, q0):
        r"""
        s(Kernel self, size_t q0)

        Shorthand for appending an "s" gate with a single qubit.

        Parameters
        ----------
        q0 : int
            The qubit to apply the gate to.

        Returns
        -------
        None

        """
        return _openql.Kernel_s(self, q0)

    def sdag(self, q0):
        r"""
        sdag(Kernel self, size_t q0)

        Shorthand for appending an "sdag" gate with a single qubit.

        Parameters
        ----------
        q0 : int
            The qubit to apply the gate to.

        Returns
        -------
        None

        """
        return _openql.Kernel_sdag(self, q0)

    def t(self, q0):
        r"""
        t(Kernel self, size_t q0)

        Shorthand for appending a "t" gate with a single qubit.

        Parameters
        ----------
        q0 : int
            The qubit to apply the gate to.

        Returns
        -------
        None

        """
        return _openql.Kernel_t(self, q0)

    def tdag(self, q0):
        r"""
        tdag(Kernel self, size_t q0)

        Shorthand for appending a "tdag" gate with a single qubit.

        Parameters
        ----------
        q0 : int
            The qubit to apply the gate to.

        Returns
        -------
        None

        """
        return _openql.Kernel_tdag(self, q0)

    def x(self, q0):
        r"""
        x(Kernel self, size_t q0)

        Shorthand for appending an "x" gate with a single qubit.

        Parameters
        ----------
        q0 : int
            The qubit to apply the gate to.

        Returns
        -------
        None

        """
        return _openql.Kernel_x(self, q0)

    def y(self, q0):
        r"""
        y(Kernel self, size_t q0)

        Shorthand for appending a "y" gate with a single qubit.

        Parameters
        ----------
        q0 : int
            The qubit to apply the gate to.

        Returns
        -------
        None

        """
        return _openql.Kernel_y(self, q0)

    def z(self, q0):
        r"""
        z(Kernel self, size_t q0)

        Shorthand for appending a "z" gate with a single qubit.

        Parameters
        ----------
        q0 : int
            The qubit to apply the gate to.

        Returns
        -------
        None

        """
        return _openql.Kernel_z(self, q0)

    def rx90(self, q0):
        r"""
        rx90(Kernel self, size_t q0)

        Shorthand for appending an "rx90" gate with a single qubit.

        Parameters
        ----------
        q0 : int
            The qubit to apply the gate to.

        Returns
        -------
        None

        """
        return _openql.Kernel_rx90(self, q0)

    def mrx90(self, q0):
        r"""
        mrx90(Kernel self, size_t q0)

        Shorthand for appending an "mrx90" gate with a single qubit.

        Parameters
        ----------
        q0 : int
            The qubit to apply the gate to.

        Returns
        -------
        None

        """
        return _openql.Kernel_mrx90(self, q0)

    def rx180(self, q0):
        r"""
        rx180(Kernel self, size_t q0)

        Shorthand for appending an "rx180" gate with a single qubit.

        Parameters
        ----------
        q0 : int
            The qubit to apply the gate to.

        Returns
        -------
        None

        """
        return _openql.Kernel_rx180(self, q0)

    def ry90(self, q0):
        r"""
        ry90(Kernel self, size_t q0)

        Shorthand for appending an "ry90" gate with a single qubit.

        Parameters
        ----------
        q0 : int
            The qubit to apply the gate to.

        Returns
        -------
        None

        """
        return _openql.Kernel_ry90(self, q0)

    def mry90(self, q0):
        r"""
        mry90(Kernel self, size_t q0)

        Shorthand for appending an "mry90" gate with a single qubit.

        Parameters
        ----------
        q0 : int
            The qubit to apply the gate to.

        Returns
        -------
        None

        """
        return _openql.Kernel_mry90(self, q0)

    def ry180(self, q0):
        r"""
        ry180(Kernel self, size_t q0)

        Shorthand for appending an "ry180" gate with a single qubit.

        Parameters
        ----------
        q0 : int
            The qubit to apply the gate to.

        Returns
        -------
        None

        """
        return _openql.Kernel_ry180(self, q0)

    def rx(self, q0, angle):
        r"""
        rx(Kernel self, size_t q0, double angle)

        Shorthand for appending an "rx" gate with a single qubit and the given rotation
        in radians.

        Parameters
        ----------
        q0 : int
            The qubit to apply the gate to.

        angle : float
            The rotation angle in radians.

        Returns
        -------
        None

        """
        return _openql.Kernel_rx(self, q0, angle)

    def ry(self, q0, angle):
        r"""
        ry(Kernel self, size_t q0, double angle)

        Shorthand for appending an "ry" gate with a single qubit and the given rotation
        in radians.

        Parameters
        ----------
        q0 : int
            The qubit to apply the gate to.

        angle : float
            The rotation angle in radians.

        Returns
        -------
        None

        """
        return _openql.Kernel_ry(self, q0, angle)

    def rz(self, q0, angle):
        r"""
        rz(Kernel self, size_t q0, double angle)

        Shorthand for appending an "rz" gate with a single qubit and the given rotation
        in radians.

        Parameters
        ----------
        q0 : int
            The qubit to apply the gate to.

        angle : float
            The rotation angle in radians.

        Returns
        -------
        None

        """
        return _openql.Kernel_rz(self, q0, angle)

    def measure(self, *args):
        r"""
        measure(Kernel self, size_t q0)
        measure(Kernel self, size_t q0, size_t b0)

        Shorthand for appending a "measure" gate with a single qubit and implicit or
        explicit result bit register.

        Parameters
        ----------
        q0 : int
            The qubit to measure.

        b0 : int
            The bit register to store the result in. If not specified, the result will
            be placed in the bit register corresponding to the index of the measured
            qubit.

        Returns
        -------
        None

        """
        return _openql.Kernel_measure(self, *args)

    def prepz(self, q0):
        r"""
        prepz(Kernel self, size_t q0)

        Shorthand for appending a "prepz" gate with a single qubit.

        Parameters
        ----------
        q0 : int
            The qubit to prepare in the Z basis.

        Returns
        -------
        None

        """
        return _openql.Kernel_prepz(self, q0)

    def cnot(self, q0, q1):
        r"""
        cnot(Kernel self, size_t q0, size_t q1)

        Shorthand for appending a "cnot" gate with two qubits.

        Parameters
        ----------
        q0 : int
            The control qubit index.

        q1 : int
            The target qubit index

        Returns
        -------
        None

        """
        return _openql.Kernel_cnot(self, q0, q1)

    def cphase(self, q0, q1):
        r"""
        cphase(Kernel self, size_t q0, size_t q1)

        Shorthand for appending a "cphase" gate with two qubits.

        Parameters
        ----------
        q0 : int
            The first qubit index.

        q1 : int
            The second qubit index.

        Returns
        -------
        None

        """
        return _openql.Kernel_cphase(self, q0, q1)

    def cz(self, q0, q1):
        r"""
        cz(Kernel self, size_t q0, size_t q1)

        Shorthand for appending a "cz" gate with two qubits.

        Parameters
        ----------
        q0 : int
            The first qubit index.

        q1 : int
            The second qubit index.

        Returns
        -------
        None

        """
        return _openql.Kernel_cz(self, q0, q1)

    def toffoli(self, q0, q1, q2):
        r"""
        toffoli(Kernel self, size_t q0, size_t q1, size_t q2)

        Shorthand for appending a "toffoli" gate with three qubits.

        Parameters
        ----------
        q0 : int
            The first control qubit index.

        q1 : int
            The second control qubit index.

        q2 : int
            The target qubit index.

        Returns
        -------
        None

        """
        return _openql.Kernel_toffoli(self, q0, q1, q2)

    def clifford(self, id, q0):
        r"""
        clifford(Kernel self, int id, size_t q0)

        Shorthand for appending the Clifford gate with the specific number using
        the minimal number of rx90, rx180, mrx90, ry90, ry180, and mry90 gates.

        Parameters
        ----------
        id : int
            The Clifford gate expansion index:

             - 0: no gates inserted.
             - 1: ry90; rx90
             - 2: mrx90, mry90
             - 3: rx180
             - 4: mry90, mrx90
             - 5: rx90, mry90
             - 6: ry180
             - 7: mry90, rx90
             - 8: rx90, ry90
             - 9: rx180, ry180
             - 10: ry90, mrx90
             - 11: mrx90, ry90
             - 12: ry90, rx180
             - 13: mrx90
             - 14: rx90, mry90, mrx90
             - 15: mry90
             - 16: rx90
             - 17: rx90, ry90, rx90
             - 18: mry90, rx180
             - 19: rx90, ry180
             - 20: rx90, mry90, rx90
             - 21: ry90
             - 22: mrx90, ry180
             - 23: rx90, ry90, mrx90

        q0 : int
            The target qubit.

        Returns
        -------
        None

        """
        return _openql.Kernel_clifford(self, id, q0)

    def wait(self, qubits, duration):
        r"""
        wait(Kernel self, vectorui qubits, size_t duration)

        Shorthand for appending a "wait" gate with the specified qubits and
        duration in nanoseconds. If no qubits are specified, the wait applies to
        all qubits instead (a wait with no qubits is meaningless). Note that the
        duration will usually end up being rounded up to multiples of the
        platform's cycle time.

        Parameters
        ----------
        qubits : List[int]
            The list of qubits to apply the wait gate to. If empty, the list will be
            replaced with the set of all qubits.

        duration : int
            The duration of the wait gate in nanoseconds.

        Returns
        -------
        None

        """
        return _openql.Kernel_wait(self, qubits, duration)

    def barrier(self, *args):
        r"""
        barrier(Kernel self, vectorui qubits=std::vector< size_t >())

        Shorthand for appending a "wait" gate with the specified qubits and
        duration 0. If no qubits are specified, the wait applies to all qubits
        instead (a wait with no qubits is meaningless).

        Parameters
        ----------
        qubits : List[int]
            The list of qubits to apply the wait gate to. If empty or unspecified, the
            list will be replaced with the set of all qubits.

        Returns
        -------
        None

        """
        return _openql.Kernel_barrier(self, *args)

    def display(self):
        r"""
        display(Kernel self)

        Shorthand for appending a "display" gate with no qubits.

        Parameters
        ----------
        None

        Returns
        -------
        None

        """
        return _openql.Kernel_display(self)

    def controlled(self, k, control_qubits, ancilla_qubits):
        r"""
        controlled(Kernel self, Kernel k, vectorui control_qubits, vectorui ancilla_qubits)

        Appends a controlled kernel. The number of control and ancilla qubits
        must be equal.

        Parameters
        ----------
        k : Kernel
            The kernel to make controlled.

        control_qubits : List[int]
            The qubits that control the kernel.

        ancilla_qubits : List[int]
            The ancilla qubits to use to make the kernel controlled. The number of
            ancilla qubits must equal the number of control qubits.

        Returns
        -------
        None

        """
        return _openql.Kernel_controlled(self, k, control_qubits, ancilla_qubits)

    def conjugate(self, k):
        r"""
        conjugate(Kernel self, Kernel k)

        Appends the conjugate of the given kernel to this kernel.

        NOTE: this high-level functionality is poorly/not maintained, and relies
        on default gates, which are on the list for removal.

        Parameters
        ----------
        k : Kernel
            The kernel to conjugate.

        Returns
        -------
        None

        """
        return _openql.Kernel_conjugate(self, k)
    __swig_destroy__ = _openql.delete_Kernel

# Register Kernel in _openql:
_openql.Kernel_swigregister(Kernel)

class Program(object):
    r"""

    Represents a complete quantum program.

    The constructor creates a new program with the given name, using the given
    platform. The third, fourth, and fifth arguments optionally specify the
    desired number of qubits, classical integer registers, and classical bit
    registers. If not specified, the number of qubits is taken from the
    platform, and no classical or bit registers will be allocated.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    name = property(_openql.Program_name_get, doc=r"""
    name : q(const).std::string

    The name given to the program by the user.

    """)
    platform = property(_openql.Program_platform_get, doc=r"""
    platform : q(const).ql::api::Platform

    The platform associated with the program.

    """)
    qubit_count = property(_openql.Program_qubit_count_get, doc=r"""
    qubit_count : q(const).size_t

    The number of (virtual) qubits allocated for the program.

    """)
    creg_count = property(_openql.Program_creg_count_get, doc=r"""
    creg_count : q(const).size_t

    The number of classical integer registers allocated for the program.

    """)
    breg_count = property(_openql.Program_breg_count_get, doc=r"""
    breg_count : q(const).size_t

    The number of classical bit registers allocated for the program.

    """)

    def __init__(self, name, platform, qubit_count=0, creg_count=0, breg_count=0):
        r"""__init__(Program self, std::string const & name, Platform platform, size_t qubit_count=0, size_t creg_count=0, size_t breg_count=0) -> Program"""
        _openql.Program_swiginit(self, _openql.new_Program(name, platform, qubit_count, creg_count, breg_count))

    def add_kernel(self, k):
        r"""
        add_kernel(Program self, Kernel k)

        Adds an unconditionally-executed kernel to the end of the program.

        Parameters
        ----------
        k : Kernel
            The kernel to add.

        Returns
        -------
        None

        """
        return _openql.Program_add_kernel(self, k)

    def add_program(self, p):
        r"""
        add_program(Program self, Program p)

        Adds an unconditionally-executed subprogram to the end of the program.

        Parameters
        ----------
        p : Program
            The subprogram to add.

        Returns
        -------
        None

        """
        return _openql.Program_add_program(self, p)

    def add_if(self, *args):
        r"""
        add_if(Program self, Kernel k, Operation operation)
        add_if(Program self, Program p, Operation operation)

        Adds a conditionally-executed kernel or subprogram to the end of the program.
        The kernel/subprogram will be executed if the given classical condition
        evaluates to true.

        Parameters
        ----------
        k : Kernel
            The kernel to add.

        p : Program
            The subprogram to add.

        operation : Operation
            The operation that must evaluate to true for the kernel/subprogram to be
            executed.

        Returns
        -------
        None

        """
        return _openql.Program_add_if(self, *args)

    def add_if_else(self, *args):
        r"""
        add_if_else(Program self, Kernel k_if, Kernel k_else, Operation operation)
        add_if_else(Program self, Program p_if, Program p_else, Operation operation)

        Adds two conditionally-executed kernels/subprograms with inverted conditions to
        the end of the program. The first kernel/subprogram will be executed if the
        given classical condition evaluates to true; the second kernel/subprogram will
        be executed if it evaluates to false.

        Parameters
        ----------
        k_if : Kernel
            The kernel to execute when the condition evaluates to true.

        p_if : Program
            The subprogram to execute when the condition evaluates to true.

        k_else : Kernel
            The kernel to execute when the condition evaluates to false.

        p_else : Program
            The subprogram to execute when the condition evaluates to false.

        operation : Operation
            The operation that determines which kernel/subprogram will be executed.

        Returns
        -------
        None

        """
        return _openql.Program_add_if_else(self, *args)

    def add_do_while(self, *args):
        r"""
        add_do_while(Program self, Kernel k, Operation operation)
        add_do_while(Program self, Program p, Operation operation)

        Adds a kernel/subprogram that will be repeated until the given classical
        condition evaluates to true. The kernel/subprogram is executed at least once,
        since the condition is evaluated at the end of the loop body.

        Parameters
        ----------
        k : Kernel
            The kernel that represents the loop body.

        p : Program
            The subprogram that represents the loop body.

        operation : Operation
            The operation that must evaluate to true at the end of the loop body for
            the loop body to be executed again.

        Returns
        -------
        None

        """
        return _openql.Program_add_do_while(self, *args)

    def add_for(self, *args):
        r"""
        add_for(Program self, Kernel k, size_t iterations)
        add_for(Program self, Program p, size_t iterations)

        Adds an unconditionally-executed kernel/subprogram that will loop for the given
        number of iterations.

        Parameters
        ----------
        k : Kernel
            The kernel that represents the loop body.

        p : Program
            The subprogram that represents the loop body.

        iterations : int
            The number of loop iterations.

        Returns
        -------
        None

        """
        return _openql.Program_add_for(self, *args)

    def set_sweep_points(self, sweep_points):
        r"""
        set_sweep_points(Program self, vectord sweep_points)

        Sets sweep point information for the program.

        NOTE: sweep points functionality is deprecated and may be removed at any time.
        Do not use it in new programs.

        Parameters
        ----------
        sweep_points : List[float]
            The list of sweep points.

        Returns
        -------
        None

        """
        return _openql.Program_set_sweep_points(self, sweep_points)

    def get_sweep_points(self):
        r"""
        get_sweep_points(Program self) -> vectord

        Returns the configured sweep point information for the program.

        NOTE: sweep points functionality is deprecated and may be removed at any time.
        Do not use it in new programs.

        Parameters
        ----------
        None

        Returns
        -------
        List[float]
            The previously configured sweep point information for the program, or an
            empty list if none were configured.

        """
        return _openql.Program_get_sweep_points(self)

    def set_config_file(self, config_file_name):
        r"""
        set_config_file(Program self, std::string const & config_file_name)

        Sets the name of the file that the sweep points will be written to.

        NOTE: sweep points functionality is deprecated and may be removed at any time.
        Do not use it in new programs.

        Parameters
        ----------
        config_file_name : str
            The name of the file that the sweep points are to be written to.

        Returns
        -------
        None

        """
        return _openql.Program_set_config_file(self, config_file_name)

    def has_compiler(self):
        r"""
        has_compiler(Program self) -> bool

        Whether a custom compiler configuration has been attached to this
        program. When this is the case, it will be used to implement compile(),
        rather than generating the compiler in-place from defaults and global
        options during the call.

        Parameters
        ----------
        None

        Returns
        -------
        bool
            Whether a custom compiler configuration has been attached to this program.

        """
        return _openql.Program_has_compiler(self)

    def get_compiler(self):
        r"""
        get_compiler(Program self) -> Compiler

        Returns the custom compiler configuration associated with this program.
        If no such configuration exists yet, the default one is created,
        attached, and returned.

        Parameters
        ----------
        None

        Returns
        -------
        Compiler
            A Compiler object that may be used to introspect or modify the compilation
            strategy associated with this program.

        """
        return _openql.Program_get_compiler(self)

    def set_compiler(self, compiler):
        r"""
        set_compiler(Program self, Compiler compiler)

        Sets the compiler associated with this program. It will then be used for
        compile().

        Parameters
        ----------
        compiler : Compiler
            The new compiler configuration.

        Returns
        -------
        None

        """
        return _openql.Program_set_compiler(self, compiler)

    def compile(self):
        r"""
        compile(Program self)

        Compiles the program.

        Parameters
        ----------
        None

        Returns
        -------
        None

        """
        return _openql.Program_compile(self)

    def print_interaction_matrix(self):
        r"""
        print_interaction_matrix(Program self)

        Prints the interaction matrix for each kernel in the program.

        Parameters
        ----------
        None

        Returns
        -------
        None

        """
        return _openql.Program_print_interaction_matrix(self)

    def write_interaction_matrix(self):
        r"""
        write_interaction_matrix(Program self)

        Writes the interaction matrix for each kernel in the program to a file.
        This is one of the few functions that still uses the global output_dir
        option.

        Parameters
        ----------
        None

        Returns
        -------
        None

        """
        return _openql.Program_write_interaction_matrix(self)
    __swig_destroy__ = _openql.delete_Program

# Register Program in _openql:
_openql.Program_swigregister(Program)

class cQasmReader(object):
    r"""

    cQASM reader interface.

    To read a cQASM file, build a cQASM reader for the an already-existing program,
    and then call file2circuit or string2circuit to add the kernels from the cQASM
    file/string to the program. Optionally a platform can be specified as well, but
    this is redundant (it must be the same platform as the one that the program was
    constructed with); these overloads only exist for backward compatibility.

    Because OpenQL supports custom gates and cQASM (historically) does not, and also
    because OpenQL's internal representation of gates is still a bit different from
    what cQASM uses, you may need custom conversion rules for the gates. This can
    be done by specifying a gateset configuration JSON file using gateset_fname.
    This file must consist of a JSON array containing objects with the following
    structure:

    .. code-block::

       {
           "name": "<name>",               # mandatory
           "params": "<typespec>",         # mandatory
           "allow_conditional": <bool>,    # whether conditional gates of this type are accepted, defaults to true
           "allow_parallel": <bool>,       # whether parallel gates of this type are accepted, defaults to true
           "allow_reused_qubits": <bool>,  # whether reused qubit args for this type are accepted, defaults to false
           "ql_name": "<name>",            # defaults to "name"
           "ql_qubits": [                  # list or "all", defaults to the "Q" args
               0,                          # hardcoded qubit index
               "%0"                        # reference to argument 0, which can be a qubitref, bitref, or int
           ],
           "ql_cregs": [                   # list or "all", defaults to the "I" args
               0,                          # hardcoded creg index
               "%0"                        # reference to argument 0, which can be an int variable reference, or int for creg index
           ],
           "ql_bregs": [                   # list or "all", defaults to the "B" args
               0,                          # hardcoded breg index
               "%0"                        # reference to argument 0, which can be an int variable reference, or int for creg index
           ],
           "ql_duration": 0,               # duration; int to hardcode or "%i" to take from param i (must be of type int), defaults to 0
           "ql_angle": 0.0,                # angle; float to hardcode or "%i" to take from param i (must be of type int or real), defaults to first arg of type real or 0.0
           "ql_angle_type": "<type>",      # interpretation of angle arg; one of "rad" (radians), "deg" (degrees), or "pow2" (2pi/2^k radians), defaults to "rad"
           "implicit_sgmq": <bool>,        # if multiple qubit args are present, a single-qubit gate of this type should be replicated for these qubits (instead of a single gate with many qubits)
           "implicit_breg": <bool>         # the breg operand(s) that implicitly belongs to the qubit operand(s) in the gate should be added to the OpenQL operand list
       }

    The typespec string defines the expected argument types for the gate. Each
    character in the string represents an argument. The following characters are
    supported by libqasm:

     - Q = qubit
     - B = assignable bit/boolean (measurement register)
     - b = bit/boolean
     - a = axis (x, y, or z)
     - I = assignable integer
     - i = integer
     - r = real
     - c = complex
     - u = complex matrix of size 4^n, where n is the number of qubits in the
       parameter list (automatically deduced)
     - s = (quoted) string
     - j = json

    Note that OpenQL only uses an argument if it is referred to in one of the
    "ql_*" keys, either implicitly or explicitly.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    platform = property(_openql.cQasmReader_platform_get, doc=r"""
    platform : q(const).ql::api::Platform

    The platform associated with the reader.

    """)
    program = property(_openql.cQasmReader_program_get, doc=r"""
    program : q(const).ql::api::Program

    The program that the cQASM circuits will be added to.

    """)

    def __init__(self, *args):
        r"""
        __init__(cQasmReader self, Platform platform, Program program, std::string const & gateset_fname="") -> cQasmReader
        __init__(cQasmReader self, Program program, std::string const & gateset_fname="") -> cQasmReader
        """
        _openql.cQasmReader_swiginit(self, _openql.new_cQasmReader(*args))

    def string2circuit(self, cqasm_str):
        r"""
        string2circuit(cQasmReader self, std::string const & cqasm_str)

        Interprets a string as cQASM file and adds its contents to the program
        associated with this reader.

        Parameters
        ----------
        cqasm_str : str
            The string representing the contents of the cQASM file.

        Returns
        -------
        None

        """
        return _openql.cQasmReader_string2circuit(self, cqasm_str)

    def file2circuit(self, cqasm_file_path):
        r"""
        file2circuit(cQasmReader self, std::string const & cqasm_file_path)

        Interprets a string as cQASM file and adds its contents to the program
        associated with this reader.

        Parameters
        ----------
        cqasm_file_path : str
            The path to the cQASM file to load.

        Returns
        -------
        None

        """
        return _openql.cQasmReader_file2circuit(self, cqasm_file_path)
    __swig_destroy__ = _openql.delete_cQasmReader

# Register cQasmReader in _openql:
_openql.cQasmReader_swigregister(cQasmReader)

class vectorp(object):
    r"""Proxy of C++ std::vector< ql::api::Pass > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(vectorp self) -> SwigPyIterator"""
        return _openql.vectorp_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(vectorp self) -> bool"""
        return _openql.vectorp___nonzero__(self)

    def __bool__(self):
        r"""__bool__(vectorp self) -> bool"""
        return _openql.vectorp___bool__(self)

    def __len__(self):
        r"""__len__(vectorp self) -> std::vector< ql::api::Pass >::size_type"""
        return _openql.vectorp___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(vectorp self, std::vector< ql::api::Pass >::difference_type i, std::vector< ql::api::Pass >::difference_type j) -> vectorp"""
        return _openql.vectorp___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(vectorp self, std::vector< ql::api::Pass >::difference_type i, std::vector< ql::api::Pass >::difference_type j)
        __setslice__(vectorp self, std::vector< ql::api::Pass >::difference_type i, std::vector< ql::api::Pass >::difference_type j, vectorp v)
        """
        return _openql.vectorp___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(vectorp self, std::vector< ql::api::Pass >::difference_type i, std::vector< ql::api::Pass >::difference_type j)"""
        return _openql.vectorp___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(vectorp self, std::vector< ql::api::Pass >::difference_type i)
        __delitem__(vectorp self, PySliceObject * slice)
        """
        return _openql.vectorp___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(vectorp self, PySliceObject * slice) -> vectorp
        __getitem__(vectorp self, std::vector< ql::api::Pass >::difference_type i) -> Pass
        """
        return _openql.vectorp___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(vectorp self, PySliceObject * slice, vectorp v)
        __setitem__(vectorp self, PySliceObject * slice)
        __setitem__(vectorp self, std::vector< ql::api::Pass >::difference_type i, Pass x)
        """
        return _openql.vectorp___setitem__(self, *args)

    def pop(self):
        r"""pop(vectorp self) -> Pass"""
        return _openql.vectorp_pop(self)

    def append(self, x):
        r"""append(vectorp self, Pass x)"""
        return _openql.vectorp_append(self, x)

    def empty(self):
        r"""empty(vectorp self) -> bool"""
        return _openql.vectorp_empty(self)

    def size(self):
        r"""size(vectorp self) -> std::vector< ql::api::Pass >::size_type"""
        return _openql.vectorp_size(self)

    def swap(self, v):
        r"""swap(vectorp self, vectorp v)"""
        return _openql.vectorp_swap(self, v)

    def begin(self):
        r"""begin(vectorp self) -> std::vector< ql::api::Pass >::iterator"""
        return _openql.vectorp_begin(self)

    def end(self):
        r"""end(vectorp self) -> std::vector< ql::api::Pass >::iterator"""
        return _openql.vectorp_end(self)

    def rbegin(self):
        r"""rbegin(vectorp self) -> std::vector< ql::api::Pass >::reverse_iterator"""
        return _openql.vectorp_rbegin(self)

    def rend(self):
        r"""rend(vectorp self) -> std::vector< ql::api::Pass >::reverse_iterator"""
        return _openql.vectorp_rend(self)

    def clear(self):
        r"""clear(vectorp self)"""
        return _openql.vectorp_clear(self)

    def get_allocator(self):
        r"""get_allocator(vectorp self) -> std::vector< ql::api::Pass >::allocator_type"""
        return _openql.vectorp_get_allocator(self)

    def pop_back(self):
        r"""pop_back(vectorp self)"""
        return _openql.vectorp_pop_back(self)

    def erase(self, *args):
        r"""
        erase(vectorp self, std::vector< ql::api::Pass >::iterator pos) -> std::vector< ql::api::Pass >::iterator
        erase(vectorp self, std::vector< ql::api::Pass >::iterator first, std::vector< ql::api::Pass >::iterator last) -> std::vector< ql::api::Pass >::iterator
        """
        return _openql.vectorp_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(vectorp self) -> vectorp
        __init__(vectorp self, vectorp other) -> vectorp
        __init__(vectorp self, std::vector< ql::api::Pass >::size_type size) -> vectorp
        __init__(vectorp self, std::vector< ql::api::Pass >::size_type size, Pass value) -> vectorp
        """
        _openql.vectorp_swiginit(self, _openql.new_vectorp(*args))

    def push_back(self, x):
        r"""push_back(vectorp self, Pass x)"""
        return _openql.vectorp_push_back(self, x)

    def front(self):
        r"""front(vectorp self) -> Pass"""
        return _openql.vectorp_front(self)

    def back(self):
        r"""back(vectorp self) -> Pass"""
        return _openql.vectorp_back(self)

    def assign(self, n, x):
        r"""assign(vectorp self, std::vector< ql::api::Pass >::size_type n, Pass x)"""
        return _openql.vectorp_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(vectorp self, std::vector< ql::api::Pass >::size_type new_size)
        resize(vectorp self, std::vector< ql::api::Pass >::size_type new_size, Pass x)
        """
        return _openql.vectorp_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(vectorp self, std::vector< ql::api::Pass >::iterator pos, Pass x) -> std::vector< ql::api::Pass >::iterator
        insert(vectorp self, std::vector< ql::api::Pass >::iterator pos, std::vector< ql::api::Pass >::size_type n, Pass x)
        """
        return _openql.vectorp_insert(self, *args)

    def reserve(self, n):
        r"""reserve(vectorp self, std::vector< ql::api::Pass >::size_type n)"""
        return _openql.vectorp_reserve(self, n)

    def capacity(self):
        r"""capacity(vectorp self) -> std::vector< ql::api::Pass >::size_type"""
        return _openql.vectorp_capacity(self)
    __swig_destroy__ = _openql.delete_vectorp

# Register vectorp in _openql:
_openql.vectorp_swigregister(vectorp)



