"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Intrinsic = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const stack_trace_1 = require("../stack-trace");
const token_1 = require("../token");
/**
 * Token subclass that represents values intrinsic to the target document language
 *
 * WARNING: this class should not be externally exposed, but is currently visible
 * because of a limitation of jsii (https://github.com/aws/jsii/issues/524).
 *
 * This class will disappear in a future release and should not be used.
 *
 */
class Intrinsic {
    constructor(value, options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_IntrinsicProps(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Intrinsic);
            }
            throw error;
        }
        if (isFunction(value)) {
            throw new Error(`Argument to Intrinsic must be a plain value object, got ${value}`);
        }
        this.creationStack = options.stackTrace ?? true ? stack_trace_1.captureStackTrace() : [];
        this.value = value;
    }
    resolve(_context) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_IResolveContext(_context);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.resolve);
            }
            throw error;
        }
        return this.value;
    }
    /**
     * Convert an instance of this Token to a string
     *
     * This method will be called implicitly by language runtimes if the object
     * is embedded into a string. We treat it the same as an explicit
     * stringification.
     */
    toString() {
        return token_1.Token.asString(this);
    }
    /**
     * Turn this Token into JSON
     *
     * Called automatically when JSON.stringify() is called on a Token.
     */
    toJSON() {
        // We can't do the right work here because in case we contain a function, we
        // won't know the type of value that function represents (in the simplest
        // case, string or number), and we can't know that without an
        // IResolveContext to actually do the resolution, which we don't have.
        // We used to throw an error, but since JSON.stringify() is often used in
        // error messages to produce a readable representation of an object, if we
        // throw here we'll obfuscate that descriptive error with something worse.
        // So return a string representation that indicates this thing is a token
        // and needs resolving.
        return '<unresolved-token>';
    }
    /**
     * Creates a throwable Error object that contains the token creation stack trace.
     * @param message Error message
     */
    newError(message) {
        return new Error(`${message}\nToken created:\n    at ${this.creationStack.join('\n    at ')}\nError thrown:`);
    }
}
exports.Intrinsic = Intrinsic;
_a = JSII_RTTI_SYMBOL_1;
Intrinsic[_a] = { fqn: "@aws-cdk/core.Intrinsic", version: "1.164.0" };
function isFunction(x) {
    return typeof x === 'function';
}
//# sourceMappingURL=data:application/json;base64,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