# -*- coding: utf-8 -*-
"""
Basic interface to about 1,400 emojis.  Simply short_name, and unicode value.  
Has some simple wrappers at bottom, random good emoji, etc.
"""

import random

EMOJIS = {
    "1st_place_medal": u"\U0001F947",
    "2nd_place_medal": u"\U0001F948",
    "3rd_place_medal": u"\U0001F949",
    "AB_button_(blood_type)": u"\U0001F18E",
    "ATM_sign": u"\U0001F3E7",
    "A_button_(blood_type)": u"\U0001F170\U0000FE0F",
    "abacus": u"\U0001F9EE",
    "accordion": u"\U0001FA97",
    "adhesive_bandage": u"\U0001FA79",
    "admission_tickets": u"\U0001F39F\U0000FE0F",
    "aerial_tramway": u"\U0001F6A1",
    "airplane": u"\U00002708\U0000FE0F",
    "airplane_arrival": u"\U0001F6EC",
    "airplane_departure": u"\U0001F6EB",
    "alarm_clock": u"\U000023F0",
    "alembic": u"\U00002697\U0000FE0F",
    "alien": u"\U0001F47D",
    "alien_monster": u"\U0001F47E",
    "ambulance": u"\U0001F691",
    "american_football": u"\U0001F3C8",
    "amphora": u"\U0001F3FA",
    "anatomical_heart": u"\U0001FAC0",
    "anchor": u"\U00002693",
    "anger_symbol": u"\U0001F4A2",
    "angry_face": u"\U0001F620",
    "angry_face_with_horns": u"\U0001F47F",
    "anguished_face": u"\U0001F627",
    "ant": u"\U0001F41C",
    "antenna_bars": u"\U0001F4F6",
    "anxious_face_with_sweat": u"\U0001F630",
    "articulated_lorry": u"\U0001F69B",
    "artist": u"\U0001F9D1\U0000200D\U0001F3A8",
    "artist_palette": u"\U0001F3A8",
    "astonished_face": u"\U0001F632",
    "astronaut": u"\U0001F9D1\U0000200D\U0001F680",
    "atom_symbol": u"\U0000269B\U0000FE0F",
    "auto_rickshaw": u"\U0001F6FA",
    "automobile": u"\U0001F697",
    "avocado": u"\U0001F951",
    "axe": u"\U0001FA93",
    "baby": u"\U0001F476",
    "baby_angel": u"\U0001F47C",
    "baby_bottle": u"\U0001F37C",
    "baby_chick": u"\U0001F424",
    "baby_symbol": u"\U0001F6BC",
    "backhand_index_pointing_down": u"\U0001F447",
    "backhand_index_pointing_left": u"\U0001F448",
    "backhand_index_pointing_right": u"\U0001F449",
    "backhand_index_pointing_up": u"\U0001F446",
    "backpack": u"\U0001F392",
    "bacon": u"\U0001F953",
    "badger": u"\U0001F9A1",
    "badminton": u"\U0001F3F8",
    "bagel": u"\U0001F96F",
    "baggage_claim": u"\U0001F6C4",
    "baguette_bread": u"\U0001F956",
    "balance_scale": u"\U00002696\U0000FE0F",
    "ballet_shoes": u"\U0001FA70",
    "balloon": u"\U0001F388",
    "ballot_box_with_ballot": u"\U0001F5F3\U0000FE0F",
    "banana": u"\U0001F34C",
    "banjo": u"\U0001FA95",
    "bank": u"\U0001F3E6",
    "bar_chart": u"\U0001F4CA",
    "barber_pole": u"\U0001F488",
    "baseball": u"\U000026BE",
    "basket": u"\U0001F9FA",
    "basketball": u"\U0001F3C0",
    "bat": u"\U0001F987",
    "bathtub": u"\U0001F6C1",
    "battery": u"\U0001F50B",
    "beach_with_umbrella": u"\U0001F3D6\U0000FE0F",
    "beaming_face_with_smiling_eyes": u"\U0001F601",
    "beans": u"\U0001FAD8",
    "bear": u"\U0001F43B",
    "beating_heart": u"\U0001F493",
    "beaver": u"\U0001F9AB",
    "bed": u"\U0001F6CF\U0000FE0F",
    "beer_mug": u"\U0001F37A",
    "beetle": u"\U0001FAB2",
    "bell": u"\U0001F514",
    "bell_pepper": u"\U0001FAD1",
    "bell_with_slash": u"\U0001F515",
    "bellhop_bell": u"\U0001F6CE\U0000FE0F",
    "bento_box": u"\U0001F371",
    "beverage_box": u"\U0001F9C3",
    "bicycle": u"\U0001F6B2",
    "bikini": u"\U0001F459",
    "billed_cap": u"\U0001F9E2",
    "biohazard": u"\U00002623\U0000FE0F",
    "bird": u"\U0001F426",
    "birthday_cake": u"\U0001F382",
    "bison": u"\U0001F9AC",
    "black_cat": u"\U0001F408\U0000200D\U00002B1B",
    "black_circle": u"\U000026AB",
    "black_flag": u"\U0001F3F4",
    "black_heart": u"\U0001F5A4",
    "black_large_square": u"\U00002B1B",
    "black_medium-small_square": u"\U000025FE",
    "black_medium_square": u"\U000025FC\U0000FE0F",
    "black_nib": u"\U00002712\U0000FE0F",
    "black_small_square": u"\U000025AA\U0000FE0F",
    "black_square_button": u"\U0001F532",
    "blossom": u"\U0001F33C",
    "blowfish": u"\U0001F421",
    "blue_book": u"\U0001F4D8",
    "blue_circle": u"\U0001F535",
    "blue_heart": u"\U0001F499",
    "blue_square": u"\U0001F7E6",
    "blueberries": u"\U0001FAD0",
    "boar": u"\U0001F417",
    "bomb": u"\U0001F4A3",
    "bone": u"\U0001F9B4",
    "bookmark": u"\U0001F516",
    "bookmark_tabs": u"\U0001F4D1",
    "books": u"\U0001F4DA",
    "boomerang": u"\U0001FA83",
    "bottle_with_popping_cork": u"\U0001F37E",
    "bouquet": u"\U0001F490",
    "bow_and_arrow": u"\U0001F3F9",
    "bowl_with_spoon": u"\U0001F963",
    "bowling": u"\U0001F3B3",
    "boxing_glove": u"\U0001F94A",
    "boy": u"\U0001F466",
    "brain": u"\U0001F9E0",
    "bread": u"\U0001F35E",
    "breast-feeding": u"\U0001F931",
    "brick": u"\U0001F9F1",
    "bridge_at_night": u"\U0001F309",
    "briefcase": u"\U0001F4BC",
    "briefs": u"\U0001FA72",
    "bright_button": u"\U0001F506",
    "broccoli": u"\U0001F966",
    "broken_heart": u"\U0001F494",
    "broom": u"\U0001F9F9",
    "brown_circle": u"\U0001F7E4",
    "brown_heart": u"\U0001F90E",
    "brown_square": u"\U0001F7EB",
    "bubble_tea": u"\U0001F9CB",
    "bubbles": u"\U0001FAE7",
    "bucket": u"\U0001FAA3",
    "bug": u"\U0001F41B",
    "building_construction": u"\U0001F3D7\U0000FE0F",
    "bullet_train": u"\U0001F685",
    "bullseye": u"\U0001F3AF",
    "burrito": u"\U0001F32F",
    "bus": u"\U0001F68C",
    "bus_stop": u"\U0001F68F",
    "bust_in_silhouette": u"\U0001F464",
    "busts_in_silhouette": u"\U0001F465",
    "butter": u"\U0001F9C8",
    "butterfly": u"\U0001F98B",
    "cactus": u"\U0001F335",
    "calendar": u"\U0001F4C5",
    "call_me_hand": u"\U0001F919",
    "camel": u"\U0001F42A",
    "camera": u"\U0001F4F7",
    "camera_with_flash": u"\U0001F4F8",
    "camping": u"\U0001F3D5\U0000FE0F",
    "candle": u"\U0001F56F\U0000FE0F",
    "candy": u"\U0001F36C",
    "canned_food": u"\U0001F96B",
    "canoe": u"\U0001F6F6",
    "card_file_box": u"\U0001F5C3\U0000FE0F",
    "card_index": u"\U0001F4C7",
    "card_index_dividers": u"\U0001F5C2\U0000FE0F",
    "carousel_horse": u"\U0001F3A0",
    "carp_streamer": u"\U0001F38F",
    "carpentry_saw": u"\U0001FA9A",
    "carrot": u"\U0001F955",
    "castle": u"\U0001F3F0",
    "cat": u"\U0001F408",
    "cat_face": u"\U0001F431",
    "cat_with_tears_of_joy": u"\U0001F639",
    "cat_with_wry_smile": u"\U0001F63C",
    "chains": u"\U000026D3\U0000FE0F",
    "chair": u"\U0001FA91",
    "chart_decreasing": u"\U0001F4C9",
    "chart_increasing": u"\U0001F4C8",
    "chart_increasing_with_yen": u"\U0001F4B9",
    "check_box_with_check": u"\U00002611\U0000FE0F",
    "check_mark": u"\U00002714\U0000FE0F",
    "check_mark_button": u"\U00002705",
    "cheese_wedge": u"\U0001F9C0",
    "chequered_flag": u"\U0001F3C1",
    "cherries": u"\U0001F352",
    "cherry_blossom": u"\U0001F338",
    "chess_pawn": u"\U0000265F\U0000FE0F",
    "chestnut": u"\U0001F330",
    "chicken": u"\U0001F414",
    "child": u"\U0001F9D2",
    "children_crossing": u"\U0001F6B8",
    "chipmunk": u"\U0001F43F\U0000FE0F",
    "chocolate_bar": u"\U0001F36B",
    "chopsticks": u"\U0001F962",
    "church": u"\U000026EA",
    "cigarette": u"\U0001F6AC",
    "cinema": u"\U0001F3A6",
    "circled_M": u"\U000024C2\U0000FE0F",
    "circus_tent": u"\U0001F3AA",
    "cityscape": u"\U0001F3D9\U0000FE0F",
    "cityscape_at_dusk": u"\U0001F306",
    "clamp": u"\U0001F5DC\U0000FE0F",
    "clapper_board": u"\U0001F3AC",
    "clapping_hands": u"\U0001F44F",
    "classical_building": u"\U0001F3DB\U0000FE0F",
    "clinking_beer_mugs": u"\U0001F37B",
    "clinking_glasses": u"\U0001F942",
    "clipboard": u"\U0001F4CB",
    "clockwise_vertical_arrows": u"\U0001F503",
    "closed_book": u"\U0001F4D5",
    "closed_mailbox_with_lowered_flag": u"\U0001F4EA",
    "closed_mailbox_with_raised_flag": u"\U0001F4EB",
    "closed_umbrella": u"\U0001F302",
    "cloud": u"\U00002601\U0000FE0F",
    "cloud_with_lightning": u"\U0001F329\U0000FE0F",
    "cloud_with_lightning_and_rain": u"\U000026C8\U0000FE0F",
    "cloud_with_rain": u"\U0001F327\U0000FE0F",
    "cloud_with_snow": u"\U0001F328\U0000FE0F",
    "clown_face": u"\U0001F921",
    "club_suit": u"\U00002663\U0000FE0F",
    "clutch_bag": u"\U0001F45D",
    "coat": u"\U0001F9E5",
    "cockroach": u"\U0001FAB3",
    "cocktail_glass": u"\U0001F378",
    "coconut": u"\U0001F965",
    "coffin": u"\U000026B0\U0000FE0F",
    "coin": u"\U0001FA99",
    "cold_face": u"\U0001F976",
    "collision": u"\U0001F4A5",
    "comet": u"\U00002604\U0000FE0F",
    "compass": u"\U0001F9ED",
    "computer_disk": u"\U0001F4BD",
    "computer_mouse": u"\U0001F5B1\U0000FE0F",
    "confetti_ball": u"\U0001F38A",
    "confounded_face": u"\U0001F616",
    "confused_face": u"\U0001F615",
    "construction": u"\U0001F6A7",
    "construction_worker": u"\U0001F477",
    "control_knobs": u"\U0001F39B\U0000FE0F",
    "convenience_store": u"\U0001F3EA",
    "cook": u"\U0001F9D1\U0000200D\U0001F373",
    "cooked_rice": u"\U0001F35A",
    "cookie": u"\U0001F36A",
    "cooking": u"\U0001F373",
    "copyright": u"\U000000A9\U0000FE0F",
    "couch_and_lamp": u"\U0001F6CB\U0000FE0F",
    "counterclockwise_arrows_button": u"\U0001F504",
    "couple_with_heart": u"\U0001F491",
    "couple_with_heart_man_man": u"\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468",
    "couple_with_heart_woman_man": u"\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468",
    "couple_with_heart_woman_woman": u"\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469",
    "cow": u"\U0001F404",
    "cow_face": u"\U0001F42E",
    "cowboy_hat_face": u"\U0001F920",
    "crab": u"\U0001F980",
    "crayon": u"\U0001F58D\U0000FE0F",
    "credit_card": u"\U0001F4B3",
    "crescent_moon": u"\U0001F319",
    "cricket": u"\U0001F997",
    "cricket_game": u"\U0001F3CF",
    "crocodile": u"\U0001F40A",
    "croissant": u"\U0001F950",
    "cross_mark": u"\U0000274C",
    "cross_mark_button": u"\U0000274E",
    "crossed_fingers": u"\U0001F91E",
    "crossed_flags": u"\U0001F38C",
    "crossed_swords": u"\U00002694\U0000FE0F",
    "crown": u"\U0001F451",
    "crying_cat": u"\U0001F63F",
    "crying_face": u"\U0001F622",
    "crystal_ball": u"\U0001F52E",
    "cucumber": u"\U0001F952",
    "cup_with_straw": u"\U0001F964",
    "cupcake": u"\U0001F9C1",
    "curling_stone": u"\U0001F94C",
    "curly_loop": u"\U000027B0",
    "currency_exchange": u"\U0001F4B1",
    "curry_rice": u"\U0001F35B",
    "custard": u"\U0001F36E",
    "customs": u"\U0001F6C3",
    "cut_of_meat": u"\U0001F969",
    "cyclone": u"\U0001F300",
    "dagger": u"\U0001F5E1\U0000FE0F",
    "dango": u"\U0001F361",
    "dashing_away": u"\U0001F4A8",
    "deaf_man": u"\U0001F9CF\U0000200D\U00002642\U0000FE0F",
    "deaf_person": u"\U0001F9CF",
    "deaf_woman": u"\U0001F9CF\U0000200D\U00002640\U0000FE0F",
    "deciduous_tree": u"\U0001F333",
    "deer": u"\U0001F98C",
    "delivery_truck": u"\U0001F69A",
    "department_store": u"\U0001F3EC",
    "derelict_house": u"\U0001F3DA\U0000FE0F",
    "desert": u"\U0001F3DC\U0000FE0F",
    "desert_island": u"\U0001F3DD\U0000FE0F",
    "desktop_computer": u"\U0001F5A5\U0000FE0F",
    "detective": u"\U0001F575\U0000FE0F",
    "diamond_suit": u"\U00002666\U0000FE0F",
    "diamond_with_a_dot": u"\U0001F4A0",
    "dim_button": u"\U0001F505",
    "disappointed_face": u"\U0001F61E",
    "disguised_face": u"\U0001F978",
    "divide": u"\U00002797",
    "diving_mask": u"\U0001F93F",
    "diya_lamp": u"\U0001FA94",
    "dizzy": u"\U0001F4AB",
    "dna": u"\U0001F9EC",
    "dodo": u"\U0001F9A4",
    "dog": u"\U0001F415",
    "dog_face": u"\U0001F436",
    "dollar_banknote": u"\U0001F4B5",
    "dolphin": u"\U0001F42C",
    "door": u"\U0001F6AA",
    "dotted_six-pointed_star": u"\U0001F52F",
    "double_curly_loop": u"\U000027BF",
    "double_exclamation_mark": u"\U0000203C\U0000FE0F",
    "doughnut": u"\U0001F369",
    "dove": u"\U0001F54A\U0000FE0F",
    "down-left_arrow": u"\U00002199\U0000FE0F",
    "down-right_arrow": u"\U00002198\U0000FE0F",
    "down_arrow": u"\U00002B07\U0000FE0F",
    "downcast_face_with_sweat": u"\U0001F613",
    "downwards_button": u"\U0001F53D",
    "dragon": u"\U0001F409",
    "dragon_face": u"\U0001F432",
    "dress": u"\U0001F457",
    "drooling_face": u"\U0001F924",
    "drop_of_blood": u"\U0001FA78",
    "droplet": u"\U0001F4A7",
    "drum": u"\U0001F941",
    "duck": u"\U0001F986",
    "dumpling": u"\U0001F95F",
    "dvd": u"\U0001F4C0",
    "e-mail": u"\U0001F4E7",
    "eagle": u"\U0001F985",
    "ear": u"\U0001F442",
    "ear_of_corn": u"\U0001F33D",
    "ear_with_hearing_aid": u"\U0001F9BB",
    "egg": u"\U0001F95A",
    "eggplant": u"\U0001F346",
    "eight-pointed_star": u"\U00002734\U0000FE0F",
    "eight-spoked_asterisk": u"\U00002733\U0000FE0F",
    "eight-thirty": u"\U0001F563",
    "eight_o’clock": u"\U0001F557",
    "eject_button": u"\U000023CF\U0000FE0F",
    "electric_plug": u"\U0001F50C",
    "elephant": u"\U0001F418",
    "elevator": u"\U0001F6D7",
    "eleven-thirty": u"\U0001F566",
    "eleven_o’clock": u"\U0001F55A",
    "elf": u"\U0001F9DD",
    "empty_nest": u"\U0001FAB9",
    "envelope": u"\U00002709\U0000FE0F",
    "envelope_with_arrow": u"\U0001F4E9",
    "euro_banknote": u"\U0001F4B6",
    "evergreen_tree": u"\U0001F332",
    "ewe": u"\U0001F411",
    "exclamation_question_mark": u"\U00002049\U0000FE0F",
    "exploding_head": u"\U0001F92F",
    "expressionless_face": u"\U0001F611",
    "eye": u"\U0001F441\U0000FE0F",
    "eye_in_speech_bubble": u"\U0001F441\U0000FE0F\U0000200D\U0001F5E8\U0000FE0F",
    "eyes": u"\U0001F440",
    "face_blowing_a_kiss": u"\U0001F618",
    "face_exhaling": u"\U0001F62E\U0000200D\U0001F4A8",
    "face_in_clouds": u"\U0001F636\U0000200D\U0001F32B\U0000FE0F",
    "face_savoring_food": u"\U0001F60B",
    "face_screaming_in_fear": u"\U0001F631",
    "face_vomiting": u"\U0001F92E",
    "face_with_crossed-out_eyes": u"\U0001F635",
    "face_with_hand_over_mouth": u"\U0001F92D",
    "face_with_head-bandage": u"\U0001F915",
    "face_with_medical_mask": u"\U0001F637",
    "face_with_monocle": u"\U0001F9D0",
    "face_with_open_mouth": u"\U0001F62E",
    "face_with_raised_eyebrow": u"\U0001F928",
    "face_with_rolling_eyes": u"\U0001F644",
    "face_with_spiral_eyes": u"\U0001F635\U0000200D\U0001F4AB",
    "face_with_steam_from_nose": u"\U0001F624",
    "face_with_symbols_on_mouth": u"\U0001F92C",
    "face_with_tears_of_joy": u"\U0001F602",
    "face_with_thermometer": u"\U0001F912",
    "face_with_tongue": u"\U0001F61B",
    "face_without_mouth": u"\U0001F636",
    "factory": u"\U0001F3ED",
    "factory_worker": u"\U0001F9D1\U0000200D\U0001F3ED",
    "fairy": u"\U0001F9DA",
    "falafel": u"\U0001F9C6",
    "fallen_leaf": u"\U0001F342",
    "family": u"\U0001F46A",
    "family_man_boy": u"\U0001F468\U0000200D\U0001F466",
    "family_man_boy_boy": u"\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466",
    "family_man_girl": u"\U0001F468\U0000200D\U0001F467",
    "family_man_girl_boy": u"\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466",
    "family_man_girl_girl": u"\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467",
    "family_man_man_boy": u"\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466",
    "family_man_man_boy_boy": u"\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466",
    "family_man_man_girl": u"\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467",
    "family_man_man_girl_boy": u"\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466",
    "family_man_man_girl_girl": u"\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467",
    "family_man_woman_boy": u"\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466",
    "family_man_woman_boy_boy": u"\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466",
    "family_man_woman_girl": u"\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467",
    "family_man_woman_girl_boy": u"\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466",
    "family_man_woman_girl_girl": u"\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467",
    "family_woman_boy": u"\U0001F469\U0000200D\U0001F466",
    "family_woman_boy_boy": u"\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466",
    "family_woman_girl": u"\U0001F469\U0000200D\U0001F467",
    "family_woman_girl_boy": u"\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466",
    "family_woman_girl_girl": u"\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467",
    "family_woman_woman_boy": u"\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466",
    "family_woman_woman_boy_boy": u"\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466",
    "family_woman_woman_girl": u"\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467",
    "family_woman_woman_girl_boy": u"\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466",
    "family_woman_woman_girl_girl": u"\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467",
    "farmer": u"\U0001F9D1\U0000200D\U0001F33E",
    "fast-forward_button": u"\U000023E9",
    "fast_down_button": u"\U000023EC",
    "fast_reverse_button": u"\U000023EA",
    "fast_up_button": u"\U000023EB",
    "fax_machine": u"\U0001F4E0",
    "fearful_face": u"\U0001F628",
    "feather": u"\U0001FAB6",
    "female_sign": u"\U00002640\U0000FE0F",
    "ferris_wheel": u"\U0001F3A1",
    "ferry": u"\U000026F4\U0000FE0F",
    "field_hockey": u"\U0001F3D1",
    "file_cabinet": u"\U0001F5C4\U0000FE0F",
    "file_folder": u"\U0001F4C1",
    "film_frames": u"\U0001F39E\U0000FE0F",
    "film_projector": u"\U0001F4FD\U0000FE0F",
    "fire": u"\U0001F525",
    "fire_engine": u"\U0001F692",
    "fire_extinguisher": u"\U0001F9EF",
    "firecracker": u"\U0001F9E8",
    "firefighter": u"\U0001F9D1\U0000200D\U0001F692",
    "fireworks": u"\U0001F386",
    "first_quarter_moon": u"\U0001F313",
    "first_quarter_moon_face": u"\U0001F31B",
    "fish": u"\U0001F41F",
    "fish_cake_with_swirl": u"\U0001F365",
    "fishing_pole": u"\U0001F3A3",
    "five-thirty": u"\U0001F560",
    "five_o’clock": u"\U0001F554",
    "flag_in_hole": u"\U000026F3",
    "flamingo": u"\U0001F9A9",
    "flashlight": u"\U0001F526",
    "flat_shoe": u"\U0001F97F",
    "flatbread": u"\U0001FAD3",
    "fleur-de-lis": u"\U0000269C\U0000FE0F",
    "flexed_biceps": u"\U0001F4AA",
    "floppy_disk": u"\U0001F4BE",
    "flower_playing_cards": u"\U0001F3B4",
    "flushed_face": u"\U0001F633",
    "fly": u"\U0001FAB0",
    "flying_disc": u"\U0001F94F",
    "flying_saucer": u"\U0001F6F8",
    "fog": u"\U0001F32B\U0000FE0F",
    "foggy": u"\U0001F301",
    "folded_hands": u"\U0001F64F",
    "fondue": u"\U0001FAD5",
    "foot": u"\U0001F9B6",
    "footprints": u"\U0001F463",
    "fork_and_knife": u"\U0001F374",
    "fork_and_knife_with_plate": u"\U0001F37D\U0000FE0F",
    "fortune_cookie": u"\U0001F960",
    "fountain": u"\U000026F2",
    "fountain_pen": u"\U0001F58B\U0000FE0F",
    "four-thirty": u"\U0001F55F",
    "four_leaf_clover": u"\U0001F340",
    "four_o’clock": u"\U0001F553",
    "fox": u"\U0001F98A",
    "framed_picture": u"\U0001F5BC\U0000FE0F",
    "french_fries": u"\U0001F35F",
    "fried_shrimp": u"\U0001F364",
    "frog": u"\U0001F438",
    "front-facing_baby_chick": u"\U0001F425",
    "frowning_face": u"\U00002639\U0000FE0F",
    "frowning_face_with_open_mouth": u"\U0001F626",
    "fuel_pump": u"\U000026FD",
    "full_moon": u"\U0001F315",
    "full_moon_face": u"\U0001F31D",
    "funeral_urn": u"\U000026B1\U0000FE0F",
    "game_die": u"\U0001F3B2",
    "garlic": u"\U0001F9C4",
    "gear": u"\U00002699\U0000FE0F",
    "gem_stone": u"\U0001F48E",
    "genie": u"\U0001F9DE",
    "ghost": u"\U0001F47B",
    "giraffe": u"\U0001F992",
    "girl": u"\U0001F467",
    "glass_of_milk": u"\U0001F95B",
    "glasses": u"\U0001F453",
    "globe_showing_Americas": u"\U0001F30E",
    "globe_showing_Asia-Australia": u"\U0001F30F",
    "globe_showing_Europe-Africa": u"\U0001F30D",
    "globe_with_meridians": u"\U0001F310",
    "gloves": u"\U0001F9E4",
    "glowing_star": u"\U0001F31F",
    "goal_net": u"\U0001F945",
    "goat": u"\U0001F410",
    "goblin": u"\U0001F47A",
    "goggles": u"\U0001F97D",
    "gorilla": u"\U0001F98D",
    "graduation_cap": u"\U0001F393",
    "grapes": u"\U0001F347",
    "green_apple": u"\U0001F34F",
    "green_book": u"\U0001F4D7",
    "green_circle": u"\U0001F7E2",
    "green_heart": u"\U0001F49A",
    "green_salad": u"\U0001F957",
    "green_square": u"\U0001F7E9",
    "grimacing_face": u"\U0001F62C",
    "grinning_cat": u"\U0001F63A",
    "grinning_cat_with_smiling_eyes": u"\U0001F638",
    "grinning_face": u"\U0001F600",
    "grinning_face_with_big_eyes": u"\U0001F603",
    "grinning_face_with_smiling_eyes": u"\U0001F604",
    "grinning_face_with_sweat": u"\U0001F605",
    "grinning_squinting_face": u"\U0001F606",
    "growing_heart": u"\U0001F497",
    "guard": u"\U0001F482",
    "guide_dog": u"\U0001F9AE",
    "guitar": u"\U0001F3B8",
    "hamburger": u"\U0001F354",
    "hammer": u"\U0001F528",
    "hammer_and_pick": u"\U00002692\U0000FE0F",
    "hammer_and_wrench": u"\U0001F6E0\U0000FE0F",
    "hamster": u"\U0001F439",
    "hand_with_fingers_splayed": u"\U0001F590\U0000FE0F",
    "handbag": u"\U0001F45C",
    "handshake": u"\U0001F91D",
    "hatching_chick": u"\U0001F423",
    "headphone": u"\U0001F3A7",
    "headstone": u"\U0001FAA6",
    "health_worker": u"\U0001F9D1\U0000200D\U00002695\U0000FE0F",
    "hear-no-evil_monkey": u"\U0001F649",
    "heart_decoration": u"\U0001F49F",
    "heart_exclamation": u"\U00002763\U0000FE0F",
    "heart_on_fire": u"\U00002764\U0000FE0F\U0000200D\U0001F525",
    "heart_suit": u"\U00002665\U0000FE0F",
    "heart_with_arrow": u"\U0001F498",
    "heart_with_ribbon": u"\U0001F49D",
    "heavy_dollar_sign": u"\U0001F4B2",
    "hedgehog": u"\U0001F994",
    "helicopter": u"\U0001F681",
    "herb": u"\U0001F33F",
    "hibiscus": u"\U0001F33A",
    "high-heeled_shoe": u"\U0001F460",
    "high-speed_train": u"\U0001F684",
    "high_voltage": u"\U000026A1",
    "hiking_boot": u"\U0001F97E",
    "hindu_temple": u"\U0001F6D5",
    "hippopotamus": u"\U0001F99B",
    "hole": u"\U0001F573\U0000FE0F",
    "hollow_red_circle": u"\U00002B55",
    "honey_pot": u"\U0001F36F",
    "honeybee": u"\U0001F41D",
    "hook": u"\U0001FA9D",
    "horizontal_traffic_light": u"\U0001F6A5",
    "horse": u"\U0001F40E",
    "horse_face": u"\U0001F434",
    "horse_racing": u"\U0001F3C7",
    "hospital": u"\U0001F3E5",
    "hot_beverage": u"\U00002615",
    "hot_dog": u"\U0001F32D",
    "hot_face": u"\U0001F975",
    "hot_pepper": u"\U0001F336\U0000FE0F",
    "hot_springs": u"\U00002668\U0000FE0F",
    "hotel": u"\U0001F3E8",
    "hourglass_done": u"\U0000231B",
    "hourglass_not_done": u"\U000023F3",
    "house": u"\U0001F3E0",
    "house_with_garden": u"\U0001F3E1",
    "houses": u"\U0001F3D8\U0000FE0F",
    "hundred_points": u"\U0001F4AF",
    "hushed_face": u"\U0001F62F",
    "hut": u"\U0001F6D6",
    "ice": u"\U0001F9CA",
    "ice_cream": u"\U0001F368",
    "ice_hockey": u"\U0001F3D2",
    "ice_skate": u"\U000026F8\U0000FE0F",
    "inbox_tray": u"\U0001F4E5",
    "incoming_envelope": u"\U0001F4E8",
    "index_pointing_up": u"\U0000261D\U0000FE0F",
    "infinity": u"\U0000267E\U0000FE0F",
    "information": u"\U00002139\U0000FE0F",
    "input_latin_letters": u"\U0001F524",
    "input_latin_lowercase": u"\U0001F521",
    "input_latin_uppercase": u"\U0001F520",
    "input_numbers": u"\U0001F522",
    "input_symbols": u"\U0001F523",
    "jack-o-lantern": u"\U0001F383",
    "jeans": u"\U0001F456",
    "joker": u"\U0001F0CF",
    "joystick": u"\U0001F579\U0000FE0F",
    "judge": u"\U0001F9D1\U0000200D\U00002696\U0000FE0F",
    "kaaba": u"\U0001F54B",
    "kangaroo": u"\U0001F998",
    "key": u"\U0001F511",
    "keyboard": u"\U00002328\U0000FE0F",
    "keycap_#": u"\U00000023\U0000FE0F\U000020E3",
    "keycap_*": u"\U0000002A\U0000FE0F\U000020E3",
    "keycap_0": u"\U00000030\U0000FE0F\U000020E3",
    "keycap_1": u"\U00000031\U0000FE0F\U000020E3",
    "keycap_10": u"\U0001F51F",
    "keycap_2": u"\U00000032\U0000FE0F\U000020E3",
    "keycap_3": u"\U00000033\U0000FE0F\U000020E3",
    "keycap_4": u"\U00000034\U0000FE0F\U000020E3",
    "keycap_5": u"\U00000035\U0000FE0F\U000020E3",
    "keycap_6": u"\U00000036\U0000FE0F\U000020E3",
    "keycap_7": u"\U00000037\U0000FE0F\U000020E3",
    "keycap_8": u"\U00000038\U0000FE0F\U000020E3",
    "keycap_9": u"\U00000039\U0000FE0F\U000020E3",
    "kick_scooter": u"\U0001F6F4",
    "kimono": u"\U0001F458",
    "kiss": u"\U0001F48F",
    "kiss_man_man": u"\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468",
    "kiss_mark": u"\U0001F48B",
    "kiss_woman_man": u"\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468",
    "kiss_woman_woman": u"\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469",
    "kissing_cat": u"\U0001F63D",
    "kissing_face": u"\U0001F617",
    "kissing_face_with_closed_eyes": u"\U0001F61A",
    "kissing_face_with_smiling_eyes": u"\U0001F619",
    "kitchen_knife": u"\U0001F52A",
    "kite": u"\U0001FA81",
    "kiwi_fruit": u"\U0001F95D",
    "knot": u"\U0001FAA2",
    "koala": u"\U0001F428",
    "lab_coat": u"\U0001F97C",
    "label": u"\U0001F3F7\U0000FE0F",
    "lacrosse": u"\U0001F94D",
    "ladder": u"\U0001FA9C",
    "lady_beetle": u"\U0001F41E",
    "laptop": u"\U0001F4BB",
    "large_blue_diamond": u"\U0001F537",
    "large_orange_diamond": u"\U0001F536",
    "last_quarter_moon": u"\U0001F317",
    "last_quarter_moon_face": u"\U0001F31C",
    "last_track_button": u"\U000023EE\U0000FE0F",
    "latin_cross": u"\U0000271D\U0000FE0F",
    "leaf_fluttering_in_wind": u"\U0001F343",
    "leafy_green": u"\U0001F96C",
    "ledger": u"\U0001F4D2",
    "left-facing_fist": u"\U0001F91B",
    "left-right_arrow": u"\U00002194\U0000FE0F",
    "left_arrow": u"\U00002B05\U0000FE0F",
    "left_arrow_curving_right": u"\U000021AA\U0000FE0F",
    "left_luggage": u"\U0001F6C5",
    "left_speech_bubble": u"\U0001F5E8\U0000FE0F",
    "leg": u"\U0001F9B5",
    "lemon": u"\U0001F34B",
    "leopard": u"\U0001F406",
    "level_slider": u"\U0001F39A\U0000FE0F",
    "light_bulb": u"\U0001F4A1",
    "light_rail": u"\U0001F688",
    "link": u"\U0001F517",
    "linked_paperclips": u"\U0001F587\U0000FE0F",
    "lion": u"\U0001F981",
    "lipstick": u"\U0001F484",
    "litter_in_bin_sign": u"\U0001F6AE",
    "lizard": u"\U0001F98E",
    "llama": u"\U0001F999",
    "lobster": u"\U0001F99E",
    "locked": u"\U0001F512",
    "locked_with_key": u"\U0001F510",
    "locked_with_pen": u"\U0001F50F",
    "locomotive": u"\U0001F682",
    "lollipop": u"\U0001F36D",
    "long_drum": u"\U0001FA98",
    "lotion_bottle": u"\U0001F9F4",
    "lotus": u"\U0001FAB7",
    "loudly_crying_face": u"\U0001F62D",
    "loudspeaker": u"\U0001F4E2",
    "love-you_gesture": u"\U0001F91F",
    "love_hotel": u"\U0001F3E9",
    "love_letter": u"\U0001F48C",
    "luggage": u"\U0001F9F3",
    "lungs": u"\U0001FAC1",
    "lying_face": u"\U0001F925",
    "mage": u"\U0001F9D9",
    "magic_wand": u"\U0001FA84",
    "magnet": u"\U0001F9F2",
    "magnifying_glass_tilted_left": u"\U0001F50D",
    "magnifying_glass_tilted_right": u"\U0001F50E",
    "mahjong_red_dragon": u"\U0001F004",
    "male_sign": u"\U00002642\U0000FE0F",
    "mammoth": u"\U0001F9A3",
    "man": u"\U0001F468",
    "man_artist": u"\U0001F468\U0000200D\U0001F3A8",
    "man_astronaut": u"\U0001F468\U0000200D\U0001F680",
    "man_bald": u"\U0001F468\U0000200D\U0001F9B2",
    "man_beard": u"\U0001F9D4\U0000200D\U00002642\U0000FE0F",
    "man_biking": u"\U0001F6B4\U0000200D\U00002642\U0000FE0F",
    "man_blond_hair": u"\U0001F471\U0000200D\U00002642\U0000FE0F",
    "man_bouncing_ball": u"\U000026F9\U0000FE0F\U0000200D\U00002642\U0000FE0F",
    "man_bowing": u"\U0001F647\U0000200D\U00002642\U0000FE0F",
    "man_cartwheeling": u"\U0001F938\U0000200D\U00002642\U0000FE0F",
    "man_climbing": u"\U0001F9D7\U0000200D\U00002642\U0000FE0F",
    "man_construction_worker": u"\U0001F477\U0000200D\U00002642\U0000FE0F",
    "man_cook": u"\U0001F468\U0000200D\U0001F373",
    "man_curly_hair": u"\U0001F468\U0000200D\U0001F9B1",
    "man_dancing": u"\U0001F57A",
    "man_detective": u"\U0001F575\U0000FE0F\U0000200D\U00002642\U0000FE0F",
    "man_elf": u"\U0001F9DD\U0000200D\U00002642\U0000FE0F",
    "man_facepalming": u"\U0001F926\U0000200D\U00002642\U0000FE0F",
    "man_factory_worker": u"\U0001F468\U0000200D\U0001F3ED",
    "man_fairy": u"\U0001F9DA\U0000200D\U00002642\U0000FE0F",
    "man_farmer": u"\U0001F468\U0000200D\U0001F33E",
    "man_feeding_baby": u"\U0001F468\U0000200D\U0001F37C",
    "man_firefighter": u"\U0001F468\U0000200D\U0001F692",
    "man_frowning": u"\U0001F64D\U0000200D\U00002642\U0000FE0F",
    "man_genie": u"\U0001F9DE\U0000200D\U00002642\U0000FE0F",
    "man_gesturing_NO": u"\U0001F645\U0000200D\U00002642\U0000FE0F",
    "man_gesturing_OK": u"\U0001F646\U0000200D\U00002642\U0000FE0F",
    "man_getting_haircut": u"\U0001F487\U0000200D\U00002642\U0000FE0F",
    "man_getting_massage": u"\U0001F486\U0000200D\U00002642\U0000FE0F",
    "man_golfing": u"\U0001F3CC\U0000FE0F\U0000200D\U00002642\U0000FE0F",
    "man_guard": u"\U0001F482\U0000200D\U00002642\U0000FE0F",
    "man_health_worker": u"\U0001F468\U0000200D\U00002695\U0000FE0F",
    "man_in_lotus_position": u"\U0001F9D8\U0000200D\U00002642\U0000FE0F",
    "man_in_manual_wheelchair": u"\U0001F468\U0000200D\U0001F9BD",
    "man_in_motorized_wheelchair": u"\U0001F468\U0000200D\U0001F9BC",
    "man_in_steamy_room": u"\U0001F9D6\U0000200D\U00002642\U0000FE0F",
    "man_in_tuxedo": u"\U0001F935\U0000200D\U00002642\U0000FE0F",
    "man_judge": u"\U0001F468\U0000200D\U00002696\U0000FE0F",
    "man_juggling": u"\U0001F939\U0000200D\U00002642\U0000FE0F",
    "man_kneeling": u"\U0001F9CE\U0000200D\U00002642\U0000FE0F",
    "man_lifting_weights": u"\U0001F3CB\U0000FE0F\U0000200D\U00002642\U0000FE0F",
    "man_mage": u"\U0001F9D9\U0000200D\U00002642\U0000FE0F",
    "man_mechanic": u"\U0001F468\U0000200D\U0001F527",
    "man_mountain_biking": u"\U0001F6B5\U0000200D\U00002642\U0000FE0F",
    "man_office_worker": u"\U0001F468\U0000200D\U0001F4BC",
    "man_pilot": u"\U0001F468\U0000200D\U00002708\U0000FE0F",
    "man_playing_handball": u"\U0001F93E\U0000200D\U00002642\U0000FE0F",
    "man_playing_water_polo": u"\U0001F93D\U0000200D\U00002642\U0000FE0F",
    "man_police_officer": u"\U0001F46E\U0000200D\U00002642\U0000FE0F",
    "man_pouting": u"\U0001F64E\U0000200D\U00002642\U0000FE0F",
    "man_raising_hand": u"\U0001F64B\U0000200D\U00002642\U0000FE0F",
    "man_red_hair": u"\U0001F468\U0000200D\U0001F9B0",
    "man_rowing_boat": u"\U0001F6A3\U0000200D\U00002642\U0000FE0F",
    "man_running": u"\U0001F3C3\U0000200D\U00002642\U0000FE0F",
    "man_scientist": u"\U0001F468\U0000200D\U0001F52C",
    "man_shrugging": u"\U0001F937\U0000200D\U00002642\U0000FE0F",
    "man_singer": u"\U0001F468\U0000200D\U0001F3A4",
    "man_standing": u"\U0001F9CD\U0000200D\U00002642\U0000FE0F",
    "man_student": u"\U0001F468\U0000200D\U0001F393",
    "man_superhero": u"\U0001F9B8\U0000200D\U00002642\U0000FE0F",
    "man_supervillain": u"\U0001F9B9\U0000200D\U00002642\U0000FE0F",
    "man_surfing": u"\U0001F3C4\U0000200D\U00002642\U0000FE0F",
    "man_swimming": u"\U0001F3CA\U0000200D\U00002642\U0000FE0F",
    "man_teacher": u"\U0001F468\U0000200D\U0001F3EB",
    "man_technologist": u"\U0001F468\U0000200D\U0001F4BB",
    "man_tipping_hand": u"\U0001F481\U0000200D\U00002642\U0000FE0F",
    "man_vampire": u"\U0001F9DB\U0000200D\U00002642\U0000FE0F",
    "man_walking": u"\U0001F6B6\U0000200D\U00002642\U0000FE0F",
    "man_wearing_turban": u"\U0001F473\U0000200D\U00002642\U0000FE0F",
    "man_white_hair": u"\U0001F468\U0000200D\U0001F9B3",
    "man_with_veil": u"\U0001F470\U0000200D\U00002642\U0000FE0F",
    "man_with_white_cane": u"\U0001F468\U0000200D\U0001F9AF",
    "man_zombie": u"\U0001F9DF\U0000200D\U00002642\U0000FE0F",
    "mango": u"\U0001F96D",
    "mantelpiece_clock": u"\U0001F570\U0000FE0F",
    "manual_wheelchair": u"\U0001F9BD",
    "man’s_shoe": u"\U0001F45E",
    "map_of_Japan": u"\U0001F5FE",
    "maple_leaf": u"\U0001F341",
    "martial_arts_uniform": u"\U0001F94B",
    "mate": u"\U0001F9C9",
    "meat_on_bone": u"\U0001F356",
    "mechanic": u"\U0001F9D1\U0000200D\U0001F527",
    "mechanical_arm": u"\U0001F9BE",
    "mechanical_leg": u"\U0001F9BF",
    "medical_symbol": u"\U00002695\U0000FE0F",
    "megaphone": u"\U0001F4E3",
    "melon": u"\U0001F348",
    "memo": u"\U0001F4DD",
    "men_holding_hands": u"\U0001F46C",
    "men_with_bunny_ears": u"\U0001F46F\U0000200D\U00002642\U0000FE0F",
    "men_wrestling": u"\U0001F93C\U0000200D\U00002642\U0000FE0F",
    "mending_heart": u"\U00002764\U0000FE0F\U0000200D\U0001FA79",
    "menorah": u"\U0001F54E",
    "men’s_room": u"\U0001F6B9",
    "mermaid": u"\U0001F9DC\U0000200D\U00002640\U0000FE0F",
    "merman": u"\U0001F9DC\U0000200D\U00002642\U0000FE0F",
    "merperson": u"\U0001F9DC",
    "metro": u"\U0001F687",
    "microbe": u"\U0001F9A0",
    "microphone": u"\U0001F3A4",
    "microscope": u"\U0001F52C",
    "middle_finger": u"\U0001F595",
    "military_helmet": u"\U0001FA96",
    "military_medal": u"\U0001F396\U0000FE0F",
    "milky_way": u"\U0001F30C",
    "minibus": u"\U0001F690",
    "minus": u"\U00002796",
    "mirror": u"\U0001FA9E",
    "moai": u"\U0001F5FF",
    "mobile_phone": u"\U0001F4F1",
    "mobile_phone_off": u"\U0001F4F4",
    "mobile_phone_with_arrow": u"\U0001F4F2",
    "money-mouth_face": u"\U0001F911",
    "money_bag": u"\U0001F4B0",
    "money_with_wings": u"\U0001F4B8",
    "monkey": u"\U0001F412",
    "monkey_face": u"\U0001F435",
    "monorail": u"\U0001F69D",
    "moon_cake": u"\U0001F96E",
    "moon_viewing_ceremony": u"\U0001F391",
    "mosque": u"\U0001F54C",
    "mosquito": u"\U0001F99F",
    "motor_boat": u"\U0001F6E5\U0000FE0F",
    "motor_scooter": u"\U0001F6F5",
    "motorcycle": u"\U0001F3CD\U0000FE0F",
    "motorized_wheelchair": u"\U0001F9BC",
    "motorway": u"\U0001F6E3\U0000FE0F",
    "mount_fuji": u"\U0001F5FB",
    "mountain": u"\U000026F0\U0000FE0F",
    "mountain_cableway": u"\U0001F6A0",
    "mountain_railway": u"\U0001F69E",
    "mouse": u"\U0001F401",
    "mouse_face": u"\U0001F42D",
    "mouse_trap": u"\U0001FAA4",
    "mouth": u"\U0001F444",
    "movie_camera": u"\U0001F3A5",
    "multiply": u"\U00002716\U0000FE0F",
    "mushroom": u"\U0001F344",
    "musical_keyboard": u"\U0001F3B9",
    "musical_note": u"\U0001F3B5",
    "musical_notes": u"\U0001F3B6",
    "musical_score": u"\U0001F3BC",
    "muted_speaker": u"\U0001F507",
    "mx_claus": u"\U0001F9D1\U0000200D\U0001F384",
    "nail_polish": u"\U0001F485",
    "name_badge": u"\U0001F4DB",
    "national_park": u"\U0001F3DE\U0000FE0F",
    "nauseated_face": u"\U0001F922",
    "nazar_amulet": u"\U0001F9FF",
    "necktie": u"\U0001F454",
    "nerd_face": u"\U0001F913",
    "nesting_dolls": u"\U0001FA86",
    "neutral_face": u"\U0001F610",
    "new_moon": u"\U0001F311",
    "new_moon_face": u"\U0001F31A",
    "newspaper": u"\U0001F4F0",
    "next_track_button": u"\U000023ED\U0000FE0F",
    "night_with_stars": u"\U0001F303",
    "nine-thirty": u"\U0001F564",
    "nine_o’clock": u"\U0001F558",
    "ninja": u"\U0001F977",
    "no_bicycles": u"\U0001F6B3",
    "no_entry": u"\U000026D4",
    "no_littering": u"\U0001F6AF",
    "no_mobile_phones": u"\U0001F4F5",
    "no_one_under_eighteen": u"\U0001F51E",
    "no_pedestrians": u"\U0001F6B7",
    "no_smoking": u"\U0001F6AD",
    "non-potable_water": u"\U0001F6B1",
    "nose": u"\U0001F443",
    "notebook": u"\U0001F4D3",
    "notebook_with_decorative_cover": u"\U0001F4D4",
    "nut_and_bolt": u"\U0001F529",
    "octopus": u"\U0001F419",
    "oden": u"\U0001F362",
    "office_building": u"\U0001F3E2",
    "office_worker": u"\U0001F9D1\U0000200D\U0001F4BC",
    "ogre": u"\U0001F479",
    "oil_drum": u"\U0001F6E2\U0000FE0F",
    "old_key": u"\U0001F5DD\U0000FE0F",
    "old_man": u"\U0001F474",
    "old_woman": u"\U0001F475",
    "older_person": u"\U0001F9D3",
    "olive": u"\U0001FAD2",
    "om": u"\U0001F549\U0000FE0F",
    "oncoming_automobile": u"\U0001F698",
    "oncoming_bus": u"\U0001F68D",
    "oncoming_fist": u"\U0001F44A",
    "oncoming_police_car": u"\U0001F694",
    "oncoming_taxi": u"\U0001F696",
    "one-piece_swimsuit": u"\U0001FA71",
    "one-thirty": u"\U0001F55C",
    "one_o’clock": u"\U0001F550",
    "onion": u"\U0001F9C5",
    "open_book": u"\U0001F4D6",
    "open_file_folder": u"\U0001F4C2",
    "open_hands": u"\U0001F450",
    "open_mailbox_with_lowered_flag": u"\U0001F4ED",
    "open_mailbox_with_raised_flag": u"\U0001F4EC",
    "optical_disk": u"\U0001F4BF",
    "orange_book": u"\U0001F4D9",
    "orange_circle": u"\U0001F7E0",
    "orange_heart": u"\U0001F9E1",
    "orange_square": u"\U0001F7E7",
    "orangutan": u"\U0001F9A7",
    "orthodox_cross": u"\U00002626\U0000FE0F",
    "otter": u"\U0001F9A6",
    "outbox_tray": u"\U0001F4E4",
    "owl": u"\U0001F989",
    "ox": u"\U0001F402",
    "oyster": u"\U0001F9AA",
    "package": u"\U0001F4E6",
    "page_facing_up": u"\U0001F4C4",
    "page_with_curl": u"\U0001F4C3",
    "pager": u"\U0001F4DF",
    "paintbrush": u"\U0001F58C\U0000FE0F",
    "palm_tree": u"\U0001F334",
    "palms_up_together": u"\U0001F932",
    "pancakes": u"\U0001F95E",
    "panda": u"\U0001F43C",
    "paperclip": u"\U0001F4CE",
    "parachute": u"\U0001FA82",
    "parrot": u"\U0001F99C",
    "part_alternation_mark": u"\U0000303D\U0000FE0F",
    "party_popper": u"\U0001F389",
    "partying_face": u"\U0001F973",
    "passenger_ship": u"\U0001F6F3\U0000FE0F",
    "passport_control": u"\U0001F6C2",
    "pause_button": u"\U000023F8\U0000FE0F",
    "paw_prints": u"\U0001F43E",
    "peace_symbol": u"\U0000262E\U0000FE0F",
    "peach": u"\U0001F351",
    "peacock": u"\U0001F99A",
    "peanuts": u"\U0001F95C",
    "pear": u"\U0001F350",
    "pen": u"\U0001F58A\U0000FE0F",
    "pencil": u"\U0000270F\U0000FE0F",
    "penguin": u"\U0001F427",
    "pensive_face": u"\U0001F614",
    "people_holding_hands": u"\U0001F9D1\U0000200D\U0001F91D\U0000200D\U0001F9D1",
    "people_hugging": u"\U0001FAC2",
    "people_with_bunny_ears": u"\U0001F46F",
    "people_wrestling": u"\U0001F93C",
    "performing_arts": u"\U0001F3AD",
    "persevering_face": u"\U0001F623",
    "person": u"\U0001F9D1",
    "person_bald": u"\U0001F9D1\U0000200D\U0001F9B2",
    "person_beard": u"\U0001F9D4",
    "person_biking": u"\U0001F6B4",
    "person_blond_hair": u"\U0001F471",
    "person_bouncing_ball": u"\U000026F9\U0000FE0F",
    "person_bowing": u"\U0001F647",
    "person_cartwheeling": u"\U0001F938",
    "person_climbing": u"\U0001F9D7",
    "person_curly_hair": u"\U0001F9D1\U0000200D\U0001F9B1",
    "person_facepalming": u"\U0001F926",
    "person_feeding_baby": u"\U0001F9D1\U0000200D\U0001F37C",
    "person_fencing": u"\U0001F93A",
    "person_frowning": u"\U0001F64D",
    "person_gesturing_NO": u"\U0001F645",
    "person_gesturing_OK": u"\U0001F646",
    "person_getting_haircut": u"\U0001F487",
    "person_getting_massage": u"\U0001F486",
    "person_golfing": u"\U0001F3CC\U0000FE0F",
    "person_in_bed": u"\U0001F6CC",
    "person_in_lotus_position": u"\U0001F9D8",
    "person_in_manual_wheelchair": u"\U0001F9D1\U0000200D\U0001F9BD",
    "person_in_motorized_wheelchair": u"\U0001F9D1\U0000200D\U0001F9BC",
    "person_in_steamy_room": u"\U0001F9D6",
    "person_in_suit_levitating": u"\U0001F574\U0000FE0F",
    "person_in_tuxedo": u"\U0001F935",
    "person_juggling": u"\U0001F939",
    "person_kneeling": u"\U0001F9CE",
    "person_lifting_weights": u"\U0001F3CB\U0000FE0F",
    "person_mountain_biking": u"\U0001F6B5",
    "person_playing_handball": u"\U0001F93E",
    "person_playing_water_polo": u"\U0001F93D",
    "person_pouting": u"\U0001F64E",
    "person_raising_hand": u"\U0001F64B",
    "person_red_hair": u"\U0001F9D1\U0000200D\U0001F9B0",
    "person_rowing_boat": u"\U0001F6A3",
    "person_running": u"\U0001F3C3",
    "person_shrugging": u"\U0001F937",
    "person_standing": u"\U0001F9CD",
    "person_surfing": u"\U0001F3C4",
    "person_swimming": u"\U0001F3CA",
    "person_taking_bath": u"\U0001F6C0",
    "person_tipping_hand": u"\U0001F481",
    "person_walking": u"\U0001F6B6",
    "person_wearing_turban": u"\U0001F473",
    "person_white_hair": u"\U0001F9D1\U0000200D\U0001F9B3",
    "person_with_skullcap": u"\U0001F472",
    "person_with_veil": u"\U0001F470",
    "person_with_white_cane": u"\U0001F9D1\U0000200D\U0001F9AF",
    "petri_dish": u"\U0001F9EB",
    "pick": u"\U000026CF\U0000FE0F",
    "pickup_truck": u"\U0001F6FB",
    "pie": u"\U0001F967",
    "pig": u"\U0001F416",
    "pig_face": u"\U0001F437",
    "pig_nose": u"\U0001F43D",
    "pile_of_poo": u"\U0001F4A9",
    "pill": u"\U0001F48A",
    "pilot": u"\U0001F9D1\U0000200D\U00002708\U0000FE0F",
    "pinched_fingers": u"\U0001F90C",
    "pinching_hand": u"\U0001F90F",
    "pine_decoration": u"\U0001F38D",
    "pineapple": u"\U0001F34D",
    "ping_pong": u"\U0001F3D3",
    "pirate_flag": u"\U0001F3F4\U0000200D\U00002620\U0000FE0F",
    "pizza": u"\U0001F355",
    "piñata": u"\U0001FA85",
    "placard": u"\U0001FAA7",
    "place_of_worship": u"\U0001F6D0",
    "play_button": u"\U000025B6\U0000FE0F",
    "play_or_pause_button": u"\U000023EF\U0000FE0F",
    "pleading_face": u"\U0001F97A",
    "plunger": u"\U0001FAA0",
    "plus": u"\U00002795",
    "polar_bear": u"\U0001F43B\U0000200D\U00002744\U0000FE0F",
    "police_car": u"\U0001F693",
    "police_car_light": u"\U0001F6A8",
    "police_officer": u"\U0001F46E",
    "poodle": u"\U0001F429",
    "pool_8_ball": u"\U0001F3B1",
    "popcorn": u"\U0001F37F",
    "post_office": u"\U0001F3E4",
    "postal_horn": u"\U0001F4EF",
    "postbox": u"\U0001F4EE",
    "pot_of_food": u"\U0001F372",
    "potable_water": u"\U0001F6B0",
    "potato": u"\U0001F954",
    "potted_plant": u"\U0001FAB4",
    "poultry_leg": u"\U0001F357",
    "pound_banknote": u"\U0001F4B7",
    "pouting_cat": u"\U0001F63E",
    "pouting_face": u"\U0001F621",
    "prayer_beads": u"\U0001F4FF",
    "pregnant_woman": u"\U0001F930",
    "pretzel": u"\U0001F968",
    "prince": u"\U0001F934",
    "princess": u"\U0001F478",
    "printer": u"\U0001F5A8\U0000FE0F",
    "prohibited": u"\U0001F6AB",
    "purple_circle": u"\U0001F7E3",
    "purple_heart": u"\U0001F49C",
    "purple_square": u"\U0001F7EA",
    "purse": u"\U0001F45B",
    "pushpin": u"\U0001F4CC",
    "puzzle_piece": u"\U0001F9E9",
    "rabbit": u"\U0001F407",
    "rabbit_face": u"\U0001F430",
    "raccoon": u"\U0001F99D",
    "racing_car": u"\U0001F3CE\U0000FE0F",
    "radio": u"\U0001F4FB",
    "radio_button": u"\U0001F518",
    "radioactive": u"\U00002622\U0000FE0F",
    "railway_car": u"\U0001F683",
    "railway_track": u"\U0001F6E4\U0000FE0F",
    "rainbow": u"\U0001F308",
    "rainbow_flag": u"\U0001F3F3\U0000FE0F\U0000200D\U0001F308",
    "raised_back_of_hand": u"\U0001F91A",
    "raised_fist": u"\U0000270A",
    "raised_hand": u"\U0000270B",
    "raising_hands": u"\U0001F64C",
    "ram": u"\U0001F40F",
    "rat": u"\U0001F400",
    "razor": u"\U0001FA92",
    "receipt": u"\U0001F9FE",
    "record_button": u"\U000023FA\U0000FE0F",
    "recycling_symbol": u"\U0000267B\U0000FE0F",
    "red_apple": u"\U0001F34E",
    "red_circle": u"\U0001F534",
    "red_envelope": u"\U0001F9E7",
    "red_exclamation_mark": u"\U00002757",
    "red_heart": u"\U00002764\U0000FE0F",
    "red_paper_lantern": u"\U0001F3EE",
    "red_question_mark": u"\U00002753",
    "red_square": u"\U0001F7E5",
    "red_triangle_pointed_down": u"\U0001F53B",
    "red_triangle_pointed_up": u"\U0001F53A",
    "registered": u"\U000000AE\U0000FE0F",
    "relieved_face": u"\U0001F60C",
    "reminder_ribbon": u"\U0001F397\U0000FE0F",
    "repeat_button": u"\U0001F501",
    "repeat_single_button": u"\U0001F502",
    "rescue_worker’s_helmet": u"\U000026D1\U0000FE0F",
    "restroom": u"\U0001F6BB",
    "reverse_button": u"\U000025C0\U0000FE0F",
    "revolving_hearts": u"\U0001F49E",
    "rhinoceros": u"\U0001F98F",
    "ribbon": u"\U0001F380",
    "rice_ball": u"\U0001F359",
    "rice_cracker": u"\U0001F358",
    "right-facing_fist": u"\U0001F91C",
    "right_anger_bubble": u"\U0001F5EF\U0000FE0F",
    "right_arrow": u"\U000027A1\U0000FE0F",
    "right_arrow_curving_down": u"\U00002935\U0000FE0F",
    "right_arrow_curving_left": u"\U000021A9\U0000FE0F",
    "right_arrow_curving_up": u"\U00002934\U0000FE0F",
    "ring": u"\U0001F48D",
    "ringed_planet": u"\U0001FA90",
    "roasted_sweet_potato": u"\U0001F360",
    "robot": u"\U0001F916",
    "rock": u"\U0001FAA8",
    "rocket": u"\U0001F680",
    "roll_of_paper": u"\U0001F9FB",
    "rolled-up_newspaper": u"\U0001F5DE\U0000FE0F",
    "roller_coaster": u"\U0001F3A2",
    "roller_skate": u"\U0001F6FC",
    "rolling_on_the_floor_laughing": u"\U0001F923",
    "rooster": u"\U0001F413",
    "rose": u"\U0001F339",
    "rosette": u"\U0001F3F5\U0000FE0F",
    "round_pushpin": u"\U0001F4CD",
    "rugby_football": u"\U0001F3C9",
    "running_shirt": u"\U0001F3BD",
    "running_shoe": u"\U0001F45F",
    "sad_but_relieved_face": u"\U0001F625",
    "safety_pin": u"\U0001F9F7",
    "safety_vest": u"\U0001F9BA",
    "sailboat": u"\U000026F5",
    "sake": u"\U0001F376",
    "salt": u"\U0001F9C2",
    "sandwich": u"\U0001F96A",
    "sari": u"\U0001F97B",
    "satellite": u"\U0001F6F0\U0000FE0F",
    "satellite_antenna": u"\U0001F4E1",
    "sauropod": u"\U0001F995",
    "saxophone": u"\U0001F3B7",
    "scarf": u"\U0001F9E3",
    "school": u"\U0001F3EB",
    "scientist": u"\U0001F9D1\U0000200D\U0001F52C",
    "scissors": u"\U00002702\U0000FE0F",
    "scorpion": u"\U0001F982",
    "screwdriver": u"\U0001FA9B",
    "scroll": u"\U0001F4DC",
    "seal": u"\U0001F9AD",
    "seat": u"\U0001F4BA",
    "see-no-evil_monkey": u"\U0001F648",
    "seedling": u"\U0001F331",
    "selfie": u"\U0001F933",
    "service_dog": u"\U0001F415\U0000200D\U0001F9BA",
    "seven-thirty": u"\U0001F562",
    "seven_o’clock": u"\U0001F556",
    "sewing_needle": u"\U0001FAA1",
    "shallow_pan_of_food": u"\U0001F958",
    "shamrock": u"\U00002618\U0000FE0F",
    "shark": u"\U0001F988",
    "shaved_ice": u"\U0001F367",
    "sheaf_of_rice": u"\U0001F33E",
    "shield": u"\U0001F6E1\U0000FE0F",
    "shinto_shrine": u"\U000026E9\U0000FE0F",
    "ship": u"\U0001F6A2",
    "shooting_star": u"\U0001F320",
    "shopping_bags": u"\U0001F6CD\U0000FE0F",
    "shopping_cart": u"\U0001F6D2",
    "shortcake": u"\U0001F370",
    "shorts": u"\U0001FA73",
    "shower": u"\U0001F6BF",
    "shrimp": u"\U0001F990",
    "shuffle_tracks_button": u"\U0001F500",
    "shushing_face": u"\U0001F92B",
    "sign_of_the_horns": u"\U0001F918",
    "singer": u"\U0001F9D1\U0000200D\U0001F3A4",
    "six-thirty": u"\U0001F561",
    "six_o’clock": u"\U0001F555",
    "skateboard": u"\U0001F6F9",
    "skier": u"\U000026F7\U0000FE0F",
    "skis": u"\U0001F3BF",
    "skull": u"\U0001F480",
    "skull_and_crossbones": u"\U00002620\U0000FE0F",
    "skunk": u"\U0001F9A8",
    "sled": u"\U0001F6F7",
    "sleeping_face": u"\U0001F634",
    "sleepy_face": u"\U0001F62A",
    "slightly_frowning_face": u"\U0001F641",
    "slightly_smiling_face": u"\U0001F642",
    "slot_machine": u"\U0001F3B0",
    "sloth": u"\U0001F9A5",
    "small_airplane": u"\U0001F6E9\U0000FE0F",
    "small_blue_diamond": u"\U0001F539",
    "small_orange_diamond": u"\U0001F538",
    "smiling_cat_with_heart-eyes": u"\U0001F63B",
    "smiling_face": u"\U0000263A\U0000FE0F",
    "smiling_face_with_halo": u"\U0001F607",
    "smiling_face_with_heart-eyes": u"\U0001F60D",
    "smiling_face_with_hearts": u"\U0001F970",
    "smiling_face_with_horns": u"\U0001F608",
    "smiling_face_with_open_hands": u"\U0001F917",
    "smiling_face_with_smiling_eyes": u"\U0001F60A",
    "smiling_face_with_sunglasses": u"\U0001F60E",
    "smiling_face_with_tear": u"\U0001F972",
    "smirking_face": u"\U0001F60F",
    "snail": u"\U0001F40C",
    "snake": u"\U0001F40D",
    "sneezing_face": u"\U0001F927",
    "snow-capped_mountain": u"\U0001F3D4\U0000FE0F",
    "snowboarder": u"\U0001F3C2",
    "snowflake": u"\U00002744\U0000FE0F",
    "snowman": u"\U00002603\U0000FE0F",
    "snowman_without_snow": u"\U000026C4",
    "soap": u"\U0001F9FC",
    "soccer_ball": u"\U000026BD",
    "socks": u"\U0001F9E6",
    "soft_ice_cream": u"\U0001F366",
    "softball": u"\U0001F94E",
    "spade_suit": u"\U00002660\U0000FE0F",
    "spaghetti": u"\U0001F35D",
    "sparkle": u"\U00002747\U0000FE0F",
    "sparkler": u"\U0001F387",
    "sparkles": u"\U00002728",
    "sparkling_heart": u"\U0001F496",
    "speak-no-evil_monkey": u"\U0001F64A",
    "speaker_high_volume": u"\U0001F50A",
    "speaker_low_volume": u"\U0001F508",
    "speaker_medium_volume": u"\U0001F509",
    "speaking_head": u"\U0001F5E3\U0000FE0F",
    "speech_balloon": u"\U0001F4AC",
    "speedboat": u"\U0001F6A4",
    "spider": u"\U0001F577\U0000FE0F",
    "spider_web": u"\U0001F578\U0000FE0F",
    "spiral_calendar": u"\U0001F5D3\U0000FE0F",
    "spiral_notepad": u"\U0001F5D2\U0000FE0F",
    "spiral_shell": u"\U0001F41A",
    "sponge": u"\U0001F9FD",
    "spoon": u"\U0001F944",
    "sport_utility_vehicle": u"\U0001F699",
    "sports_medal": u"\U0001F3C5",
    "spouting_whale": u"\U0001F433",
    "squid": u"\U0001F991",
    "squinting_face_with_tongue": u"\U0001F61D",
    "stadium": u"\U0001F3DF\U0000FE0F",
    "star": u"\U00002B50",
    "star-struck": u"\U0001F929",
    "star_and_crescent": u"\U0000262A\U0000FE0F",
    "star_of_David": u"\U00002721\U0000FE0F",
    "station": u"\U0001F689",
    "steaming_bowl": u"\U0001F35C",
    "stethoscope": u"\U0001FA7A",
    "stop_button": u"\U000023F9\U0000FE0F",
    "stop_sign": u"\U0001F6D1",
    "stopwatch": u"\U000023F1\U0000FE0F",
    "straight_ruler": u"\U0001F4CF",
    "strawberry": u"\U0001F353",
    "student": u"\U0001F9D1\U0000200D\U0001F393",
    "studio_microphone": u"\U0001F399\U0000FE0F",
    "stuffed_flatbread": u"\U0001F959",
    "sun": u"\U00002600\U0000FE0F",
    "sun_behind_cloud": u"\U000026C5",
    "sun_behind_large_cloud": u"\U0001F325\U0000FE0F",
    "sun_behind_rain_cloud": u"\U0001F326\U0000FE0F",
    "sun_behind_small_cloud": u"\U0001F324\U0000FE0F",
    "sun_with_face": u"\U0001F31E",
    "sunflower": u"\U0001F33B",
    "sunglasses": u"\U0001F576\U0000FE0F",
    "sunrise": u"\U0001F305",
    "sunrise_over_mountains": u"\U0001F304",
    "sunset": u"\U0001F307",
    "superhero": u"\U0001F9B8",
    "supervillain": u"\U0001F9B9",
    "sushi": u"\U0001F363",
    "suspension_railway": u"\U0001F69F",
    "swan": u"\U0001F9A2",
    "sweat_droplets": u"\U0001F4A6",
    "synagogue": u"\U0001F54D",
    "syringe": u"\U0001F489",
    "t-shirt": u"\U0001F455",
    "taco": u"\U0001F32E",
    "takeout_box": u"\U0001F961",
    "tamale": u"\U0001FAD4",
    "tanabata_tree": u"\U0001F38B",
    "tangerine": u"\U0001F34A",
    "taxi": u"\U0001F695",
    "teacher": u"\U0001F9D1\U0000200D\U0001F3EB",
    "teacup_without_handle": u"\U0001F375",
    "teapot": u"\U0001FAD6",
    "tear-off_calendar": u"\U0001F4C6",
    "technologist": u"\U0001F9D1\U0000200D\U0001F4BB",
    "teddy_bear": u"\U0001F9F8",
    "telephone": u"\U0000260E\U0000FE0F",
    "telephone_receiver": u"\U0001F4DE",
    "telescope": u"\U0001F52D",
    "television": u"\U0001F4FA",
    "ten-thirty": u"\U0001F565",
    "ten_o’clock": u"\U0001F559",
    "tennis": u"\U0001F3BE",
    "tent": u"\U000026FA",
    "test_tube": u"\U0001F9EA",
    "thermometer": u"\U0001F321\U0000FE0F",
    "thinking_face": u"\U0001F914",
    "thong_sandal": u"\U0001FA74",
    "thought_balloon": u"\U0001F4AD",
    "thread": u"\U0001F9F5",
    "three-thirty": u"\U0001F55E",
    "three_o’clock": u"\U0001F552",
    "thumbs_down": u"\U0001F44E",
    "thumbs_up": u"\U0001F44D",
    "ticket": u"\U0001F3AB",
    "tiger": u"\U0001F405",
    "tiger_face": u"\U0001F42F",
    "timer_clock": u"\U000023F2\U0000FE0F",
    "tired_face": u"\U0001F62B",
    "toilet": u"\U0001F6BD",
    "tomato": u"\U0001F345",
    "tongue": u"\U0001F445",
    "toolbox": u"\U0001F9F0",
    "tooth": u"\U0001F9B7",
    "toothbrush": u"\U0001FAA5",
    "top_hat": u"\U0001F3A9",
    "tornado": u"\U0001F32A\U0000FE0F",
    "trackball": u"\U0001F5B2\U0000FE0F",
    "tractor": u"\U0001F69C",
    "trade_mark": u"\U00002122\U0000FE0F",
    "train": u"\U0001F686",
    "tram": u"\U0001F68A",
    "tram_car": u"\U0001F68B",
    "transgender_flag": u"\U0001F3F3\U0000FE0F\U0000200D\U000026A7\U0000FE0F",
    "transgender_symbol": u"\U000026A7\U0000FE0F",
    "triangular_flag": u"\U0001F6A9",
    "triangular_ruler": u"\U0001F4D0",
    "trident_emblem": u"\U0001F531",
    "trolleybus": u"\U0001F68E",
    "trophy": u"\U0001F3C6",
    "tropical_drink": u"\U0001F379",
    "tropical_fish": u"\U0001F420",
    "trumpet": u"\U0001F3BA",
    "tulip": u"\U0001F337",
    "tumbler_glass": u"\U0001F943",
    "turkey": u"\U0001F983",
    "turtle": u"\U0001F422",
    "twelve-thirty": u"\U0001F567",
    "twelve_o’clock": u"\U0001F55B",
    "two-hump_camel": u"\U0001F42B",
    "two-thirty": u"\U0001F55D",
    "two_hearts": u"\U0001F495",
    "two_o’clock": u"\U0001F551",
    "umbrella": u"\U00002602\U0000FE0F",
    "umbrella_on_ground": u"\U000026F1\U0000FE0F",
    "umbrella_with_rain_drops": u"\U00002614",
    "unamused_face": u"\U0001F612",
    "unicorn": u"\U0001F984",
    "unlocked": u"\U0001F513",
    "up-down_arrow": u"\U00002195\U0000FE0F",
    "up-left_arrow": u"\U00002196\U0000FE0F",
    "up-right_arrow": u"\U00002197\U0000FE0F",
    "up_arrow": u"\U00002B06\U0000FE0F",
    "upside-down_face": u"\U0001F643",
    "upwards_button": u"\U0001F53C",
    "vampire": u"\U0001F9DB",
    "vertical_traffic_light": u"\U0001F6A6",
    "vibration_mode": u"\U0001F4F3",
    "victory_hand": u"\U0000270C\U0000FE0F",
    "video_camera": u"\U0001F4F9",
    "video_game": u"\U0001F3AE",
    "videocassette": u"\U0001F4FC",
    "violin": u"\U0001F3BB",
    "volcano": u"\U0001F30B",
    "volleyball": u"\U0001F3D0",
    "vulcan_salute": u"\U0001F596",
    "waffle": u"\U0001F9C7",
    "waning_crescent_moon": u"\U0001F318",
    "waning_gibbous_moon": u"\U0001F316",
    "warning": u"\U000026A0\U0000FE0F",
    "wastebasket": u"\U0001F5D1\U0000FE0F",
    "watch": u"\U0000231A",
    "water_buffalo": u"\U0001F403",
    "water_closet": u"\U0001F6BE",
    "water_pistol": u"\U0001F52B",
    "water_wave": u"\U0001F30A",
    "watermelon": u"\U0001F349",
    "waving_hand": u"\U0001F44B",
    "wavy_dash": u"\U00003030\U0000FE0F",
    "waxing_crescent_moon": u"\U0001F312",
    "waxing_gibbous_moon": u"\U0001F314",
    "weary_cat": u"\U0001F640",
    "weary_face": u"\U0001F629",
    "wedding": u"\U0001F492",
    "whale": u"\U0001F40B",
    "wheel_of_dharma": u"\U00002638\U0000FE0F",
    "wheelchair_symbol": u"\U0000267F",
    "white_cane": u"\U0001F9AF",
    "white_circle": u"\U000026AA",
    "white_exclamation_mark": u"\U00002755",
    "white_flag": u"\U0001F3F3\U0000FE0F",
    "white_flower": u"\U0001F4AE",
    "white_heart": u"\U0001F90D",
    "white_large_square": u"\U00002B1C",
    "white_medium-small_square": u"\U000025FD",
    "white_medium_square": u"\U000025FB\U0000FE0F",
    "white_question_mark": u"\U00002754",
    "white_small_square": u"\U000025AB\U0000FE0F",
    "white_square_button": u"\U0001F533",
    "wilted_flower": u"\U0001F940",
    "wind_chime": u"\U0001F390",
    "wind_face": u"\U0001F32C\U0000FE0F",
    "window": u"\U0001FA9F",
    "wine_glass": u"\U0001F377",
    "winking_face": u"\U0001F609",
    "winking_face_with_tongue": u"\U0001F61C",
    "wolf": u"\U0001F43A",
    "woman": u"\U0001F469",
    "woman_and_man_holding_hands": u"\U0001F46B",
    "woman_artist": u"\U0001F469\U0000200D\U0001F3A8",
    "woman_astronaut": u"\U0001F469\U0000200D\U0001F680",
    "woman_bald": u"\U0001F469\U0000200D\U0001F9B2",
    "woman_beard": u"\U0001F9D4\U0000200D\U00002640\U0000FE0F",
    "woman_biking": u"\U0001F6B4\U0000200D\U00002640\U0000FE0F",
    "woman_blond_hair": u"\U0001F471\U0000200D\U00002640\U0000FE0F",
    "woman_bouncing_ball": u"\U000026F9\U0000FE0F\U0000200D\U00002640\U0000FE0F",
    "woman_bowing": u"\U0001F647\U0000200D\U00002640\U0000FE0F",
    "woman_cartwheeling": u"\U0001F938\U0000200D\U00002640\U0000FE0F",
    "woman_climbing": u"\U0001F9D7\U0000200D\U00002640\U0000FE0F",
    "woman_construction_worker": u"\U0001F477\U0000200D\U00002640\U0000FE0F",
    "woman_cook": u"\U0001F469\U0000200D\U0001F373",
    "woman_curly_hair": u"\U0001F469\U0000200D\U0001F9B1",
    "woman_dancing": u"\U0001F483",
    "woman_detective": u"\U0001F575\U0000FE0F\U0000200D\U00002640\U0000FE0F",
    "woman_elf": u"\U0001F9DD\U0000200D\U00002640\U0000FE0F",
    "woman_facepalming": u"\U0001F926\U0000200D\U00002640\U0000FE0F",
    "woman_factory_worker": u"\U0001F469\U0000200D\U0001F3ED",
    "woman_fairy": u"\U0001F9DA\U0000200D\U00002640\U0000FE0F",
    "woman_farmer": u"\U0001F469\U0000200D\U0001F33E",
    "woman_feeding_baby": u"\U0001F469\U0000200D\U0001F37C",
    "woman_firefighter": u"\U0001F469\U0000200D\U0001F692",
    "woman_frowning": u"\U0001F64D\U0000200D\U00002640\U0000FE0F",
    "woman_genie": u"\U0001F9DE\U0000200D\U00002640\U0000FE0F",
    "woman_gesturing_NO": u"\U0001F645\U0000200D\U00002640\U0000FE0F",
    "woman_gesturing_OK": u"\U0001F646\U0000200D\U00002640\U0000FE0F",
    "woman_getting_haircut": u"\U0001F487\U0000200D\U00002640\U0000FE0F",
    "woman_getting_massage": u"\U0001F486\U0000200D\U00002640\U0000FE0F",
    "woman_golfing": u"\U0001F3CC\U0000FE0F\U0000200D\U00002640\U0000FE0F",
    "woman_guard": u"\U0001F482\U0000200D\U00002640\U0000FE0F",
    "woman_health_worker": u"\U0001F469\U0000200D\U00002695\U0000FE0F",
    "woman_in_lotus_position": u"\U0001F9D8\U0000200D\U00002640\U0000FE0F",
    "woman_in_manual_wheelchair": u"\U0001F469\U0000200D\U0001F9BD",
    "woman_in_motorized_wheelchair": u"\U0001F469\U0000200D\U0001F9BC",
    "woman_in_steamy_room": u"\U0001F9D6\U0000200D\U00002640\U0000FE0F",
    "woman_in_tuxedo": u"\U0001F935\U0000200D\U00002640\U0000FE0F",
    "woman_judge": u"\U0001F469\U0000200D\U00002696\U0000FE0F",
    "woman_juggling": u"\U0001F939\U0000200D\U00002640\U0000FE0F",
    "woman_kneeling": u"\U0001F9CE\U0000200D\U00002640\U0000FE0F",
    "woman_lifting_weights": u"\U0001F3CB\U0000FE0F\U0000200D\U00002640\U0000FE0F",
    "woman_mage": u"\U0001F9D9\U0000200D\U00002640\U0000FE0F",
    "woman_mechanic": u"\U0001F469\U0000200D\U0001F527",
    "woman_mountain_biking": u"\U0001F6B5\U0000200D\U00002640\U0000FE0F",
    "woman_office_worker": u"\U0001F469\U0000200D\U0001F4BC",
    "woman_pilot": u"\U0001F469\U0000200D\U00002708\U0000FE0F",
    "woman_playing_handball": u"\U0001F93E\U0000200D\U00002640\U0000FE0F",
    "woman_playing_water_polo": u"\U0001F93D\U0000200D\U00002640\U0000FE0F",
    "woman_police_officer": u"\U0001F46E\U0000200D\U00002640\U0000FE0F",
    "woman_pouting": u"\U0001F64E\U0000200D\U00002640\U0000FE0F",
    "woman_raising_hand": u"\U0001F64B\U0000200D\U00002640\U0000FE0F",
    "woman_red_hair": u"\U0001F469\U0000200D\U0001F9B0",
    "woman_rowing_boat": u"\U0001F6A3\U0000200D\U00002640\U0000FE0F",
    "woman_running": u"\U0001F3C3\U0000200D\U00002640\U0000FE0F",
    "woman_scientist": u"\U0001F469\U0000200D\U0001F52C",
    "woman_shrugging": u"\U0001F937\U0000200D\U00002640\U0000FE0F",
    "woman_singer": u"\U0001F469\U0000200D\U0001F3A4",
    "woman_standing": u"\U0001F9CD\U0000200D\U00002640\U0000FE0F",
    "woman_student": u"\U0001F469\U0000200D\U0001F393",
    "woman_superhero": u"\U0001F9B8\U0000200D\U00002640\U0000FE0F",
    "woman_supervillain": u"\U0001F9B9\U0000200D\U00002640\U0000FE0F",
    "woman_surfing": u"\U0001F3C4\U0000200D\U00002640\U0000FE0F",
    "woman_swimming": u"\U0001F3CA\U0000200D\U00002640\U0000FE0F",
    "woman_teacher": u"\U0001F469\U0000200D\U0001F3EB",
    "woman_technologist": u"\U0001F469\U0000200D\U0001F4BB",
    "woman_tipping_hand": u"\U0001F481\U0000200D\U00002640\U0000FE0F",
    "woman_vampire": u"\U0001F9DB\U0000200D\U00002640\U0000FE0F",
    "woman_walking": u"\U0001F6B6\U0000200D\U00002640\U0000FE0F",
    "woman_wearing_turban": u"\U0001F473\U0000200D\U00002640\U0000FE0F",
    "woman_white_hair": u"\U0001F469\U0000200D\U0001F9B3",
    "woman_with_headscarf": u"\U0001F9D5",
    "woman_with_veil": u"\U0001F470\U0000200D\U00002640\U0000FE0F",
    "woman_with_white_cane": u"\U0001F469\U0000200D\U0001F9AF",
    "woman_zombie": u"\U0001F9DF\U0000200D\U00002640\U0000FE0F",
    "woman’s_boot": u"\U0001F462",
    "woman’s_clothes": u"\U0001F45A",
    "woman’s_hat": u"\U0001F452",
    "woman’s_sandal": u"\U0001F461",
    "women_holding_hands": u"\U0001F46D",
    "women_with_bunny_ears": u"\U0001F46F\U0000200D\U00002640\U0000FE0F",
    "women_wrestling": u"\U0001F93C\U0000200D\U00002640\U0000FE0F",
    "women’s_room": u"\U0001F6BA",
    "wood": u"\U0001FAB5",
    "woozy_face": u"\U0001F974",
    "world_map": u"\U0001F5FA\U0000FE0F",
    "worm": u"\U0001FAB1",
    "worried_face": u"\U0001F61F",
    "wrapped_gift": u"\U0001F381",
    "wrench": u"\U0001F527",
    "writing_hand": u"\U0000270D\U0000FE0F",
    "yarn": u"\U0001F9F6",
    "yawning_face": u"\U0001F971",
    "yellow_circle": u"\U0001F7E1",
    "yellow_heart": u"\U0001F49B",
    "yellow_square": u"\U0001F7E8",
    "yen_banknote": u"\U0001F4B4",
    "yin_yang": u"\U0000262F\U0000FE0F",
    "yo-yo": u"\U0001FA80",
    "zany_face": u"\U0001F92A",
    "zebra": u"\U0001F993",
    "zipper-mouth_face": u"\U0001F910",
    "zombie": u"\U0001F9DF",
}


GOOD_EMOJIS = [
    'thumbs_up',
	'clapping_hands',
	'folded_hands', 
	'raised_fist',
	'flexed_biceps',
    'smiling_face_with_sunglasses',
    'star-struck',
    'crown', 
    'fire', 
    'bullseye', 
    'taco', 
    'glowing_star', 
    'hundred_points', 
    'high_voltage', 
    'kiss_mark', 
    'party_popper', 
    'partying_face',
    'rocket',
    'pizza',
    'clinking_glasses',
	'cherries',
	'1st_place_medal',
	'chart_increasing',
]

BAD_EMOJIS = [
	'scorpion',
	'snake',
	'skull_and_crossbones',
	'skull',
	'skunk',
	'vampire',
	'weary_cat',
	'collision',
	'weary_face',
	'angry_face',
	'frowning_face',
	'frowning_face_with_open_mouth',
	'thumbs_down', 
	'toilet'
]

COLLECTIONS = {
	'gun_to_the_head': ['water_pistol', 'weary_face'],
	'gamble': ['crossed_fingers', 'game_die'],
	'old_school': ['floppy_disk', 'videocassette', 'video_game', 'video_camera', 'pager'],
	'security': [
		'key', 'old_key', 'police_car', 'police_officer', 'police_car_light'
	],
	'phones': ['telephone', 'telephone_receiver'],
	'winter': ['snowman', 'snowflake', 'skier'],
	'vacation': ['palm_tree', 'man_surfing', 'beach_with_umbrella', 'passenger_ship', 'tropical_drink'],
	'money': ['money_with_wings', 'money_bag', 'heavy_dollar_sign', 'dollar_banknote'],
	'sports': ['man_golfing', 'man_running', 'man_lifting_weights', 'curling_stone', 'basketball'],
    'love': ['peach', 'high-heeled_shoe', 'lipstick', 'kiss', 'red_heart', 'tongue']
}

def load_emoji(short_name):
	code = EMOJIS.get(short_name)
	if code:
		return code

def print_samples():
	for k,v in EMOJIS.items():
		print(f'{k} - {v}')

def rnd_good_emoji(qty=1):
	"""
	"""
	results = []
	for n in range(qty):
		r = random.randint(1,len(GOOD_EMOJIS))
		key = GOOD_EMOJIS[r-1]
		results.append(EMOJIS[key])
	return ''.join([x for x in results])

def rnd_bad_emoji(qty=1):
	"""
	"""
	results = []
	for n in range(qty):
		r = random.randint(1,len(BAD_EMOJIS))
		key = BAD_EMOJIS[r-1]
		results.append(EMOJIS[key])

	return ''.join([x for x in results])

