"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Vocabulary:
1. ExtDatabase refers to DB in external data sources & contains
credentials/config.
2. ExtTable refers to a specific table etc. in the context of an external
database
3. Source refers to a (table, dataset) along with some config
4. Sink refers to a (table, dataset) along with some config
5. This whole module is called connector.
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class ExtDatabase(google.protobuf.message.Message):
    """-----------------------------------------
    First we have all the databases
    -----------------------------------------
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    MYSQL_FIELD_NUMBER: builtins.int
    POSTGRES_FIELD_NUMBER: builtins.int
    REFERENCE_FIELD_NUMBER: builtins.int
    S3_FIELD_NUMBER: builtins.int
    BIGQUERY_FIELD_NUMBER: builtins.int
    SNOWFLAKE_FIELD_NUMBER: builtins.int
    KAFKA_FIELD_NUMBER: builtins.int
    name: builtins.str
    @property
    def mysql(self) -> global___MySQL: ...
    @property
    def postgres(self) -> global___Postgres: ...
    @property
    def reference(self) -> global___Reference:
        """When a source has already been created on the console
        Or via code and is specified by name ONLY.
        """
    @property
    def s3(self) -> global___S3: ...
    @property
    def bigquery(self) -> global___Bigquery: ...
    @property
    def snowflake(self) -> global___Snowflake: ...
    @property
    def kafka(self) -> global___Kafka: ...
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        mysql: global___MySQL | None = ...,
        postgres: global___Postgres | None = ...,
        reference: global___Reference | None = ...,
        s3: global___S3 | None = ...,
        bigquery: global___Bigquery | None = ...,
        snowflake: global___Snowflake | None = ...,
        kafka: global___Kafka | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["bigquery", b"bigquery", "kafka", b"kafka", "mysql", b"mysql", "postgres", b"postgres", "reference", b"reference", "s3", b"s3", "snowflake", b"snowflake", "variant", b"variant"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["bigquery", b"bigquery", "kafka", b"kafka", "mysql", b"mysql", "name", b"name", "postgres", b"postgres", "reference", b"reference", "s3", b"s3", "snowflake", b"snowflake", "variant", b"variant"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["variant", b"variant"]) -> typing_extensions.Literal["mysql", "postgres", "reference", "s3", "bigquery", "snowflake", "kafka"] | None: ...

global___ExtDatabase = ExtDatabase

class Reference(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ExtDBType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ExtDBTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Reference._ExtDBType.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        MYSQL: Reference._ExtDBType.ValueType  # 0
        POSTGRES: Reference._ExtDBType.ValueType  # 1
        S3: Reference._ExtDBType.ValueType  # 2
        KAFKA: Reference._ExtDBType.ValueType  # 3
        BIGQUERY: Reference._ExtDBType.ValueType  # 4
        SNOWFLAKE: Reference._ExtDBType.ValueType  # 5

    class ExtDBType(_ExtDBType, metaclass=_ExtDBTypeEnumTypeWrapper): ...
    MYSQL: Reference.ExtDBType.ValueType  # 0
    POSTGRES: Reference.ExtDBType.ValueType  # 1
    S3: Reference.ExtDBType.ValueType  # 2
    KAFKA: Reference.ExtDBType.ValueType  # 3
    BIGQUERY: Reference.ExtDBType.ValueType  # 4
    SNOWFLAKE: Reference.ExtDBType.ValueType  # 5

    DBTYPE_FIELD_NUMBER: builtins.int
    dbtype: global___Reference.ExtDBType.ValueType
    def __init__(
        self,
        *,
        dbtype: global___Reference.ExtDBType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["dbtype", b"dbtype"]) -> None: ...

global___Reference = Reference

class MySQL(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HOST_FIELD_NUMBER: builtins.int
    DATABASE_FIELD_NUMBER: builtins.int
    USER_FIELD_NUMBER: builtins.int
    PASSWORD_FIELD_NUMBER: builtins.int
    PORT_FIELD_NUMBER: builtins.int
    JDBC_PARAMS_FIELD_NUMBER: builtins.int
    host: builtins.str
    database: builtins.str
    user: builtins.str
    password: builtins.str
    port: builtins.int
    jdbc_params: builtins.str
    def __init__(
        self,
        *,
        host: builtins.str = ...,
        database: builtins.str = ...,
        user: builtins.str = ...,
        password: builtins.str = ...,
        port: builtins.int = ...,
        jdbc_params: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["database", b"database", "host", b"host", "jdbc_params", b"jdbc_params", "password", b"password", "port", b"port", "user", b"user"]) -> None: ...

global___MySQL = MySQL

class Postgres(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HOST_FIELD_NUMBER: builtins.int
    DATABASE_FIELD_NUMBER: builtins.int
    USER_FIELD_NUMBER: builtins.int
    PASSWORD_FIELD_NUMBER: builtins.int
    PORT_FIELD_NUMBER: builtins.int
    JDBC_PARAMS_FIELD_NUMBER: builtins.int
    host: builtins.str
    database: builtins.str
    user: builtins.str
    password: builtins.str
    port: builtins.int
    jdbc_params: builtins.str
    def __init__(
        self,
        *,
        host: builtins.str = ...,
        database: builtins.str = ...,
        user: builtins.str = ...,
        password: builtins.str = ...,
        port: builtins.int = ...,
        jdbc_params: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["database", b"database", "host", b"host", "jdbc_params", b"jdbc_params", "password", b"password", "port", b"port", "user", b"user"]) -> None: ...

global___Postgres = Postgres

class S3(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AWS_SECRET_ACCESS_KEY_FIELD_NUMBER: builtins.int
    AWS_ACCESS_KEY_ID_FIELD_NUMBER: builtins.int
    aws_secret_access_key: builtins.str
    aws_access_key_id: builtins.str
    def __init__(
        self,
        *,
        aws_secret_access_key: builtins.str = ...,
        aws_access_key_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["aws_access_key_id", b"aws_access_key_id", "aws_secret_access_key", b"aws_secret_access_key"]) -> None: ...

global___S3 = S3

class Bigquery(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_FIELD_NUMBER: builtins.int
    CREDENTIALS_JSON_FIELD_NUMBER: builtins.int
    PROJECT_ID_FIELD_NUMBER: builtins.int
    dataset: builtins.str
    credentials_json: builtins.str
    project_id: builtins.str
    def __init__(
        self,
        *,
        dataset: builtins.str = ...,
        credentials_json: builtins.str = ...,
        project_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["credentials_json", b"credentials_json", "dataset", b"dataset", "project_id", b"project_id"]) -> None: ...

global___Bigquery = Bigquery

class Snowflake(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_FIELD_NUMBER: builtins.int
    USER_FIELD_NUMBER: builtins.int
    PASSWORD_FIELD_NUMBER: builtins.int
    SCHEMA_FIELD_NUMBER: builtins.int
    WAREHOUSE_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    JDBC_PARAMS_FIELD_NUMBER: builtins.int
    DATABASE_FIELD_NUMBER: builtins.int
    account: builtins.str
    user: builtins.str
    password: builtins.str
    schema: builtins.str
    warehouse: builtins.str
    role: builtins.str
    jdbc_params: builtins.str
    database: builtins.str
    def __init__(
        self,
        *,
        account: builtins.str = ...,
        user: builtins.str = ...,
        password: builtins.str = ...,
        schema: builtins.str = ...,
        warehouse: builtins.str = ...,
        role: builtins.str = ...,
        jdbc_params: builtins.str = ...,
        database: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["account", b"account", "database", b"database", "jdbc_params", b"jdbc_params", "password", b"password", "role", b"role", "schema", b"schema", "user", b"user", "warehouse", b"warehouse"]) -> None: ...

global___Snowflake = Snowflake

class Kafka(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BOOTSTRAP_SERVERS_FIELD_NUMBER: builtins.int
    SECURITY_PROTOCOL_FIELD_NUMBER: builtins.int
    SASL_MECHANISM_FIELD_NUMBER: builtins.int
    SASL_JAAS_CONFIG_FIELD_NUMBER: builtins.int
    SASL_PLAIN_USERNAME_FIELD_NUMBER: builtins.int
    SASL_PLAIN_PASSWORD_FIELD_NUMBER: builtins.int
    GROUP_ID_FIELD_NUMBER: builtins.int
    bootstrap_servers: builtins.str
    security_protocol: builtins.str
    sasl_mechanism: builtins.str
    sasl_jaas_config: builtins.str
    sasl_plain_username: builtins.str
    sasl_plain_password: builtins.str
    group_id: builtins.str
    def __init__(
        self,
        *,
        bootstrap_servers: builtins.str = ...,
        security_protocol: builtins.str = ...,
        sasl_mechanism: builtins.str = ...,
        sasl_jaas_config: builtins.str = ...,
        sasl_plain_username: builtins.str = ...,
        sasl_plain_password: builtins.str = ...,
        group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bootstrap_servers", b"bootstrap_servers", "group_id", b"group_id", "sasl_jaas_config", b"sasl_jaas_config", "sasl_mechanism", b"sasl_mechanism", "sasl_plain_password", b"sasl_plain_password", "sasl_plain_username", b"sasl_plain_username", "security_protocol", b"security_protocol"]) -> None: ...

global___Kafka = Kafka

class ExtTable(google.protobuf.message.Message):
    """-----------------------------------------
    Next, all the tables
    -----------------------------------------
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MYSQL_TABLE_FIELD_NUMBER: builtins.int
    PG_TABLE_FIELD_NUMBER: builtins.int
    S3_TABLE_FIELD_NUMBER: builtins.int
    KAFKA_TOPIC_FIELD_NUMBER: builtins.int
    SNOWFLAKE_TABLE_FIELD_NUMBER: builtins.int
    BIGQUERY_TABLE_FIELD_NUMBER: builtins.int
    @property
    def mysql_table(self) -> global___MySQLTable: ...
    @property
    def pg_table(self) -> global___PostgresTable: ...
    @property
    def s3_table(self) -> global___S3Table: ...
    @property
    def kafka_topic(self) -> global___KafkaTopic: ...
    @property
    def snowflake_table(self) -> global___SnowflakeTable: ...
    @property
    def bigquery_table(self) -> global___BigqueryTable: ...
    def __init__(
        self,
        *,
        mysql_table: global___MySQLTable | None = ...,
        pg_table: global___PostgresTable | None = ...,
        s3_table: global___S3Table | None = ...,
        kafka_topic: global___KafkaTopic | None = ...,
        snowflake_table: global___SnowflakeTable | None = ...,
        bigquery_table: global___BigqueryTable | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["bigquery_table", b"bigquery_table", "kafka_topic", b"kafka_topic", "mysql_table", b"mysql_table", "pg_table", b"pg_table", "s3_table", b"s3_table", "snowflake_table", b"snowflake_table", "variant", b"variant"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["bigquery_table", b"bigquery_table", "kafka_topic", b"kafka_topic", "mysql_table", b"mysql_table", "pg_table", b"pg_table", "s3_table", b"s3_table", "snowflake_table", b"snowflake_table", "variant", b"variant"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["variant", b"variant"]) -> typing_extensions.Literal["mysql_table", "pg_table", "s3_table", "kafka_topic", "snowflake_table", "bigquery_table"] | None: ...

global___ExtTable = ExtTable

class MySQLTable(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DB_FIELD_NUMBER: builtins.int
    TABLE_NAME_FIELD_NUMBER: builtins.int
    @property
    def db(self) -> global___ExtDatabase: ...
    table_name: builtins.str
    def __init__(
        self,
        *,
        db: global___ExtDatabase | None = ...,
        table_name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["db", b"db"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["db", b"db", "table_name", b"table_name"]) -> None: ...

global___MySQLTable = MySQLTable

class PostgresTable(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DB_FIELD_NUMBER: builtins.int
    TABLE_NAME_FIELD_NUMBER: builtins.int
    @property
    def db(self) -> global___ExtDatabase: ...
    table_name: builtins.str
    def __init__(
        self,
        *,
        db: global___ExtDatabase | None = ...,
        table_name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["db", b"db"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["db", b"db", "table_name", b"table_name"]) -> None: ...

global___PostgresTable = PostgresTable

class S3Table(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUCKET_FIELD_NUMBER: builtins.int
    PATH_PREFIX_FIELD_NUMBER: builtins.int
    DELIMITER_FIELD_NUMBER: builtins.int
    FORMAT_FIELD_NUMBER: builtins.int
    DB_FIELD_NUMBER: builtins.int
    bucket: builtins.str
    path_prefix: builtins.str
    delimiter: builtins.str
    format: builtins.str
    @property
    def db(self) -> global___ExtDatabase: ...
    def __init__(
        self,
        *,
        bucket: builtins.str = ...,
        path_prefix: builtins.str = ...,
        delimiter: builtins.str = ...,
        format: builtins.str = ...,
        db: global___ExtDatabase | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["db", b"db"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["bucket", b"bucket", "db", b"db", "delimiter", b"delimiter", "format", b"format", "path_prefix", b"path_prefix"]) -> None: ...

global___S3Table = S3Table

class KafkaTopic(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DB_FIELD_NUMBER: builtins.int
    TOPIC_FIELD_NUMBER: builtins.int
    @property
    def db(self) -> global___ExtDatabase: ...
    topic: builtins.str
    def __init__(
        self,
        *,
        db: global___ExtDatabase | None = ...,
        topic: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["db", b"db"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["db", b"db", "topic", b"topic"]) -> None: ...

global___KafkaTopic = KafkaTopic

class BigqueryTable(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DB_FIELD_NUMBER: builtins.int
    TABLE_NAME_FIELD_NUMBER: builtins.int
    @property
    def db(self) -> global___ExtDatabase: ...
    table_name: builtins.str
    def __init__(
        self,
        *,
        db: global___ExtDatabase | None = ...,
        table_name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["db", b"db"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["db", b"db", "table_name", b"table_name"]) -> None: ...

global___BigqueryTable = BigqueryTable

class SnowflakeTable(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DB_FIELD_NUMBER: builtins.int
    TABLE_NAME_FIELD_NUMBER: builtins.int
    @property
    def db(self) -> global___ExtDatabase: ...
    table_name: builtins.str
    def __init__(
        self,
        *,
        db: global___ExtDatabase | None = ...,
        table_name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["db", b"db"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["db", b"db", "table_name", b"table_name"]) -> None: ...

global___SnowflakeTable = SnowflakeTable

class Source(google.protobuf.message.Message):
    """-----------------------------------------
    Finally, all the sources and sinks
    -----------------------------------------
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TABLE_FIELD_NUMBER: builtins.int
    DATASET_FIELD_NUMBER: builtins.int
    EVERY_FIELD_NUMBER: builtins.int
    CURSOR_FIELD_NUMBER: builtins.int
    LATENESS_FIELD_NUMBER: builtins.int
    @property
    def table(self) -> global___ExtTable: ...
    dataset: builtins.str
    @property
    def every(self) -> google.protobuf.duration_pb2.Duration: ...
    cursor: builtins.str
    @property
    def lateness(self) -> google.protobuf.duration_pb2.Duration: ...
    def __init__(
        self,
        *,
        table: global___ExtTable | None = ...,
        dataset: builtins.str = ...,
        every: google.protobuf.duration_pb2.Duration | None = ...,
        cursor: builtins.str | None = ...,
        lateness: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_cursor", b"_cursor", "cursor", b"cursor", "every", b"every", "lateness", b"lateness", "table", b"table"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_cursor", b"_cursor", "cursor", b"cursor", "dataset", b"dataset", "every", b"every", "lateness", b"lateness", "table", b"table"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_cursor", b"_cursor"]) -> typing_extensions.Literal["cursor"] | None: ...

global___Source = Source

class Sink(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TABLE_FIELD_NUMBER: builtins.int
    DATASET_FIELD_NUMBER: builtins.int
    @property
    def table(self) -> global___ExtTable: ...
    dataset: builtins.str
    def __init__(
        self,
        *,
        table: global___ExtTable | None = ...,
        dataset: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["table", b"table"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["dataset", b"dataset", "table", b"table"]) -> None: ...

global___Sink = Sink
