from sentence_transformers import SentenceTransformer
from config import CONFIG


class Embedding:
    def __init__(self):
        self.model = SentenceTransformer(CONFIG['embeddings']['model'])
        
    
    def encode(self, chunks):
        embeddings = self.model.encode(chunks, normalize_embeddings=True)
        return embeddings.tolist()
    