---
---

# Prompt Loss

Evaluate the prompt and its results. Provide feedback on the following aspects:

- Clarity: The prompt should be unambiguous and clearly state the desired
  outcome.
- Specificity: It should include necessary details without being overly verbose.
- Relevance: All information in the prompt should be pertinent to the task.
- Consistency: The prompt should not contain contradictory instructions.
- Actionability: It should guide the AI towards producing a concrete, useful
  output.
- Output quality: Assess if the results effectively address the prompt's
  requirements.
- Output consistency: Check if multiple runs produce similarly appropriate
  results.
- Efficiency: Evaluate if the prompt achieves the desired outcome with minimal
  complexity.

## Handling of cases where the answer is not in the text

When evaluating a prompt, consider how it handles situations where the required
information isn't directly available. A good prompt should:

- Encourage the AI to state clearly when it doesn't have the information.
- Guide the AI to provide related information or suggest where to find the
  answer.
- Avoid making up false information to fill gaps.
- Potentially ask for clarification or additional context if needed.

## Suggestions for improvement

When evaluating a prompt, the assessor should not only identify issues but also
provide constructive feedback. Suggestions for improvement might include:

- Rewording for clarity if the prompt is ambiguous.
- Adding or removing details to achieve the right level of specificity.
- Restructuring the prompt to better guide the AI's response.
- Incorporating constraints or guidelines to improve output quality.
- Suggesting ways to make the prompt more robust across different scenarios.

When evaluating, compare the prompt against these criteria and analyze how well
the results match the intended goal. Look for areas of improvement in both the
prompt's structure and content based on the quality of the outputs.

Be specific and constructive in your feedback for revising the prompt.
Do not revise the prompt, just provide feedback.
Do not provude examples, just provide feedback.
