/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementDiagnosticConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#always_log_errors ApiManagementDiagnostic#always_log_errors}
    */
    readonly alwaysLogErrors?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#api_management_logger_id ApiManagementDiagnostic#api_management_logger_id}
    */
    readonly apiManagementLoggerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#api_management_name ApiManagementDiagnostic#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#http_correlation_protocol ApiManagementDiagnostic#http_correlation_protocol}
    */
    readonly httpCorrelationProtocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#id ApiManagementDiagnostic#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#identifier ApiManagementDiagnostic#identifier}
    */
    readonly identifier: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#log_client_ip ApiManagementDiagnostic#log_client_ip}
    */
    readonly logClientIp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#operation_name_format ApiManagementDiagnostic#operation_name_format}
    */
    readonly operationNameFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#resource_group_name ApiManagementDiagnostic#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#sampling_percentage ApiManagementDiagnostic#sampling_percentage}
    */
    readonly samplingPercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#verbosity ApiManagementDiagnostic#verbosity}
    */
    readonly verbosity?: string;
    /**
    * backend_request block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#backend_request ApiManagementDiagnostic#backend_request}
    */
    readonly backendRequest?: ApiManagementDiagnosticBackendRequest;
    /**
    * backend_response block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#backend_response ApiManagementDiagnostic#backend_response}
    */
    readonly backendResponse?: ApiManagementDiagnosticBackendResponse;
    /**
    * frontend_request block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#frontend_request ApiManagementDiagnostic#frontend_request}
    */
    readonly frontendRequest?: ApiManagementDiagnosticFrontendRequest;
    /**
    * frontend_response block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#frontend_response ApiManagementDiagnostic#frontend_response}
    */
    readonly frontendResponse?: ApiManagementDiagnosticFrontendResponse;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#timeouts ApiManagementDiagnostic#timeouts}
    */
    readonly timeouts?: ApiManagementDiagnosticTimeouts;
}
export interface ApiManagementDiagnosticBackendRequestDataMaskingHeaders {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#mode ApiManagementDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#value ApiManagementDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementDiagnosticBackendRequestDataMaskingHeadersToTerraform(struct?: ApiManagementDiagnosticBackendRequestDataMaskingHeaders | cdktf.IResolvable): any;
export declare function apiManagementDiagnosticBackendRequestDataMaskingHeadersToHclTerraform(struct?: ApiManagementDiagnosticBackendRequestDataMaskingHeaders | cdktf.IResolvable): any;
export declare class ApiManagementDiagnosticBackendRequestDataMaskingHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementDiagnosticBackendRequestDataMaskingHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementDiagnosticBackendRequestDataMaskingHeaders | cdktf.IResolvable | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ApiManagementDiagnosticBackendRequestDataMaskingHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementDiagnosticBackendRequestDataMaskingHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementDiagnosticBackendRequestDataMaskingHeadersOutputReference;
}
export interface ApiManagementDiagnosticBackendRequestDataMaskingQueryParams {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#mode ApiManagementDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#value ApiManagementDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementDiagnosticBackendRequestDataMaskingQueryParamsToTerraform(struct?: ApiManagementDiagnosticBackendRequestDataMaskingQueryParams | cdktf.IResolvable): any;
export declare function apiManagementDiagnosticBackendRequestDataMaskingQueryParamsToHclTerraform(struct?: ApiManagementDiagnosticBackendRequestDataMaskingQueryParams | cdktf.IResolvable): any;
export declare class ApiManagementDiagnosticBackendRequestDataMaskingQueryParamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementDiagnosticBackendRequestDataMaskingQueryParams | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementDiagnosticBackendRequestDataMaskingQueryParams | cdktf.IResolvable | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ApiManagementDiagnosticBackendRequestDataMaskingQueryParamsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementDiagnosticBackendRequestDataMaskingQueryParams[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementDiagnosticBackendRequestDataMaskingQueryParamsOutputReference;
}
export interface ApiManagementDiagnosticBackendRequestDataMasking {
    /**
    * headers block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#headers ApiManagementDiagnostic#headers}
    */
    readonly headers?: ApiManagementDiagnosticBackendRequestDataMaskingHeaders[] | cdktf.IResolvable;
    /**
    * query_params block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#query_params ApiManagementDiagnostic#query_params}
    */
    readonly queryParams?: ApiManagementDiagnosticBackendRequestDataMaskingQueryParams[] | cdktf.IResolvable;
}
export declare function apiManagementDiagnosticBackendRequestDataMaskingToTerraform(struct?: ApiManagementDiagnosticBackendRequestDataMaskingOutputReference | ApiManagementDiagnosticBackendRequestDataMasking): any;
export declare function apiManagementDiagnosticBackendRequestDataMaskingToHclTerraform(struct?: ApiManagementDiagnosticBackendRequestDataMaskingOutputReference | ApiManagementDiagnosticBackendRequestDataMasking): any;
export declare class ApiManagementDiagnosticBackendRequestDataMaskingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementDiagnosticBackendRequestDataMasking | undefined;
    set internalValue(value: ApiManagementDiagnosticBackendRequestDataMasking | undefined);
    private _headers;
    get headers(): ApiManagementDiagnosticBackendRequestDataMaskingHeadersList;
    putHeaders(value: ApiManagementDiagnosticBackendRequestDataMaskingHeaders[] | cdktf.IResolvable): void;
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | ApiManagementDiagnosticBackendRequestDataMaskingHeaders[] | undefined;
    private _queryParams;
    get queryParams(): ApiManagementDiagnosticBackendRequestDataMaskingQueryParamsList;
    putQueryParams(value: ApiManagementDiagnosticBackendRequestDataMaskingQueryParams[] | cdktf.IResolvable): void;
    resetQueryParams(): void;
    get queryParamsInput(): cdktf.IResolvable | ApiManagementDiagnosticBackendRequestDataMaskingQueryParams[] | undefined;
}
export interface ApiManagementDiagnosticBackendRequest {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#body_bytes ApiManagementDiagnostic#body_bytes}
    */
    readonly bodyBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#headers_to_log ApiManagementDiagnostic#headers_to_log}
    */
    readonly headersToLog?: string[];
    /**
    * data_masking block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#data_masking ApiManagementDiagnostic#data_masking}
    */
    readonly dataMasking?: ApiManagementDiagnosticBackendRequestDataMasking;
}
export declare function apiManagementDiagnosticBackendRequestToTerraform(struct?: ApiManagementDiagnosticBackendRequestOutputReference | ApiManagementDiagnosticBackendRequest): any;
export declare function apiManagementDiagnosticBackendRequestToHclTerraform(struct?: ApiManagementDiagnosticBackendRequestOutputReference | ApiManagementDiagnosticBackendRequest): any;
export declare class ApiManagementDiagnosticBackendRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementDiagnosticBackendRequest | undefined;
    set internalValue(value: ApiManagementDiagnosticBackendRequest | undefined);
    private _bodyBytes?;
    get bodyBytes(): number;
    set bodyBytes(value: number);
    resetBodyBytes(): void;
    get bodyBytesInput(): number | undefined;
    private _headersToLog?;
    get headersToLog(): string[];
    set headersToLog(value: string[]);
    resetHeadersToLog(): void;
    get headersToLogInput(): string[] | undefined;
    private _dataMasking;
    get dataMasking(): ApiManagementDiagnosticBackendRequestDataMaskingOutputReference;
    putDataMasking(value: ApiManagementDiagnosticBackendRequestDataMasking): void;
    resetDataMasking(): void;
    get dataMaskingInput(): ApiManagementDiagnosticBackendRequestDataMasking | undefined;
}
export interface ApiManagementDiagnosticBackendResponseDataMaskingHeaders {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#mode ApiManagementDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#value ApiManagementDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementDiagnosticBackendResponseDataMaskingHeadersToTerraform(struct?: ApiManagementDiagnosticBackendResponseDataMaskingHeaders | cdktf.IResolvable): any;
export declare function apiManagementDiagnosticBackendResponseDataMaskingHeadersToHclTerraform(struct?: ApiManagementDiagnosticBackendResponseDataMaskingHeaders | cdktf.IResolvable): any;
export declare class ApiManagementDiagnosticBackendResponseDataMaskingHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementDiagnosticBackendResponseDataMaskingHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementDiagnosticBackendResponseDataMaskingHeaders | cdktf.IResolvable | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ApiManagementDiagnosticBackendResponseDataMaskingHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementDiagnosticBackendResponseDataMaskingHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementDiagnosticBackendResponseDataMaskingHeadersOutputReference;
}
export interface ApiManagementDiagnosticBackendResponseDataMaskingQueryParams {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#mode ApiManagementDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#value ApiManagementDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementDiagnosticBackendResponseDataMaskingQueryParamsToTerraform(struct?: ApiManagementDiagnosticBackendResponseDataMaskingQueryParams | cdktf.IResolvable): any;
export declare function apiManagementDiagnosticBackendResponseDataMaskingQueryParamsToHclTerraform(struct?: ApiManagementDiagnosticBackendResponseDataMaskingQueryParams | cdktf.IResolvable): any;
export declare class ApiManagementDiagnosticBackendResponseDataMaskingQueryParamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementDiagnosticBackendResponseDataMaskingQueryParams | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementDiagnosticBackendResponseDataMaskingQueryParams | cdktf.IResolvable | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ApiManagementDiagnosticBackendResponseDataMaskingQueryParamsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementDiagnosticBackendResponseDataMaskingQueryParams[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementDiagnosticBackendResponseDataMaskingQueryParamsOutputReference;
}
export interface ApiManagementDiagnosticBackendResponseDataMasking {
    /**
    * headers block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#headers ApiManagementDiagnostic#headers}
    */
    readonly headers?: ApiManagementDiagnosticBackendResponseDataMaskingHeaders[] | cdktf.IResolvable;
    /**
    * query_params block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#query_params ApiManagementDiagnostic#query_params}
    */
    readonly queryParams?: ApiManagementDiagnosticBackendResponseDataMaskingQueryParams[] | cdktf.IResolvable;
}
export declare function apiManagementDiagnosticBackendResponseDataMaskingToTerraform(struct?: ApiManagementDiagnosticBackendResponseDataMaskingOutputReference | ApiManagementDiagnosticBackendResponseDataMasking): any;
export declare function apiManagementDiagnosticBackendResponseDataMaskingToHclTerraform(struct?: ApiManagementDiagnosticBackendResponseDataMaskingOutputReference | ApiManagementDiagnosticBackendResponseDataMasking): any;
export declare class ApiManagementDiagnosticBackendResponseDataMaskingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementDiagnosticBackendResponseDataMasking | undefined;
    set internalValue(value: ApiManagementDiagnosticBackendResponseDataMasking | undefined);
    private _headers;
    get headers(): ApiManagementDiagnosticBackendResponseDataMaskingHeadersList;
    putHeaders(value: ApiManagementDiagnosticBackendResponseDataMaskingHeaders[] | cdktf.IResolvable): void;
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | ApiManagementDiagnosticBackendResponseDataMaskingHeaders[] | undefined;
    private _queryParams;
    get queryParams(): ApiManagementDiagnosticBackendResponseDataMaskingQueryParamsList;
    putQueryParams(value: ApiManagementDiagnosticBackendResponseDataMaskingQueryParams[] | cdktf.IResolvable): void;
    resetQueryParams(): void;
    get queryParamsInput(): cdktf.IResolvable | ApiManagementDiagnosticBackendResponseDataMaskingQueryParams[] | undefined;
}
export interface ApiManagementDiagnosticBackendResponse {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#body_bytes ApiManagementDiagnostic#body_bytes}
    */
    readonly bodyBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#headers_to_log ApiManagementDiagnostic#headers_to_log}
    */
    readonly headersToLog?: string[];
    /**
    * data_masking block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#data_masking ApiManagementDiagnostic#data_masking}
    */
    readonly dataMasking?: ApiManagementDiagnosticBackendResponseDataMasking;
}
export declare function apiManagementDiagnosticBackendResponseToTerraform(struct?: ApiManagementDiagnosticBackendResponseOutputReference | ApiManagementDiagnosticBackendResponse): any;
export declare function apiManagementDiagnosticBackendResponseToHclTerraform(struct?: ApiManagementDiagnosticBackendResponseOutputReference | ApiManagementDiagnosticBackendResponse): any;
export declare class ApiManagementDiagnosticBackendResponseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementDiagnosticBackendResponse | undefined;
    set internalValue(value: ApiManagementDiagnosticBackendResponse | undefined);
    private _bodyBytes?;
    get bodyBytes(): number;
    set bodyBytes(value: number);
    resetBodyBytes(): void;
    get bodyBytesInput(): number | undefined;
    private _headersToLog?;
    get headersToLog(): string[];
    set headersToLog(value: string[]);
    resetHeadersToLog(): void;
    get headersToLogInput(): string[] | undefined;
    private _dataMasking;
    get dataMasking(): ApiManagementDiagnosticBackendResponseDataMaskingOutputReference;
    putDataMasking(value: ApiManagementDiagnosticBackendResponseDataMasking): void;
    resetDataMasking(): void;
    get dataMaskingInput(): ApiManagementDiagnosticBackendResponseDataMasking | undefined;
}
export interface ApiManagementDiagnosticFrontendRequestDataMaskingHeaders {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#mode ApiManagementDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#value ApiManagementDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementDiagnosticFrontendRequestDataMaskingHeadersToTerraform(struct?: ApiManagementDiagnosticFrontendRequestDataMaskingHeaders | cdktf.IResolvable): any;
export declare function apiManagementDiagnosticFrontendRequestDataMaskingHeadersToHclTerraform(struct?: ApiManagementDiagnosticFrontendRequestDataMaskingHeaders | cdktf.IResolvable): any;
export declare class ApiManagementDiagnosticFrontendRequestDataMaskingHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementDiagnosticFrontendRequestDataMaskingHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementDiagnosticFrontendRequestDataMaskingHeaders | cdktf.IResolvable | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ApiManagementDiagnosticFrontendRequestDataMaskingHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementDiagnosticFrontendRequestDataMaskingHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementDiagnosticFrontendRequestDataMaskingHeadersOutputReference;
}
export interface ApiManagementDiagnosticFrontendRequestDataMaskingQueryParams {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#mode ApiManagementDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#value ApiManagementDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementDiagnosticFrontendRequestDataMaskingQueryParamsToTerraform(struct?: ApiManagementDiagnosticFrontendRequestDataMaskingQueryParams | cdktf.IResolvable): any;
export declare function apiManagementDiagnosticFrontendRequestDataMaskingQueryParamsToHclTerraform(struct?: ApiManagementDiagnosticFrontendRequestDataMaskingQueryParams | cdktf.IResolvable): any;
export declare class ApiManagementDiagnosticFrontendRequestDataMaskingQueryParamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementDiagnosticFrontendRequestDataMaskingQueryParams | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementDiagnosticFrontendRequestDataMaskingQueryParams | cdktf.IResolvable | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ApiManagementDiagnosticFrontendRequestDataMaskingQueryParamsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementDiagnosticFrontendRequestDataMaskingQueryParams[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementDiagnosticFrontendRequestDataMaskingQueryParamsOutputReference;
}
export interface ApiManagementDiagnosticFrontendRequestDataMasking {
    /**
    * headers block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#headers ApiManagementDiagnostic#headers}
    */
    readonly headers?: ApiManagementDiagnosticFrontendRequestDataMaskingHeaders[] | cdktf.IResolvable;
    /**
    * query_params block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#query_params ApiManagementDiagnostic#query_params}
    */
    readonly queryParams?: ApiManagementDiagnosticFrontendRequestDataMaskingQueryParams[] | cdktf.IResolvable;
}
export declare function apiManagementDiagnosticFrontendRequestDataMaskingToTerraform(struct?: ApiManagementDiagnosticFrontendRequestDataMaskingOutputReference | ApiManagementDiagnosticFrontendRequestDataMasking): any;
export declare function apiManagementDiagnosticFrontendRequestDataMaskingToHclTerraform(struct?: ApiManagementDiagnosticFrontendRequestDataMaskingOutputReference | ApiManagementDiagnosticFrontendRequestDataMasking): any;
export declare class ApiManagementDiagnosticFrontendRequestDataMaskingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementDiagnosticFrontendRequestDataMasking | undefined;
    set internalValue(value: ApiManagementDiagnosticFrontendRequestDataMasking | undefined);
    private _headers;
    get headers(): ApiManagementDiagnosticFrontendRequestDataMaskingHeadersList;
    putHeaders(value: ApiManagementDiagnosticFrontendRequestDataMaskingHeaders[] | cdktf.IResolvable): void;
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | ApiManagementDiagnosticFrontendRequestDataMaskingHeaders[] | undefined;
    private _queryParams;
    get queryParams(): ApiManagementDiagnosticFrontendRequestDataMaskingQueryParamsList;
    putQueryParams(value: ApiManagementDiagnosticFrontendRequestDataMaskingQueryParams[] | cdktf.IResolvable): void;
    resetQueryParams(): void;
    get queryParamsInput(): cdktf.IResolvable | ApiManagementDiagnosticFrontendRequestDataMaskingQueryParams[] | undefined;
}
export interface ApiManagementDiagnosticFrontendRequest {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#body_bytes ApiManagementDiagnostic#body_bytes}
    */
    readonly bodyBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#headers_to_log ApiManagementDiagnostic#headers_to_log}
    */
    readonly headersToLog?: string[];
    /**
    * data_masking block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#data_masking ApiManagementDiagnostic#data_masking}
    */
    readonly dataMasking?: ApiManagementDiagnosticFrontendRequestDataMasking;
}
export declare function apiManagementDiagnosticFrontendRequestToTerraform(struct?: ApiManagementDiagnosticFrontendRequestOutputReference | ApiManagementDiagnosticFrontendRequest): any;
export declare function apiManagementDiagnosticFrontendRequestToHclTerraform(struct?: ApiManagementDiagnosticFrontendRequestOutputReference | ApiManagementDiagnosticFrontendRequest): any;
export declare class ApiManagementDiagnosticFrontendRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementDiagnosticFrontendRequest | undefined;
    set internalValue(value: ApiManagementDiagnosticFrontendRequest | undefined);
    private _bodyBytes?;
    get bodyBytes(): number;
    set bodyBytes(value: number);
    resetBodyBytes(): void;
    get bodyBytesInput(): number | undefined;
    private _headersToLog?;
    get headersToLog(): string[];
    set headersToLog(value: string[]);
    resetHeadersToLog(): void;
    get headersToLogInput(): string[] | undefined;
    private _dataMasking;
    get dataMasking(): ApiManagementDiagnosticFrontendRequestDataMaskingOutputReference;
    putDataMasking(value: ApiManagementDiagnosticFrontendRequestDataMasking): void;
    resetDataMasking(): void;
    get dataMaskingInput(): ApiManagementDiagnosticFrontendRequestDataMasking | undefined;
}
export interface ApiManagementDiagnosticFrontendResponseDataMaskingHeaders {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#mode ApiManagementDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#value ApiManagementDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementDiagnosticFrontendResponseDataMaskingHeadersToTerraform(struct?: ApiManagementDiagnosticFrontendResponseDataMaskingHeaders | cdktf.IResolvable): any;
export declare function apiManagementDiagnosticFrontendResponseDataMaskingHeadersToHclTerraform(struct?: ApiManagementDiagnosticFrontendResponseDataMaskingHeaders | cdktf.IResolvable): any;
export declare class ApiManagementDiagnosticFrontendResponseDataMaskingHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementDiagnosticFrontendResponseDataMaskingHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementDiagnosticFrontendResponseDataMaskingHeaders | cdktf.IResolvable | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ApiManagementDiagnosticFrontendResponseDataMaskingHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementDiagnosticFrontendResponseDataMaskingHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementDiagnosticFrontendResponseDataMaskingHeadersOutputReference;
}
export interface ApiManagementDiagnosticFrontendResponseDataMaskingQueryParams {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#mode ApiManagementDiagnostic#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#value ApiManagementDiagnostic#value}
    */
    readonly value: string;
}
export declare function apiManagementDiagnosticFrontendResponseDataMaskingQueryParamsToTerraform(struct?: ApiManagementDiagnosticFrontendResponseDataMaskingQueryParams | cdktf.IResolvable): any;
export declare function apiManagementDiagnosticFrontendResponseDataMaskingQueryParamsToHclTerraform(struct?: ApiManagementDiagnosticFrontendResponseDataMaskingQueryParams | cdktf.IResolvable): any;
export declare class ApiManagementDiagnosticFrontendResponseDataMaskingQueryParamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementDiagnosticFrontendResponseDataMaskingQueryParams | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementDiagnosticFrontendResponseDataMaskingQueryParams | cdktf.IResolvable | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ApiManagementDiagnosticFrontendResponseDataMaskingQueryParamsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementDiagnosticFrontendResponseDataMaskingQueryParams[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementDiagnosticFrontendResponseDataMaskingQueryParamsOutputReference;
}
export interface ApiManagementDiagnosticFrontendResponseDataMasking {
    /**
    * headers block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#headers ApiManagementDiagnostic#headers}
    */
    readonly headers?: ApiManagementDiagnosticFrontendResponseDataMaskingHeaders[] | cdktf.IResolvable;
    /**
    * query_params block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#query_params ApiManagementDiagnostic#query_params}
    */
    readonly queryParams?: ApiManagementDiagnosticFrontendResponseDataMaskingQueryParams[] | cdktf.IResolvable;
}
export declare function apiManagementDiagnosticFrontendResponseDataMaskingToTerraform(struct?: ApiManagementDiagnosticFrontendResponseDataMaskingOutputReference | ApiManagementDiagnosticFrontendResponseDataMasking): any;
export declare function apiManagementDiagnosticFrontendResponseDataMaskingToHclTerraform(struct?: ApiManagementDiagnosticFrontendResponseDataMaskingOutputReference | ApiManagementDiagnosticFrontendResponseDataMasking): any;
export declare class ApiManagementDiagnosticFrontendResponseDataMaskingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementDiagnosticFrontendResponseDataMasking | undefined;
    set internalValue(value: ApiManagementDiagnosticFrontendResponseDataMasking | undefined);
    private _headers;
    get headers(): ApiManagementDiagnosticFrontendResponseDataMaskingHeadersList;
    putHeaders(value: ApiManagementDiagnosticFrontendResponseDataMaskingHeaders[] | cdktf.IResolvable): void;
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | ApiManagementDiagnosticFrontendResponseDataMaskingHeaders[] | undefined;
    private _queryParams;
    get queryParams(): ApiManagementDiagnosticFrontendResponseDataMaskingQueryParamsList;
    putQueryParams(value: ApiManagementDiagnosticFrontendResponseDataMaskingQueryParams[] | cdktf.IResolvable): void;
    resetQueryParams(): void;
    get queryParamsInput(): cdktf.IResolvable | ApiManagementDiagnosticFrontendResponseDataMaskingQueryParams[] | undefined;
}
export interface ApiManagementDiagnosticFrontendResponse {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#body_bytes ApiManagementDiagnostic#body_bytes}
    */
    readonly bodyBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#headers_to_log ApiManagementDiagnostic#headers_to_log}
    */
    readonly headersToLog?: string[];
    /**
    * data_masking block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#data_masking ApiManagementDiagnostic#data_masking}
    */
    readonly dataMasking?: ApiManagementDiagnosticFrontendResponseDataMasking;
}
export declare function apiManagementDiagnosticFrontendResponseToTerraform(struct?: ApiManagementDiagnosticFrontendResponseOutputReference | ApiManagementDiagnosticFrontendResponse): any;
export declare function apiManagementDiagnosticFrontendResponseToHclTerraform(struct?: ApiManagementDiagnosticFrontendResponseOutputReference | ApiManagementDiagnosticFrontendResponse): any;
export declare class ApiManagementDiagnosticFrontendResponseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementDiagnosticFrontendResponse | undefined;
    set internalValue(value: ApiManagementDiagnosticFrontendResponse | undefined);
    private _bodyBytes?;
    get bodyBytes(): number;
    set bodyBytes(value: number);
    resetBodyBytes(): void;
    get bodyBytesInput(): number | undefined;
    private _headersToLog?;
    get headersToLog(): string[];
    set headersToLog(value: string[]);
    resetHeadersToLog(): void;
    get headersToLogInput(): string[] | undefined;
    private _dataMasking;
    get dataMasking(): ApiManagementDiagnosticFrontendResponseDataMaskingOutputReference;
    putDataMasking(value: ApiManagementDiagnosticFrontendResponseDataMasking): void;
    resetDataMasking(): void;
    get dataMaskingInput(): ApiManagementDiagnosticFrontendResponseDataMasking | undefined;
}
export interface ApiManagementDiagnosticTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#create ApiManagementDiagnostic#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#delete ApiManagementDiagnostic#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#read ApiManagementDiagnostic#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#update ApiManagementDiagnostic#update}
    */
    readonly update?: string;
}
export declare function apiManagementDiagnosticTimeoutsToTerraform(struct?: ApiManagementDiagnosticTimeouts | cdktf.IResolvable): any;
export declare function apiManagementDiagnosticTimeoutsToHclTerraform(struct?: ApiManagementDiagnosticTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementDiagnosticTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementDiagnosticTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementDiagnosticTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic azurerm_api_management_diagnostic}
*/
export declare class ApiManagementDiagnostic extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_diagnostic";
    /**
    * Generates CDKTF code for importing a ApiManagementDiagnostic resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ApiManagementDiagnostic to import
    * @param importFromId The id of the existing ApiManagementDiagnostic that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ApiManagementDiagnostic to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/api_management_diagnostic azurerm_api_management_diagnostic} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementDiagnosticConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementDiagnosticConfig);
    private _alwaysLogErrors?;
    get alwaysLogErrors(): boolean | cdktf.IResolvable;
    set alwaysLogErrors(value: boolean | cdktf.IResolvable);
    resetAlwaysLogErrors(): void;
    get alwaysLogErrorsInput(): boolean | cdktf.IResolvable | undefined;
    private _apiManagementLoggerId?;
    get apiManagementLoggerId(): string;
    set apiManagementLoggerId(value: string);
    get apiManagementLoggerIdInput(): string | undefined;
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    private _httpCorrelationProtocol?;
    get httpCorrelationProtocol(): string;
    set httpCorrelationProtocol(value: string);
    resetHttpCorrelationProtocol(): void;
    get httpCorrelationProtocolInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identifier?;
    get identifier(): string;
    set identifier(value: string);
    get identifierInput(): string | undefined;
    private _logClientIp?;
    get logClientIp(): boolean | cdktf.IResolvable;
    set logClientIp(value: boolean | cdktf.IResolvable);
    resetLogClientIp(): void;
    get logClientIpInput(): boolean | cdktf.IResolvable | undefined;
    private _operationNameFormat?;
    get operationNameFormat(): string;
    set operationNameFormat(value: string);
    resetOperationNameFormat(): void;
    get operationNameFormatInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _samplingPercentage?;
    get samplingPercentage(): number;
    set samplingPercentage(value: number);
    resetSamplingPercentage(): void;
    get samplingPercentageInput(): number | undefined;
    private _verbosity?;
    get verbosity(): string;
    set verbosity(value: string);
    resetVerbosity(): void;
    get verbosityInput(): string | undefined;
    private _backendRequest;
    get backendRequest(): ApiManagementDiagnosticBackendRequestOutputReference;
    putBackendRequest(value: ApiManagementDiagnosticBackendRequest): void;
    resetBackendRequest(): void;
    get backendRequestInput(): ApiManagementDiagnosticBackendRequest | undefined;
    private _backendResponse;
    get backendResponse(): ApiManagementDiagnosticBackendResponseOutputReference;
    putBackendResponse(value: ApiManagementDiagnosticBackendResponse): void;
    resetBackendResponse(): void;
    get backendResponseInput(): ApiManagementDiagnosticBackendResponse | undefined;
    private _frontendRequest;
    get frontendRequest(): ApiManagementDiagnosticFrontendRequestOutputReference;
    putFrontendRequest(value: ApiManagementDiagnosticFrontendRequest): void;
    resetFrontendRequest(): void;
    get frontendRequestInput(): ApiManagementDiagnosticFrontendRequest | undefined;
    private _frontendResponse;
    get frontendResponse(): ApiManagementDiagnosticFrontendResponseOutputReference;
    putFrontendResponse(value: ApiManagementDiagnosticFrontendResponse): void;
    resetFrontendResponse(): void;
    get frontendResponseInput(): ApiManagementDiagnosticFrontendResponse | undefined;
    private _timeouts;
    get timeouts(): ApiManagementDiagnosticTimeoutsOutputReference;
    putTimeouts(value: ApiManagementDiagnosticTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApiManagementDiagnosticTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
