/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppServiceEnvironmentV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/app_service_environment_v3#allow_new_private_endpoint_connections AppServiceEnvironmentV3#allow_new_private_endpoint_connections}
    */
    readonly allowNewPrivateEndpointConnections?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/app_service_environment_v3#dedicated_host_count AppServiceEnvironmentV3#dedicated_host_count}
    */
    readonly dedicatedHostCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/app_service_environment_v3#id AppServiceEnvironmentV3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/app_service_environment_v3#internal_load_balancing_mode AppServiceEnvironmentV3#internal_load_balancing_mode}
    */
    readonly internalLoadBalancingMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/app_service_environment_v3#name AppServiceEnvironmentV3#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/app_service_environment_v3#remote_debugging_enabled AppServiceEnvironmentV3#remote_debugging_enabled}
    */
    readonly remoteDebuggingEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/app_service_environment_v3#resource_group_name AppServiceEnvironmentV3#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/app_service_environment_v3#subnet_id AppServiceEnvironmentV3#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/app_service_environment_v3#tags AppServiceEnvironmentV3#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/app_service_environment_v3#zone_redundant AppServiceEnvironmentV3#zone_redundant}
    */
    readonly zoneRedundant?: boolean | cdktf.IResolvable;
    /**
    * cluster_setting block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/app_service_environment_v3#cluster_setting AppServiceEnvironmentV3#cluster_setting}
    */
    readonly clusterSetting?: AppServiceEnvironmentV3ClusterSetting[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/app_service_environment_v3#timeouts AppServiceEnvironmentV3#timeouts}
    */
    readonly timeouts?: AppServiceEnvironmentV3Timeouts;
}
export interface AppServiceEnvironmentV3InboundNetworkDependencies {
}
export declare function appServiceEnvironmentV3InboundNetworkDependenciesToTerraform(struct?: AppServiceEnvironmentV3InboundNetworkDependencies): any;
export declare function appServiceEnvironmentV3InboundNetworkDependenciesToHclTerraform(struct?: AppServiceEnvironmentV3InboundNetworkDependencies): any;
export declare class AppServiceEnvironmentV3InboundNetworkDependenciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppServiceEnvironmentV3InboundNetworkDependencies | undefined;
    set internalValue(value: AppServiceEnvironmentV3InboundNetworkDependencies | undefined);
    get description(): string;
    get ipAddresses(): string[];
    get ports(): string[];
}
export declare class AppServiceEnvironmentV3InboundNetworkDependenciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppServiceEnvironmentV3InboundNetworkDependenciesOutputReference;
}
export interface AppServiceEnvironmentV3ClusterSetting {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/app_service_environment_v3#name AppServiceEnvironmentV3#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/app_service_environment_v3#value AppServiceEnvironmentV3#value}
    */
    readonly value: string;
}
export declare function appServiceEnvironmentV3ClusterSettingToTerraform(struct?: AppServiceEnvironmentV3ClusterSetting | cdktf.IResolvable): any;
export declare function appServiceEnvironmentV3ClusterSettingToHclTerraform(struct?: AppServiceEnvironmentV3ClusterSetting | cdktf.IResolvable): any;
export declare class AppServiceEnvironmentV3ClusterSettingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppServiceEnvironmentV3ClusterSetting | cdktf.IResolvable | undefined;
    set internalValue(value: AppServiceEnvironmentV3ClusterSetting | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class AppServiceEnvironmentV3ClusterSettingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppServiceEnvironmentV3ClusterSetting[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppServiceEnvironmentV3ClusterSettingOutputReference;
}
export interface AppServiceEnvironmentV3Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/app_service_environment_v3#create AppServiceEnvironmentV3#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/app_service_environment_v3#delete AppServiceEnvironmentV3#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/app_service_environment_v3#read AppServiceEnvironmentV3#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/app_service_environment_v3#update AppServiceEnvironmentV3#update}
    */
    readonly update?: string;
}
export declare function appServiceEnvironmentV3TimeoutsToTerraform(struct?: AppServiceEnvironmentV3Timeouts | cdktf.IResolvable): any;
export declare function appServiceEnvironmentV3TimeoutsToHclTerraform(struct?: AppServiceEnvironmentV3Timeouts | cdktf.IResolvable): any;
export declare class AppServiceEnvironmentV3TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceEnvironmentV3Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AppServiceEnvironmentV3Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/app_service_environment_v3 azurerm_app_service_environment_v3}
*/
export declare class AppServiceEnvironmentV3 extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_app_service_environment_v3";
    /**
    * Generates CDKTF code for importing a AppServiceEnvironmentV3 resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AppServiceEnvironmentV3 to import
    * @param importFromId The id of the existing AppServiceEnvironmentV3 that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/app_service_environment_v3#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AppServiceEnvironmentV3 to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/app_service_environment_v3 azurerm_app_service_environment_v3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppServiceEnvironmentV3Config
    */
    constructor(scope: Construct, id: string, config: AppServiceEnvironmentV3Config);
    private _allowNewPrivateEndpointConnections?;
    get allowNewPrivateEndpointConnections(): boolean | cdktf.IResolvable;
    set allowNewPrivateEndpointConnections(value: boolean | cdktf.IResolvable);
    resetAllowNewPrivateEndpointConnections(): void;
    get allowNewPrivateEndpointConnectionsInput(): boolean | cdktf.IResolvable | undefined;
    private _dedicatedHostCount?;
    get dedicatedHostCount(): number;
    set dedicatedHostCount(value: number);
    resetDedicatedHostCount(): void;
    get dedicatedHostCountInput(): number | undefined;
    get dnsSuffix(): string;
    get externalInboundIpAddresses(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _inboundNetworkDependencies;
    get inboundNetworkDependencies(): AppServiceEnvironmentV3InboundNetworkDependenciesList;
    get internalInboundIpAddresses(): string[];
    private _internalLoadBalancingMode?;
    get internalLoadBalancingMode(): string;
    set internalLoadBalancingMode(value: string);
    resetInternalLoadBalancingMode(): void;
    get internalLoadBalancingModeInput(): string | undefined;
    get ipSslAddressCount(): number;
    get linuxOutboundIpAddresses(): string[];
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get pricingTier(): string;
    private _remoteDebuggingEnabled?;
    get remoteDebuggingEnabled(): boolean | cdktf.IResolvable;
    set remoteDebuggingEnabled(value: boolean | cdktf.IResolvable);
    resetRemoteDebuggingEnabled(): void;
    get remoteDebuggingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get windowsOutboundIpAddresses(): string[];
    private _zoneRedundant?;
    get zoneRedundant(): boolean | cdktf.IResolvable;
    set zoneRedundant(value: boolean | cdktf.IResolvable);
    resetZoneRedundant(): void;
    get zoneRedundantInput(): boolean | cdktf.IResolvable | undefined;
    private _clusterSetting;
    get clusterSetting(): AppServiceEnvironmentV3ClusterSettingList;
    putClusterSetting(value: AppServiceEnvironmentV3ClusterSetting[] | cdktf.IResolvable): void;
    resetClusterSetting(): void;
    get clusterSettingInput(): cdktf.IResolvable | AppServiceEnvironmentV3ClusterSetting[] | undefined;
    private _timeouts;
    get timeouts(): AppServiceEnvironmentV3TimeoutsOutputReference;
    putTimeouts(value: AppServiceEnvironmentV3Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AppServiceEnvironmentV3Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
