/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CognitiveDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/cognitive_deployment#cognitive_account_id CognitiveDeployment#cognitive_account_id}
    */
    readonly cognitiveAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/cognitive_deployment#id CognitiveDeployment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/cognitive_deployment#name CognitiveDeployment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/cognitive_deployment#rai_policy_name CognitiveDeployment#rai_policy_name}
    */
    readonly raiPolicyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/cognitive_deployment#version_upgrade_option CognitiveDeployment#version_upgrade_option}
    */
    readonly versionUpgradeOption?: string;
    /**
    * model block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/cognitive_deployment#model CognitiveDeployment#model}
    */
    readonly model: CognitiveDeploymentModel;
    /**
    * sku block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/cognitive_deployment#sku CognitiveDeployment#sku}
    */
    readonly sku: CognitiveDeploymentSku;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/cognitive_deployment#timeouts CognitiveDeployment#timeouts}
    */
    readonly timeouts?: CognitiveDeploymentTimeouts;
}
export interface CognitiveDeploymentModel {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/cognitive_deployment#format CognitiveDeployment#format}
    */
    readonly format: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/cognitive_deployment#name CognitiveDeployment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/cognitive_deployment#version CognitiveDeployment#version}
    */
    readonly version?: string;
}
export declare function cognitiveDeploymentModelToTerraform(struct?: CognitiveDeploymentModelOutputReference | CognitiveDeploymentModel): any;
export declare function cognitiveDeploymentModelToHclTerraform(struct?: CognitiveDeploymentModelOutputReference | CognitiveDeploymentModel): any;
export declare class CognitiveDeploymentModelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CognitiveDeploymentModel | undefined;
    set internalValue(value: CognitiveDeploymentModel | undefined);
    private _format?;
    get format(): string;
    set format(value: string);
    get formatInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface CognitiveDeploymentSku {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/cognitive_deployment#capacity CognitiveDeployment#capacity}
    */
    readonly capacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/cognitive_deployment#family CognitiveDeployment#family}
    */
    readonly family?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/cognitive_deployment#name CognitiveDeployment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/cognitive_deployment#size CognitiveDeployment#size}
    */
    readonly size?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/cognitive_deployment#tier CognitiveDeployment#tier}
    */
    readonly tier?: string;
}
export declare function cognitiveDeploymentSkuToTerraform(struct?: CognitiveDeploymentSkuOutputReference | CognitiveDeploymentSku): any;
export declare function cognitiveDeploymentSkuToHclTerraform(struct?: CognitiveDeploymentSkuOutputReference | CognitiveDeploymentSku): any;
export declare class CognitiveDeploymentSkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CognitiveDeploymentSku | undefined;
    set internalValue(value: CognitiveDeploymentSku | undefined);
    private _capacity?;
    get capacity(): number;
    set capacity(value: number);
    resetCapacity(): void;
    get capacityInput(): number | undefined;
    private _family?;
    get family(): string;
    set family(value: string);
    resetFamily(): void;
    get familyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _size?;
    get size(): string;
    set size(value: string);
    resetSize(): void;
    get sizeInput(): string | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    resetTier(): void;
    get tierInput(): string | undefined;
}
export interface CognitiveDeploymentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/cognitive_deployment#create CognitiveDeployment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/cognitive_deployment#delete CognitiveDeployment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/cognitive_deployment#read CognitiveDeployment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/cognitive_deployment#update CognitiveDeployment#update}
    */
    readonly update?: string;
}
export declare function cognitiveDeploymentTimeoutsToTerraform(struct?: CognitiveDeploymentTimeouts | cdktf.IResolvable): any;
export declare function cognitiveDeploymentTimeoutsToHclTerraform(struct?: CognitiveDeploymentTimeouts | cdktf.IResolvable): any;
export declare class CognitiveDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CognitiveDeploymentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CognitiveDeploymentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/cognitive_deployment azurerm_cognitive_deployment}
*/
export declare class CognitiveDeployment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cognitive_deployment";
    /**
    * Generates CDKTF code for importing a CognitiveDeployment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CognitiveDeployment to import
    * @param importFromId The id of the existing CognitiveDeployment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/cognitive_deployment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CognitiveDeployment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/cognitive_deployment azurerm_cognitive_deployment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CognitiveDeploymentConfig
    */
    constructor(scope: Construct, id: string, config: CognitiveDeploymentConfig);
    private _cognitiveAccountId?;
    get cognitiveAccountId(): string;
    set cognitiveAccountId(value: string);
    get cognitiveAccountIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _raiPolicyName?;
    get raiPolicyName(): string;
    set raiPolicyName(value: string);
    resetRaiPolicyName(): void;
    get raiPolicyNameInput(): string | undefined;
    private _versionUpgradeOption?;
    get versionUpgradeOption(): string;
    set versionUpgradeOption(value: string);
    resetVersionUpgradeOption(): void;
    get versionUpgradeOptionInput(): string | undefined;
    private _model;
    get model(): CognitiveDeploymentModelOutputReference;
    putModel(value: CognitiveDeploymentModel): void;
    get modelInput(): CognitiveDeploymentModel | undefined;
    private _sku;
    get sku(): CognitiveDeploymentSkuOutputReference;
    putSku(value: CognitiveDeploymentSku): void;
    get skuInput(): CognitiveDeploymentSku | undefined;
    private _timeouts;
    get timeouts(): CognitiveDeploymentTimeoutsOutputReference;
    putTimeouts(value: CognitiveDeploymentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CognitiveDeploymentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
