/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermBatchPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/batch_pool#account_name DataAzurermBatchPool#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/batch_pool#id DataAzurermBatchPool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/batch_pool#name DataAzurermBatchPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/batch_pool#resource_group_name DataAzurermBatchPool#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/batch_pool#timeouts DataAzurermBatchPool#timeouts}
    */
    readonly timeouts?: DataAzurermBatchPoolTimeouts;
}
export interface DataAzurermBatchPoolAutoScale {
}
export declare function dataAzurermBatchPoolAutoScaleToTerraform(struct?: DataAzurermBatchPoolAutoScale): any;
export declare function dataAzurermBatchPoolAutoScaleToHclTerraform(struct?: DataAzurermBatchPoolAutoScale): any;
export declare class DataAzurermBatchPoolAutoScaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolAutoScale | undefined;
    set internalValue(value: DataAzurermBatchPoolAutoScale | undefined);
    get evaluationInterval(): string;
    get formula(): string;
}
export declare class DataAzurermBatchPoolAutoScaleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolAutoScaleOutputReference;
}
export interface DataAzurermBatchPoolCertificate {
}
export declare function dataAzurermBatchPoolCertificateToTerraform(struct?: DataAzurermBatchPoolCertificate): any;
export declare function dataAzurermBatchPoolCertificateToHclTerraform(struct?: DataAzurermBatchPoolCertificate): any;
export declare class DataAzurermBatchPoolCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolCertificate | undefined;
    set internalValue(value: DataAzurermBatchPoolCertificate | undefined);
    get id(): string;
    get storeLocation(): string;
    get storeName(): string;
    get visibility(): string[];
}
export declare class DataAzurermBatchPoolCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolCertificateOutputReference;
}
export interface DataAzurermBatchPoolContainerConfigurationContainerRegistries {
}
export declare function dataAzurermBatchPoolContainerConfigurationContainerRegistriesToTerraform(struct?: DataAzurermBatchPoolContainerConfigurationContainerRegistries): any;
export declare function dataAzurermBatchPoolContainerConfigurationContainerRegistriesToHclTerraform(struct?: DataAzurermBatchPoolContainerConfigurationContainerRegistries): any;
export declare class DataAzurermBatchPoolContainerConfigurationContainerRegistriesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolContainerConfigurationContainerRegistries | undefined;
    set internalValue(value: DataAzurermBatchPoolContainerConfigurationContainerRegistries | undefined);
    get password(): string;
    get registryServer(): string;
    get userAssignedIdentityId(): string;
    get userName(): string;
}
export declare class DataAzurermBatchPoolContainerConfigurationContainerRegistriesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolContainerConfigurationContainerRegistriesOutputReference;
}
export interface DataAzurermBatchPoolContainerConfiguration {
}
export declare function dataAzurermBatchPoolContainerConfigurationToTerraform(struct?: DataAzurermBatchPoolContainerConfiguration): any;
export declare function dataAzurermBatchPoolContainerConfigurationToHclTerraform(struct?: DataAzurermBatchPoolContainerConfiguration): any;
export declare class DataAzurermBatchPoolContainerConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolContainerConfiguration | undefined;
    set internalValue(value: DataAzurermBatchPoolContainerConfiguration | undefined);
    get containerImageNames(): string[];
    private _containerRegistries;
    get containerRegistries(): DataAzurermBatchPoolContainerConfigurationContainerRegistriesList;
    get type(): string;
}
export declare class DataAzurermBatchPoolContainerConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolContainerConfigurationOutputReference;
}
export interface DataAzurermBatchPoolDataDisks {
}
export declare function dataAzurermBatchPoolDataDisksToTerraform(struct?: DataAzurermBatchPoolDataDisks): any;
export declare function dataAzurermBatchPoolDataDisksToHclTerraform(struct?: DataAzurermBatchPoolDataDisks): any;
export declare class DataAzurermBatchPoolDataDisksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolDataDisks | undefined;
    set internalValue(value: DataAzurermBatchPoolDataDisks | undefined);
    get caching(): string;
    get diskSizeGb(): number;
    get lun(): number;
    get storageAccountType(): string;
}
export declare class DataAzurermBatchPoolDataDisksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolDataDisksOutputReference;
}
export interface DataAzurermBatchPoolDiskEncryption {
}
export declare function dataAzurermBatchPoolDiskEncryptionToTerraform(struct?: DataAzurermBatchPoolDiskEncryption): any;
export declare function dataAzurermBatchPoolDiskEncryptionToHclTerraform(struct?: DataAzurermBatchPoolDiskEncryption): any;
export declare class DataAzurermBatchPoolDiskEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolDiskEncryption | undefined;
    set internalValue(value: DataAzurermBatchPoolDiskEncryption | undefined);
    get diskEncryptionTarget(): string;
}
export declare class DataAzurermBatchPoolDiskEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolDiskEncryptionOutputReference;
}
export interface DataAzurermBatchPoolExtensions {
}
export declare function dataAzurermBatchPoolExtensionsToTerraform(struct?: DataAzurermBatchPoolExtensions): any;
export declare function dataAzurermBatchPoolExtensionsToHclTerraform(struct?: DataAzurermBatchPoolExtensions): any;
export declare class DataAzurermBatchPoolExtensionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolExtensions | undefined;
    set internalValue(value: DataAzurermBatchPoolExtensions | undefined);
    get autoUpgradeMinorVersion(): cdktf.IResolvable;
    get name(): string;
    get protectedSettings(): string;
    get provisionAfterExtensions(): string[];
    get publisher(): string;
    get settingsJson(): string;
    get type(): string;
    get typeHandlerVersion(): string;
}
export declare class DataAzurermBatchPoolExtensionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolExtensionsOutputReference;
}
export interface DataAzurermBatchPoolFixedScale {
}
export declare function dataAzurermBatchPoolFixedScaleToTerraform(struct?: DataAzurermBatchPoolFixedScale): any;
export declare function dataAzurermBatchPoolFixedScaleToHclTerraform(struct?: DataAzurermBatchPoolFixedScale): any;
export declare class DataAzurermBatchPoolFixedScaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolFixedScale | undefined;
    set internalValue(value: DataAzurermBatchPoolFixedScale | undefined);
    get resizeTimeout(): string;
    get targetDedicatedNodes(): number;
    get targetLowPriorityNodes(): number;
}
export declare class DataAzurermBatchPoolFixedScaleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolFixedScaleOutputReference;
}
export interface DataAzurermBatchPoolMountAzureBlobFileSystem {
}
export declare function dataAzurermBatchPoolMountAzureBlobFileSystemToTerraform(struct?: DataAzurermBatchPoolMountAzureBlobFileSystem): any;
export declare function dataAzurermBatchPoolMountAzureBlobFileSystemToHclTerraform(struct?: DataAzurermBatchPoolMountAzureBlobFileSystem): any;
export declare class DataAzurermBatchPoolMountAzureBlobFileSystemOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolMountAzureBlobFileSystem | undefined;
    set internalValue(value: DataAzurermBatchPoolMountAzureBlobFileSystem | undefined);
    get accountKey(): string;
    get accountName(): string;
    get blobfuseOptions(): string;
    get containerName(): string;
    get identityId(): string;
    get relativeMountPath(): string;
    get sasKey(): string;
}
export declare class DataAzurermBatchPoolMountAzureBlobFileSystemList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolMountAzureBlobFileSystemOutputReference;
}
export interface DataAzurermBatchPoolMountAzureFileShare {
}
export declare function dataAzurermBatchPoolMountAzureFileShareToTerraform(struct?: DataAzurermBatchPoolMountAzureFileShare): any;
export declare function dataAzurermBatchPoolMountAzureFileShareToHclTerraform(struct?: DataAzurermBatchPoolMountAzureFileShare): any;
export declare class DataAzurermBatchPoolMountAzureFileShareOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolMountAzureFileShare | undefined;
    set internalValue(value: DataAzurermBatchPoolMountAzureFileShare | undefined);
    get accountKey(): string;
    get accountName(): string;
    get azureFileUrl(): string;
    get mountOptions(): string;
    get relativeMountPath(): string;
}
export declare class DataAzurermBatchPoolMountAzureFileShareList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolMountAzureFileShareOutputReference;
}
export interface DataAzurermBatchPoolMountCifsMount {
}
export declare function dataAzurermBatchPoolMountCifsMountToTerraform(struct?: DataAzurermBatchPoolMountCifsMount): any;
export declare function dataAzurermBatchPoolMountCifsMountToHclTerraform(struct?: DataAzurermBatchPoolMountCifsMount): any;
export declare class DataAzurermBatchPoolMountCifsMountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolMountCifsMount | undefined;
    set internalValue(value: DataAzurermBatchPoolMountCifsMount | undefined);
    get mountOptions(): string;
    get password(): string;
    get relativeMountPath(): string;
    get source(): string;
    get userName(): string;
}
export declare class DataAzurermBatchPoolMountCifsMountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolMountCifsMountOutputReference;
}
export interface DataAzurermBatchPoolMountNfsMount {
}
export declare function dataAzurermBatchPoolMountNfsMountToTerraform(struct?: DataAzurermBatchPoolMountNfsMount): any;
export declare function dataAzurermBatchPoolMountNfsMountToHclTerraform(struct?: DataAzurermBatchPoolMountNfsMount): any;
export declare class DataAzurermBatchPoolMountNfsMountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolMountNfsMount | undefined;
    set internalValue(value: DataAzurermBatchPoolMountNfsMount | undefined);
    get mountOptions(): string;
    get relativeMountPath(): string;
    get source(): string;
}
export declare class DataAzurermBatchPoolMountNfsMountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolMountNfsMountOutputReference;
}
export interface DataAzurermBatchPoolMount {
}
export declare function dataAzurermBatchPoolMountToTerraform(struct?: DataAzurermBatchPoolMount): any;
export declare function dataAzurermBatchPoolMountToHclTerraform(struct?: DataAzurermBatchPoolMount): any;
export declare class DataAzurermBatchPoolMountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolMount | undefined;
    set internalValue(value: DataAzurermBatchPoolMount | undefined);
    private _azureBlobFileSystem;
    get azureBlobFileSystem(): DataAzurermBatchPoolMountAzureBlobFileSystemList;
    private _azureFileShare;
    get azureFileShare(): DataAzurermBatchPoolMountAzureFileShareList;
    private _cifsMount;
    get cifsMount(): DataAzurermBatchPoolMountCifsMountList;
    private _nfsMount;
    get nfsMount(): DataAzurermBatchPoolMountNfsMountList;
}
export declare class DataAzurermBatchPoolMountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolMountOutputReference;
}
export interface DataAzurermBatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules {
}
export declare function dataAzurermBatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRulesToTerraform(struct?: DataAzurermBatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules): any;
export declare function dataAzurermBatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRulesToHclTerraform(struct?: DataAzurermBatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules): any;
export declare class DataAzurermBatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules | undefined;
    set internalValue(value: DataAzurermBatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules | undefined);
    get access(): string;
    get priority(): number;
    get sourceAddressPrefix(): string;
    get sourcePortRanges(): string[];
}
export declare class DataAzurermBatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRulesOutputReference;
}
export interface DataAzurermBatchPoolNetworkConfigurationEndpointConfiguration {
}
export declare function dataAzurermBatchPoolNetworkConfigurationEndpointConfigurationToTerraform(struct?: DataAzurermBatchPoolNetworkConfigurationEndpointConfiguration): any;
export declare function dataAzurermBatchPoolNetworkConfigurationEndpointConfigurationToHclTerraform(struct?: DataAzurermBatchPoolNetworkConfigurationEndpointConfiguration): any;
export declare class DataAzurermBatchPoolNetworkConfigurationEndpointConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolNetworkConfigurationEndpointConfiguration | undefined;
    set internalValue(value: DataAzurermBatchPoolNetworkConfigurationEndpointConfiguration | undefined);
    get backendPort(): number;
    get frontendPortRange(): string;
    get name(): string;
    private _networkSecurityGroupRules;
    get networkSecurityGroupRules(): DataAzurermBatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRulesList;
    get protocol(): string;
}
export declare class DataAzurermBatchPoolNetworkConfigurationEndpointConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolNetworkConfigurationEndpointConfigurationOutputReference;
}
export interface DataAzurermBatchPoolNetworkConfiguration {
}
export declare function dataAzurermBatchPoolNetworkConfigurationToTerraform(struct?: DataAzurermBatchPoolNetworkConfiguration): any;
export declare function dataAzurermBatchPoolNetworkConfigurationToHclTerraform(struct?: DataAzurermBatchPoolNetworkConfiguration): any;
export declare class DataAzurermBatchPoolNetworkConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolNetworkConfiguration | undefined;
    set internalValue(value: DataAzurermBatchPoolNetworkConfiguration | undefined);
    get acceleratedNetworkingEnabled(): cdktf.IResolvable;
    get dynamicVnetAssignmentScope(): string;
    private _endpointConfiguration;
    get endpointConfiguration(): DataAzurermBatchPoolNetworkConfigurationEndpointConfigurationList;
    get publicAddressProvisioningType(): string;
    get publicIps(): string[];
    get subnetId(): string;
}
export declare class DataAzurermBatchPoolNetworkConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolNetworkConfigurationOutputReference;
}
export interface DataAzurermBatchPoolNodePlacement {
}
export declare function dataAzurermBatchPoolNodePlacementToTerraform(struct?: DataAzurermBatchPoolNodePlacement): any;
export declare function dataAzurermBatchPoolNodePlacementToHclTerraform(struct?: DataAzurermBatchPoolNodePlacement): any;
export declare class DataAzurermBatchPoolNodePlacementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolNodePlacement | undefined;
    set internalValue(value: DataAzurermBatchPoolNodePlacement | undefined);
    get policy(): string;
}
export declare class DataAzurermBatchPoolNodePlacementList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolNodePlacementOutputReference;
}
export interface DataAzurermBatchPoolStartTaskContainerRegistry {
}
export declare function dataAzurermBatchPoolStartTaskContainerRegistryToTerraform(struct?: DataAzurermBatchPoolStartTaskContainerRegistry): any;
export declare function dataAzurermBatchPoolStartTaskContainerRegistryToHclTerraform(struct?: DataAzurermBatchPoolStartTaskContainerRegistry): any;
export declare class DataAzurermBatchPoolStartTaskContainerRegistryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolStartTaskContainerRegistry | undefined;
    set internalValue(value: DataAzurermBatchPoolStartTaskContainerRegistry | undefined);
    get password(): string;
    get registryServer(): string;
    get userAssignedIdentityId(): string;
    get userName(): string;
}
export declare class DataAzurermBatchPoolStartTaskContainerRegistryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolStartTaskContainerRegistryOutputReference;
}
export interface DataAzurermBatchPoolStartTaskContainer {
}
export declare function dataAzurermBatchPoolStartTaskContainerToTerraform(struct?: DataAzurermBatchPoolStartTaskContainer): any;
export declare function dataAzurermBatchPoolStartTaskContainerToHclTerraform(struct?: DataAzurermBatchPoolStartTaskContainer): any;
export declare class DataAzurermBatchPoolStartTaskContainerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolStartTaskContainer | undefined;
    set internalValue(value: DataAzurermBatchPoolStartTaskContainer | undefined);
    get imageName(): string;
    private _registry;
    get registry(): DataAzurermBatchPoolStartTaskContainerRegistryList;
    get runOptions(): string;
    get workingDirectory(): string;
}
export declare class DataAzurermBatchPoolStartTaskContainerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolStartTaskContainerOutputReference;
}
export interface DataAzurermBatchPoolStartTaskResourceFile {
}
export declare function dataAzurermBatchPoolStartTaskResourceFileToTerraform(struct?: DataAzurermBatchPoolStartTaskResourceFile): any;
export declare function dataAzurermBatchPoolStartTaskResourceFileToHclTerraform(struct?: DataAzurermBatchPoolStartTaskResourceFile): any;
export declare class DataAzurermBatchPoolStartTaskResourceFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolStartTaskResourceFile | undefined;
    set internalValue(value: DataAzurermBatchPoolStartTaskResourceFile | undefined);
    get autoStorageContainerName(): string;
    get blobPrefix(): string;
    get fileMode(): string;
    get filePath(): string;
    get httpUrl(): string;
    get storageContainerUrl(): string;
    get userAssignedIdentityId(): string;
}
export declare class DataAzurermBatchPoolStartTaskResourceFileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolStartTaskResourceFileOutputReference;
}
export interface DataAzurermBatchPoolStartTaskUserIdentityAutoUser {
}
export declare function dataAzurermBatchPoolStartTaskUserIdentityAutoUserToTerraform(struct?: DataAzurermBatchPoolStartTaskUserIdentityAutoUser): any;
export declare function dataAzurermBatchPoolStartTaskUserIdentityAutoUserToHclTerraform(struct?: DataAzurermBatchPoolStartTaskUserIdentityAutoUser): any;
export declare class DataAzurermBatchPoolStartTaskUserIdentityAutoUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolStartTaskUserIdentityAutoUser | undefined;
    set internalValue(value: DataAzurermBatchPoolStartTaskUserIdentityAutoUser | undefined);
    get elevationLevel(): string;
    get scope(): string;
}
export declare class DataAzurermBatchPoolStartTaskUserIdentityAutoUserList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolStartTaskUserIdentityAutoUserOutputReference;
}
export interface DataAzurermBatchPoolStartTaskUserIdentity {
}
export declare function dataAzurermBatchPoolStartTaskUserIdentityToTerraform(struct?: DataAzurermBatchPoolStartTaskUserIdentity): any;
export declare function dataAzurermBatchPoolStartTaskUserIdentityToHclTerraform(struct?: DataAzurermBatchPoolStartTaskUserIdentity): any;
export declare class DataAzurermBatchPoolStartTaskUserIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolStartTaskUserIdentity | undefined;
    set internalValue(value: DataAzurermBatchPoolStartTaskUserIdentity | undefined);
    private _autoUser;
    get autoUser(): DataAzurermBatchPoolStartTaskUserIdentityAutoUserList;
    get userName(): string;
}
export declare class DataAzurermBatchPoolStartTaskUserIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolStartTaskUserIdentityOutputReference;
}
export interface DataAzurermBatchPoolStartTask {
}
export declare function dataAzurermBatchPoolStartTaskToTerraform(struct?: DataAzurermBatchPoolStartTask): any;
export declare function dataAzurermBatchPoolStartTaskToHclTerraform(struct?: DataAzurermBatchPoolStartTask): any;
export declare class DataAzurermBatchPoolStartTaskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolStartTask | undefined;
    set internalValue(value: DataAzurermBatchPoolStartTask | undefined);
    get commandLine(): string;
    private _commonEnvironmentProperties;
    get commonEnvironmentProperties(): cdktf.StringMap;
    private _container;
    get container(): DataAzurermBatchPoolStartTaskContainerList;
    private _resourceFile;
    get resourceFile(): DataAzurermBatchPoolStartTaskResourceFileList;
    get taskRetryMaximum(): number;
    private _userIdentity;
    get userIdentity(): DataAzurermBatchPoolStartTaskUserIdentityList;
    get waitForSuccess(): cdktf.IResolvable;
}
export declare class DataAzurermBatchPoolStartTaskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolStartTaskOutputReference;
}
export interface DataAzurermBatchPoolStorageImageReference {
}
export declare function dataAzurermBatchPoolStorageImageReferenceToTerraform(struct?: DataAzurermBatchPoolStorageImageReference): any;
export declare function dataAzurermBatchPoolStorageImageReferenceToHclTerraform(struct?: DataAzurermBatchPoolStorageImageReference): any;
export declare class DataAzurermBatchPoolStorageImageReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolStorageImageReference | undefined;
    set internalValue(value: DataAzurermBatchPoolStorageImageReference | undefined);
    get id(): string;
    get offer(): string;
    get publisher(): string;
    get sku(): string;
    get version(): string;
}
export declare class DataAzurermBatchPoolStorageImageReferenceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolStorageImageReferenceOutputReference;
}
export interface DataAzurermBatchPoolTaskSchedulingPolicy {
}
export declare function dataAzurermBatchPoolTaskSchedulingPolicyToTerraform(struct?: DataAzurermBatchPoolTaskSchedulingPolicy): any;
export declare function dataAzurermBatchPoolTaskSchedulingPolicyToHclTerraform(struct?: DataAzurermBatchPoolTaskSchedulingPolicy): any;
export declare class DataAzurermBatchPoolTaskSchedulingPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolTaskSchedulingPolicy | undefined;
    set internalValue(value: DataAzurermBatchPoolTaskSchedulingPolicy | undefined);
    get nodeFillType(): string;
}
export declare class DataAzurermBatchPoolTaskSchedulingPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolTaskSchedulingPolicyOutputReference;
}
export interface DataAzurermBatchPoolUserAccountsLinuxUserConfiguration {
}
export declare function dataAzurermBatchPoolUserAccountsLinuxUserConfigurationToTerraform(struct?: DataAzurermBatchPoolUserAccountsLinuxUserConfiguration): any;
export declare function dataAzurermBatchPoolUserAccountsLinuxUserConfigurationToHclTerraform(struct?: DataAzurermBatchPoolUserAccountsLinuxUserConfiguration): any;
export declare class DataAzurermBatchPoolUserAccountsLinuxUserConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolUserAccountsLinuxUserConfiguration | undefined;
    set internalValue(value: DataAzurermBatchPoolUserAccountsLinuxUserConfiguration | undefined);
    get gid(): number;
    get sshPrivateKey(): string;
    get uid(): number;
}
export declare class DataAzurermBatchPoolUserAccountsLinuxUserConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolUserAccountsLinuxUserConfigurationOutputReference;
}
export interface DataAzurermBatchPoolUserAccountsWindowsUserConfiguration {
}
export declare function dataAzurermBatchPoolUserAccountsWindowsUserConfigurationToTerraform(struct?: DataAzurermBatchPoolUserAccountsWindowsUserConfiguration): any;
export declare function dataAzurermBatchPoolUserAccountsWindowsUserConfigurationToHclTerraform(struct?: DataAzurermBatchPoolUserAccountsWindowsUserConfiguration): any;
export declare class DataAzurermBatchPoolUserAccountsWindowsUserConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolUserAccountsWindowsUserConfiguration | undefined;
    set internalValue(value: DataAzurermBatchPoolUserAccountsWindowsUserConfiguration | undefined);
    get loginMode(): string;
}
export declare class DataAzurermBatchPoolUserAccountsWindowsUserConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolUserAccountsWindowsUserConfigurationOutputReference;
}
export interface DataAzurermBatchPoolUserAccounts {
}
export declare function dataAzurermBatchPoolUserAccountsToTerraform(struct?: DataAzurermBatchPoolUserAccounts): any;
export declare function dataAzurermBatchPoolUserAccountsToHclTerraform(struct?: DataAzurermBatchPoolUserAccounts): any;
export declare class DataAzurermBatchPoolUserAccountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolUserAccounts | undefined;
    set internalValue(value: DataAzurermBatchPoolUserAccounts | undefined);
    get elevationLevel(): string;
    private _linuxUserConfiguration;
    get linuxUserConfiguration(): DataAzurermBatchPoolUserAccountsLinuxUserConfigurationList;
    get name(): string;
    get password(): string;
    private _windowsUserConfiguration;
    get windowsUserConfiguration(): DataAzurermBatchPoolUserAccountsWindowsUserConfigurationList;
}
export declare class DataAzurermBatchPoolUserAccountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolUserAccountsOutputReference;
}
export interface DataAzurermBatchPoolWindows {
}
export declare function dataAzurermBatchPoolWindowsToTerraform(struct?: DataAzurermBatchPoolWindows): any;
export declare function dataAzurermBatchPoolWindowsToHclTerraform(struct?: DataAzurermBatchPoolWindows): any;
export declare class DataAzurermBatchPoolWindowsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermBatchPoolWindows | undefined;
    set internalValue(value: DataAzurermBatchPoolWindows | undefined);
    get enableAutomaticUpdates(): cdktf.IResolvable;
}
export declare class DataAzurermBatchPoolWindowsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermBatchPoolWindowsOutputReference;
}
export interface DataAzurermBatchPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/batch_pool#read DataAzurermBatchPool#read}
    */
    readonly read?: string;
}
export declare function dataAzurermBatchPoolTimeoutsToTerraform(struct?: DataAzurermBatchPoolTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermBatchPoolTimeoutsToHclTerraform(struct?: DataAzurermBatchPoolTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermBatchPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermBatchPoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermBatchPoolTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/batch_pool azurerm_batch_pool}
*/
export declare class DataAzurermBatchPool extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_batch_pool";
    /**
    * Generates CDKTF code for importing a DataAzurermBatchPool resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermBatchPool to import
    * @param importFromId The id of the existing DataAzurermBatchPool that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/batch_pool#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermBatchPool to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/batch_pool azurerm_batch_pool} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermBatchPoolConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermBatchPoolConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _autoScale;
    get autoScale(): DataAzurermBatchPoolAutoScaleList;
    private _certificate;
    get certificate(): DataAzurermBatchPoolCertificateList;
    private _containerConfiguration;
    get containerConfiguration(): DataAzurermBatchPoolContainerConfigurationList;
    private _dataDisks;
    get dataDisks(): DataAzurermBatchPoolDataDisksList;
    private _diskEncryption;
    get diskEncryption(): DataAzurermBatchPoolDiskEncryptionList;
    get displayName(): string;
    private _extensions;
    get extensions(): DataAzurermBatchPoolExtensionsList;
    private _fixedScale;
    get fixedScale(): DataAzurermBatchPoolFixedScaleList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get interNodeCommunication(): string;
    get licenseType(): string;
    get maxTasksPerNode(): number;
    private _metadata;
    get metadata(): cdktf.StringMap;
    private _mount;
    get mount(): DataAzurermBatchPoolMountList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkConfiguration;
    get networkConfiguration(): DataAzurermBatchPoolNetworkConfigurationList;
    get nodeAgentSkuId(): string;
    private _nodePlacement;
    get nodePlacement(): DataAzurermBatchPoolNodePlacementList;
    get osDiskPlacement(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _startTask;
    get startTask(): DataAzurermBatchPoolStartTaskList;
    private _storageImageReference;
    get storageImageReference(): DataAzurermBatchPoolStorageImageReferenceList;
    private _taskSchedulingPolicy;
    get taskSchedulingPolicy(): DataAzurermBatchPoolTaskSchedulingPolicyList;
    private _userAccounts;
    get userAccounts(): DataAzurermBatchPoolUserAccountsList;
    get vmSize(): string;
    private _windows;
    get windows(): DataAzurermBatchPoolWindowsList;
    private _timeouts;
    get timeouts(): DataAzurermBatchPoolTimeoutsOutputReference;
    putTimeouts(value: DataAzurermBatchPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermBatchPoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
