/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermBlueprintPublishedVersionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/blueprint_published_version#blueprint_name DataAzurermBlueprintPublishedVersion#blueprint_name}
    */
    readonly blueprintName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/blueprint_published_version#id DataAzurermBlueprintPublishedVersion#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/blueprint_published_version#scope_id DataAzurermBlueprintPublishedVersion#scope_id}
    */
    readonly scopeId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/blueprint_published_version#version DataAzurermBlueprintPublishedVersion#version}
    */
    readonly version: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/blueprint_published_version#timeouts DataAzurermBlueprintPublishedVersion#timeouts}
    */
    readonly timeouts?: DataAzurermBlueprintPublishedVersionTimeouts;
}
export interface DataAzurermBlueprintPublishedVersionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/blueprint_published_version#read DataAzurermBlueprintPublishedVersion#read}
    */
    readonly read?: string;
}
export declare function dataAzurermBlueprintPublishedVersionTimeoutsToTerraform(struct?: DataAzurermBlueprintPublishedVersionTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermBlueprintPublishedVersionTimeoutsToHclTerraform(struct?: DataAzurermBlueprintPublishedVersionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermBlueprintPublishedVersionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermBlueprintPublishedVersionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermBlueprintPublishedVersionTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/blueprint_published_version azurerm_blueprint_published_version}
*/
export declare class DataAzurermBlueprintPublishedVersion extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_blueprint_published_version";
    /**
    * Generates CDKTF code for importing a DataAzurermBlueprintPublishedVersion resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermBlueprintPublishedVersion to import
    * @param importFromId The id of the existing DataAzurermBlueprintPublishedVersion that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/blueprint_published_version#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermBlueprintPublishedVersion to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/blueprint_published_version azurerm_blueprint_published_version} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermBlueprintPublishedVersionConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermBlueprintPublishedVersionConfig);
    private _blueprintName?;
    get blueprintName(): string;
    set blueprintName(value: string);
    get blueprintNameInput(): string | undefined;
    get description(): string;
    get displayName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lastModified(): string;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    get scopeIdInput(): string | undefined;
    get targetScope(): string;
    get timeCreated(): string;
    get type(): string;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermBlueprintPublishedVersionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermBlueprintPublishedVersionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermBlueprintPublishedVersionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
