/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermExpressRouteCircuitPeeringConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/express_route_circuit_peering#express_route_circuit_name DataAzurermExpressRouteCircuitPeering#express_route_circuit_name}
    */
    readonly expressRouteCircuitName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/express_route_circuit_peering#id DataAzurermExpressRouteCircuitPeering#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/express_route_circuit_peering#peering_type DataAzurermExpressRouteCircuitPeering#peering_type}
    */
    readonly peeringType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/express_route_circuit_peering#resource_group_name DataAzurermExpressRouteCircuitPeering#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/express_route_circuit_peering#timeouts DataAzurermExpressRouteCircuitPeering#timeouts}
    */
    readonly timeouts?: DataAzurermExpressRouteCircuitPeeringTimeouts;
}
export interface DataAzurermExpressRouteCircuitPeeringTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/express_route_circuit_peering#read DataAzurermExpressRouteCircuitPeering#read}
    */
    readonly read?: string;
}
export declare function dataAzurermExpressRouteCircuitPeeringTimeoutsToTerraform(struct?: DataAzurermExpressRouteCircuitPeeringTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermExpressRouteCircuitPeeringTimeoutsToHclTerraform(struct?: DataAzurermExpressRouteCircuitPeeringTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermExpressRouteCircuitPeeringTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermExpressRouteCircuitPeeringTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermExpressRouteCircuitPeeringTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/express_route_circuit_peering azurerm_express_route_circuit_peering}
*/
export declare class DataAzurermExpressRouteCircuitPeering extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_express_route_circuit_peering";
    /**
    * Generates CDKTF code for importing a DataAzurermExpressRouteCircuitPeering resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermExpressRouteCircuitPeering to import
    * @param importFromId The id of the existing DataAzurermExpressRouteCircuitPeering that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/express_route_circuit_peering#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermExpressRouteCircuitPeering to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/express_route_circuit_peering azurerm_express_route_circuit_peering} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermExpressRouteCircuitPeeringConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermExpressRouteCircuitPeeringConfig);
    get azureAsn(): number;
    private _expressRouteCircuitName?;
    get expressRouteCircuitName(): string;
    set expressRouteCircuitName(value: string);
    get expressRouteCircuitNameInput(): string | undefined;
    get gatewayManagerEtag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ipv4Enabled(): cdktf.IResolvable;
    get peerAsn(): number;
    private _peeringType?;
    get peeringType(): string;
    set peeringType(value: string);
    get peeringTypeInput(): string | undefined;
    get primaryAzurePort(): string;
    get primaryPeerAddressPrefix(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get routeFilterId(): string;
    get secondaryAzurePort(): string;
    get secondaryPeerAddressPrefix(): string;
    get sharedKey(): string;
    get vlanId(): number;
    private _timeouts;
    get timeouts(): DataAzurermExpressRouteCircuitPeeringTimeoutsOutputReference;
    putTimeouts(value: DataAzurermExpressRouteCircuitPeeringTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermExpressRouteCircuitPeeringTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
