/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermHealthcareFhirServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/healthcare_fhir_service#id DataAzurermHealthcareFhirService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/healthcare_fhir_service#name DataAzurermHealthcareFhirService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/healthcare_fhir_service#tags DataAzurermHealthcareFhirService#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/healthcare_fhir_service#workspace_id DataAzurermHealthcareFhirService#workspace_id}
    */
    readonly workspaceId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/healthcare_fhir_service#timeouts DataAzurermHealthcareFhirService#timeouts}
    */
    readonly timeouts?: DataAzurermHealthcareFhirServiceTimeouts;
}
export interface DataAzurermHealthcareFhirServiceAuthentication {
}
export declare function dataAzurermHealthcareFhirServiceAuthenticationToTerraform(struct?: DataAzurermHealthcareFhirServiceAuthentication): any;
export declare function dataAzurermHealthcareFhirServiceAuthenticationToHclTerraform(struct?: DataAzurermHealthcareFhirServiceAuthentication): any;
export declare class DataAzurermHealthcareFhirServiceAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHealthcareFhirServiceAuthentication | undefined;
    set internalValue(value: DataAzurermHealthcareFhirServiceAuthentication | undefined);
    get audience(): string;
    get authority(): string;
    get smartProxyEnabled(): cdktf.IResolvable;
}
export declare class DataAzurermHealthcareFhirServiceAuthenticationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHealthcareFhirServiceAuthenticationOutputReference;
}
export interface DataAzurermHealthcareFhirServiceCors {
}
export declare function dataAzurermHealthcareFhirServiceCorsToTerraform(struct?: DataAzurermHealthcareFhirServiceCors): any;
export declare function dataAzurermHealthcareFhirServiceCorsToHclTerraform(struct?: DataAzurermHealthcareFhirServiceCors): any;
export declare class DataAzurermHealthcareFhirServiceCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHealthcareFhirServiceCors | undefined;
    set internalValue(value: DataAzurermHealthcareFhirServiceCors | undefined);
    get allowedHeaders(): string[];
    get allowedMethods(): string[];
    get allowedOrigins(): string[];
    get credentialsAllowed(): cdktf.IResolvable;
    get maxAgeInSeconds(): number;
}
export declare class DataAzurermHealthcareFhirServiceCorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHealthcareFhirServiceCorsOutputReference;
}
export interface DataAzurermHealthcareFhirServiceIdentity {
}
export declare function dataAzurermHealthcareFhirServiceIdentityToTerraform(struct?: DataAzurermHealthcareFhirServiceIdentity): any;
export declare function dataAzurermHealthcareFhirServiceIdentityToHclTerraform(struct?: DataAzurermHealthcareFhirServiceIdentity): any;
export declare class DataAzurermHealthcareFhirServiceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHealthcareFhirServiceIdentity | undefined;
    set internalValue(value: DataAzurermHealthcareFhirServiceIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermHealthcareFhirServiceIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHealthcareFhirServiceIdentityOutputReference;
}
export interface DataAzurermHealthcareFhirServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/healthcare_fhir_service#read DataAzurermHealthcareFhirService#read}
    */
    readonly read?: string;
}
export declare function dataAzurermHealthcareFhirServiceTimeoutsToTerraform(struct?: DataAzurermHealthcareFhirServiceTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermHealthcareFhirServiceTimeoutsToHclTerraform(struct?: DataAzurermHealthcareFhirServiceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermHealthcareFhirServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermHealthcareFhirServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermHealthcareFhirServiceTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/healthcare_fhir_service azurerm_healthcare_fhir_service}
*/
export declare class DataAzurermHealthcareFhirService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_healthcare_fhir_service";
    /**
    * Generates CDKTF code for importing a DataAzurermHealthcareFhirService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermHealthcareFhirService to import
    * @param importFromId The id of the existing DataAzurermHealthcareFhirService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/healthcare_fhir_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermHealthcareFhirService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/healthcare_fhir_service azurerm_healthcare_fhir_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermHealthcareFhirServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermHealthcareFhirServiceConfig);
    get accessPolicyObjectIds(): string[];
    private _authentication;
    get authentication(): DataAzurermHealthcareFhirServiceAuthenticationList;
    get configurationExportStorageAccountName(): string;
    get containerRegistryLoginServerUrl(): string[];
    private _cors;
    get cors(): DataAzurermHealthcareFhirServiceCorsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermHealthcareFhirServiceIdentityList;
    get kind(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _workspaceId?;
    get workspaceId(): string;
    set workspaceId(value: string);
    get workspaceIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermHealthcareFhirServiceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermHealthcareFhirServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermHealthcareFhirServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
