/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermImagesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/images#id DataAzurermImages#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/images#resource_group_name DataAzurermImages#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/images#tags_filter DataAzurermImages#tags_filter}
    */
    readonly tagsFilter?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/images#timeouts DataAzurermImages#timeouts}
    */
    readonly timeouts?: DataAzurermImagesTimeouts;
}
export interface DataAzurermImagesImagesDataDisk {
}
export declare function dataAzurermImagesImagesDataDiskToTerraform(struct?: DataAzurermImagesImagesDataDisk): any;
export declare function dataAzurermImagesImagesDataDiskToHclTerraform(struct?: DataAzurermImagesImagesDataDisk): any;
export declare class DataAzurermImagesImagesDataDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermImagesImagesDataDisk | undefined;
    set internalValue(value: DataAzurermImagesImagesDataDisk | undefined);
    get blobUri(): string;
    get caching(): string;
    get lun(): number;
    get managedDiskId(): string;
    get sizeGb(): number;
}
export declare class DataAzurermImagesImagesDataDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermImagesImagesDataDiskOutputReference;
}
export interface DataAzurermImagesImagesOsDisk {
}
export declare function dataAzurermImagesImagesOsDiskToTerraform(struct?: DataAzurermImagesImagesOsDisk): any;
export declare function dataAzurermImagesImagesOsDiskToHclTerraform(struct?: DataAzurermImagesImagesOsDisk): any;
export declare class DataAzurermImagesImagesOsDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermImagesImagesOsDisk | undefined;
    set internalValue(value: DataAzurermImagesImagesOsDisk | undefined);
    get blobUri(): string;
    get caching(): string;
    get diskEncryptionSetId(): string;
    get managedDiskId(): string;
    get osState(): string;
    get osType(): string;
    get sizeGb(): number;
}
export declare class DataAzurermImagesImagesOsDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermImagesImagesOsDiskOutputReference;
}
export interface DataAzurermImagesImages {
}
export declare function dataAzurermImagesImagesToTerraform(struct?: DataAzurermImagesImages): any;
export declare function dataAzurermImagesImagesToHclTerraform(struct?: DataAzurermImagesImages): any;
export declare class DataAzurermImagesImagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermImagesImages | undefined;
    set internalValue(value: DataAzurermImagesImages | undefined);
    private _dataDisk;
    get dataDisk(): DataAzurermImagesImagesDataDiskList;
    get location(): string;
    get name(): string;
    private _osDisk;
    get osDisk(): DataAzurermImagesImagesOsDiskList;
    private _tags;
    get tags(): cdktf.StringMap;
    get zoneResilient(): cdktf.IResolvable;
}
export declare class DataAzurermImagesImagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermImagesImagesOutputReference;
}
export interface DataAzurermImagesTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/images#read DataAzurermImages#read}
    */
    readonly read?: string;
}
export declare function dataAzurermImagesTimeoutsToTerraform(struct?: DataAzurermImagesTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermImagesTimeoutsToHclTerraform(struct?: DataAzurermImagesTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermImagesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermImagesTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermImagesTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/images azurerm_images}
*/
export declare class DataAzurermImages extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_images";
    /**
    * Generates CDKTF code for importing a DataAzurermImages resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermImages to import
    * @param importFromId The id of the existing DataAzurermImages that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/images#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermImages to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/images azurerm_images} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermImagesConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermImagesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _images;
    get images(): DataAzurermImagesImagesList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tagsFilter?;
    get tagsFilter(): {
        [key: string]: string;
    };
    set tagsFilter(value: {
        [key: string]: string;
    });
    resetTagsFilter(): void;
    get tagsFilterInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): DataAzurermImagesTimeoutsOutputReference;
    putTimeouts(value: DataAzurermImagesTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermImagesTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
