/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermLinuxFunctionAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/linux_function_app#id DataAzurermLinuxFunctionApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/linux_function_app#name DataAzurermLinuxFunctionApp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/linux_function_app#resource_group_name DataAzurermLinuxFunctionApp#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/linux_function_app#timeouts DataAzurermLinuxFunctionApp#timeouts}
    */
    readonly timeouts?: DataAzurermLinuxFunctionAppTimeouts;
}
export interface DataAzurermLinuxFunctionAppAuthSettingsActiveDirectory {
}
export declare function dataAzurermLinuxFunctionAppAuthSettingsActiveDirectoryToTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsActiveDirectory): any;
export declare function dataAzurermLinuxFunctionAppAuthSettingsActiveDirectoryToHclTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsActiveDirectory): any;
export declare class DataAzurermLinuxFunctionAppAuthSettingsActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppAuthSettingsActiveDirectory | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppAuthSettingsActiveDirectory | undefined);
    get allowedAudiences(): string[];
    get clientId(): string;
    get clientSecret(): string;
    get clientSecretSettingName(): string;
}
export declare class DataAzurermLinuxFunctionAppAuthSettingsActiveDirectoryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppAuthSettingsActiveDirectoryOutputReference;
}
export interface DataAzurermLinuxFunctionAppAuthSettingsFacebook {
}
export declare function dataAzurermLinuxFunctionAppAuthSettingsFacebookToTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsFacebook): any;
export declare function dataAzurermLinuxFunctionAppAuthSettingsFacebookToHclTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsFacebook): any;
export declare class DataAzurermLinuxFunctionAppAuthSettingsFacebookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppAuthSettingsFacebook | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppAuthSettingsFacebook | undefined);
    get appId(): string;
    get appSecret(): string;
    get appSecretSettingName(): string;
    get oauthScopes(): string[];
}
export declare class DataAzurermLinuxFunctionAppAuthSettingsFacebookList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppAuthSettingsFacebookOutputReference;
}
export interface DataAzurermLinuxFunctionAppAuthSettingsGithub {
}
export declare function dataAzurermLinuxFunctionAppAuthSettingsGithubToTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsGithub): any;
export declare function dataAzurermLinuxFunctionAppAuthSettingsGithubToHclTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsGithub): any;
export declare class DataAzurermLinuxFunctionAppAuthSettingsGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppAuthSettingsGithub | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppAuthSettingsGithub | undefined);
    get clientId(): string;
    get clientSecret(): string;
    get clientSecretSettingName(): string;
    get oauthScopes(): string[];
}
export declare class DataAzurermLinuxFunctionAppAuthSettingsGithubList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppAuthSettingsGithubOutputReference;
}
export interface DataAzurermLinuxFunctionAppAuthSettingsGoogle {
}
export declare function dataAzurermLinuxFunctionAppAuthSettingsGoogleToTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsGoogle): any;
export declare function dataAzurermLinuxFunctionAppAuthSettingsGoogleToHclTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsGoogle): any;
export declare class DataAzurermLinuxFunctionAppAuthSettingsGoogleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppAuthSettingsGoogle | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppAuthSettingsGoogle | undefined);
    get clientId(): string;
    get clientSecret(): string;
    get clientSecretSettingName(): string;
    get oauthScopes(): string[];
}
export declare class DataAzurermLinuxFunctionAppAuthSettingsGoogleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppAuthSettingsGoogleOutputReference;
}
export interface DataAzurermLinuxFunctionAppAuthSettingsMicrosoft {
}
export declare function dataAzurermLinuxFunctionAppAuthSettingsMicrosoftToTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsMicrosoft): any;
export declare function dataAzurermLinuxFunctionAppAuthSettingsMicrosoftToHclTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsMicrosoft): any;
export declare class DataAzurermLinuxFunctionAppAuthSettingsMicrosoftOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppAuthSettingsMicrosoft | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppAuthSettingsMicrosoft | undefined);
    get clientId(): string;
    get clientSecret(): string;
    get clientSecretSettingName(): string;
    get oauthScopes(): string[];
}
export declare class DataAzurermLinuxFunctionAppAuthSettingsMicrosoftList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppAuthSettingsMicrosoftOutputReference;
}
export interface DataAzurermLinuxFunctionAppAuthSettingsTwitter {
}
export declare function dataAzurermLinuxFunctionAppAuthSettingsTwitterToTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsTwitter): any;
export declare function dataAzurermLinuxFunctionAppAuthSettingsTwitterToHclTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsTwitter): any;
export declare class DataAzurermLinuxFunctionAppAuthSettingsTwitterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppAuthSettingsTwitter | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppAuthSettingsTwitter | undefined);
    get consumerKey(): string;
    get consumerSecret(): string;
    get consumerSecretSettingName(): string;
}
export declare class DataAzurermLinuxFunctionAppAuthSettingsTwitterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppAuthSettingsTwitterOutputReference;
}
export interface DataAzurermLinuxFunctionAppAuthSettings {
}
export declare function dataAzurermLinuxFunctionAppAuthSettingsToTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettings): any;
export declare function dataAzurermLinuxFunctionAppAuthSettingsToHclTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettings): any;
export declare class DataAzurermLinuxFunctionAppAuthSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppAuthSettings | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppAuthSettings | undefined);
    private _activeDirectory;
    get activeDirectory(): DataAzurermLinuxFunctionAppAuthSettingsActiveDirectoryList;
    private _additionalLoginParameters;
    get additionalLoginParameters(): cdktf.StringMap;
    get allowedExternalRedirectUrls(): string[];
    get defaultProvider(): string;
    get enabled(): cdktf.IResolvable;
    private _facebook;
    get facebook(): DataAzurermLinuxFunctionAppAuthSettingsFacebookList;
    private _github;
    get github(): DataAzurermLinuxFunctionAppAuthSettingsGithubList;
    private _google;
    get google(): DataAzurermLinuxFunctionAppAuthSettingsGoogleList;
    get issuer(): string;
    private _microsoft;
    get microsoft(): DataAzurermLinuxFunctionAppAuthSettingsMicrosoftList;
    get runtimeVersion(): string;
    get tokenRefreshExtensionHours(): number;
    get tokenStoreEnabled(): cdktf.IResolvable;
    private _twitter;
    get twitter(): DataAzurermLinuxFunctionAppAuthSettingsTwitterList;
    get unauthenticatedClientAction(): string;
}
export declare class DataAzurermLinuxFunctionAppAuthSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppAuthSettingsOutputReference;
}
export interface DataAzurermLinuxFunctionAppAuthSettingsV2ActiveDirectoryV2 {
}
export declare function dataAzurermLinuxFunctionAppAuthSettingsV2ActiveDirectoryV2ToTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsV2ActiveDirectoryV2): any;
export declare function dataAzurermLinuxFunctionAppAuthSettingsV2ActiveDirectoryV2ToHclTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsV2ActiveDirectoryV2): any;
export declare class DataAzurermLinuxFunctionAppAuthSettingsV2ActiveDirectoryV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppAuthSettingsV2ActiveDirectoryV2 | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppAuthSettingsV2ActiveDirectoryV2 | undefined);
    get allowedApplications(): string[];
    get allowedAudiences(): string[];
    get allowedGroups(): string[];
    get allowedIdentities(): string[];
    get clientId(): string;
    get clientSecretCertificateThumbprint(): string;
    get clientSecretSettingName(): string;
    get jwtAllowedClientApplications(): string[];
    get jwtAllowedGroups(): string[];
    private _loginParameters;
    get loginParameters(): cdktf.StringMap;
    get tenantAuthEndpoint(): string;
    get wwwAuthenticationDisabled(): cdktf.IResolvable;
}
export declare class DataAzurermLinuxFunctionAppAuthSettingsV2ActiveDirectoryV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppAuthSettingsV2ActiveDirectoryV2OutputReference;
}
export interface DataAzurermLinuxFunctionAppAuthSettingsV2AppleV2 {
}
export declare function dataAzurermLinuxFunctionAppAuthSettingsV2AppleV2ToTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsV2AppleV2): any;
export declare function dataAzurermLinuxFunctionAppAuthSettingsV2AppleV2ToHclTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsV2AppleV2): any;
export declare class DataAzurermLinuxFunctionAppAuthSettingsV2AppleV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppAuthSettingsV2AppleV2 | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppAuthSettingsV2AppleV2 | undefined);
    get clientId(): string;
    get clientSecretSettingName(): string;
    get loginScopes(): string[];
}
export declare class DataAzurermLinuxFunctionAppAuthSettingsV2AppleV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppAuthSettingsV2AppleV2OutputReference;
}
export interface DataAzurermLinuxFunctionAppAuthSettingsV2AzureStaticWebAppV2 {
}
export declare function dataAzurermLinuxFunctionAppAuthSettingsV2AzureStaticWebAppV2ToTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsV2AzureStaticWebAppV2): any;
export declare function dataAzurermLinuxFunctionAppAuthSettingsV2AzureStaticWebAppV2ToHclTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsV2AzureStaticWebAppV2): any;
export declare class DataAzurermLinuxFunctionAppAuthSettingsV2AzureStaticWebAppV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppAuthSettingsV2AzureStaticWebAppV2 | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppAuthSettingsV2AzureStaticWebAppV2 | undefined);
    get clientId(): string;
}
export declare class DataAzurermLinuxFunctionAppAuthSettingsV2AzureStaticWebAppV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppAuthSettingsV2AzureStaticWebAppV2OutputReference;
}
export interface DataAzurermLinuxFunctionAppAuthSettingsV2CustomOidcV2 {
}
export declare function dataAzurermLinuxFunctionAppAuthSettingsV2CustomOidcV2ToTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsV2CustomOidcV2): any;
export declare function dataAzurermLinuxFunctionAppAuthSettingsV2CustomOidcV2ToHclTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsV2CustomOidcV2): any;
export declare class DataAzurermLinuxFunctionAppAuthSettingsV2CustomOidcV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppAuthSettingsV2CustomOidcV2 | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppAuthSettingsV2CustomOidcV2 | undefined);
    get authorisationEndpoint(): string;
    get certificationUri(): string;
    get clientCredentialMethod(): string;
    get clientId(): string;
    get clientSecretSettingName(): string;
    get issuerEndpoint(): string;
    get name(): string;
    get nameClaimType(): string;
    get openidConfigurationEndpoint(): string;
    get scopes(): string[];
    get tokenEndpoint(): string;
}
export declare class DataAzurermLinuxFunctionAppAuthSettingsV2CustomOidcV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppAuthSettingsV2CustomOidcV2OutputReference;
}
export interface DataAzurermLinuxFunctionAppAuthSettingsV2FacebookV2 {
}
export declare function dataAzurermLinuxFunctionAppAuthSettingsV2FacebookV2ToTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsV2FacebookV2): any;
export declare function dataAzurermLinuxFunctionAppAuthSettingsV2FacebookV2ToHclTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsV2FacebookV2): any;
export declare class DataAzurermLinuxFunctionAppAuthSettingsV2FacebookV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppAuthSettingsV2FacebookV2 | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppAuthSettingsV2FacebookV2 | undefined);
    get appId(): string;
    get appSecretSettingName(): string;
    get graphApiVersion(): string;
    get loginScopes(): string[];
}
export declare class DataAzurermLinuxFunctionAppAuthSettingsV2FacebookV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppAuthSettingsV2FacebookV2OutputReference;
}
export interface DataAzurermLinuxFunctionAppAuthSettingsV2GithubV2 {
}
export declare function dataAzurermLinuxFunctionAppAuthSettingsV2GithubV2ToTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsV2GithubV2): any;
export declare function dataAzurermLinuxFunctionAppAuthSettingsV2GithubV2ToHclTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsV2GithubV2): any;
export declare class DataAzurermLinuxFunctionAppAuthSettingsV2GithubV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppAuthSettingsV2GithubV2 | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppAuthSettingsV2GithubV2 | undefined);
    get clientId(): string;
    get clientSecretSettingName(): string;
    get loginScopes(): string[];
}
export declare class DataAzurermLinuxFunctionAppAuthSettingsV2GithubV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppAuthSettingsV2GithubV2OutputReference;
}
export interface DataAzurermLinuxFunctionAppAuthSettingsV2GoogleV2 {
}
export declare function dataAzurermLinuxFunctionAppAuthSettingsV2GoogleV2ToTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsV2GoogleV2): any;
export declare function dataAzurermLinuxFunctionAppAuthSettingsV2GoogleV2ToHclTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsV2GoogleV2): any;
export declare class DataAzurermLinuxFunctionAppAuthSettingsV2GoogleV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppAuthSettingsV2GoogleV2 | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppAuthSettingsV2GoogleV2 | undefined);
    get allowedAudiences(): string[];
    get clientId(): string;
    get clientSecretSettingName(): string;
    get loginScopes(): string[];
}
export declare class DataAzurermLinuxFunctionAppAuthSettingsV2GoogleV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppAuthSettingsV2GoogleV2OutputReference;
}
export interface DataAzurermLinuxFunctionAppAuthSettingsV2Login {
}
export declare function dataAzurermLinuxFunctionAppAuthSettingsV2LoginToTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsV2Login): any;
export declare function dataAzurermLinuxFunctionAppAuthSettingsV2LoginToHclTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsV2Login): any;
export declare class DataAzurermLinuxFunctionAppAuthSettingsV2LoginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppAuthSettingsV2Login | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppAuthSettingsV2Login | undefined);
    get allowedExternalRedirectUrls(): string[];
    get cookieExpirationConvention(): string;
    get cookieExpirationTime(): string;
    get logoutEndpoint(): string;
    get nonceExpirationTime(): string;
    get preserveUrlFragmentsForLogins(): cdktf.IResolvable;
    get tokenRefreshExtensionTime(): number;
    get tokenStoreEnabled(): cdktf.IResolvable;
    get tokenStorePath(): string;
    get tokenStoreSasSettingName(): string;
    get validateNonce(): cdktf.IResolvable;
}
export declare class DataAzurermLinuxFunctionAppAuthSettingsV2LoginList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppAuthSettingsV2LoginOutputReference;
}
export interface DataAzurermLinuxFunctionAppAuthSettingsV2MicrosoftV2 {
}
export declare function dataAzurermLinuxFunctionAppAuthSettingsV2MicrosoftV2ToTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsV2MicrosoftV2): any;
export declare function dataAzurermLinuxFunctionAppAuthSettingsV2MicrosoftV2ToHclTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsV2MicrosoftV2): any;
export declare class DataAzurermLinuxFunctionAppAuthSettingsV2MicrosoftV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppAuthSettingsV2MicrosoftV2 | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppAuthSettingsV2MicrosoftV2 | undefined);
    get allowedAudiences(): string[];
    get clientId(): string;
    get clientSecretSettingName(): string;
    get loginScopes(): string[];
}
export declare class DataAzurermLinuxFunctionAppAuthSettingsV2MicrosoftV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppAuthSettingsV2MicrosoftV2OutputReference;
}
export interface DataAzurermLinuxFunctionAppAuthSettingsV2TwitterV2 {
}
export declare function dataAzurermLinuxFunctionAppAuthSettingsV2TwitterV2ToTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsV2TwitterV2): any;
export declare function dataAzurermLinuxFunctionAppAuthSettingsV2TwitterV2ToHclTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsV2TwitterV2): any;
export declare class DataAzurermLinuxFunctionAppAuthSettingsV2TwitterV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppAuthSettingsV2TwitterV2 | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppAuthSettingsV2TwitterV2 | undefined);
    get consumerKey(): string;
    get consumerSecretSettingName(): string;
}
export declare class DataAzurermLinuxFunctionAppAuthSettingsV2TwitterV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppAuthSettingsV2TwitterV2OutputReference;
}
export interface DataAzurermLinuxFunctionAppAuthSettingsV2 {
}
export declare function dataAzurermLinuxFunctionAppAuthSettingsV2ToTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsV2): any;
export declare function dataAzurermLinuxFunctionAppAuthSettingsV2ToHclTerraform(struct?: DataAzurermLinuxFunctionAppAuthSettingsV2): any;
export declare class DataAzurermLinuxFunctionAppAuthSettingsV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppAuthSettingsV2 | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppAuthSettingsV2 | undefined);
    private _activeDirectoryV2;
    get activeDirectoryV2(): DataAzurermLinuxFunctionAppAuthSettingsV2ActiveDirectoryV2List;
    private _appleV2;
    get appleV2(): DataAzurermLinuxFunctionAppAuthSettingsV2AppleV2List;
    get authEnabled(): cdktf.IResolvable;
    private _azureStaticWebAppV2;
    get azureStaticWebAppV2(): DataAzurermLinuxFunctionAppAuthSettingsV2AzureStaticWebAppV2List;
    get configFilePath(): string;
    private _customOidcV2;
    get customOidcV2(): DataAzurermLinuxFunctionAppAuthSettingsV2CustomOidcV2List;
    get defaultProvider(): string;
    get excludedPaths(): string[];
    private _facebookV2;
    get facebookV2(): DataAzurermLinuxFunctionAppAuthSettingsV2FacebookV2List;
    get forwardProxyConvention(): string;
    get forwardProxyCustomHostHeaderName(): string;
    get forwardProxyCustomSchemeHeaderName(): string;
    private _githubV2;
    get githubV2(): DataAzurermLinuxFunctionAppAuthSettingsV2GithubV2List;
    private _googleV2;
    get googleV2(): DataAzurermLinuxFunctionAppAuthSettingsV2GoogleV2List;
    get httpRouteApiPrefix(): string;
    private _login;
    get login(): DataAzurermLinuxFunctionAppAuthSettingsV2LoginList;
    private _microsoftV2;
    get microsoftV2(): DataAzurermLinuxFunctionAppAuthSettingsV2MicrosoftV2List;
    get requireAuthentication(): cdktf.IResolvable;
    get requireHttps(): cdktf.IResolvable;
    get runtimeVersion(): string;
    private _twitterV2;
    get twitterV2(): DataAzurermLinuxFunctionAppAuthSettingsV2TwitterV2List;
    get unauthenticatedAction(): string;
}
export declare class DataAzurermLinuxFunctionAppAuthSettingsV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppAuthSettingsV2OutputReference;
}
export interface DataAzurermLinuxFunctionAppBackupSchedule {
}
export declare function dataAzurermLinuxFunctionAppBackupScheduleToTerraform(struct?: DataAzurermLinuxFunctionAppBackupSchedule): any;
export declare function dataAzurermLinuxFunctionAppBackupScheduleToHclTerraform(struct?: DataAzurermLinuxFunctionAppBackupSchedule): any;
export declare class DataAzurermLinuxFunctionAppBackupScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppBackupSchedule | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppBackupSchedule | undefined);
    get frequencyInterval(): number;
    get frequencyUnit(): string;
    get keepAtLeastOneBackup(): cdktf.IResolvable;
    get lastExecutionTime(): string;
    get retentionPeriodDays(): number;
    get startTime(): string;
}
export declare class DataAzurermLinuxFunctionAppBackupScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppBackupScheduleOutputReference;
}
export interface DataAzurermLinuxFunctionAppBackup {
}
export declare function dataAzurermLinuxFunctionAppBackupToTerraform(struct?: DataAzurermLinuxFunctionAppBackup): any;
export declare function dataAzurermLinuxFunctionAppBackupToHclTerraform(struct?: DataAzurermLinuxFunctionAppBackup): any;
export declare class DataAzurermLinuxFunctionAppBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppBackup | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppBackup | undefined);
    get enabled(): cdktf.IResolvable;
    get name(): string;
    private _schedule;
    get schedule(): DataAzurermLinuxFunctionAppBackupScheduleList;
    get storageAccountUrl(): string;
}
export declare class DataAzurermLinuxFunctionAppBackupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppBackupOutputReference;
}
export interface DataAzurermLinuxFunctionAppConnectionString {
}
export declare function dataAzurermLinuxFunctionAppConnectionStringToTerraform(struct?: DataAzurermLinuxFunctionAppConnectionString): any;
export declare function dataAzurermLinuxFunctionAppConnectionStringToHclTerraform(struct?: DataAzurermLinuxFunctionAppConnectionString): any;
export declare class DataAzurermLinuxFunctionAppConnectionStringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppConnectionString | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppConnectionString | undefined);
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class DataAzurermLinuxFunctionAppConnectionStringList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppConnectionStringOutputReference;
}
export interface DataAzurermLinuxFunctionAppIdentity {
}
export declare function dataAzurermLinuxFunctionAppIdentityToTerraform(struct?: DataAzurermLinuxFunctionAppIdentity): any;
export declare function dataAzurermLinuxFunctionAppIdentityToHclTerraform(struct?: DataAzurermLinuxFunctionAppIdentity): any;
export declare class DataAzurermLinuxFunctionAppIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppIdentity | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermLinuxFunctionAppIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppIdentityOutputReference;
}
export interface DataAzurermLinuxFunctionAppSiteConfigAppServiceLogs {
}
export declare function dataAzurermLinuxFunctionAppSiteConfigAppServiceLogsToTerraform(struct?: DataAzurermLinuxFunctionAppSiteConfigAppServiceLogs): any;
export declare function dataAzurermLinuxFunctionAppSiteConfigAppServiceLogsToHclTerraform(struct?: DataAzurermLinuxFunctionAppSiteConfigAppServiceLogs): any;
export declare class DataAzurermLinuxFunctionAppSiteConfigAppServiceLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppSiteConfigAppServiceLogs | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppSiteConfigAppServiceLogs | undefined);
    get diskQuotaMb(): number;
    get retentionPeriodDays(): number;
}
export declare class DataAzurermLinuxFunctionAppSiteConfigAppServiceLogsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppSiteConfigAppServiceLogsOutputReference;
}
export interface DataAzurermLinuxFunctionAppSiteConfigApplicationStackDocker {
}
export declare function dataAzurermLinuxFunctionAppSiteConfigApplicationStackDockerToTerraform(struct?: DataAzurermLinuxFunctionAppSiteConfigApplicationStackDocker): any;
export declare function dataAzurermLinuxFunctionAppSiteConfigApplicationStackDockerToHclTerraform(struct?: DataAzurermLinuxFunctionAppSiteConfigApplicationStackDocker): any;
export declare class DataAzurermLinuxFunctionAppSiteConfigApplicationStackDockerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppSiteConfigApplicationStackDocker | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppSiteConfigApplicationStackDocker | undefined);
    get imageName(): string;
    get imageTag(): string;
    get registryPassword(): string;
    get registryUrl(): string;
    get registryUsername(): string;
}
export declare class DataAzurermLinuxFunctionAppSiteConfigApplicationStackDockerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppSiteConfigApplicationStackDockerOutputReference;
}
export interface DataAzurermLinuxFunctionAppSiteConfigApplicationStack {
}
export declare function dataAzurermLinuxFunctionAppSiteConfigApplicationStackToTerraform(struct?: DataAzurermLinuxFunctionAppSiteConfigApplicationStack): any;
export declare function dataAzurermLinuxFunctionAppSiteConfigApplicationStackToHclTerraform(struct?: DataAzurermLinuxFunctionAppSiteConfigApplicationStack): any;
export declare class DataAzurermLinuxFunctionAppSiteConfigApplicationStackOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppSiteConfigApplicationStack | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppSiteConfigApplicationStack | undefined);
    private _docker;
    get docker(): DataAzurermLinuxFunctionAppSiteConfigApplicationStackDockerList;
    get dotnetVersion(): string;
    get javaVersion(): string;
    get nodeVersion(): string;
    get powershellCoreVersion(): string;
    get pythonVersion(): string;
    get useCustomRuntime(): cdktf.IResolvable;
    get useDotnetIsolatedRuntime(): cdktf.IResolvable;
}
export declare class DataAzurermLinuxFunctionAppSiteConfigApplicationStackList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppSiteConfigApplicationStackOutputReference;
}
export interface DataAzurermLinuxFunctionAppSiteConfigCors {
}
export declare function dataAzurermLinuxFunctionAppSiteConfigCorsToTerraform(struct?: DataAzurermLinuxFunctionAppSiteConfigCors): any;
export declare function dataAzurermLinuxFunctionAppSiteConfigCorsToHclTerraform(struct?: DataAzurermLinuxFunctionAppSiteConfigCors): any;
export declare class DataAzurermLinuxFunctionAppSiteConfigCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppSiteConfigCors | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppSiteConfigCors | undefined);
    get allowedOrigins(): string[];
    get supportCredentials(): cdktf.IResolvable;
}
export declare class DataAzurermLinuxFunctionAppSiteConfigCorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppSiteConfigCorsOutputReference;
}
export interface DataAzurermLinuxFunctionAppSiteConfigIpRestrictionHeaders {
}
export declare function dataAzurermLinuxFunctionAppSiteConfigIpRestrictionHeadersToTerraform(struct?: DataAzurermLinuxFunctionAppSiteConfigIpRestrictionHeaders): any;
export declare function dataAzurermLinuxFunctionAppSiteConfigIpRestrictionHeadersToHclTerraform(struct?: DataAzurermLinuxFunctionAppSiteConfigIpRestrictionHeaders): any;
export declare class DataAzurermLinuxFunctionAppSiteConfigIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppSiteConfigIpRestrictionHeaders | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppSiteConfigIpRestrictionHeaders | undefined);
    get xAzureFdid(): string[];
    get xFdHealthProbe(): string[];
    get xForwardedFor(): string[];
    get xForwardedHost(): string[];
}
export declare class DataAzurermLinuxFunctionAppSiteConfigIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppSiteConfigIpRestrictionHeadersOutputReference;
}
export interface DataAzurermLinuxFunctionAppSiteConfigIpRestriction {
}
export declare function dataAzurermLinuxFunctionAppSiteConfigIpRestrictionToTerraform(struct?: DataAzurermLinuxFunctionAppSiteConfigIpRestriction): any;
export declare function dataAzurermLinuxFunctionAppSiteConfigIpRestrictionToHclTerraform(struct?: DataAzurermLinuxFunctionAppSiteConfigIpRestriction): any;
export declare class DataAzurermLinuxFunctionAppSiteConfigIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppSiteConfigIpRestriction | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppSiteConfigIpRestriction | undefined);
    get action(): string;
    get description(): string;
    private _headers;
    get headers(): DataAzurermLinuxFunctionAppSiteConfigIpRestrictionHeadersList;
    get ipAddress(): string;
    get name(): string;
    get priority(): number;
    get serviceTag(): string;
    get virtualNetworkSubnetId(): string;
}
export declare class DataAzurermLinuxFunctionAppSiteConfigIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppSiteConfigIpRestrictionOutputReference;
}
export interface DataAzurermLinuxFunctionAppSiteConfigScmIpRestrictionHeaders {
}
export declare function dataAzurermLinuxFunctionAppSiteConfigScmIpRestrictionHeadersToTerraform(struct?: DataAzurermLinuxFunctionAppSiteConfigScmIpRestrictionHeaders): any;
export declare function dataAzurermLinuxFunctionAppSiteConfigScmIpRestrictionHeadersToHclTerraform(struct?: DataAzurermLinuxFunctionAppSiteConfigScmIpRestrictionHeaders): any;
export declare class DataAzurermLinuxFunctionAppSiteConfigScmIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppSiteConfigScmIpRestrictionHeaders | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppSiteConfigScmIpRestrictionHeaders | undefined);
    get xAzureFdid(): string[];
    get xFdHealthProbe(): string[];
    get xForwardedFor(): string[];
    get xForwardedHost(): string[];
}
export declare class DataAzurermLinuxFunctionAppSiteConfigScmIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppSiteConfigScmIpRestrictionHeadersOutputReference;
}
export interface DataAzurermLinuxFunctionAppSiteConfigScmIpRestriction {
}
export declare function dataAzurermLinuxFunctionAppSiteConfigScmIpRestrictionToTerraform(struct?: DataAzurermLinuxFunctionAppSiteConfigScmIpRestriction): any;
export declare function dataAzurermLinuxFunctionAppSiteConfigScmIpRestrictionToHclTerraform(struct?: DataAzurermLinuxFunctionAppSiteConfigScmIpRestriction): any;
export declare class DataAzurermLinuxFunctionAppSiteConfigScmIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppSiteConfigScmIpRestriction | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppSiteConfigScmIpRestriction | undefined);
    get action(): string;
    get description(): string;
    private _headers;
    get headers(): DataAzurermLinuxFunctionAppSiteConfigScmIpRestrictionHeadersList;
    get ipAddress(): string;
    get name(): string;
    get priority(): number;
    get serviceTag(): string;
    get virtualNetworkSubnetId(): string;
}
export declare class DataAzurermLinuxFunctionAppSiteConfigScmIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppSiteConfigScmIpRestrictionOutputReference;
}
export interface DataAzurermLinuxFunctionAppSiteConfig {
}
export declare function dataAzurermLinuxFunctionAppSiteConfigToTerraform(struct?: DataAzurermLinuxFunctionAppSiteConfig): any;
export declare function dataAzurermLinuxFunctionAppSiteConfigToHclTerraform(struct?: DataAzurermLinuxFunctionAppSiteConfig): any;
export declare class DataAzurermLinuxFunctionAppSiteConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppSiteConfig | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppSiteConfig | undefined);
    get alwaysOn(): cdktf.IResolvable;
    get apiDefinitionUrl(): string;
    get apiManagementApiId(): string;
    get appCommandLine(): string;
    get appScaleLimit(): number;
    private _appServiceLogs;
    get appServiceLogs(): DataAzurermLinuxFunctionAppSiteConfigAppServiceLogsList;
    get applicationInsightsConnectionString(): string;
    get applicationInsightsKey(): string;
    private _applicationStack;
    get applicationStack(): DataAzurermLinuxFunctionAppSiteConfigApplicationStackList;
    get containerRegistryManagedIdentityClientId(): string;
    get containerRegistryUseManagedIdentity(): cdktf.IResolvable;
    private _cors;
    get cors(): DataAzurermLinuxFunctionAppSiteConfigCorsList;
    get defaultDocuments(): string[];
    get detailedErrorLoggingEnabled(): cdktf.IResolvable;
    get elasticInstanceMinimum(): number;
    get ftpsState(): string;
    get healthCheckEvictionTimeInMin(): number;
    get healthCheckPath(): string;
    get http2Enabled(): cdktf.IResolvable;
    private _ipRestriction;
    get ipRestriction(): DataAzurermLinuxFunctionAppSiteConfigIpRestrictionList;
    get ipRestrictionDefaultAction(): string;
    get linuxFxVersion(): string;
    get loadBalancingMode(): string;
    get managedPipelineMode(): string;
    get minimumTlsVersion(): string;
    get preWarmedInstanceCount(): number;
    get remoteDebuggingEnabled(): cdktf.IResolvable;
    get remoteDebuggingVersion(): string;
    get runtimeScaleMonitoringEnabled(): cdktf.IResolvable;
    private _scmIpRestriction;
    get scmIpRestriction(): DataAzurermLinuxFunctionAppSiteConfigScmIpRestrictionList;
    get scmIpRestrictionDefaultAction(): string;
    get scmMinimumTlsVersion(): string;
    get scmType(): string;
    get scmUseMainIpRestriction(): cdktf.IResolvable;
    get use32BitWorker(): cdktf.IResolvable;
    get vnetRouteAllEnabled(): cdktf.IResolvable;
    get websocketsEnabled(): cdktf.IResolvable;
    get workerCount(): number;
}
export declare class DataAzurermLinuxFunctionAppSiteConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppSiteConfigOutputReference;
}
export interface DataAzurermLinuxFunctionAppSiteCredential {
}
export declare function dataAzurermLinuxFunctionAppSiteCredentialToTerraform(struct?: DataAzurermLinuxFunctionAppSiteCredential): any;
export declare function dataAzurermLinuxFunctionAppSiteCredentialToHclTerraform(struct?: DataAzurermLinuxFunctionAppSiteCredential): any;
export declare class DataAzurermLinuxFunctionAppSiteCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppSiteCredential | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppSiteCredential | undefined);
    get name(): string;
    get password(): string;
}
export declare class DataAzurermLinuxFunctionAppSiteCredentialList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppSiteCredentialOutputReference;
}
export interface DataAzurermLinuxFunctionAppStickySettings {
}
export declare function dataAzurermLinuxFunctionAppStickySettingsToTerraform(struct?: DataAzurermLinuxFunctionAppStickySettings): any;
export declare function dataAzurermLinuxFunctionAppStickySettingsToHclTerraform(struct?: DataAzurermLinuxFunctionAppStickySettings): any;
export declare class DataAzurermLinuxFunctionAppStickySettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxFunctionAppStickySettings | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppStickySettings | undefined);
    get appSettingNames(): string[];
    get connectionStringNames(): string[];
}
export declare class DataAzurermLinuxFunctionAppStickySettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxFunctionAppStickySettingsOutputReference;
}
export interface DataAzurermLinuxFunctionAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/linux_function_app#read DataAzurermLinuxFunctionApp#read}
    */
    readonly read?: string;
}
export declare function dataAzurermLinuxFunctionAppTimeoutsToTerraform(struct?: DataAzurermLinuxFunctionAppTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermLinuxFunctionAppTimeoutsToHclTerraform(struct?: DataAzurermLinuxFunctionAppTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermLinuxFunctionAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermLinuxFunctionAppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermLinuxFunctionAppTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/linux_function_app azurerm_linux_function_app}
*/
export declare class DataAzurermLinuxFunctionApp extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_linux_function_app";
    /**
    * Generates CDKTF code for importing a DataAzurermLinuxFunctionApp resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermLinuxFunctionApp to import
    * @param importFromId The id of the existing DataAzurermLinuxFunctionApp that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/linux_function_app#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermLinuxFunctionApp to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/linux_function_app azurerm_linux_function_app} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermLinuxFunctionAppConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermLinuxFunctionAppConfig);
    private _appSettings;
    get appSettings(): cdktf.StringMap;
    private _authSettings;
    get authSettings(): DataAzurermLinuxFunctionAppAuthSettingsList;
    private _authSettingsV2;
    get authSettingsV2(): DataAzurermLinuxFunctionAppAuthSettingsV2List;
    get availability(): string;
    private _backup;
    get backup(): DataAzurermLinuxFunctionAppBackupList;
    get builtinLoggingEnabled(): cdktf.IResolvable;
    get clientCertificateEnabled(): cdktf.IResolvable;
    get clientCertificateExclusionPaths(): string;
    get clientCertificateMode(): string;
    private _connectionString;
    get connectionString(): DataAzurermLinuxFunctionAppConnectionStringList;
    get contentShareForceDisabled(): cdktf.IResolvable;
    get customDomainVerificationId(): string;
    get dailyMemoryTimeQuota(): number;
    get defaultHostname(): string;
    get enabled(): cdktf.IResolvable;
    get ftpPublishBasicAuthenticationEnabled(): cdktf.IResolvable;
    get functionsExtensionVersion(): string;
    get hostingEnvironmentId(): string;
    get httpsOnly(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermLinuxFunctionAppIdentityList;
    get kind(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundIpAddressList(): string[];
    get outboundIpAddresses(): string;
    get possibleOutboundIpAddressList(): string[];
    get possibleOutboundIpAddresses(): string;
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get servicePlanId(): string;
    private _siteConfig;
    get siteConfig(): DataAzurermLinuxFunctionAppSiteConfigList;
    private _siteCredential;
    get siteCredential(): DataAzurermLinuxFunctionAppSiteCredentialList;
    private _stickySettings;
    get stickySettings(): DataAzurermLinuxFunctionAppStickySettingsList;
    get storageAccountAccessKey(): string;
    get storageAccountName(): string;
    get storageKeyVaultSecretId(): string;
    get storageUsesManagedIdentity(): cdktf.IResolvable;
    private _tags;
    get tags(): cdktf.StringMap;
    get usage(): string;
    get virtualNetworkSubnetId(): string;
    get webdeployPublishBasicAuthenticationEnabled(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermLinuxFunctionAppTimeoutsOutputReference;
    putTimeouts(value: DataAzurermLinuxFunctionAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermLinuxFunctionAppTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
