/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPrivateDnsResolverInboundEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/private_dns_resolver_inbound_endpoint#id DataAzurermPrivateDnsResolverInboundEndpoint#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/private_dns_resolver_inbound_endpoint#name DataAzurermPrivateDnsResolverInboundEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/private_dns_resolver_inbound_endpoint#private_dns_resolver_id DataAzurermPrivateDnsResolverInboundEndpoint#private_dns_resolver_id}
    */
    readonly privateDnsResolverId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/private_dns_resolver_inbound_endpoint#timeouts DataAzurermPrivateDnsResolverInboundEndpoint#timeouts}
    */
    readonly timeouts?: DataAzurermPrivateDnsResolverInboundEndpointTimeouts;
}
export interface DataAzurermPrivateDnsResolverInboundEndpointIpConfigurations {
}
export declare function dataAzurermPrivateDnsResolverInboundEndpointIpConfigurationsToTerraform(struct?: DataAzurermPrivateDnsResolverInboundEndpointIpConfigurations): any;
export declare function dataAzurermPrivateDnsResolverInboundEndpointIpConfigurationsToHclTerraform(struct?: DataAzurermPrivateDnsResolverInboundEndpointIpConfigurations): any;
export declare class DataAzurermPrivateDnsResolverInboundEndpointIpConfigurationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermPrivateDnsResolverInboundEndpointIpConfigurations | undefined;
    set internalValue(value: DataAzurermPrivateDnsResolverInboundEndpointIpConfigurations | undefined);
    get privateIpAddress(): string;
    get privateIpAllocationMethod(): string;
    get subnetId(): string;
}
export declare class DataAzurermPrivateDnsResolverInboundEndpointIpConfigurationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermPrivateDnsResolverInboundEndpointIpConfigurationsOutputReference;
}
export interface DataAzurermPrivateDnsResolverInboundEndpointTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/private_dns_resolver_inbound_endpoint#read DataAzurermPrivateDnsResolverInboundEndpoint#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPrivateDnsResolverInboundEndpointTimeoutsToTerraform(struct?: DataAzurermPrivateDnsResolverInboundEndpointTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermPrivateDnsResolverInboundEndpointTimeoutsToHclTerraform(struct?: DataAzurermPrivateDnsResolverInboundEndpointTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPrivateDnsResolverInboundEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermPrivateDnsResolverInboundEndpointTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermPrivateDnsResolverInboundEndpointTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/private_dns_resolver_inbound_endpoint azurerm_private_dns_resolver_inbound_endpoint}
*/
export declare class DataAzurermPrivateDnsResolverInboundEndpoint extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_private_dns_resolver_inbound_endpoint";
    /**
    * Generates CDKTF code for importing a DataAzurermPrivateDnsResolverInboundEndpoint resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermPrivateDnsResolverInboundEndpoint to import
    * @param importFromId The id of the existing DataAzurermPrivateDnsResolverInboundEndpoint that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/private_dns_resolver_inbound_endpoint#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermPrivateDnsResolverInboundEndpoint to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/private_dns_resolver_inbound_endpoint azurerm_private_dns_resolver_inbound_endpoint} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPrivateDnsResolverInboundEndpointConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPrivateDnsResolverInboundEndpointConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipConfigurations;
    get ipConfigurations(): DataAzurermPrivateDnsResolverInboundEndpointIpConfigurationsList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privateDnsResolverId?;
    get privateDnsResolverId(): string;
    set privateDnsResolverId(value: string);
    get privateDnsResolverIdInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermPrivateDnsResolverInboundEndpointTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPrivateDnsResolverInboundEndpointTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermPrivateDnsResolverInboundEndpointTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
