/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermStreamAnalyticsJobConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/stream_analytics_job#id DataAzurermStreamAnalyticsJob#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/stream_analytics_job#name DataAzurermStreamAnalyticsJob#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/stream_analytics_job#resource_group_name DataAzurermStreamAnalyticsJob#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/stream_analytics_job#timeouts DataAzurermStreamAnalyticsJob#timeouts}
    */
    readonly timeouts?: DataAzurermStreamAnalyticsJobTimeouts;
}
export interface DataAzurermStreamAnalyticsJobIdentity {
}
export declare function dataAzurermStreamAnalyticsJobIdentityToTerraform(struct?: DataAzurermStreamAnalyticsJobIdentity): any;
export declare function dataAzurermStreamAnalyticsJobIdentityToHclTerraform(struct?: DataAzurermStreamAnalyticsJobIdentity): any;
export declare class DataAzurermStreamAnalyticsJobIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermStreamAnalyticsJobIdentity | undefined;
    set internalValue(value: DataAzurermStreamAnalyticsJobIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermStreamAnalyticsJobIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermStreamAnalyticsJobIdentityOutputReference;
}
export interface DataAzurermStreamAnalyticsJobTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/stream_analytics_job#read DataAzurermStreamAnalyticsJob#read}
    */
    readonly read?: string;
}
export declare function dataAzurermStreamAnalyticsJobTimeoutsToTerraform(struct?: DataAzurermStreamAnalyticsJobTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermStreamAnalyticsJobTimeoutsToHclTerraform(struct?: DataAzurermStreamAnalyticsJobTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermStreamAnalyticsJobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermStreamAnalyticsJobTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermStreamAnalyticsJobTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/stream_analytics_job azurerm_stream_analytics_job}
*/
export declare class DataAzurermStreamAnalyticsJob extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_stream_analytics_job";
    /**
    * Generates CDKTF code for importing a DataAzurermStreamAnalyticsJob resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermStreamAnalyticsJob to import
    * @param importFromId The id of the existing DataAzurermStreamAnalyticsJob that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/stream_analytics_job#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermStreamAnalyticsJob to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/data-sources/stream_analytics_job azurerm_stream_analytics_job} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermStreamAnalyticsJobConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermStreamAnalyticsJobConfig);
    get compatibilityLevel(): string;
    get dataLocale(): string;
    get eventsLateArrivalMaxDelayInSeconds(): number;
    get eventsOutOfOrderMaxDelayInSeconds(): number;
    get eventsOutOfOrderPolicy(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermStreamAnalyticsJobIdentityList;
    get jobId(): string;
    get lastOutputTime(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outputErrorPolicy(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get skuName(): string;
    get startMode(): string;
    get startTime(): string;
    get streamingUnits(): number;
    get transformationQuery(): string;
    private _timeouts;
    get timeouts(): DataAzurermStreamAnalyticsJobTimeoutsOutputReference;
    putTimeouts(value: DataAzurermStreamAnalyticsJobTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermStreamAnalyticsJobTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
