/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataFactoryLinkedServiceSqlServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server#additional_properties DataFactoryLinkedServiceSqlServer#additional_properties}
    */
    readonly additionalProperties?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server#annotations DataFactoryLinkedServiceSqlServer#annotations}
    */
    readonly annotations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server#connection_string DataFactoryLinkedServiceSqlServer#connection_string}
    */
    readonly connectionString?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server#data_factory_id DataFactoryLinkedServiceSqlServer#data_factory_id}
    */
    readonly dataFactoryId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server#description DataFactoryLinkedServiceSqlServer#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server#id DataFactoryLinkedServiceSqlServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server#integration_runtime_name DataFactoryLinkedServiceSqlServer#integration_runtime_name}
    */
    readonly integrationRuntimeName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server#name DataFactoryLinkedServiceSqlServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server#parameters DataFactoryLinkedServiceSqlServer#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server#user_name DataFactoryLinkedServiceSqlServer#user_name}
    */
    readonly userName?: string;
    /**
    * key_vault_connection_string block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server#key_vault_connection_string DataFactoryLinkedServiceSqlServer#key_vault_connection_string}
    */
    readonly keyVaultConnectionString?: DataFactoryLinkedServiceSqlServerKeyVaultConnectionString;
    /**
    * key_vault_password block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server#key_vault_password DataFactoryLinkedServiceSqlServer#key_vault_password}
    */
    readonly keyVaultPassword?: DataFactoryLinkedServiceSqlServerKeyVaultPassword;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server#timeouts DataFactoryLinkedServiceSqlServer#timeouts}
    */
    readonly timeouts?: DataFactoryLinkedServiceSqlServerTimeouts;
}
export interface DataFactoryLinkedServiceSqlServerKeyVaultConnectionString {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server#linked_service_name DataFactoryLinkedServiceSqlServer#linked_service_name}
    */
    readonly linkedServiceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server#secret_name DataFactoryLinkedServiceSqlServer#secret_name}
    */
    readonly secretName: string;
}
export declare function dataFactoryLinkedServiceSqlServerKeyVaultConnectionStringToTerraform(struct?: DataFactoryLinkedServiceSqlServerKeyVaultConnectionStringOutputReference | DataFactoryLinkedServiceSqlServerKeyVaultConnectionString): any;
export declare function dataFactoryLinkedServiceSqlServerKeyVaultConnectionStringToHclTerraform(struct?: DataFactoryLinkedServiceSqlServerKeyVaultConnectionStringOutputReference | DataFactoryLinkedServiceSqlServerKeyVaultConnectionString): any;
export declare class DataFactoryLinkedServiceSqlServerKeyVaultConnectionStringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryLinkedServiceSqlServerKeyVaultConnectionString | undefined;
    set internalValue(value: DataFactoryLinkedServiceSqlServerKeyVaultConnectionString | undefined);
    private _linkedServiceName?;
    get linkedServiceName(): string;
    set linkedServiceName(value: string);
    get linkedServiceNameInput(): string | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    get secretNameInput(): string | undefined;
}
export interface DataFactoryLinkedServiceSqlServerKeyVaultPassword {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server#linked_service_name DataFactoryLinkedServiceSqlServer#linked_service_name}
    */
    readonly linkedServiceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server#secret_name DataFactoryLinkedServiceSqlServer#secret_name}
    */
    readonly secretName: string;
}
export declare function dataFactoryLinkedServiceSqlServerKeyVaultPasswordToTerraform(struct?: DataFactoryLinkedServiceSqlServerKeyVaultPasswordOutputReference | DataFactoryLinkedServiceSqlServerKeyVaultPassword): any;
export declare function dataFactoryLinkedServiceSqlServerKeyVaultPasswordToHclTerraform(struct?: DataFactoryLinkedServiceSqlServerKeyVaultPasswordOutputReference | DataFactoryLinkedServiceSqlServerKeyVaultPassword): any;
export declare class DataFactoryLinkedServiceSqlServerKeyVaultPasswordOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryLinkedServiceSqlServerKeyVaultPassword | undefined;
    set internalValue(value: DataFactoryLinkedServiceSqlServerKeyVaultPassword | undefined);
    private _linkedServiceName?;
    get linkedServiceName(): string;
    set linkedServiceName(value: string);
    get linkedServiceNameInput(): string | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    get secretNameInput(): string | undefined;
}
export interface DataFactoryLinkedServiceSqlServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server#create DataFactoryLinkedServiceSqlServer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server#delete DataFactoryLinkedServiceSqlServer#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server#read DataFactoryLinkedServiceSqlServer#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server#update DataFactoryLinkedServiceSqlServer#update}
    */
    readonly update?: string;
}
export declare function dataFactoryLinkedServiceSqlServerTimeoutsToTerraform(struct?: DataFactoryLinkedServiceSqlServerTimeouts | cdktf.IResolvable): any;
export declare function dataFactoryLinkedServiceSqlServerTimeoutsToHclTerraform(struct?: DataFactoryLinkedServiceSqlServerTimeouts | cdktf.IResolvable): any;
export declare class DataFactoryLinkedServiceSqlServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryLinkedServiceSqlServerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryLinkedServiceSqlServerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server azurerm_data_factory_linked_service_sql_server}
*/
export declare class DataFactoryLinkedServiceSqlServer extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_data_factory_linked_service_sql_server";
    /**
    * Generates CDKTF code for importing a DataFactoryLinkedServiceSqlServer resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataFactoryLinkedServiceSqlServer to import
    * @param importFromId The id of the existing DataFactoryLinkedServiceSqlServer that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataFactoryLinkedServiceSqlServer to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_factory_linked_service_sql_server azurerm_data_factory_linked_service_sql_server} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataFactoryLinkedServiceSqlServerConfig
    */
    constructor(scope: Construct, id: string, config: DataFactoryLinkedServiceSqlServerConfig);
    private _additionalProperties?;
    get additionalProperties(): {
        [key: string]: string;
    };
    set additionalProperties(value: {
        [key: string]: string;
    });
    resetAdditionalProperties(): void;
    get additionalPropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    get annotations(): string[];
    set annotations(value: string[]);
    resetAnnotations(): void;
    get annotationsInput(): string[] | undefined;
    private _connectionString?;
    get connectionString(): string;
    set connectionString(value: string);
    resetConnectionString(): void;
    get connectionStringInput(): string | undefined;
    private _dataFactoryId?;
    get dataFactoryId(): string;
    set dataFactoryId(value: string);
    get dataFactoryIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _integrationRuntimeName?;
    get integrationRuntimeName(): string;
    set integrationRuntimeName(value: string);
    resetIntegrationRuntimeName(): void;
    get integrationRuntimeNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _userName?;
    get userName(): string;
    set userName(value: string);
    resetUserName(): void;
    get userNameInput(): string | undefined;
    private _keyVaultConnectionString;
    get keyVaultConnectionString(): DataFactoryLinkedServiceSqlServerKeyVaultConnectionStringOutputReference;
    putKeyVaultConnectionString(value: DataFactoryLinkedServiceSqlServerKeyVaultConnectionString): void;
    resetKeyVaultConnectionString(): void;
    get keyVaultConnectionStringInput(): DataFactoryLinkedServiceSqlServerKeyVaultConnectionString | undefined;
    private _keyVaultPassword;
    get keyVaultPassword(): DataFactoryLinkedServiceSqlServerKeyVaultPasswordOutputReference;
    putKeyVaultPassword(value: DataFactoryLinkedServiceSqlServerKeyVaultPassword): void;
    resetKeyVaultPassword(): void;
    get keyVaultPasswordInput(): DataFactoryLinkedServiceSqlServerKeyVaultPassword | undefined;
    private _timeouts;
    get timeouts(): DataFactoryLinkedServiceSqlServerTimeoutsOutputReference;
    putTimeouts(value: DataFactoryLinkedServiceSqlServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataFactoryLinkedServiceSqlServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
