/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataProtectionBackupInstanceKubernetesClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_protection_backup_instance_kubernetes_cluster#backup_policy_id DataProtectionBackupInstanceKubernetesCluster#backup_policy_id}
    */
    readonly backupPolicyId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_protection_backup_instance_kubernetes_cluster#id DataProtectionBackupInstanceKubernetesCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_protection_backup_instance_kubernetes_cluster#kubernetes_cluster_id DataProtectionBackupInstanceKubernetesCluster#kubernetes_cluster_id}
    */
    readonly kubernetesClusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_protection_backup_instance_kubernetes_cluster#location DataProtectionBackupInstanceKubernetesCluster#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_protection_backup_instance_kubernetes_cluster#name DataProtectionBackupInstanceKubernetesCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_protection_backup_instance_kubernetes_cluster#snapshot_resource_group_name DataProtectionBackupInstanceKubernetesCluster#snapshot_resource_group_name}
    */
    readonly snapshotResourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_protection_backup_instance_kubernetes_cluster#vault_id DataProtectionBackupInstanceKubernetesCluster#vault_id}
    */
    readonly vaultId: string;
    /**
    * backup_datasource_parameters block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_protection_backup_instance_kubernetes_cluster#backup_datasource_parameters DataProtectionBackupInstanceKubernetesCluster#backup_datasource_parameters}
    */
    readonly backupDatasourceParameters?: DataProtectionBackupInstanceKubernetesClusterBackupDatasourceParameters;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_protection_backup_instance_kubernetes_cluster#timeouts DataProtectionBackupInstanceKubernetesCluster#timeouts}
    */
    readonly timeouts?: DataProtectionBackupInstanceKubernetesClusterTimeouts;
}
export interface DataProtectionBackupInstanceKubernetesClusterBackupDatasourceParameters {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_protection_backup_instance_kubernetes_cluster#cluster_scoped_resources_enabled DataProtectionBackupInstanceKubernetesCluster#cluster_scoped_resources_enabled}
    */
    readonly clusterScopedResourcesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_protection_backup_instance_kubernetes_cluster#excluded_namespaces DataProtectionBackupInstanceKubernetesCluster#excluded_namespaces}
    */
    readonly excludedNamespaces?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_protection_backup_instance_kubernetes_cluster#excluded_resource_types DataProtectionBackupInstanceKubernetesCluster#excluded_resource_types}
    */
    readonly excludedResourceTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_protection_backup_instance_kubernetes_cluster#included_namespaces DataProtectionBackupInstanceKubernetesCluster#included_namespaces}
    */
    readonly includedNamespaces?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_protection_backup_instance_kubernetes_cluster#included_resource_types DataProtectionBackupInstanceKubernetesCluster#included_resource_types}
    */
    readonly includedResourceTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_protection_backup_instance_kubernetes_cluster#label_selectors DataProtectionBackupInstanceKubernetesCluster#label_selectors}
    */
    readonly labelSelectors?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_protection_backup_instance_kubernetes_cluster#volume_snapshot_enabled DataProtectionBackupInstanceKubernetesCluster#volume_snapshot_enabled}
    */
    readonly volumeSnapshotEnabled?: boolean | cdktf.IResolvable;
}
export declare function dataProtectionBackupInstanceKubernetesClusterBackupDatasourceParametersToTerraform(struct?: DataProtectionBackupInstanceKubernetesClusterBackupDatasourceParametersOutputReference | DataProtectionBackupInstanceKubernetesClusterBackupDatasourceParameters): any;
export declare function dataProtectionBackupInstanceKubernetesClusterBackupDatasourceParametersToHclTerraform(struct?: DataProtectionBackupInstanceKubernetesClusterBackupDatasourceParametersOutputReference | DataProtectionBackupInstanceKubernetesClusterBackupDatasourceParameters): any;
export declare class DataProtectionBackupInstanceKubernetesClusterBackupDatasourceParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataProtectionBackupInstanceKubernetesClusterBackupDatasourceParameters | undefined;
    set internalValue(value: DataProtectionBackupInstanceKubernetesClusterBackupDatasourceParameters | undefined);
    private _clusterScopedResourcesEnabled?;
    get clusterScopedResourcesEnabled(): boolean | cdktf.IResolvable;
    set clusterScopedResourcesEnabled(value: boolean | cdktf.IResolvable);
    resetClusterScopedResourcesEnabled(): void;
    get clusterScopedResourcesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _excludedNamespaces?;
    get excludedNamespaces(): string[];
    set excludedNamespaces(value: string[]);
    resetExcludedNamespaces(): void;
    get excludedNamespacesInput(): string[] | undefined;
    private _excludedResourceTypes?;
    get excludedResourceTypes(): string[];
    set excludedResourceTypes(value: string[]);
    resetExcludedResourceTypes(): void;
    get excludedResourceTypesInput(): string[] | undefined;
    private _includedNamespaces?;
    get includedNamespaces(): string[];
    set includedNamespaces(value: string[]);
    resetIncludedNamespaces(): void;
    get includedNamespacesInput(): string[] | undefined;
    private _includedResourceTypes?;
    get includedResourceTypes(): string[];
    set includedResourceTypes(value: string[]);
    resetIncludedResourceTypes(): void;
    get includedResourceTypesInput(): string[] | undefined;
    private _labelSelectors?;
    get labelSelectors(): string[];
    set labelSelectors(value: string[]);
    resetLabelSelectors(): void;
    get labelSelectorsInput(): string[] | undefined;
    private _volumeSnapshotEnabled?;
    get volumeSnapshotEnabled(): boolean | cdktf.IResolvable;
    set volumeSnapshotEnabled(value: boolean | cdktf.IResolvable);
    resetVolumeSnapshotEnabled(): void;
    get volumeSnapshotEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DataProtectionBackupInstanceKubernetesClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_protection_backup_instance_kubernetes_cluster#create DataProtectionBackupInstanceKubernetesCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_protection_backup_instance_kubernetes_cluster#delete DataProtectionBackupInstanceKubernetesCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_protection_backup_instance_kubernetes_cluster#read DataProtectionBackupInstanceKubernetesCluster#read}
    */
    readonly read?: string;
}
export declare function dataProtectionBackupInstanceKubernetesClusterTimeoutsToTerraform(struct?: DataProtectionBackupInstanceKubernetesClusterTimeouts | cdktf.IResolvable): any;
export declare function dataProtectionBackupInstanceKubernetesClusterTimeoutsToHclTerraform(struct?: DataProtectionBackupInstanceKubernetesClusterTimeouts | cdktf.IResolvable): any;
export declare class DataProtectionBackupInstanceKubernetesClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataProtectionBackupInstanceKubernetesClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataProtectionBackupInstanceKubernetesClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_protection_backup_instance_kubernetes_cluster azurerm_data_protection_backup_instance_kubernetes_cluster}
*/
export declare class DataProtectionBackupInstanceKubernetesCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_data_protection_backup_instance_kubernetes_cluster";
    /**
    * Generates CDKTF code for importing a DataProtectionBackupInstanceKubernetesCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataProtectionBackupInstanceKubernetesCluster to import
    * @param importFromId The id of the existing DataProtectionBackupInstanceKubernetesCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_protection_backup_instance_kubernetes_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataProtectionBackupInstanceKubernetesCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/data_protection_backup_instance_kubernetes_cluster azurerm_data_protection_backup_instance_kubernetes_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataProtectionBackupInstanceKubernetesClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataProtectionBackupInstanceKubernetesClusterConfig);
    private _backupPolicyId?;
    get backupPolicyId(): string;
    set backupPolicyId(value: string);
    get backupPolicyIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kubernetesClusterId?;
    get kubernetesClusterId(): string;
    set kubernetesClusterId(value: string);
    get kubernetesClusterIdInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _snapshotResourceGroupName?;
    get snapshotResourceGroupName(): string;
    set snapshotResourceGroupName(value: string);
    get snapshotResourceGroupNameInput(): string | undefined;
    private _vaultId?;
    get vaultId(): string;
    set vaultId(value: string);
    get vaultIdInput(): string | undefined;
    private _backupDatasourceParameters;
    get backupDatasourceParameters(): DataProtectionBackupInstanceKubernetesClusterBackupDatasourceParametersOutputReference;
    putBackupDatasourceParameters(value: DataProtectionBackupInstanceKubernetesClusterBackupDatasourceParameters): void;
    resetBackupDatasourceParameters(): void;
    get backupDatasourceParametersInput(): DataProtectionBackupInstanceKubernetesClusterBackupDatasourceParameters | undefined;
    private _timeouts;
    get timeouts(): DataProtectionBackupInstanceKubernetesClusterTimeoutsOutputReference;
    putTimeouts(value: DataProtectionBackupInstanceKubernetesClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataProtectionBackupInstanceKubernetesClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
