/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DevCenterProjectEnvironmentTypeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_center_project_environment_type#creator_role_assignment_roles DevCenterProjectEnvironmentType#creator_role_assignment_roles}
    */
    readonly creatorRoleAssignmentRoles?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_center_project_environment_type#deployment_target_id DevCenterProjectEnvironmentType#deployment_target_id}
    */
    readonly deploymentTargetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_center_project_environment_type#dev_center_project_id DevCenterProjectEnvironmentType#dev_center_project_id}
    */
    readonly devCenterProjectId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_center_project_environment_type#id DevCenterProjectEnvironmentType#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_center_project_environment_type#location DevCenterProjectEnvironmentType#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_center_project_environment_type#name DevCenterProjectEnvironmentType#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_center_project_environment_type#tags DevCenterProjectEnvironmentType#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_center_project_environment_type#identity DevCenterProjectEnvironmentType#identity}
    */
    readonly identity: DevCenterProjectEnvironmentTypeIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_center_project_environment_type#timeouts DevCenterProjectEnvironmentType#timeouts}
    */
    readonly timeouts?: DevCenterProjectEnvironmentTypeTimeouts;
    /**
    * user_role_assignment block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_center_project_environment_type#user_role_assignment DevCenterProjectEnvironmentType#user_role_assignment}
    */
    readonly userRoleAssignment?: DevCenterProjectEnvironmentTypeUserRoleAssignment[] | cdktf.IResolvable;
}
export interface DevCenterProjectEnvironmentTypeIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_center_project_environment_type#identity_ids DevCenterProjectEnvironmentType#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_center_project_environment_type#type DevCenterProjectEnvironmentType#type}
    */
    readonly type: string;
}
export declare function devCenterProjectEnvironmentTypeIdentityToTerraform(struct?: DevCenterProjectEnvironmentTypeIdentityOutputReference | DevCenterProjectEnvironmentTypeIdentity): any;
export declare function devCenterProjectEnvironmentTypeIdentityToHclTerraform(struct?: DevCenterProjectEnvironmentTypeIdentityOutputReference | DevCenterProjectEnvironmentTypeIdentity): any;
export declare class DevCenterProjectEnvironmentTypeIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DevCenterProjectEnvironmentTypeIdentity | undefined;
    set internalValue(value: DevCenterProjectEnvironmentTypeIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface DevCenterProjectEnvironmentTypeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_center_project_environment_type#create DevCenterProjectEnvironmentType#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_center_project_environment_type#delete DevCenterProjectEnvironmentType#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_center_project_environment_type#read DevCenterProjectEnvironmentType#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_center_project_environment_type#update DevCenterProjectEnvironmentType#update}
    */
    readonly update?: string;
}
export declare function devCenterProjectEnvironmentTypeTimeoutsToTerraform(struct?: DevCenterProjectEnvironmentTypeTimeouts | cdktf.IResolvable): any;
export declare function devCenterProjectEnvironmentTypeTimeoutsToHclTerraform(struct?: DevCenterProjectEnvironmentTypeTimeouts | cdktf.IResolvable): any;
export declare class DevCenterProjectEnvironmentTypeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DevCenterProjectEnvironmentTypeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DevCenterProjectEnvironmentTypeTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface DevCenterProjectEnvironmentTypeUserRoleAssignment {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_center_project_environment_type#roles DevCenterProjectEnvironmentType#roles}
    */
    readonly roles: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_center_project_environment_type#user_id DevCenterProjectEnvironmentType#user_id}
    */
    readonly userId: string;
}
export declare function devCenterProjectEnvironmentTypeUserRoleAssignmentToTerraform(struct?: DevCenterProjectEnvironmentTypeUserRoleAssignment | cdktf.IResolvable): any;
export declare function devCenterProjectEnvironmentTypeUserRoleAssignmentToHclTerraform(struct?: DevCenterProjectEnvironmentTypeUserRoleAssignment | cdktf.IResolvable): any;
export declare class DevCenterProjectEnvironmentTypeUserRoleAssignmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DevCenterProjectEnvironmentTypeUserRoleAssignment | cdktf.IResolvable | undefined;
    set internalValue(value: DevCenterProjectEnvironmentTypeUserRoleAssignment | cdktf.IResolvable | undefined);
    private _roles?;
    get roles(): string[];
    set roles(value: string[]);
    get rolesInput(): string[] | undefined;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    get userIdInput(): string | undefined;
}
export declare class DevCenterProjectEnvironmentTypeUserRoleAssignmentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DevCenterProjectEnvironmentTypeUserRoleAssignment[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DevCenterProjectEnvironmentTypeUserRoleAssignmentOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_center_project_environment_type azurerm_dev_center_project_environment_type}
*/
export declare class DevCenterProjectEnvironmentType extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_dev_center_project_environment_type";
    /**
    * Generates CDKTF code for importing a DevCenterProjectEnvironmentType resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DevCenterProjectEnvironmentType to import
    * @param importFromId The id of the existing DevCenterProjectEnvironmentType that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_center_project_environment_type#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DevCenterProjectEnvironmentType to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_center_project_environment_type azurerm_dev_center_project_environment_type} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DevCenterProjectEnvironmentTypeConfig
    */
    constructor(scope: Construct, id: string, config: DevCenterProjectEnvironmentTypeConfig);
    private _creatorRoleAssignmentRoles?;
    get creatorRoleAssignmentRoles(): string[];
    set creatorRoleAssignmentRoles(value: string[]);
    resetCreatorRoleAssignmentRoles(): void;
    get creatorRoleAssignmentRolesInput(): string[] | undefined;
    private _deploymentTargetId?;
    get deploymentTargetId(): string;
    set deploymentTargetId(value: string);
    get deploymentTargetIdInput(): string | undefined;
    private _devCenterProjectId?;
    get devCenterProjectId(): string;
    set devCenterProjectId(value: string);
    get devCenterProjectIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _identity;
    get identity(): DevCenterProjectEnvironmentTypeIdentityOutputReference;
    putIdentity(value: DevCenterProjectEnvironmentTypeIdentity): void;
    get identityInput(): DevCenterProjectEnvironmentTypeIdentity | undefined;
    private _timeouts;
    get timeouts(): DevCenterProjectEnvironmentTypeTimeoutsOutputReference;
    putTimeouts(value: DevCenterProjectEnvironmentTypeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DevCenterProjectEnvironmentTypeTimeouts | undefined;
    private _userRoleAssignment;
    get userRoleAssignment(): DevCenterProjectEnvironmentTypeUserRoleAssignmentList;
    putUserRoleAssignment(value: DevCenterProjectEnvironmentTypeUserRoleAssignment[] | cdktf.IResolvable): void;
    resetUserRoleAssignment(): void;
    get userRoleAssignmentInput(): cdktf.IResolvable | DevCenterProjectEnvironmentTypeUserRoleAssignment[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
