/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DevTestWindowsVirtualMachineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#allow_claim DevTestWindowsVirtualMachine#allow_claim}
    */
    readonly allowClaim?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#disallow_public_ip_address DevTestWindowsVirtualMachine#disallow_public_ip_address}
    */
    readonly disallowPublicIpAddress?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#id DevTestWindowsVirtualMachine#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#lab_name DevTestWindowsVirtualMachine#lab_name}
    */
    readonly labName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#lab_subnet_name DevTestWindowsVirtualMachine#lab_subnet_name}
    */
    readonly labSubnetName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#lab_virtual_network_id DevTestWindowsVirtualMachine#lab_virtual_network_id}
    */
    readonly labVirtualNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#location DevTestWindowsVirtualMachine#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#name DevTestWindowsVirtualMachine#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#notes DevTestWindowsVirtualMachine#notes}
    */
    readonly notes?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#password DevTestWindowsVirtualMachine#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#resource_group_name DevTestWindowsVirtualMachine#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#size DevTestWindowsVirtualMachine#size}
    */
    readonly size: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#storage_type DevTestWindowsVirtualMachine#storage_type}
    */
    readonly storageType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#tags DevTestWindowsVirtualMachine#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#username DevTestWindowsVirtualMachine#username}
    */
    readonly username: string;
    /**
    * gallery_image_reference block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#gallery_image_reference DevTestWindowsVirtualMachine#gallery_image_reference}
    */
    readonly galleryImageReference: DevTestWindowsVirtualMachineGalleryImageReference;
    /**
    * inbound_nat_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#inbound_nat_rule DevTestWindowsVirtualMachine#inbound_nat_rule}
    */
    readonly inboundNatRule?: DevTestWindowsVirtualMachineInboundNatRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#timeouts DevTestWindowsVirtualMachine#timeouts}
    */
    readonly timeouts?: DevTestWindowsVirtualMachineTimeouts;
}
export interface DevTestWindowsVirtualMachineGalleryImageReference {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#offer DevTestWindowsVirtualMachine#offer}
    */
    readonly offer: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#publisher DevTestWindowsVirtualMachine#publisher}
    */
    readonly publisher: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#sku DevTestWindowsVirtualMachine#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#version DevTestWindowsVirtualMachine#version}
    */
    readonly version: string;
}
export declare function devTestWindowsVirtualMachineGalleryImageReferenceToTerraform(struct?: DevTestWindowsVirtualMachineGalleryImageReferenceOutputReference | DevTestWindowsVirtualMachineGalleryImageReference): any;
export declare function devTestWindowsVirtualMachineGalleryImageReferenceToHclTerraform(struct?: DevTestWindowsVirtualMachineGalleryImageReferenceOutputReference | DevTestWindowsVirtualMachineGalleryImageReference): any;
export declare class DevTestWindowsVirtualMachineGalleryImageReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DevTestWindowsVirtualMachineGalleryImageReference | undefined;
    set internalValue(value: DevTestWindowsVirtualMachineGalleryImageReference | undefined);
    private _offer?;
    get offer(): string;
    set offer(value: string);
    get offerInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export interface DevTestWindowsVirtualMachineInboundNatRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#backend_port DevTestWindowsVirtualMachine#backend_port}
    */
    readonly backendPort: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#protocol DevTestWindowsVirtualMachine#protocol}
    */
    readonly protocol: string;
}
export declare function devTestWindowsVirtualMachineInboundNatRuleToTerraform(struct?: DevTestWindowsVirtualMachineInboundNatRule | cdktf.IResolvable): any;
export declare function devTestWindowsVirtualMachineInboundNatRuleToHclTerraform(struct?: DevTestWindowsVirtualMachineInboundNatRule | cdktf.IResolvable): any;
export declare class DevTestWindowsVirtualMachineInboundNatRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DevTestWindowsVirtualMachineInboundNatRule | cdktf.IResolvable | undefined;
    set internalValue(value: DevTestWindowsVirtualMachineInboundNatRule | cdktf.IResolvable | undefined);
    private _backendPort?;
    get backendPort(): number;
    set backendPort(value: number);
    get backendPortInput(): number | undefined;
    get frontendPort(): number;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
}
export declare class DevTestWindowsVirtualMachineInboundNatRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DevTestWindowsVirtualMachineInboundNatRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DevTestWindowsVirtualMachineInboundNatRuleOutputReference;
}
export interface DevTestWindowsVirtualMachineTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#create DevTestWindowsVirtualMachine#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#delete DevTestWindowsVirtualMachine#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#read DevTestWindowsVirtualMachine#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#update DevTestWindowsVirtualMachine#update}
    */
    readonly update?: string;
}
export declare function devTestWindowsVirtualMachineTimeoutsToTerraform(struct?: DevTestWindowsVirtualMachineTimeouts | cdktf.IResolvable): any;
export declare function devTestWindowsVirtualMachineTimeoutsToHclTerraform(struct?: DevTestWindowsVirtualMachineTimeouts | cdktf.IResolvable): any;
export declare class DevTestWindowsVirtualMachineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DevTestWindowsVirtualMachineTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DevTestWindowsVirtualMachineTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine azurerm_dev_test_windows_virtual_machine}
*/
export declare class DevTestWindowsVirtualMachine extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_dev_test_windows_virtual_machine";
    /**
    * Generates CDKTF code for importing a DevTestWindowsVirtualMachine resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DevTestWindowsVirtualMachine to import
    * @param importFromId The id of the existing DevTestWindowsVirtualMachine that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DevTestWindowsVirtualMachine to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dev_test_windows_virtual_machine azurerm_dev_test_windows_virtual_machine} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DevTestWindowsVirtualMachineConfig
    */
    constructor(scope: Construct, id: string, config: DevTestWindowsVirtualMachineConfig);
    private _allowClaim?;
    get allowClaim(): boolean | cdktf.IResolvable;
    set allowClaim(value: boolean | cdktf.IResolvable);
    resetAllowClaim(): void;
    get allowClaimInput(): boolean | cdktf.IResolvable | undefined;
    private _disallowPublicIpAddress?;
    get disallowPublicIpAddress(): boolean | cdktf.IResolvable;
    set disallowPublicIpAddress(value: boolean | cdktf.IResolvable);
    resetDisallowPublicIpAddress(): void;
    get disallowPublicIpAddressInput(): boolean | cdktf.IResolvable | undefined;
    get fqdn(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labName?;
    get labName(): string;
    set labName(value: string);
    get labNameInput(): string | undefined;
    private _labSubnetName?;
    get labSubnetName(): string;
    set labSubnetName(value: string);
    get labSubnetNameInput(): string | undefined;
    private _labVirtualNetworkId?;
    get labVirtualNetworkId(): string;
    set labVirtualNetworkId(value: string);
    get labVirtualNetworkIdInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notes?;
    get notes(): string;
    set notes(value: string);
    resetNotes(): void;
    get notesInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _size?;
    get size(): string;
    set size(value: string);
    get sizeInput(): string | undefined;
    private _storageType?;
    get storageType(): string;
    set storageType(value: string);
    get storageTypeInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get uniqueIdentifier(): string;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _galleryImageReference;
    get galleryImageReference(): DevTestWindowsVirtualMachineGalleryImageReferenceOutputReference;
    putGalleryImageReference(value: DevTestWindowsVirtualMachineGalleryImageReference): void;
    get galleryImageReferenceInput(): DevTestWindowsVirtualMachineGalleryImageReference | undefined;
    private _inboundNatRule;
    get inboundNatRule(): DevTestWindowsVirtualMachineInboundNatRuleList;
    putInboundNatRule(value: DevTestWindowsVirtualMachineInboundNatRule[] | cdktf.IResolvable): void;
    resetInboundNatRule(): void;
    get inboundNatRuleInput(): cdktf.IResolvable | DevTestWindowsVirtualMachineInboundNatRule[] | undefined;
    private _timeouts;
    get timeouts(): DevTestWindowsVirtualMachineTimeoutsOutputReference;
    putTimeouts(value: DevTestWindowsVirtualMachineTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DevTestWindowsVirtualMachineTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
