/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DnsZoneConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dns_zone#id DnsZone#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dns_zone#name DnsZone#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dns_zone#resource_group_name DnsZone#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dns_zone#tags DnsZone#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * soa_record block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dns_zone#soa_record DnsZone#soa_record}
    */
    readonly soaRecord?: DnsZoneSoaRecord;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dns_zone#timeouts DnsZone#timeouts}
    */
    readonly timeouts?: DnsZoneTimeouts;
}
export interface DnsZoneSoaRecord {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dns_zone#email DnsZone#email}
    */
    readonly email: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dns_zone#expire_time DnsZone#expire_time}
    */
    readonly expireTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dns_zone#minimum_ttl DnsZone#minimum_ttl}
    */
    readonly minimumTtl?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dns_zone#refresh_time DnsZone#refresh_time}
    */
    readonly refreshTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dns_zone#retry_time DnsZone#retry_time}
    */
    readonly retryTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dns_zone#serial_number DnsZone#serial_number}
    */
    readonly serialNumber?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dns_zone#tags DnsZone#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dns_zone#ttl DnsZone#ttl}
    */
    readonly ttl?: number;
}
export declare function dnsZoneSoaRecordToTerraform(struct?: DnsZoneSoaRecordOutputReference | DnsZoneSoaRecord): any;
export declare function dnsZoneSoaRecordToHclTerraform(struct?: DnsZoneSoaRecordOutputReference | DnsZoneSoaRecord): any;
export declare class DnsZoneSoaRecordOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DnsZoneSoaRecord | undefined;
    set internalValue(value: DnsZoneSoaRecord | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _expireTime?;
    get expireTime(): number;
    set expireTime(value: number);
    resetExpireTime(): void;
    get expireTimeInput(): number | undefined;
    get fqdn(): string;
    get hostName(): string;
    private _minimumTtl?;
    get minimumTtl(): number;
    set minimumTtl(value: number);
    resetMinimumTtl(): void;
    get minimumTtlInput(): number | undefined;
    private _refreshTime?;
    get refreshTime(): number;
    set refreshTime(value: number);
    resetRefreshTime(): void;
    get refreshTimeInput(): number | undefined;
    private _retryTime?;
    get retryTime(): number;
    set retryTime(value: number);
    resetRetryTime(): void;
    get retryTimeInput(): number | undefined;
    private _serialNumber?;
    get serialNumber(): number;
    set serialNumber(value: number);
    resetSerialNumber(): void;
    get serialNumberInput(): number | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    resetTtl(): void;
    get ttlInput(): number | undefined;
}
export interface DnsZoneTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dns_zone#create DnsZone#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dns_zone#delete DnsZone#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dns_zone#read DnsZone#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dns_zone#update DnsZone#update}
    */
    readonly update?: string;
}
export declare function dnsZoneTimeoutsToTerraform(struct?: DnsZoneTimeouts | cdktf.IResolvable): any;
export declare function dnsZoneTimeoutsToHclTerraform(struct?: DnsZoneTimeouts | cdktf.IResolvable): any;
export declare class DnsZoneTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DnsZoneTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DnsZoneTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dns_zone azurerm_dns_zone}
*/
export declare class DnsZone extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_dns_zone";
    /**
    * Generates CDKTF code for importing a DnsZone resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DnsZone to import
    * @param importFromId The id of the existing DnsZone that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dns_zone#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DnsZone to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/dns_zone azurerm_dns_zone} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DnsZoneConfig
    */
    constructor(scope: Construct, id: string, config: DnsZoneConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get maxNumberOfRecordSets(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get nameServers(): string[];
    get numberOfRecordSets(): number;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _soaRecord;
    get soaRecord(): DnsZoneSoaRecordOutputReference;
    putSoaRecord(value: DnsZoneSoaRecord): void;
    resetSoaRecord(): void;
    get soaRecordInput(): DnsZoneSoaRecord | undefined;
    private _timeouts;
    get timeouts(): DnsZoneTimeoutsOutputReference;
    putTimeouts(value: DnsZoneTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DnsZoneTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
