/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IothubDpsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#allocation_policy IothubDps#allocation_policy}
    */
    readonly allocationPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#data_residency_enabled IothubDps#data_residency_enabled}
    */
    readonly dataResidencyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#id IothubDps#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#location IothubDps#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#name IothubDps#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#public_network_access_enabled IothubDps#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#resource_group_name IothubDps#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#tags IothubDps#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * ip_filter_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#ip_filter_rule IothubDps#ip_filter_rule}
    */
    readonly ipFilterRule?: IothubDpsIpFilterRule[] | cdktf.IResolvable;
    /**
    * linked_hub block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#linked_hub IothubDps#linked_hub}
    */
    readonly linkedHub?: IothubDpsLinkedHub[] | cdktf.IResolvable;
    /**
    * sku block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#sku IothubDps#sku}
    */
    readonly sku: IothubDpsSku;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#timeouts IothubDps#timeouts}
    */
    readonly timeouts?: IothubDpsTimeouts;
}
export interface IothubDpsIpFilterRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#action IothubDps#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#ip_mask IothubDps#ip_mask}
    */
    readonly ipMask: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#name IothubDps#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#target IothubDps#target}
    */
    readonly target?: string;
}
export declare function iothubDpsIpFilterRuleToTerraform(struct?: IothubDpsIpFilterRule | cdktf.IResolvable): any;
export declare function iothubDpsIpFilterRuleToHclTerraform(struct?: IothubDpsIpFilterRule | cdktf.IResolvable): any;
export declare class IothubDpsIpFilterRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IothubDpsIpFilterRule | cdktf.IResolvable | undefined;
    set internalValue(value: IothubDpsIpFilterRule | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _ipMask?;
    get ipMask(): string;
    set ipMask(value: string);
    get ipMaskInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
}
export declare class IothubDpsIpFilterRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: IothubDpsIpFilterRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IothubDpsIpFilterRuleOutputReference;
}
export interface IothubDpsLinkedHub {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#allocation_weight IothubDps#allocation_weight}
    */
    readonly allocationWeight?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#apply_allocation_policy IothubDps#apply_allocation_policy}
    */
    readonly applyAllocationPolicy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#connection_string IothubDps#connection_string}
    */
    readonly connectionString: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#location IothubDps#location}
    */
    readonly location: string;
}
export declare function iothubDpsLinkedHubToTerraform(struct?: IothubDpsLinkedHub | cdktf.IResolvable): any;
export declare function iothubDpsLinkedHubToHclTerraform(struct?: IothubDpsLinkedHub | cdktf.IResolvable): any;
export declare class IothubDpsLinkedHubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IothubDpsLinkedHub | cdktf.IResolvable | undefined;
    set internalValue(value: IothubDpsLinkedHub | cdktf.IResolvable | undefined);
    private _allocationWeight?;
    get allocationWeight(): number;
    set allocationWeight(value: number);
    resetAllocationWeight(): void;
    get allocationWeightInput(): number | undefined;
    private _applyAllocationPolicy?;
    get applyAllocationPolicy(): boolean | cdktf.IResolvable;
    set applyAllocationPolicy(value: boolean | cdktf.IResolvable);
    resetApplyAllocationPolicy(): void;
    get applyAllocationPolicyInput(): boolean | cdktf.IResolvable | undefined;
    private _connectionString?;
    get connectionString(): string;
    set connectionString(value: string);
    get connectionStringInput(): string | undefined;
    get hostname(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
}
export declare class IothubDpsLinkedHubList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: IothubDpsLinkedHub[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IothubDpsLinkedHubOutputReference;
}
export interface IothubDpsSku {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#capacity IothubDps#capacity}
    */
    readonly capacity: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#name IothubDps#name}
    */
    readonly name: string;
}
export declare function iothubDpsSkuToTerraform(struct?: IothubDpsSkuOutputReference | IothubDpsSku): any;
export declare function iothubDpsSkuToHclTerraform(struct?: IothubDpsSkuOutputReference | IothubDpsSku): any;
export declare class IothubDpsSkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IothubDpsSku | undefined;
    set internalValue(value: IothubDpsSku | undefined);
    private _capacity?;
    get capacity(): number;
    set capacity(value: number);
    get capacityInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface IothubDpsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#create IothubDps#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#delete IothubDps#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#read IothubDps#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#update IothubDps#update}
    */
    readonly update?: string;
}
export declare function iothubDpsTimeoutsToTerraform(struct?: IothubDpsTimeouts | cdktf.IResolvable): any;
export declare function iothubDpsTimeoutsToHclTerraform(struct?: IothubDpsTimeouts | cdktf.IResolvable): any;
export declare class IothubDpsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IothubDpsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: IothubDpsTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps azurerm_iothub_dps}
*/
export declare class IothubDps extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_iothub_dps";
    /**
    * Generates CDKTF code for importing a IothubDps resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the IothubDps to import
    * @param importFromId The id of the existing IothubDps that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the IothubDps to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/iothub_dps azurerm_iothub_dps} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IothubDpsConfig
    */
    constructor(scope: Construct, id: string, config: IothubDpsConfig);
    private _allocationPolicy?;
    get allocationPolicy(): string;
    set allocationPolicy(value: string);
    resetAllocationPolicy(): void;
    get allocationPolicyInput(): string | undefined;
    private _dataResidencyEnabled?;
    get dataResidencyEnabled(): boolean | cdktf.IResolvable;
    set dataResidencyEnabled(value: boolean | cdktf.IResolvable);
    resetDataResidencyEnabled(): void;
    get dataResidencyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get deviceProvisioningHostName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get idScope(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get serviceOperationsHostName(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _ipFilterRule;
    get ipFilterRule(): IothubDpsIpFilterRuleList;
    putIpFilterRule(value: IothubDpsIpFilterRule[] | cdktf.IResolvable): void;
    resetIpFilterRule(): void;
    get ipFilterRuleInput(): cdktf.IResolvable | IothubDpsIpFilterRule[] | undefined;
    private _linkedHub;
    get linkedHub(): IothubDpsLinkedHubList;
    putLinkedHub(value: IothubDpsLinkedHub[] | cdktf.IResolvable): void;
    resetLinkedHub(): void;
    get linkedHubInput(): cdktf.IResolvable | IothubDpsLinkedHub[] | undefined;
    private _sku;
    get sku(): IothubDpsSkuOutputReference;
    putSku(value: IothubDpsSku): void;
    get skuInput(): IothubDpsSku | undefined;
    private _timeouts;
    get timeouts(): IothubDpsTimeoutsOutputReference;
    putTimeouts(value: IothubDpsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | IothubDpsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
