/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ManagedApplicationDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/managed_application_definition#create_ui_definition ManagedApplicationDefinition#create_ui_definition}
    */
    readonly createUiDefinition?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/managed_application_definition#description ManagedApplicationDefinition#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/managed_application_definition#display_name ManagedApplicationDefinition#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/managed_application_definition#id ManagedApplicationDefinition#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/managed_application_definition#location ManagedApplicationDefinition#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/managed_application_definition#lock_level ManagedApplicationDefinition#lock_level}
    */
    readonly lockLevel: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/managed_application_definition#main_template ManagedApplicationDefinition#main_template}
    */
    readonly mainTemplate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/managed_application_definition#name ManagedApplicationDefinition#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/managed_application_definition#package_enabled ManagedApplicationDefinition#package_enabled}
    */
    readonly packageEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/managed_application_definition#package_file_uri ManagedApplicationDefinition#package_file_uri}
    */
    readonly packageFileUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/managed_application_definition#resource_group_name ManagedApplicationDefinition#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/managed_application_definition#tags ManagedApplicationDefinition#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * authorization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/managed_application_definition#authorization ManagedApplicationDefinition#authorization}
    */
    readonly authorization?: ManagedApplicationDefinitionAuthorization[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/managed_application_definition#timeouts ManagedApplicationDefinition#timeouts}
    */
    readonly timeouts?: ManagedApplicationDefinitionTimeouts;
}
export interface ManagedApplicationDefinitionAuthorization {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/managed_application_definition#role_definition_id ManagedApplicationDefinition#role_definition_id}
    */
    readonly roleDefinitionId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/managed_application_definition#service_principal_id ManagedApplicationDefinition#service_principal_id}
    */
    readonly servicePrincipalId: string;
}
export declare function managedApplicationDefinitionAuthorizationToTerraform(struct?: ManagedApplicationDefinitionAuthorization | cdktf.IResolvable): any;
export declare function managedApplicationDefinitionAuthorizationToHclTerraform(struct?: ManagedApplicationDefinitionAuthorization | cdktf.IResolvable): any;
export declare class ManagedApplicationDefinitionAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ManagedApplicationDefinitionAuthorization | cdktf.IResolvable | undefined;
    set internalValue(value: ManagedApplicationDefinitionAuthorization | cdktf.IResolvable | undefined);
    private _roleDefinitionId?;
    get roleDefinitionId(): string;
    set roleDefinitionId(value: string);
    get roleDefinitionIdInput(): string | undefined;
    private _servicePrincipalId?;
    get servicePrincipalId(): string;
    set servicePrincipalId(value: string);
    get servicePrincipalIdInput(): string | undefined;
}
export declare class ManagedApplicationDefinitionAuthorizationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ManagedApplicationDefinitionAuthorization[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ManagedApplicationDefinitionAuthorizationOutputReference;
}
export interface ManagedApplicationDefinitionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/managed_application_definition#create ManagedApplicationDefinition#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/managed_application_definition#delete ManagedApplicationDefinition#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/managed_application_definition#read ManagedApplicationDefinition#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/managed_application_definition#update ManagedApplicationDefinition#update}
    */
    readonly update?: string;
}
export declare function managedApplicationDefinitionTimeoutsToTerraform(struct?: ManagedApplicationDefinitionTimeouts | cdktf.IResolvable): any;
export declare function managedApplicationDefinitionTimeoutsToHclTerraform(struct?: ManagedApplicationDefinitionTimeouts | cdktf.IResolvable): any;
export declare class ManagedApplicationDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagedApplicationDefinitionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ManagedApplicationDefinitionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/managed_application_definition azurerm_managed_application_definition}
*/
export declare class ManagedApplicationDefinition extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_managed_application_definition";
    /**
    * Generates CDKTF code for importing a ManagedApplicationDefinition resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ManagedApplicationDefinition to import
    * @param importFromId The id of the existing ManagedApplicationDefinition that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/managed_application_definition#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ManagedApplicationDefinition to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/managed_application_definition azurerm_managed_application_definition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ManagedApplicationDefinitionConfig
    */
    constructor(scope: Construct, id: string, config: ManagedApplicationDefinitionConfig);
    private _createUiDefinition?;
    get createUiDefinition(): string;
    set createUiDefinition(value: string);
    resetCreateUiDefinition(): void;
    get createUiDefinitionInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _lockLevel?;
    get lockLevel(): string;
    set lockLevel(value: string);
    get lockLevelInput(): string | undefined;
    private _mainTemplate?;
    get mainTemplate(): string;
    set mainTemplate(value: string);
    resetMainTemplate(): void;
    get mainTemplateInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _packageEnabled?;
    get packageEnabled(): boolean | cdktf.IResolvable;
    set packageEnabled(value: boolean | cdktf.IResolvable);
    resetPackageEnabled(): void;
    get packageEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _packageFileUri?;
    get packageFileUri(): string;
    set packageFileUri(value: string);
    resetPackageFileUri(): void;
    get packageFileUriInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _authorization;
    get authorization(): ManagedApplicationDefinitionAuthorizationList;
    putAuthorization(value: ManagedApplicationDefinitionAuthorization[] | cdktf.IResolvable): void;
    resetAuthorization(): void;
    get authorizationInput(): cdktf.IResolvable | ManagedApplicationDefinitionAuthorization[] | undefined;
    private _timeouts;
    get timeouts(): ManagedApplicationDefinitionTimeoutsOutputReference;
    putTimeouts(value: ManagedApplicationDefinitionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ManagedApplicationDefinitionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
