/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitorAlertPrometheusRuleGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#cluster_name MonitorAlertPrometheusRuleGroup#cluster_name}
    */
    readonly clusterName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#description MonitorAlertPrometheusRuleGroup#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#id MonitorAlertPrometheusRuleGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#interval MonitorAlertPrometheusRuleGroup#interval}
    */
    readonly interval?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#location MonitorAlertPrometheusRuleGroup#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#name MonitorAlertPrometheusRuleGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#resource_group_name MonitorAlertPrometheusRuleGroup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#rule_group_enabled MonitorAlertPrometheusRuleGroup#rule_group_enabled}
    */
    readonly ruleGroupEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#scopes MonitorAlertPrometheusRuleGroup#scopes}
    */
    readonly scopes: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#tags MonitorAlertPrometheusRuleGroup#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#rule MonitorAlertPrometheusRuleGroup#rule}
    */
    readonly rule: MonitorAlertPrometheusRuleGroupRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#timeouts MonitorAlertPrometheusRuleGroup#timeouts}
    */
    readonly timeouts?: MonitorAlertPrometheusRuleGroupTimeouts;
}
export interface MonitorAlertPrometheusRuleGroupRuleAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#action_group_id MonitorAlertPrometheusRuleGroup#action_group_id}
    */
    readonly actionGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#action_properties MonitorAlertPrometheusRuleGroup#action_properties}
    */
    readonly actionProperties?: {
        [key: string]: string;
    };
}
export declare function monitorAlertPrometheusRuleGroupRuleActionToTerraform(struct?: MonitorAlertPrometheusRuleGroupRuleAction | cdktf.IResolvable): any;
export declare function monitorAlertPrometheusRuleGroupRuleActionToHclTerraform(struct?: MonitorAlertPrometheusRuleGroupRuleAction | cdktf.IResolvable): any;
export declare class MonitorAlertPrometheusRuleGroupRuleActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorAlertPrometheusRuleGroupRuleAction | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorAlertPrometheusRuleGroupRuleAction | cdktf.IResolvable | undefined);
    private _actionGroupId?;
    get actionGroupId(): string;
    set actionGroupId(value: string);
    get actionGroupIdInput(): string | undefined;
    private _actionProperties?;
    get actionProperties(): {
        [key: string]: string;
    };
    set actionProperties(value: {
        [key: string]: string;
    });
    resetActionProperties(): void;
    get actionPropertiesInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class MonitorAlertPrometheusRuleGroupRuleActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorAlertPrometheusRuleGroupRuleAction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorAlertPrometheusRuleGroupRuleActionOutputReference;
}
export interface MonitorAlertPrometheusRuleGroupRuleAlertResolution {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#auto_resolved MonitorAlertPrometheusRuleGroup#auto_resolved}
    */
    readonly autoResolved?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#time_to_resolve MonitorAlertPrometheusRuleGroup#time_to_resolve}
    */
    readonly timeToResolve?: string;
}
export declare function monitorAlertPrometheusRuleGroupRuleAlertResolutionToTerraform(struct?: MonitorAlertPrometheusRuleGroupRuleAlertResolutionOutputReference | MonitorAlertPrometheusRuleGroupRuleAlertResolution): any;
export declare function monitorAlertPrometheusRuleGroupRuleAlertResolutionToHclTerraform(struct?: MonitorAlertPrometheusRuleGroupRuleAlertResolutionOutputReference | MonitorAlertPrometheusRuleGroupRuleAlertResolution): any;
export declare class MonitorAlertPrometheusRuleGroupRuleAlertResolutionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertPrometheusRuleGroupRuleAlertResolution | undefined;
    set internalValue(value: MonitorAlertPrometheusRuleGroupRuleAlertResolution | undefined);
    private _autoResolved?;
    get autoResolved(): boolean | cdktf.IResolvable;
    set autoResolved(value: boolean | cdktf.IResolvable);
    resetAutoResolved(): void;
    get autoResolvedInput(): boolean | cdktf.IResolvable | undefined;
    private _timeToResolve?;
    get timeToResolve(): string;
    set timeToResolve(value: string);
    resetTimeToResolve(): void;
    get timeToResolveInput(): string | undefined;
}
export interface MonitorAlertPrometheusRuleGroupRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#alert MonitorAlertPrometheusRuleGroup#alert}
    */
    readonly alert?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#annotations MonitorAlertPrometheusRuleGroup#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#enabled MonitorAlertPrometheusRuleGroup#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#expression MonitorAlertPrometheusRuleGroup#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#for MonitorAlertPrometheusRuleGroup#for}
    */
    readonly for?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#labels MonitorAlertPrometheusRuleGroup#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#record MonitorAlertPrometheusRuleGroup#record}
    */
    readonly record?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#severity MonitorAlertPrometheusRuleGroup#severity}
    */
    readonly severity?: number;
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#action MonitorAlertPrometheusRuleGroup#action}
    */
    readonly action?: MonitorAlertPrometheusRuleGroupRuleAction[] | cdktf.IResolvable;
    /**
    * alert_resolution block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#alert_resolution MonitorAlertPrometheusRuleGroup#alert_resolution}
    */
    readonly alertResolution?: MonitorAlertPrometheusRuleGroupRuleAlertResolution;
}
export declare function monitorAlertPrometheusRuleGroupRuleToTerraform(struct?: MonitorAlertPrometheusRuleGroupRule | cdktf.IResolvable): any;
export declare function monitorAlertPrometheusRuleGroupRuleToHclTerraform(struct?: MonitorAlertPrometheusRuleGroupRule | cdktf.IResolvable): any;
export declare class MonitorAlertPrometheusRuleGroupRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorAlertPrometheusRuleGroupRule | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorAlertPrometheusRuleGroupRule | cdktf.IResolvable | undefined);
    private _alert?;
    get alert(): string;
    set alert(value: string);
    resetAlert(): void;
    get alertInput(): string | undefined;
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _for?;
    get for(): string;
    set for(value: string);
    resetFor(): void;
    get forInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _record?;
    get record(): string;
    set record(value: string);
    resetRecord(): void;
    get recordInput(): string | undefined;
    private _severity?;
    get severity(): number;
    set severity(value: number);
    resetSeverity(): void;
    get severityInput(): number | undefined;
    private _action;
    get action(): MonitorAlertPrometheusRuleGroupRuleActionList;
    putAction(value: MonitorAlertPrometheusRuleGroupRuleAction[] | cdktf.IResolvable): void;
    resetAction(): void;
    get actionInput(): cdktf.IResolvable | MonitorAlertPrometheusRuleGroupRuleAction[] | undefined;
    private _alertResolution;
    get alertResolution(): MonitorAlertPrometheusRuleGroupRuleAlertResolutionOutputReference;
    putAlertResolution(value: MonitorAlertPrometheusRuleGroupRuleAlertResolution): void;
    resetAlertResolution(): void;
    get alertResolutionInput(): MonitorAlertPrometheusRuleGroupRuleAlertResolution | undefined;
}
export declare class MonitorAlertPrometheusRuleGroupRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorAlertPrometheusRuleGroupRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorAlertPrometheusRuleGroupRuleOutputReference;
}
export interface MonitorAlertPrometheusRuleGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#create MonitorAlertPrometheusRuleGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#delete MonitorAlertPrometheusRuleGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#read MonitorAlertPrometheusRuleGroup#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#update MonitorAlertPrometheusRuleGroup#update}
    */
    readonly update?: string;
}
export declare function monitorAlertPrometheusRuleGroupTimeoutsToTerraform(struct?: MonitorAlertPrometheusRuleGroupTimeouts | cdktf.IResolvable): any;
export declare function monitorAlertPrometheusRuleGroupTimeoutsToHclTerraform(struct?: MonitorAlertPrometheusRuleGroupTimeouts | cdktf.IResolvable): any;
export declare class MonitorAlertPrometheusRuleGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertPrometheusRuleGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorAlertPrometheusRuleGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group azurerm_monitor_alert_prometheus_rule_group}
*/
export declare class MonitorAlertPrometheusRuleGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_monitor_alert_prometheus_rule_group";
    /**
    * Generates CDKTF code for importing a MonitorAlertPrometheusRuleGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MonitorAlertPrometheusRuleGroup to import
    * @param importFromId The id of the existing MonitorAlertPrometheusRuleGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MonitorAlertPrometheusRuleGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/monitor_alert_prometheus_rule_group azurerm_monitor_alert_prometheus_rule_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitorAlertPrometheusRuleGroupConfig
    */
    constructor(scope: Construct, id: string, config: MonitorAlertPrometheusRuleGroupConfig);
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    resetClusterName(): void;
    get clusterNameInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _interval?;
    get interval(): string;
    set interval(value: string);
    resetInterval(): void;
    get intervalInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _ruleGroupEnabled?;
    get ruleGroupEnabled(): boolean | cdktf.IResolvable;
    set ruleGroupEnabled(value: boolean | cdktf.IResolvable);
    resetRuleGroupEnabled(): void;
    get ruleGroupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    get scopesInput(): string[] | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _rule;
    get rule(): MonitorAlertPrometheusRuleGroupRuleList;
    putRule(value: MonitorAlertPrometheusRuleGroupRule[] | cdktf.IResolvable): void;
    get ruleInput(): cdktf.IResolvable | MonitorAlertPrometheusRuleGroupRule[] | undefined;
    private _timeouts;
    get timeouts(): MonitorAlertPrometheusRuleGroupTimeoutsOutputReference;
    putTimeouts(value: MonitorAlertPrometheusRuleGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MonitorAlertPrometheusRuleGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
