/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MssqlServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#administrator_login MssqlServer#administrator_login}
    */
    readonly administratorLogin?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#administrator_login_password MssqlServer#administrator_login_password}
    */
    readonly administratorLoginPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#connection_policy MssqlServer#connection_policy}
    */
    readonly connectionPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#id MssqlServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#location MssqlServer#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#minimum_tls_version MssqlServer#minimum_tls_version}
    */
    readonly minimumTlsVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#name MssqlServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#outbound_network_restriction_enabled MssqlServer#outbound_network_restriction_enabled}
    */
    readonly outboundNetworkRestrictionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#primary_user_assigned_identity_id MssqlServer#primary_user_assigned_identity_id}
    */
    readonly primaryUserAssignedIdentityId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#public_network_access_enabled MssqlServer#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#resource_group_name MssqlServer#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#tags MssqlServer#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#transparent_data_encryption_key_vault_key_id MssqlServer#transparent_data_encryption_key_vault_key_id}
    */
    readonly transparentDataEncryptionKeyVaultKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#version MssqlServer#version}
    */
    readonly version: string;
    /**
    * azuread_administrator block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#azuread_administrator MssqlServer#azuread_administrator}
    */
    readonly azureadAdministrator?: MssqlServerAzureadAdministrator;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#identity MssqlServer#identity}
    */
    readonly identity?: MssqlServerIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#timeouts MssqlServer#timeouts}
    */
    readonly timeouts?: MssqlServerTimeouts;
}
export interface MssqlServerAzureadAdministrator {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#azuread_authentication_only MssqlServer#azuread_authentication_only}
    */
    readonly azureadAuthenticationOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#login_username MssqlServer#login_username}
    */
    readonly loginUsername: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#object_id MssqlServer#object_id}
    */
    readonly objectId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#tenant_id MssqlServer#tenant_id}
    */
    readonly tenantId?: string;
}
export declare function mssqlServerAzureadAdministratorToTerraform(struct?: MssqlServerAzureadAdministratorOutputReference | MssqlServerAzureadAdministrator): any;
export declare function mssqlServerAzureadAdministratorToHclTerraform(struct?: MssqlServerAzureadAdministratorOutputReference | MssqlServerAzureadAdministrator): any;
export declare class MssqlServerAzureadAdministratorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlServerAzureadAdministrator | undefined;
    set internalValue(value: MssqlServerAzureadAdministrator | undefined);
    private _azureadAuthenticationOnly?;
    get azureadAuthenticationOnly(): boolean | cdktf.IResolvable;
    set azureadAuthenticationOnly(value: boolean | cdktf.IResolvable);
    resetAzureadAuthenticationOnly(): void;
    get azureadAuthenticationOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _loginUsername?;
    get loginUsername(): string;
    set loginUsername(value: string);
    get loginUsernameInput(): string | undefined;
    private _objectId?;
    get objectId(): string;
    set objectId(value: string);
    get objectIdInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
}
export interface MssqlServerIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#identity_ids MssqlServer#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#type MssqlServer#type}
    */
    readonly type: string;
}
export declare function mssqlServerIdentityToTerraform(struct?: MssqlServerIdentityOutputReference | MssqlServerIdentity): any;
export declare function mssqlServerIdentityToHclTerraform(struct?: MssqlServerIdentityOutputReference | MssqlServerIdentity): any;
export declare class MssqlServerIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlServerIdentity | undefined;
    set internalValue(value: MssqlServerIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface MssqlServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#create MssqlServer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#delete MssqlServer#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#read MssqlServer#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#update MssqlServer#update}
    */
    readonly update?: string;
}
export declare function mssqlServerTimeoutsToTerraform(struct?: MssqlServerTimeouts | cdktf.IResolvable): any;
export declare function mssqlServerTimeoutsToHclTerraform(struct?: MssqlServerTimeouts | cdktf.IResolvable): any;
export declare class MssqlServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlServerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MssqlServerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server azurerm_mssql_server}
*/
export declare class MssqlServer extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mssql_server";
    /**
    * Generates CDKTF code for importing a MssqlServer resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MssqlServer to import
    * @param importFromId The id of the existing MssqlServer that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MssqlServer to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/mssql_server azurerm_mssql_server} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MssqlServerConfig
    */
    constructor(scope: Construct, id: string, config: MssqlServerConfig);
    private _administratorLogin?;
    get administratorLogin(): string;
    set administratorLogin(value: string);
    resetAdministratorLogin(): void;
    get administratorLoginInput(): string | undefined;
    private _administratorLoginPassword?;
    get administratorLoginPassword(): string;
    set administratorLoginPassword(value: string);
    resetAdministratorLoginPassword(): void;
    get administratorLoginPasswordInput(): string | undefined;
    private _connectionPolicy?;
    get connectionPolicy(): string;
    set connectionPolicy(value: string);
    resetConnectionPolicy(): void;
    get connectionPolicyInput(): string | undefined;
    get fullyQualifiedDomainName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _minimumTlsVersion?;
    get minimumTlsVersion(): string;
    set minimumTlsVersion(value: string);
    resetMinimumTlsVersion(): void;
    get minimumTlsVersionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _outboundNetworkRestrictionEnabled?;
    get outboundNetworkRestrictionEnabled(): boolean | cdktf.IResolvable;
    set outboundNetworkRestrictionEnabled(value: boolean | cdktf.IResolvable);
    resetOutboundNetworkRestrictionEnabled(): void;
    get outboundNetworkRestrictionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _primaryUserAssignedIdentityId?;
    get primaryUserAssignedIdentityId(): string;
    set primaryUserAssignedIdentityId(value: string);
    resetPrimaryUserAssignedIdentityId(): void;
    get primaryUserAssignedIdentityIdInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get restorableDroppedDatabaseIds(): string[];
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _transparentDataEncryptionKeyVaultKeyId?;
    get transparentDataEncryptionKeyVaultKeyId(): string;
    set transparentDataEncryptionKeyVaultKeyId(value: string);
    resetTransparentDataEncryptionKeyVaultKeyId(): void;
    get transparentDataEncryptionKeyVaultKeyIdInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _azureadAdministrator;
    get azureadAdministrator(): MssqlServerAzureadAdministratorOutputReference;
    putAzureadAdministrator(value: MssqlServerAzureadAdministrator): void;
    resetAzureadAdministrator(): void;
    get azureadAdministratorInput(): MssqlServerAzureadAdministrator | undefined;
    private _identity;
    get identity(): MssqlServerIdentityOutputReference;
    putIdentity(value: MssqlServerIdentity): void;
    resetIdentity(): void;
    get identityInput(): MssqlServerIdentity | undefined;
    private _timeouts;
    get timeouts(): MssqlServerTimeoutsOutputReference;
    putTimeouts(value: MssqlServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MssqlServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
