/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OrchestratedVirtualMachineScaleSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#capacity_reservation_group_id OrchestratedVirtualMachineScaleSet#capacity_reservation_group_id}
    */
    readonly capacityReservationGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#encryption_at_host_enabled OrchestratedVirtualMachineScaleSet#encryption_at_host_enabled}
    */
    readonly encryptionAtHostEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#eviction_policy OrchestratedVirtualMachineScaleSet#eviction_policy}
    */
    readonly evictionPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#extension_operations_enabled OrchestratedVirtualMachineScaleSet#extension_operations_enabled}
    */
    readonly extensionOperationsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#extensions_time_budget OrchestratedVirtualMachineScaleSet#extensions_time_budget}
    */
    readonly extensionsTimeBudget?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#id OrchestratedVirtualMachineScaleSet#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#instances OrchestratedVirtualMachineScaleSet#instances}
    */
    readonly instances?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#license_type OrchestratedVirtualMachineScaleSet#license_type}
    */
    readonly licenseType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#location OrchestratedVirtualMachineScaleSet#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#max_bid_price OrchestratedVirtualMachineScaleSet#max_bid_price}
    */
    readonly maxBidPrice?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#name OrchestratedVirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#platform_fault_domain_count OrchestratedVirtualMachineScaleSet#platform_fault_domain_count}
    */
    readonly platformFaultDomainCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#priority OrchestratedVirtualMachineScaleSet#priority}
    */
    readonly priority?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#proximity_placement_group_id OrchestratedVirtualMachineScaleSet#proximity_placement_group_id}
    */
    readonly proximityPlacementGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#resource_group_name OrchestratedVirtualMachineScaleSet#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#single_placement_group OrchestratedVirtualMachineScaleSet#single_placement_group}
    */
    readonly singlePlacementGroup?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#sku_name OrchestratedVirtualMachineScaleSet#sku_name}
    */
    readonly skuName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#source_image_id OrchestratedVirtualMachineScaleSet#source_image_id}
    */
    readonly sourceImageId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#tags OrchestratedVirtualMachineScaleSet#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#user_data_base64 OrchestratedVirtualMachineScaleSet#user_data_base64}
    */
    readonly userDataBase64?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#zone_balance OrchestratedVirtualMachineScaleSet#zone_balance}
    */
    readonly zoneBalance?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#zones OrchestratedVirtualMachineScaleSet#zones}
    */
    readonly zones?: string[];
    /**
    * additional_capabilities block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#additional_capabilities OrchestratedVirtualMachineScaleSet#additional_capabilities}
    */
    readonly additionalCapabilities?: OrchestratedVirtualMachineScaleSetAdditionalCapabilities;
    /**
    * automatic_instance_repair block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#automatic_instance_repair OrchestratedVirtualMachineScaleSet#automatic_instance_repair}
    */
    readonly automaticInstanceRepair?: OrchestratedVirtualMachineScaleSetAutomaticInstanceRepair;
    /**
    * boot_diagnostics block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#boot_diagnostics OrchestratedVirtualMachineScaleSet#boot_diagnostics}
    */
    readonly bootDiagnostics?: OrchestratedVirtualMachineScaleSetBootDiagnostics;
    /**
    * data_disk block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#data_disk OrchestratedVirtualMachineScaleSet#data_disk}
    */
    readonly dataDisk?: OrchestratedVirtualMachineScaleSetDataDisk[] | cdktf.IResolvable;
    /**
    * extension block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#extension OrchestratedVirtualMachineScaleSet#extension}
    */
    readonly extension?: OrchestratedVirtualMachineScaleSetExtension[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#identity OrchestratedVirtualMachineScaleSet#identity}
    */
    readonly identity?: OrchestratedVirtualMachineScaleSetIdentity;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#network_interface OrchestratedVirtualMachineScaleSet#network_interface}
    */
    readonly networkInterface?: OrchestratedVirtualMachineScaleSetNetworkInterface[] | cdktf.IResolvable;
    /**
    * os_disk block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#os_disk OrchestratedVirtualMachineScaleSet#os_disk}
    */
    readonly osDisk?: OrchestratedVirtualMachineScaleSetOsDisk;
    /**
    * os_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#os_profile OrchestratedVirtualMachineScaleSet#os_profile}
    */
    readonly osProfile?: OrchestratedVirtualMachineScaleSetOsProfile;
    /**
    * plan block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#plan OrchestratedVirtualMachineScaleSet#plan}
    */
    readonly plan?: OrchestratedVirtualMachineScaleSetPlan;
    /**
    * priority_mix block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#priority_mix OrchestratedVirtualMachineScaleSet#priority_mix}
    */
    readonly priorityMix?: OrchestratedVirtualMachineScaleSetPriorityMix;
    /**
    * source_image_reference block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#source_image_reference OrchestratedVirtualMachineScaleSet#source_image_reference}
    */
    readonly sourceImageReference?: OrchestratedVirtualMachineScaleSetSourceImageReference;
    /**
    * termination_notification block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#termination_notification OrchestratedVirtualMachineScaleSet#termination_notification}
    */
    readonly terminationNotification?: OrchestratedVirtualMachineScaleSetTerminationNotification;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#timeouts OrchestratedVirtualMachineScaleSet#timeouts}
    */
    readonly timeouts?: OrchestratedVirtualMachineScaleSetTimeouts;
}
export interface OrchestratedVirtualMachineScaleSetAdditionalCapabilities {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#ultra_ssd_enabled OrchestratedVirtualMachineScaleSet#ultra_ssd_enabled}
    */
    readonly ultraSsdEnabled?: boolean | cdktf.IResolvable;
}
export declare function orchestratedVirtualMachineScaleSetAdditionalCapabilitiesToTerraform(struct?: OrchestratedVirtualMachineScaleSetAdditionalCapabilitiesOutputReference | OrchestratedVirtualMachineScaleSetAdditionalCapabilities): any;
export declare function orchestratedVirtualMachineScaleSetAdditionalCapabilitiesToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetAdditionalCapabilitiesOutputReference | OrchestratedVirtualMachineScaleSetAdditionalCapabilities): any;
export declare class OrchestratedVirtualMachineScaleSetAdditionalCapabilitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrchestratedVirtualMachineScaleSetAdditionalCapabilities | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetAdditionalCapabilities | undefined);
    private _ultraSsdEnabled?;
    get ultraSsdEnabled(): boolean | cdktf.IResolvable;
    set ultraSsdEnabled(value: boolean | cdktf.IResolvable);
    resetUltraSsdEnabled(): void;
    get ultraSsdEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OrchestratedVirtualMachineScaleSetAutomaticInstanceRepair {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#action OrchestratedVirtualMachineScaleSet#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#enabled OrchestratedVirtualMachineScaleSet#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#grace_period OrchestratedVirtualMachineScaleSet#grace_period}
    */
    readonly gracePeriod?: string;
}
export declare function orchestratedVirtualMachineScaleSetAutomaticInstanceRepairToTerraform(struct?: OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairOutputReference | OrchestratedVirtualMachineScaleSetAutomaticInstanceRepair): any;
export declare function orchestratedVirtualMachineScaleSetAutomaticInstanceRepairToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairOutputReference | OrchestratedVirtualMachineScaleSetAutomaticInstanceRepair): any;
export declare class OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrchestratedVirtualMachineScaleSetAutomaticInstanceRepair | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetAutomaticInstanceRepair | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _gracePeriod?;
    get gracePeriod(): string;
    set gracePeriod(value: string);
    resetGracePeriod(): void;
    get gracePeriodInput(): string | undefined;
}
export interface OrchestratedVirtualMachineScaleSetBootDiagnostics {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#storage_account_uri OrchestratedVirtualMachineScaleSet#storage_account_uri}
    */
    readonly storageAccountUri?: string;
}
export declare function orchestratedVirtualMachineScaleSetBootDiagnosticsToTerraform(struct?: OrchestratedVirtualMachineScaleSetBootDiagnosticsOutputReference | OrchestratedVirtualMachineScaleSetBootDiagnostics): any;
export declare function orchestratedVirtualMachineScaleSetBootDiagnosticsToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetBootDiagnosticsOutputReference | OrchestratedVirtualMachineScaleSetBootDiagnostics): any;
export declare class OrchestratedVirtualMachineScaleSetBootDiagnosticsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrchestratedVirtualMachineScaleSetBootDiagnostics | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetBootDiagnostics | undefined);
    private _storageAccountUri?;
    get storageAccountUri(): string;
    set storageAccountUri(value: string);
    resetStorageAccountUri(): void;
    get storageAccountUriInput(): string | undefined;
}
export interface OrchestratedVirtualMachineScaleSetDataDisk {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#caching OrchestratedVirtualMachineScaleSet#caching}
    */
    readonly caching: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#create_option OrchestratedVirtualMachineScaleSet#create_option}
    */
    readonly createOption?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#disk_encryption_set_id OrchestratedVirtualMachineScaleSet#disk_encryption_set_id}
    */
    readonly diskEncryptionSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#disk_size_gb OrchestratedVirtualMachineScaleSet#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#lun OrchestratedVirtualMachineScaleSet#lun}
    */
    readonly lun?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#storage_account_type OrchestratedVirtualMachineScaleSet#storage_account_type}
    */
    readonly storageAccountType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#ultra_ssd_disk_iops_read_write OrchestratedVirtualMachineScaleSet#ultra_ssd_disk_iops_read_write}
    */
    readonly ultraSsdDiskIopsReadWrite?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#ultra_ssd_disk_mbps_read_write OrchestratedVirtualMachineScaleSet#ultra_ssd_disk_mbps_read_write}
    */
    readonly ultraSsdDiskMbpsReadWrite?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#write_accelerator_enabled OrchestratedVirtualMachineScaleSet#write_accelerator_enabled}
    */
    readonly writeAcceleratorEnabled?: boolean | cdktf.IResolvable;
}
export declare function orchestratedVirtualMachineScaleSetDataDiskToTerraform(struct?: OrchestratedVirtualMachineScaleSetDataDisk | cdktf.IResolvable): any;
export declare function orchestratedVirtualMachineScaleSetDataDiskToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetDataDisk | cdktf.IResolvable): any;
export declare class OrchestratedVirtualMachineScaleSetDataDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OrchestratedVirtualMachineScaleSetDataDisk | cdktf.IResolvable | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetDataDisk | cdktf.IResolvable | undefined);
    private _caching?;
    get caching(): string;
    set caching(value: string);
    get cachingInput(): string | undefined;
    private _createOption?;
    get createOption(): string;
    set createOption(value: string);
    resetCreateOption(): void;
    get createOptionInput(): string | undefined;
    private _diskEncryptionSetId?;
    get diskEncryptionSetId(): string;
    set diskEncryptionSetId(value: string);
    resetDiskEncryptionSetId(): void;
    get diskEncryptionSetIdInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _lun?;
    get lun(): number;
    set lun(value: number);
    resetLun(): void;
    get lunInput(): number | undefined;
    private _storageAccountType?;
    get storageAccountType(): string;
    set storageAccountType(value: string);
    get storageAccountTypeInput(): string | undefined;
    private _ultraSsdDiskIopsReadWrite?;
    get ultraSsdDiskIopsReadWrite(): number;
    set ultraSsdDiskIopsReadWrite(value: number);
    resetUltraSsdDiskIopsReadWrite(): void;
    get ultraSsdDiskIopsReadWriteInput(): number | undefined;
    private _ultraSsdDiskMbpsReadWrite?;
    get ultraSsdDiskMbpsReadWrite(): number;
    set ultraSsdDiskMbpsReadWrite(value: number);
    resetUltraSsdDiskMbpsReadWrite(): void;
    get ultraSsdDiskMbpsReadWriteInput(): number | undefined;
    private _writeAcceleratorEnabled?;
    get writeAcceleratorEnabled(): boolean | cdktf.IResolvable;
    set writeAcceleratorEnabled(value: boolean | cdktf.IResolvable);
    resetWriteAcceleratorEnabled(): void;
    get writeAcceleratorEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class OrchestratedVirtualMachineScaleSetDataDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OrchestratedVirtualMachineScaleSetDataDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OrchestratedVirtualMachineScaleSetDataDiskOutputReference;
}
export interface OrchestratedVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#secret_url OrchestratedVirtualMachineScaleSet#secret_url}
    */
    readonly secretUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#source_vault_id OrchestratedVirtualMachineScaleSet#source_vault_id}
    */
    readonly sourceVaultId: string;
}
export declare function orchestratedVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultToTerraform(struct?: OrchestratedVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultOutputReference | OrchestratedVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault): any;
export declare function orchestratedVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultOutputReference | OrchestratedVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault): any;
export declare class OrchestratedVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrchestratedVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault | undefined);
    private _secretUrl?;
    get secretUrl(): string;
    set secretUrl(value: string);
    get secretUrlInput(): string | undefined;
    private _sourceVaultId?;
    get sourceVaultId(): string;
    set sourceVaultId(value: string);
    get sourceVaultIdInput(): string | undefined;
}
export interface OrchestratedVirtualMachineScaleSetExtension {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#auto_upgrade_minor_version_enabled OrchestratedVirtualMachineScaleSet#auto_upgrade_minor_version_enabled}
    */
    readonly autoUpgradeMinorVersionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#extensions_to_provision_after_vm_creation OrchestratedVirtualMachineScaleSet#extensions_to_provision_after_vm_creation}
    */
    readonly extensionsToProvisionAfterVmCreation?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#failure_suppression_enabled OrchestratedVirtualMachineScaleSet#failure_suppression_enabled}
    */
    readonly failureSuppressionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#force_extension_execution_on_change OrchestratedVirtualMachineScaleSet#force_extension_execution_on_change}
    */
    readonly forceExtensionExecutionOnChange?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#name OrchestratedVirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#protected_settings OrchestratedVirtualMachineScaleSet#protected_settings}
    */
    readonly protectedSettings?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#publisher OrchestratedVirtualMachineScaleSet#publisher}
    */
    readonly publisher: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#settings OrchestratedVirtualMachineScaleSet#settings}
    */
    readonly settings?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#type OrchestratedVirtualMachineScaleSet#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#type_handler_version OrchestratedVirtualMachineScaleSet#type_handler_version}
    */
    readonly typeHandlerVersion: string;
    /**
    * protected_settings_from_key_vault block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#protected_settings_from_key_vault OrchestratedVirtualMachineScaleSet#protected_settings_from_key_vault}
    */
    readonly protectedSettingsFromKeyVault?: OrchestratedVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault;
}
export declare function orchestratedVirtualMachineScaleSetExtensionToTerraform(struct?: OrchestratedVirtualMachineScaleSetExtension | cdktf.IResolvable): any;
export declare function orchestratedVirtualMachineScaleSetExtensionToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetExtension | cdktf.IResolvable): any;
export declare class OrchestratedVirtualMachineScaleSetExtensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OrchestratedVirtualMachineScaleSetExtension | cdktf.IResolvable | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetExtension | cdktf.IResolvable | undefined);
    private _autoUpgradeMinorVersionEnabled?;
    get autoUpgradeMinorVersionEnabled(): boolean | cdktf.IResolvable;
    set autoUpgradeMinorVersionEnabled(value: boolean | cdktf.IResolvable);
    resetAutoUpgradeMinorVersionEnabled(): void;
    get autoUpgradeMinorVersionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _extensionsToProvisionAfterVmCreation?;
    get extensionsToProvisionAfterVmCreation(): string[];
    set extensionsToProvisionAfterVmCreation(value: string[]);
    resetExtensionsToProvisionAfterVmCreation(): void;
    get extensionsToProvisionAfterVmCreationInput(): string[] | undefined;
    private _failureSuppressionEnabled?;
    get failureSuppressionEnabled(): boolean | cdktf.IResolvable;
    set failureSuppressionEnabled(value: boolean | cdktf.IResolvable);
    resetFailureSuppressionEnabled(): void;
    get failureSuppressionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _forceExtensionExecutionOnChange?;
    get forceExtensionExecutionOnChange(): string;
    set forceExtensionExecutionOnChange(value: string);
    resetForceExtensionExecutionOnChange(): void;
    get forceExtensionExecutionOnChangeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protectedSettings?;
    get protectedSettings(): string;
    set protectedSettings(value: string);
    resetProtectedSettings(): void;
    get protectedSettingsInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
    private _settings?;
    get settings(): string;
    set settings(value: string);
    resetSettings(): void;
    get settingsInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _typeHandlerVersion?;
    get typeHandlerVersion(): string;
    set typeHandlerVersion(value: string);
    get typeHandlerVersionInput(): string | undefined;
    private _protectedSettingsFromKeyVault;
    get protectedSettingsFromKeyVault(): OrchestratedVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultOutputReference;
    putProtectedSettingsFromKeyVault(value: OrchestratedVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault): void;
    resetProtectedSettingsFromKeyVault(): void;
    get protectedSettingsFromKeyVaultInput(): OrchestratedVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault | undefined;
}
export declare class OrchestratedVirtualMachineScaleSetExtensionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OrchestratedVirtualMachineScaleSetExtension[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OrchestratedVirtualMachineScaleSetExtensionOutputReference;
}
export interface OrchestratedVirtualMachineScaleSetIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#identity_ids OrchestratedVirtualMachineScaleSet#identity_ids}
    */
    readonly identityIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#type OrchestratedVirtualMachineScaleSet#type}
    */
    readonly type: string;
}
export declare function orchestratedVirtualMachineScaleSetIdentityToTerraform(struct?: OrchestratedVirtualMachineScaleSetIdentityOutputReference | OrchestratedVirtualMachineScaleSetIdentity): any;
export declare function orchestratedVirtualMachineScaleSetIdentityToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetIdentityOutputReference | OrchestratedVirtualMachineScaleSetIdentity): any;
export declare class OrchestratedVirtualMachineScaleSetIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrchestratedVirtualMachineScaleSetIdentity | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    get identityIdsInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#tag OrchestratedVirtualMachineScaleSet#tag}
    */
    readonly tag: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#type OrchestratedVirtualMachineScaleSet#type}
    */
    readonly type: string;
}
export declare function orchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagToTerraform(struct?: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag | cdktf.IResolvable): any;
export declare function orchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag | cdktf.IResolvable): any;
export declare class OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag | cdktf.IResolvable | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag | cdktf.IResolvable | undefined);
    private _tag?;
    get tag(): string;
    set tag(value: string);
    get tagInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagOutputReference;
}
export interface OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#domain_name_label OrchestratedVirtualMachineScaleSet#domain_name_label}
    */
    readonly domainNameLabel?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#idle_timeout_in_minutes OrchestratedVirtualMachineScaleSet#idle_timeout_in_minutes}
    */
    readonly idleTimeoutInMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#name OrchestratedVirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#public_ip_prefix_id OrchestratedVirtualMachineScaleSet#public_ip_prefix_id}
    */
    readonly publicIpPrefixId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#sku_name OrchestratedVirtualMachineScaleSet#sku_name}
    */
    readonly skuName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#version OrchestratedVirtualMachineScaleSet#version}
    */
    readonly version?: string;
    /**
    * ip_tag block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#ip_tag OrchestratedVirtualMachineScaleSet#ip_tag}
    */
    readonly ipTag?: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag[] | cdktf.IResolvable;
}
export declare function orchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressToTerraform(struct?: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress | cdktf.IResolvable): any;
export declare function orchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress | cdktf.IResolvable): any;
export declare class OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress | cdktf.IResolvable | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress | cdktf.IResolvable | undefined);
    private _domainNameLabel?;
    get domainNameLabel(): string;
    set domainNameLabel(value: string);
    resetDomainNameLabel(): void;
    get domainNameLabelInput(): string | undefined;
    private _idleTimeoutInMinutes?;
    get idleTimeoutInMinutes(): number;
    set idleTimeoutInMinutes(value: number);
    resetIdleTimeoutInMinutes(): void;
    get idleTimeoutInMinutesInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicIpPrefixId?;
    get publicIpPrefixId(): string;
    set publicIpPrefixId(value: string);
    resetPublicIpPrefixId(): void;
    get publicIpPrefixIdInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    resetSkuName(): void;
    get skuNameInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _ipTag;
    get ipTag(): OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagList;
    putIpTag(value: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag[] | cdktf.IResolvable): void;
    resetIpTag(): void;
    get ipTagInput(): cdktf.IResolvable | OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag[] | undefined;
}
export declare class OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressOutputReference;
}
export interface OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#application_gateway_backend_address_pool_ids OrchestratedVirtualMachineScaleSet#application_gateway_backend_address_pool_ids}
    */
    readonly applicationGatewayBackendAddressPoolIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#application_security_group_ids OrchestratedVirtualMachineScaleSet#application_security_group_ids}
    */
    readonly applicationSecurityGroupIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#load_balancer_backend_address_pool_ids OrchestratedVirtualMachineScaleSet#load_balancer_backend_address_pool_ids}
    */
    readonly loadBalancerBackendAddressPoolIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#name OrchestratedVirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#primary OrchestratedVirtualMachineScaleSet#primary}
    */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#subnet_id OrchestratedVirtualMachineScaleSet#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#version OrchestratedVirtualMachineScaleSet#version}
    */
    readonly version?: string;
    /**
    * public_ip_address block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#public_ip_address OrchestratedVirtualMachineScaleSet#public_ip_address}
    */
    readonly publicIpAddress?: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress[] | cdktf.IResolvable;
}
export declare function orchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationToTerraform(struct?: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfiguration | cdktf.IResolvable): any;
export declare function orchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfiguration | cdktf.IResolvable): any;
export declare class OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfiguration | cdktf.IResolvable | undefined);
    private _applicationGatewayBackendAddressPoolIds?;
    get applicationGatewayBackendAddressPoolIds(): string[];
    set applicationGatewayBackendAddressPoolIds(value: string[]);
    resetApplicationGatewayBackendAddressPoolIds(): void;
    get applicationGatewayBackendAddressPoolIdsInput(): string[] | undefined;
    private _applicationSecurityGroupIds?;
    get applicationSecurityGroupIds(): string[];
    set applicationSecurityGroupIds(value: string[]);
    resetApplicationSecurityGroupIds(): void;
    get applicationSecurityGroupIdsInput(): string[] | undefined;
    private _loadBalancerBackendAddressPoolIds?;
    get loadBalancerBackendAddressPoolIds(): string[];
    set loadBalancerBackendAddressPoolIds(value: string[]);
    resetLoadBalancerBackendAddressPoolIds(): void;
    get loadBalancerBackendAddressPoolIdsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _primary?;
    get primary(): boolean | cdktf.IResolvable;
    set primary(value: boolean | cdktf.IResolvable);
    resetPrimary(): void;
    get primaryInput(): boolean | cdktf.IResolvable | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _publicIpAddress;
    get publicIpAddress(): OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressList;
    putPublicIpAddress(value: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress[] | cdktf.IResolvable): void;
    resetPublicIpAddress(): void;
    get publicIpAddressInput(): cdktf.IResolvable | OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress[] | undefined;
}
export declare class OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationOutputReference;
}
export interface OrchestratedVirtualMachineScaleSetNetworkInterface {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#dns_servers OrchestratedVirtualMachineScaleSet#dns_servers}
    */
    readonly dnsServers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#enable_accelerated_networking OrchestratedVirtualMachineScaleSet#enable_accelerated_networking}
    */
    readonly enableAcceleratedNetworking?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#enable_ip_forwarding OrchestratedVirtualMachineScaleSet#enable_ip_forwarding}
    */
    readonly enableIpForwarding?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#name OrchestratedVirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#network_security_group_id OrchestratedVirtualMachineScaleSet#network_security_group_id}
    */
    readonly networkSecurityGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#primary OrchestratedVirtualMachineScaleSet#primary}
    */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
    * ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#ip_configuration OrchestratedVirtualMachineScaleSet#ip_configuration}
    */
    readonly ipConfiguration: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfiguration[] | cdktf.IResolvable;
}
export declare function orchestratedVirtualMachineScaleSetNetworkInterfaceToTerraform(struct?: OrchestratedVirtualMachineScaleSetNetworkInterface | cdktf.IResolvable): any;
export declare function orchestratedVirtualMachineScaleSetNetworkInterfaceToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetNetworkInterface | cdktf.IResolvable): any;
export declare class OrchestratedVirtualMachineScaleSetNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OrchestratedVirtualMachineScaleSetNetworkInterface | cdktf.IResolvable | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetNetworkInterface | cdktf.IResolvable | undefined);
    private _dnsServers?;
    get dnsServers(): string[];
    set dnsServers(value: string[]);
    resetDnsServers(): void;
    get dnsServersInput(): string[] | undefined;
    private _enableAcceleratedNetworking?;
    get enableAcceleratedNetworking(): boolean | cdktf.IResolvable;
    set enableAcceleratedNetworking(value: boolean | cdktf.IResolvable);
    resetEnableAcceleratedNetworking(): void;
    get enableAcceleratedNetworkingInput(): boolean | cdktf.IResolvable | undefined;
    private _enableIpForwarding?;
    get enableIpForwarding(): boolean | cdktf.IResolvable;
    set enableIpForwarding(value: boolean | cdktf.IResolvable);
    resetEnableIpForwarding(): void;
    get enableIpForwardingInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkSecurityGroupId?;
    get networkSecurityGroupId(): string;
    set networkSecurityGroupId(value: string);
    resetNetworkSecurityGroupId(): void;
    get networkSecurityGroupIdInput(): string | undefined;
    private _primary?;
    get primary(): boolean | cdktf.IResolvable;
    set primary(value: boolean | cdktf.IResolvable);
    resetPrimary(): void;
    get primaryInput(): boolean | cdktf.IResolvable | undefined;
    private _ipConfiguration;
    get ipConfiguration(): OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationList;
    putIpConfiguration(value: OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfiguration[] | cdktf.IResolvable): void;
    get ipConfigurationInput(): cdktf.IResolvable | OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfiguration[] | undefined;
}
export declare class OrchestratedVirtualMachineScaleSetNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OrchestratedVirtualMachineScaleSetNetworkInterface[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OrchestratedVirtualMachineScaleSetNetworkInterfaceOutputReference;
}
export interface OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#option OrchestratedVirtualMachineScaleSet#option}
    */
    readonly option: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#placement OrchestratedVirtualMachineScaleSet#placement}
    */
    readonly placement?: string;
}
export declare function orchestratedVirtualMachineScaleSetOsDiskDiffDiskSettingsToTerraform(struct?: OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettingsOutputReference | OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettings): any;
export declare function orchestratedVirtualMachineScaleSetOsDiskDiffDiskSettingsToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettingsOutputReference | OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettings): any;
export declare class OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettings | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettings | undefined);
    private _option?;
    get option(): string;
    set option(value: string);
    get optionInput(): string | undefined;
    private _placement?;
    get placement(): string;
    set placement(value: string);
    resetPlacement(): void;
    get placementInput(): string | undefined;
}
export interface OrchestratedVirtualMachineScaleSetOsDisk {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#caching OrchestratedVirtualMachineScaleSet#caching}
    */
    readonly caching: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#disk_encryption_set_id OrchestratedVirtualMachineScaleSet#disk_encryption_set_id}
    */
    readonly diskEncryptionSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#disk_size_gb OrchestratedVirtualMachineScaleSet#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#storage_account_type OrchestratedVirtualMachineScaleSet#storage_account_type}
    */
    readonly storageAccountType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#write_accelerator_enabled OrchestratedVirtualMachineScaleSet#write_accelerator_enabled}
    */
    readonly writeAcceleratorEnabled?: boolean | cdktf.IResolvable;
    /**
    * diff_disk_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#diff_disk_settings OrchestratedVirtualMachineScaleSet#diff_disk_settings}
    */
    readonly diffDiskSettings?: OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettings;
}
export declare function orchestratedVirtualMachineScaleSetOsDiskToTerraform(struct?: OrchestratedVirtualMachineScaleSetOsDiskOutputReference | OrchestratedVirtualMachineScaleSetOsDisk): any;
export declare function orchestratedVirtualMachineScaleSetOsDiskToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetOsDiskOutputReference | OrchestratedVirtualMachineScaleSetOsDisk): any;
export declare class OrchestratedVirtualMachineScaleSetOsDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrchestratedVirtualMachineScaleSetOsDisk | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetOsDisk | undefined);
    private _caching?;
    get caching(): string;
    set caching(value: string);
    get cachingInput(): string | undefined;
    private _diskEncryptionSetId?;
    get diskEncryptionSetId(): string;
    set diskEncryptionSetId(value: string);
    resetDiskEncryptionSetId(): void;
    get diskEncryptionSetIdInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _storageAccountType?;
    get storageAccountType(): string;
    set storageAccountType(value: string);
    get storageAccountTypeInput(): string | undefined;
    private _writeAcceleratorEnabled?;
    get writeAcceleratorEnabled(): boolean | cdktf.IResolvable;
    set writeAcceleratorEnabled(value: boolean | cdktf.IResolvable);
    resetWriteAcceleratorEnabled(): void;
    get writeAcceleratorEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _diffDiskSettings;
    get diffDiskSettings(): OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettingsOutputReference;
    putDiffDiskSettings(value: OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettings): void;
    resetDiffDiskSettings(): void;
    get diffDiskSettingsInput(): OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettings | undefined;
}
export interface OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKey {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#public_key OrchestratedVirtualMachineScaleSet#public_key}
    */
    readonly publicKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#username OrchestratedVirtualMachineScaleSet#username}
    */
    readonly username: string;
}
export declare function orchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKeyToTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKey | cdktf.IResolvable): any;
export declare function orchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKeyToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKey | cdktf.IResolvable): any;
export declare class OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKey | cdktf.IResolvable | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKey | cdktf.IResolvable | undefined);
    private _publicKey?;
    get publicKey(): string;
    set publicKey(value: string);
    get publicKeyInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export declare class OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKey[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKeyOutputReference;
}
export interface OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#url OrchestratedVirtualMachineScaleSet#url}
    */
    readonly url: string;
}
export declare function orchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificateToTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificate | cdktf.IResolvable): any;
export declare function orchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificateToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificate | cdktf.IResolvable): any;
export declare class OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificate | cdktf.IResolvable | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificate | cdktf.IResolvable | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export declare class OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificateOutputReference;
}
export interface OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecret {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#key_vault_id OrchestratedVirtualMachineScaleSet#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#certificate OrchestratedVirtualMachineScaleSet#certificate}
    */
    readonly certificate: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificate[] | cdktf.IResolvable;
}
export declare function orchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretToTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecret | cdktf.IResolvable): any;
export declare function orchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecret | cdktf.IResolvable): any;
export declare class OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecret | cdktf.IResolvable | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecret | cdktf.IResolvable | undefined);
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    private _certificate;
    get certificate(): OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificateList;
    putCertificate(value: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificate[] | cdktf.IResolvable): void;
    get certificateInput(): cdktf.IResolvable | OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificate[] | undefined;
}
export declare class OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecret[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretOutputReference;
}
export interface OrchestratedVirtualMachineScaleSetOsProfileLinuxConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#admin_password OrchestratedVirtualMachineScaleSet#admin_password}
    */
    readonly adminPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#admin_username OrchestratedVirtualMachineScaleSet#admin_username}
    */
    readonly adminUsername: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#computer_name_prefix OrchestratedVirtualMachineScaleSet#computer_name_prefix}
    */
    readonly computerNamePrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#disable_password_authentication OrchestratedVirtualMachineScaleSet#disable_password_authentication}
    */
    readonly disablePasswordAuthentication?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#patch_assessment_mode OrchestratedVirtualMachineScaleSet#patch_assessment_mode}
    */
    readonly patchAssessmentMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#patch_mode OrchestratedVirtualMachineScaleSet#patch_mode}
    */
    readonly patchMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#provision_vm_agent OrchestratedVirtualMachineScaleSet#provision_vm_agent}
    */
    readonly provisionVmAgent?: boolean | cdktf.IResolvable;
    /**
    * admin_ssh_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#admin_ssh_key OrchestratedVirtualMachineScaleSet#admin_ssh_key}
    */
    readonly adminSshKey?: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKey[] | cdktf.IResolvable;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#secret OrchestratedVirtualMachineScaleSet#secret}
    */
    readonly secret?: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecret[] | cdktf.IResolvable;
}
export declare function orchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationToTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationOutputReference | OrchestratedVirtualMachineScaleSetOsProfileLinuxConfiguration): any;
export declare function orchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationOutputReference | OrchestratedVirtualMachineScaleSetOsProfileLinuxConfiguration): any;
export declare class OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrchestratedVirtualMachineScaleSetOsProfileLinuxConfiguration | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfiguration | undefined);
    private _adminPassword?;
    get adminPassword(): string;
    set adminPassword(value: string);
    resetAdminPassword(): void;
    get adminPasswordInput(): string | undefined;
    private _adminUsername?;
    get adminUsername(): string;
    set adminUsername(value: string);
    get adminUsernameInput(): string | undefined;
    private _computerNamePrefix?;
    get computerNamePrefix(): string;
    set computerNamePrefix(value: string);
    resetComputerNamePrefix(): void;
    get computerNamePrefixInput(): string | undefined;
    private _disablePasswordAuthentication?;
    get disablePasswordAuthentication(): boolean | cdktf.IResolvable;
    set disablePasswordAuthentication(value: boolean | cdktf.IResolvable);
    resetDisablePasswordAuthentication(): void;
    get disablePasswordAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _patchAssessmentMode?;
    get patchAssessmentMode(): string;
    set patchAssessmentMode(value: string);
    resetPatchAssessmentMode(): void;
    get patchAssessmentModeInput(): string | undefined;
    private _patchMode?;
    get patchMode(): string;
    set patchMode(value: string);
    resetPatchMode(): void;
    get patchModeInput(): string | undefined;
    private _provisionVmAgent?;
    get provisionVmAgent(): boolean | cdktf.IResolvable;
    set provisionVmAgent(value: boolean | cdktf.IResolvable);
    resetProvisionVmAgent(): void;
    get provisionVmAgentInput(): boolean | cdktf.IResolvable | undefined;
    private _adminSshKey;
    get adminSshKey(): OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKeyList;
    putAdminSshKey(value: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKey[] | cdktf.IResolvable): void;
    resetAdminSshKey(): void;
    get adminSshKeyInput(): cdktf.IResolvable | OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKey[] | undefined;
    private _secret;
    get secret(): OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretList;
    putSecret(value: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecret[] | cdktf.IResolvable): void;
    resetSecret(): void;
    get secretInput(): cdktf.IResolvable | OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecret[] | undefined;
}
export interface OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationAdditionalUnattendContent {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#content OrchestratedVirtualMachineScaleSet#content}
    */
    readonly content: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#setting OrchestratedVirtualMachineScaleSet#setting}
    */
    readonly setting: string;
}
export declare function orchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationAdditionalUnattendContentToTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationAdditionalUnattendContent | cdktf.IResolvable): any;
export declare function orchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationAdditionalUnattendContentToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationAdditionalUnattendContent | cdktf.IResolvable): any;
export declare class OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationAdditionalUnattendContentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationAdditionalUnattendContent | cdktf.IResolvable | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationAdditionalUnattendContent | cdktf.IResolvable | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    private _setting?;
    get setting(): string;
    set setting(value: string);
    get settingInput(): string | undefined;
}
export declare class OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationAdditionalUnattendContentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationAdditionalUnattendContent[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationAdditionalUnattendContentOutputReference;
}
export interface OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#store OrchestratedVirtualMachineScaleSet#store}
    */
    readonly store: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#url OrchestratedVirtualMachineScaleSet#url}
    */
    readonly url: string;
}
export declare function orchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificateToTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificate | cdktf.IResolvable): any;
export declare function orchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificateToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificate | cdktf.IResolvable): any;
export declare class OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificate | cdktf.IResolvable | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificate | cdktf.IResolvable | undefined);
    private _store?;
    get store(): string;
    set store(value: string);
    get storeInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export declare class OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificateOutputReference;
}
export interface OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecret {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#key_vault_id OrchestratedVirtualMachineScaleSet#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#certificate OrchestratedVirtualMachineScaleSet#certificate}
    */
    readonly certificate: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificate[] | cdktf.IResolvable;
}
export declare function orchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretToTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecret | cdktf.IResolvable): any;
export declare function orchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecret | cdktf.IResolvable): any;
export declare class OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecret | cdktf.IResolvable | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecret | cdktf.IResolvable | undefined);
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    private _certificate;
    get certificate(): OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificateList;
    putCertificate(value: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificate[] | cdktf.IResolvable): void;
    get certificateInput(): cdktf.IResolvable | OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificate[] | undefined;
}
export declare class OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecret[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretOutputReference;
}
export interface OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListener {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#certificate_url OrchestratedVirtualMachineScaleSet#certificate_url}
    */
    readonly certificateUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#protocol OrchestratedVirtualMachineScaleSet#protocol}
    */
    readonly protocol: string;
}
export declare function orchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListenerToTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListener | cdktf.IResolvable): any;
export declare function orchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListenerToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListener | cdktf.IResolvable): any;
export declare class OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListenerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListener | cdktf.IResolvable | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListener | cdktf.IResolvable | undefined);
    private _certificateUrl?;
    get certificateUrl(): string;
    set certificateUrl(value: string);
    resetCertificateUrl(): void;
    get certificateUrlInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
}
export declare class OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListenerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListener[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListenerOutputReference;
}
export interface OrchestratedVirtualMachineScaleSetOsProfileWindowsConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#admin_password OrchestratedVirtualMachineScaleSet#admin_password}
    */
    readonly adminPassword: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#admin_username OrchestratedVirtualMachineScaleSet#admin_username}
    */
    readonly adminUsername: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#computer_name_prefix OrchestratedVirtualMachineScaleSet#computer_name_prefix}
    */
    readonly computerNamePrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#enable_automatic_updates OrchestratedVirtualMachineScaleSet#enable_automatic_updates}
    */
    readonly enableAutomaticUpdates?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#hotpatching_enabled OrchestratedVirtualMachineScaleSet#hotpatching_enabled}
    */
    readonly hotpatchingEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#patch_assessment_mode OrchestratedVirtualMachineScaleSet#patch_assessment_mode}
    */
    readonly patchAssessmentMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#patch_mode OrchestratedVirtualMachineScaleSet#patch_mode}
    */
    readonly patchMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#provision_vm_agent OrchestratedVirtualMachineScaleSet#provision_vm_agent}
    */
    readonly provisionVmAgent?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#timezone OrchestratedVirtualMachineScaleSet#timezone}
    */
    readonly timezone?: string;
    /**
    * additional_unattend_content block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#additional_unattend_content OrchestratedVirtualMachineScaleSet#additional_unattend_content}
    */
    readonly additionalUnattendContent?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationAdditionalUnattendContent[] | cdktf.IResolvable;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#secret OrchestratedVirtualMachineScaleSet#secret}
    */
    readonly secret?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecret[] | cdktf.IResolvable;
    /**
    * winrm_listener block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#winrm_listener OrchestratedVirtualMachineScaleSet#winrm_listener}
    */
    readonly winrmListener?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListener[] | cdktf.IResolvable;
}
export declare function orchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationToTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationOutputReference | OrchestratedVirtualMachineScaleSetOsProfileWindowsConfiguration): any;
export declare function orchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationOutputReference | OrchestratedVirtualMachineScaleSetOsProfileWindowsConfiguration): any;
export declare class OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrchestratedVirtualMachineScaleSetOsProfileWindowsConfiguration | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfiguration | undefined);
    private _adminPassword?;
    get adminPassword(): string;
    set adminPassword(value: string);
    get adminPasswordInput(): string | undefined;
    private _adminUsername?;
    get adminUsername(): string;
    set adminUsername(value: string);
    get adminUsernameInput(): string | undefined;
    private _computerNamePrefix?;
    get computerNamePrefix(): string;
    set computerNamePrefix(value: string);
    resetComputerNamePrefix(): void;
    get computerNamePrefixInput(): string | undefined;
    private _enableAutomaticUpdates?;
    get enableAutomaticUpdates(): boolean | cdktf.IResolvable;
    set enableAutomaticUpdates(value: boolean | cdktf.IResolvable);
    resetEnableAutomaticUpdates(): void;
    get enableAutomaticUpdatesInput(): boolean | cdktf.IResolvable | undefined;
    private _hotpatchingEnabled?;
    get hotpatchingEnabled(): boolean | cdktf.IResolvable;
    set hotpatchingEnabled(value: boolean | cdktf.IResolvable);
    resetHotpatchingEnabled(): void;
    get hotpatchingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _patchAssessmentMode?;
    get patchAssessmentMode(): string;
    set patchAssessmentMode(value: string);
    resetPatchAssessmentMode(): void;
    get patchAssessmentModeInput(): string | undefined;
    private _patchMode?;
    get patchMode(): string;
    set patchMode(value: string);
    resetPatchMode(): void;
    get patchModeInput(): string | undefined;
    private _provisionVmAgent?;
    get provisionVmAgent(): boolean | cdktf.IResolvable;
    set provisionVmAgent(value: boolean | cdktf.IResolvable);
    resetProvisionVmAgent(): void;
    get provisionVmAgentInput(): boolean | cdktf.IResolvable | undefined;
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    resetTimezone(): void;
    get timezoneInput(): string | undefined;
    private _additionalUnattendContent;
    get additionalUnattendContent(): OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationAdditionalUnattendContentList;
    putAdditionalUnattendContent(value: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationAdditionalUnattendContent[] | cdktf.IResolvable): void;
    resetAdditionalUnattendContent(): void;
    get additionalUnattendContentInput(): cdktf.IResolvable | OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationAdditionalUnattendContent[] | undefined;
    private _secret;
    get secret(): OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretList;
    putSecret(value: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecret[] | cdktf.IResolvable): void;
    resetSecret(): void;
    get secretInput(): cdktf.IResolvable | OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecret[] | undefined;
    private _winrmListener;
    get winrmListener(): OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListenerList;
    putWinrmListener(value: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListener[] | cdktf.IResolvable): void;
    resetWinrmListener(): void;
    get winrmListenerInput(): cdktf.IResolvable | OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListener[] | undefined;
}
export interface OrchestratedVirtualMachineScaleSetOsProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#custom_data OrchestratedVirtualMachineScaleSet#custom_data}
    */
    readonly customData?: string;
    /**
    * linux_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#linux_configuration OrchestratedVirtualMachineScaleSet#linux_configuration}
    */
    readonly linuxConfiguration?: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfiguration;
    /**
    * windows_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#windows_configuration OrchestratedVirtualMachineScaleSet#windows_configuration}
    */
    readonly windowsConfiguration?: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfiguration;
}
export declare function orchestratedVirtualMachineScaleSetOsProfileToTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileOutputReference | OrchestratedVirtualMachineScaleSetOsProfile): any;
export declare function orchestratedVirtualMachineScaleSetOsProfileToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetOsProfileOutputReference | OrchestratedVirtualMachineScaleSetOsProfile): any;
export declare class OrchestratedVirtualMachineScaleSetOsProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrchestratedVirtualMachineScaleSetOsProfile | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetOsProfile | undefined);
    private _customData?;
    get customData(): string;
    set customData(value: string);
    resetCustomData(): void;
    get customDataInput(): string | undefined;
    private _linuxConfiguration;
    get linuxConfiguration(): OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationOutputReference;
    putLinuxConfiguration(value: OrchestratedVirtualMachineScaleSetOsProfileLinuxConfiguration): void;
    resetLinuxConfiguration(): void;
    get linuxConfigurationInput(): OrchestratedVirtualMachineScaleSetOsProfileLinuxConfiguration | undefined;
    private _windowsConfiguration;
    get windowsConfiguration(): OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationOutputReference;
    putWindowsConfiguration(value: OrchestratedVirtualMachineScaleSetOsProfileWindowsConfiguration): void;
    resetWindowsConfiguration(): void;
    get windowsConfigurationInput(): OrchestratedVirtualMachineScaleSetOsProfileWindowsConfiguration | undefined;
}
export interface OrchestratedVirtualMachineScaleSetPlan {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#name OrchestratedVirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#product OrchestratedVirtualMachineScaleSet#product}
    */
    readonly product: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#publisher OrchestratedVirtualMachineScaleSet#publisher}
    */
    readonly publisher: string;
}
export declare function orchestratedVirtualMachineScaleSetPlanToTerraform(struct?: OrchestratedVirtualMachineScaleSetPlanOutputReference | OrchestratedVirtualMachineScaleSetPlan): any;
export declare function orchestratedVirtualMachineScaleSetPlanToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetPlanOutputReference | OrchestratedVirtualMachineScaleSetPlan): any;
export declare class OrchestratedVirtualMachineScaleSetPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrchestratedVirtualMachineScaleSetPlan | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetPlan | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _product?;
    get product(): string;
    set product(value: string);
    get productInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
}
export interface OrchestratedVirtualMachineScaleSetPriorityMix {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#base_regular_count OrchestratedVirtualMachineScaleSet#base_regular_count}
    */
    readonly baseRegularCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#regular_percentage_above_base OrchestratedVirtualMachineScaleSet#regular_percentage_above_base}
    */
    readonly regularPercentageAboveBase?: number;
}
export declare function orchestratedVirtualMachineScaleSetPriorityMixToTerraform(struct?: OrchestratedVirtualMachineScaleSetPriorityMixOutputReference | OrchestratedVirtualMachineScaleSetPriorityMix): any;
export declare function orchestratedVirtualMachineScaleSetPriorityMixToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetPriorityMixOutputReference | OrchestratedVirtualMachineScaleSetPriorityMix): any;
export declare class OrchestratedVirtualMachineScaleSetPriorityMixOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrchestratedVirtualMachineScaleSetPriorityMix | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetPriorityMix | undefined);
    private _baseRegularCount?;
    get baseRegularCount(): number;
    set baseRegularCount(value: number);
    resetBaseRegularCount(): void;
    get baseRegularCountInput(): number | undefined;
    private _regularPercentageAboveBase?;
    get regularPercentageAboveBase(): number;
    set regularPercentageAboveBase(value: number);
    resetRegularPercentageAboveBase(): void;
    get regularPercentageAboveBaseInput(): number | undefined;
}
export interface OrchestratedVirtualMachineScaleSetSourceImageReference {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#offer OrchestratedVirtualMachineScaleSet#offer}
    */
    readonly offer: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#publisher OrchestratedVirtualMachineScaleSet#publisher}
    */
    readonly publisher: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#sku OrchestratedVirtualMachineScaleSet#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#version OrchestratedVirtualMachineScaleSet#version}
    */
    readonly version: string;
}
export declare function orchestratedVirtualMachineScaleSetSourceImageReferenceToTerraform(struct?: OrchestratedVirtualMachineScaleSetSourceImageReferenceOutputReference | OrchestratedVirtualMachineScaleSetSourceImageReference): any;
export declare function orchestratedVirtualMachineScaleSetSourceImageReferenceToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetSourceImageReferenceOutputReference | OrchestratedVirtualMachineScaleSetSourceImageReference): any;
export declare class OrchestratedVirtualMachineScaleSetSourceImageReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrchestratedVirtualMachineScaleSetSourceImageReference | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetSourceImageReference | undefined);
    private _offer?;
    get offer(): string;
    set offer(value: string);
    get offerInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export interface OrchestratedVirtualMachineScaleSetTerminationNotification {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#enabled OrchestratedVirtualMachineScaleSet#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#timeout OrchestratedVirtualMachineScaleSet#timeout}
    */
    readonly timeout?: string;
}
export declare function orchestratedVirtualMachineScaleSetTerminationNotificationToTerraform(struct?: OrchestratedVirtualMachineScaleSetTerminationNotificationOutputReference | OrchestratedVirtualMachineScaleSetTerminationNotification): any;
export declare function orchestratedVirtualMachineScaleSetTerminationNotificationToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetTerminationNotificationOutputReference | OrchestratedVirtualMachineScaleSetTerminationNotification): any;
export declare class OrchestratedVirtualMachineScaleSetTerminationNotificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrchestratedVirtualMachineScaleSetTerminationNotification | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetTerminationNotification | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
}
export interface OrchestratedVirtualMachineScaleSetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#create OrchestratedVirtualMachineScaleSet#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#delete OrchestratedVirtualMachineScaleSet#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#read OrchestratedVirtualMachineScaleSet#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#update OrchestratedVirtualMachineScaleSet#update}
    */
    readonly update?: string;
}
export declare function orchestratedVirtualMachineScaleSetTimeoutsToTerraform(struct?: OrchestratedVirtualMachineScaleSetTimeouts | cdktf.IResolvable): any;
export declare function orchestratedVirtualMachineScaleSetTimeoutsToHclTerraform(struct?: OrchestratedVirtualMachineScaleSetTimeouts | cdktf.IResolvable): any;
export declare class OrchestratedVirtualMachineScaleSetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrchestratedVirtualMachineScaleSetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: OrchestratedVirtualMachineScaleSetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set azurerm_orchestrated_virtual_machine_scale_set}
*/
export declare class OrchestratedVirtualMachineScaleSet extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_orchestrated_virtual_machine_scale_set";
    /**
    * Generates CDKTF code for importing a OrchestratedVirtualMachineScaleSet resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the OrchestratedVirtualMachineScaleSet to import
    * @param importFromId The id of the existing OrchestratedVirtualMachineScaleSet that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the OrchestratedVirtualMachineScaleSet to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/orchestrated_virtual_machine_scale_set azurerm_orchestrated_virtual_machine_scale_set} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OrchestratedVirtualMachineScaleSetConfig
    */
    constructor(scope: Construct, id: string, config: OrchestratedVirtualMachineScaleSetConfig);
    private _capacityReservationGroupId?;
    get capacityReservationGroupId(): string;
    set capacityReservationGroupId(value: string);
    resetCapacityReservationGroupId(): void;
    get capacityReservationGroupIdInput(): string | undefined;
    private _encryptionAtHostEnabled?;
    get encryptionAtHostEnabled(): boolean | cdktf.IResolvable;
    set encryptionAtHostEnabled(value: boolean | cdktf.IResolvable);
    resetEncryptionAtHostEnabled(): void;
    get encryptionAtHostEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _evictionPolicy?;
    get evictionPolicy(): string;
    set evictionPolicy(value: string);
    resetEvictionPolicy(): void;
    get evictionPolicyInput(): string | undefined;
    private _extensionOperationsEnabled?;
    get extensionOperationsEnabled(): boolean | cdktf.IResolvable;
    set extensionOperationsEnabled(value: boolean | cdktf.IResolvable);
    resetExtensionOperationsEnabled(): void;
    get extensionOperationsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _extensionsTimeBudget?;
    get extensionsTimeBudget(): string;
    set extensionsTimeBudget(value: string);
    resetExtensionsTimeBudget(): void;
    get extensionsTimeBudgetInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instances?;
    get instances(): number;
    set instances(value: number);
    resetInstances(): void;
    get instancesInput(): number | undefined;
    private _licenseType?;
    get licenseType(): string;
    set licenseType(value: string);
    resetLicenseType(): void;
    get licenseTypeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _maxBidPrice?;
    get maxBidPrice(): number;
    set maxBidPrice(value: number);
    resetMaxBidPrice(): void;
    get maxBidPriceInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _platformFaultDomainCount?;
    get platformFaultDomainCount(): number;
    set platformFaultDomainCount(value: number);
    get platformFaultDomainCountInput(): number | undefined;
    private _priority?;
    get priority(): string;
    set priority(value: string);
    resetPriority(): void;
    get priorityInput(): string | undefined;
    private _proximityPlacementGroupId?;
    get proximityPlacementGroupId(): string;
    set proximityPlacementGroupId(value: string);
    resetProximityPlacementGroupId(): void;
    get proximityPlacementGroupIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _singlePlacementGroup?;
    get singlePlacementGroup(): boolean | cdktf.IResolvable;
    set singlePlacementGroup(value: boolean | cdktf.IResolvable);
    resetSinglePlacementGroup(): void;
    get singlePlacementGroupInput(): boolean | cdktf.IResolvable | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    resetSkuName(): void;
    get skuNameInput(): string | undefined;
    private _sourceImageId?;
    get sourceImageId(): string;
    set sourceImageId(value: string);
    resetSourceImageId(): void;
    get sourceImageIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get uniqueId(): string;
    private _userDataBase64?;
    get userDataBase64(): string;
    set userDataBase64(value: string);
    resetUserDataBase64(): void;
    get userDataBase64Input(): string | undefined;
    private _zoneBalance?;
    get zoneBalance(): boolean | cdktf.IResolvable;
    set zoneBalance(value: boolean | cdktf.IResolvable);
    resetZoneBalance(): void;
    get zoneBalanceInput(): boolean | cdktf.IResolvable | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _additionalCapabilities;
    get additionalCapabilities(): OrchestratedVirtualMachineScaleSetAdditionalCapabilitiesOutputReference;
    putAdditionalCapabilities(value: OrchestratedVirtualMachineScaleSetAdditionalCapabilities): void;
    resetAdditionalCapabilities(): void;
    get additionalCapabilitiesInput(): OrchestratedVirtualMachineScaleSetAdditionalCapabilities | undefined;
    private _automaticInstanceRepair;
    get automaticInstanceRepair(): OrchestratedVirtualMachineScaleSetAutomaticInstanceRepairOutputReference;
    putAutomaticInstanceRepair(value: OrchestratedVirtualMachineScaleSetAutomaticInstanceRepair): void;
    resetAutomaticInstanceRepair(): void;
    get automaticInstanceRepairInput(): OrchestratedVirtualMachineScaleSetAutomaticInstanceRepair | undefined;
    private _bootDiagnostics;
    get bootDiagnostics(): OrchestratedVirtualMachineScaleSetBootDiagnosticsOutputReference;
    putBootDiagnostics(value: OrchestratedVirtualMachineScaleSetBootDiagnostics): void;
    resetBootDiagnostics(): void;
    get bootDiagnosticsInput(): OrchestratedVirtualMachineScaleSetBootDiagnostics | undefined;
    private _dataDisk;
    get dataDisk(): OrchestratedVirtualMachineScaleSetDataDiskList;
    putDataDisk(value: OrchestratedVirtualMachineScaleSetDataDisk[] | cdktf.IResolvable): void;
    resetDataDisk(): void;
    get dataDiskInput(): cdktf.IResolvable | OrchestratedVirtualMachineScaleSetDataDisk[] | undefined;
    private _extension;
    get extension(): OrchestratedVirtualMachineScaleSetExtensionList;
    putExtension(value: OrchestratedVirtualMachineScaleSetExtension[] | cdktf.IResolvable): void;
    resetExtension(): void;
    get extensionInput(): cdktf.IResolvable | OrchestratedVirtualMachineScaleSetExtension[] | undefined;
    private _identity;
    get identity(): OrchestratedVirtualMachineScaleSetIdentityOutputReference;
    putIdentity(value: OrchestratedVirtualMachineScaleSetIdentity): void;
    resetIdentity(): void;
    get identityInput(): OrchestratedVirtualMachineScaleSetIdentity | undefined;
    private _networkInterface;
    get networkInterface(): OrchestratedVirtualMachineScaleSetNetworkInterfaceList;
    putNetworkInterface(value: OrchestratedVirtualMachineScaleSetNetworkInterface[] | cdktf.IResolvable): void;
    resetNetworkInterface(): void;
    get networkInterfaceInput(): cdktf.IResolvable | OrchestratedVirtualMachineScaleSetNetworkInterface[] | undefined;
    private _osDisk;
    get osDisk(): OrchestratedVirtualMachineScaleSetOsDiskOutputReference;
    putOsDisk(value: OrchestratedVirtualMachineScaleSetOsDisk): void;
    resetOsDisk(): void;
    get osDiskInput(): OrchestratedVirtualMachineScaleSetOsDisk | undefined;
    private _osProfile;
    get osProfile(): OrchestratedVirtualMachineScaleSetOsProfileOutputReference;
    putOsProfile(value: OrchestratedVirtualMachineScaleSetOsProfile): void;
    resetOsProfile(): void;
    get osProfileInput(): OrchestratedVirtualMachineScaleSetOsProfile | undefined;
    private _plan;
    get plan(): OrchestratedVirtualMachineScaleSetPlanOutputReference;
    putPlan(value: OrchestratedVirtualMachineScaleSetPlan): void;
    resetPlan(): void;
    get planInput(): OrchestratedVirtualMachineScaleSetPlan | undefined;
    private _priorityMix;
    get priorityMix(): OrchestratedVirtualMachineScaleSetPriorityMixOutputReference;
    putPriorityMix(value: OrchestratedVirtualMachineScaleSetPriorityMix): void;
    resetPriorityMix(): void;
    get priorityMixInput(): OrchestratedVirtualMachineScaleSetPriorityMix | undefined;
    private _sourceImageReference;
    get sourceImageReference(): OrchestratedVirtualMachineScaleSetSourceImageReferenceOutputReference;
    putSourceImageReference(value: OrchestratedVirtualMachineScaleSetSourceImageReference): void;
    resetSourceImageReference(): void;
    get sourceImageReferenceInput(): OrchestratedVirtualMachineScaleSetSourceImageReference | undefined;
    private _terminationNotification;
    get terminationNotification(): OrchestratedVirtualMachineScaleSetTerminationNotificationOutputReference;
    putTerminationNotification(value: OrchestratedVirtualMachineScaleSetTerminationNotification): void;
    resetTerminationNotification(): void;
    get terminationNotificationInput(): OrchestratedVirtualMachineScaleSetTerminationNotification | undefined;
    private _timeouts;
    get timeouts(): OrchestratedVirtualMachineScaleSetTimeoutsOutputReference;
    putTimeouts(value: OrchestratedVirtualMachineScaleSetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | OrchestratedVirtualMachineScaleSetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
