/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SpringCloudConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection#client_type SpringCloudConnection#client_type}
    */
    readonly clientType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection#id SpringCloudConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection#name SpringCloudConnection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection#spring_cloud_id SpringCloudConnection#spring_cloud_id}
    */
    readonly springCloudId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection#target_resource_id SpringCloudConnection#target_resource_id}
    */
    readonly targetResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection#vnet_solution SpringCloudConnection#vnet_solution}
    */
    readonly vnetSolution?: string;
    /**
    * authentication block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection#authentication SpringCloudConnection#authentication}
    */
    readonly authentication: SpringCloudConnectionAuthentication;
    /**
    * secret_store block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection#secret_store SpringCloudConnection#secret_store}
    */
    readonly secretStore?: SpringCloudConnectionSecretStore;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection#timeouts SpringCloudConnection#timeouts}
    */
    readonly timeouts?: SpringCloudConnectionTimeouts;
}
export interface SpringCloudConnectionAuthentication {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection#certificate SpringCloudConnection#certificate}
    */
    readonly certificate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection#client_id SpringCloudConnection#client_id}
    */
    readonly clientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection#name SpringCloudConnection#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection#principal_id SpringCloudConnection#principal_id}
    */
    readonly principalId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection#secret SpringCloudConnection#secret}
    */
    readonly secret?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection#subscription_id SpringCloudConnection#subscription_id}
    */
    readonly subscriptionId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection#type SpringCloudConnection#type}
    */
    readonly type: string;
}
export declare function springCloudConnectionAuthenticationToTerraform(struct?: SpringCloudConnectionAuthenticationOutputReference | SpringCloudConnectionAuthentication): any;
export declare function springCloudConnectionAuthenticationToHclTerraform(struct?: SpringCloudConnectionAuthenticationOutputReference | SpringCloudConnectionAuthentication): any;
export declare class SpringCloudConnectionAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudConnectionAuthentication | undefined;
    set internalValue(value: SpringCloudConnectionAuthentication | undefined);
    private _certificate?;
    get certificate(): string;
    set certificate(value: string);
    resetCertificate(): void;
    get certificateInput(): string | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _principalId?;
    get principalId(): string;
    set principalId(value: string);
    resetPrincipalId(): void;
    get principalIdInput(): string | undefined;
    private _secret?;
    get secret(): string;
    set secret(value: string);
    resetSecret(): void;
    get secretInput(): string | undefined;
    private _subscriptionId?;
    get subscriptionId(): string;
    set subscriptionId(value: string);
    resetSubscriptionId(): void;
    get subscriptionIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface SpringCloudConnectionSecretStore {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection#key_vault_id SpringCloudConnection#key_vault_id}
    */
    readonly keyVaultId: string;
}
export declare function springCloudConnectionSecretStoreToTerraform(struct?: SpringCloudConnectionSecretStoreOutputReference | SpringCloudConnectionSecretStore): any;
export declare function springCloudConnectionSecretStoreToHclTerraform(struct?: SpringCloudConnectionSecretStoreOutputReference | SpringCloudConnectionSecretStore): any;
export declare class SpringCloudConnectionSecretStoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudConnectionSecretStore | undefined;
    set internalValue(value: SpringCloudConnectionSecretStore | undefined);
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
}
export interface SpringCloudConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection#create SpringCloudConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection#delete SpringCloudConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection#read SpringCloudConnection#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection#update SpringCloudConnection#update}
    */
    readonly update?: string;
}
export declare function springCloudConnectionTimeoutsToTerraform(struct?: SpringCloudConnectionTimeouts | cdktf.IResolvable): any;
export declare function springCloudConnectionTimeoutsToHclTerraform(struct?: SpringCloudConnectionTimeouts | cdktf.IResolvable): any;
export declare class SpringCloudConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SpringCloudConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection azurerm_spring_cloud_connection}
*/
export declare class SpringCloudConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_spring_cloud_connection";
    /**
    * Generates CDKTF code for importing a SpringCloudConnection resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SpringCloudConnection to import
    * @param importFromId The id of the existing SpringCloudConnection that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SpringCloudConnection to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/spring_cloud_connection azurerm_spring_cloud_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SpringCloudConnectionConfig
    */
    constructor(scope: Construct, id: string, config: SpringCloudConnectionConfig);
    private _clientType?;
    get clientType(): string;
    set clientType(value: string);
    resetClientType(): void;
    get clientTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _springCloudId?;
    get springCloudId(): string;
    set springCloudId(value: string);
    get springCloudIdInput(): string | undefined;
    private _targetResourceId?;
    get targetResourceId(): string;
    set targetResourceId(value: string);
    get targetResourceIdInput(): string | undefined;
    private _vnetSolution?;
    get vnetSolution(): string;
    set vnetSolution(value: string);
    resetVnetSolution(): void;
    get vnetSolutionInput(): string | undefined;
    private _authentication;
    get authentication(): SpringCloudConnectionAuthenticationOutputReference;
    putAuthentication(value: SpringCloudConnectionAuthentication): void;
    get authenticationInput(): SpringCloudConnectionAuthentication | undefined;
    private _secretStore;
    get secretStore(): SpringCloudConnectionSecretStoreOutputReference;
    putSecretStore(value: SpringCloudConnectionSecretStore): void;
    resetSecretStore(): void;
    get secretStoreInput(): SpringCloudConnectionSecretStore | undefined;
    private _timeouts;
    get timeouts(): SpringCloudConnectionTimeoutsOutputReference;
    putTimeouts(value: SpringCloudConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SpringCloudConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
