/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageContainerImmutabilityPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/storage_container_immutability_policy#id StorageContainerImmutabilityPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/storage_container_immutability_policy#immutability_period_in_days StorageContainerImmutabilityPolicy#immutability_period_in_days}
    */
    readonly immutabilityPeriodInDays: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/storage_container_immutability_policy#locked StorageContainerImmutabilityPolicy#locked}
    */
    readonly locked?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/storage_container_immutability_policy#protected_append_writes_all_enabled StorageContainerImmutabilityPolicy#protected_append_writes_all_enabled}
    */
    readonly protectedAppendWritesAllEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/storage_container_immutability_policy#protected_append_writes_enabled StorageContainerImmutabilityPolicy#protected_append_writes_enabled}
    */
    readonly protectedAppendWritesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/storage_container_immutability_policy#storage_container_resource_manager_id StorageContainerImmutabilityPolicy#storage_container_resource_manager_id}
    */
    readonly storageContainerResourceManagerId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/storage_container_immutability_policy#timeouts StorageContainerImmutabilityPolicy#timeouts}
    */
    readonly timeouts?: StorageContainerImmutabilityPolicyTimeouts;
}
export interface StorageContainerImmutabilityPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/storage_container_immutability_policy#create StorageContainerImmutabilityPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/storage_container_immutability_policy#delete StorageContainerImmutabilityPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/storage_container_immutability_policy#read StorageContainerImmutabilityPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/storage_container_immutability_policy#update StorageContainerImmutabilityPolicy#update}
    */
    readonly update?: string;
}
export declare function storageContainerImmutabilityPolicyTimeoutsToTerraform(struct?: StorageContainerImmutabilityPolicyTimeouts | cdktf.IResolvable): any;
export declare function storageContainerImmutabilityPolicyTimeoutsToHclTerraform(struct?: StorageContainerImmutabilityPolicyTimeouts | cdktf.IResolvable): any;
export declare class StorageContainerImmutabilityPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageContainerImmutabilityPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StorageContainerImmutabilityPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/storage_container_immutability_policy azurerm_storage_container_immutability_policy}
*/
export declare class StorageContainerImmutabilityPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_storage_container_immutability_policy";
    /**
    * Generates CDKTF code for importing a StorageContainerImmutabilityPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StorageContainerImmutabilityPolicy to import
    * @param importFromId The id of the existing StorageContainerImmutabilityPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/storage_container_immutability_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StorageContainerImmutabilityPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/storage_container_immutability_policy azurerm_storage_container_immutability_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageContainerImmutabilityPolicyConfig
    */
    constructor(scope: Construct, id: string, config: StorageContainerImmutabilityPolicyConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _immutabilityPeriodInDays?;
    get immutabilityPeriodInDays(): number;
    set immutabilityPeriodInDays(value: number);
    get immutabilityPeriodInDaysInput(): number | undefined;
    private _locked?;
    get locked(): boolean | cdktf.IResolvable;
    set locked(value: boolean | cdktf.IResolvable);
    resetLocked(): void;
    get lockedInput(): boolean | cdktf.IResolvable | undefined;
    private _protectedAppendWritesAllEnabled?;
    get protectedAppendWritesAllEnabled(): boolean | cdktf.IResolvable;
    set protectedAppendWritesAllEnabled(value: boolean | cdktf.IResolvable);
    resetProtectedAppendWritesAllEnabled(): void;
    get protectedAppendWritesAllEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _protectedAppendWritesEnabled?;
    get protectedAppendWritesEnabled(): boolean | cdktf.IResolvable;
    set protectedAppendWritesEnabled(value: boolean | cdktf.IResolvable);
    resetProtectedAppendWritesEnabled(): void;
    get protectedAppendWritesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _storageContainerResourceManagerId?;
    get storageContainerResourceManagerId(): string;
    set storageContainerResourceManagerId(value: string);
    get storageContainerResourceManagerIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): StorageContainerImmutabilityPolicyTimeoutsOutputReference;
    putTimeouts(value: StorageContainerImmutabilityPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StorageContainerImmutabilityPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
