/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SubnetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/subnet#address_prefixes Subnet#address_prefixes}
    */
    readonly addressPrefixes: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/subnet#default_outbound_access_enabled Subnet#default_outbound_access_enabled}
    */
    readonly defaultOutboundAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/subnet#id Subnet#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/subnet#name Subnet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/subnet#private_endpoint_network_policies Subnet#private_endpoint_network_policies}
    */
    readonly privateEndpointNetworkPolicies?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/subnet#private_link_service_network_policies_enabled Subnet#private_link_service_network_policies_enabled}
    */
    readonly privateLinkServiceNetworkPoliciesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/subnet#resource_group_name Subnet#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/subnet#service_endpoint_policy_ids Subnet#service_endpoint_policy_ids}
    */
    readonly serviceEndpointPolicyIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/subnet#service_endpoints Subnet#service_endpoints}
    */
    readonly serviceEndpoints?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/subnet#virtual_network_name Subnet#virtual_network_name}
    */
    readonly virtualNetworkName: string;
    /**
    * delegation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/subnet#delegation Subnet#delegation}
    */
    readonly delegation?: SubnetDelegation[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/subnet#timeouts Subnet#timeouts}
    */
    readonly timeouts?: SubnetTimeouts;
}
export interface SubnetDelegationServiceDelegation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/subnet#actions Subnet#actions}
    */
    readonly actions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/subnet#name Subnet#name}
    */
    readonly name: string;
}
export declare function subnetDelegationServiceDelegationToTerraform(struct?: SubnetDelegationServiceDelegationOutputReference | SubnetDelegationServiceDelegation): any;
export declare function subnetDelegationServiceDelegationToHclTerraform(struct?: SubnetDelegationServiceDelegationOutputReference | SubnetDelegationServiceDelegation): any;
export declare class SubnetDelegationServiceDelegationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SubnetDelegationServiceDelegation | undefined;
    set internalValue(value: SubnetDelegationServiceDelegation | undefined);
    private _actions?;
    get actions(): string[];
    set actions(value: string[]);
    resetActions(): void;
    get actionsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface SubnetDelegation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/subnet#name Subnet#name}
    */
    readonly name: string;
    /**
    * service_delegation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/subnet#service_delegation Subnet#service_delegation}
    */
    readonly serviceDelegation: SubnetDelegationServiceDelegation;
}
export declare function subnetDelegationToTerraform(struct?: SubnetDelegation | cdktf.IResolvable): any;
export declare function subnetDelegationToHclTerraform(struct?: SubnetDelegation | cdktf.IResolvable): any;
export declare class SubnetDelegationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SubnetDelegation | cdktf.IResolvable | undefined;
    set internalValue(value: SubnetDelegation | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _serviceDelegation;
    get serviceDelegation(): SubnetDelegationServiceDelegationOutputReference;
    putServiceDelegation(value: SubnetDelegationServiceDelegation): void;
    get serviceDelegationInput(): SubnetDelegationServiceDelegation | undefined;
}
export declare class SubnetDelegationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SubnetDelegation[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SubnetDelegationOutputReference;
}
export interface SubnetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/subnet#create Subnet#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/subnet#delete Subnet#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/subnet#read Subnet#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/subnet#update Subnet#update}
    */
    readonly update?: string;
}
export declare function subnetTimeoutsToTerraform(struct?: SubnetTimeouts | cdktf.IResolvable): any;
export declare function subnetTimeoutsToHclTerraform(struct?: SubnetTimeouts | cdktf.IResolvable): any;
export declare class SubnetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SubnetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SubnetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/subnet azurerm_subnet}
*/
export declare class Subnet extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_subnet";
    /**
    * Generates CDKTF code for importing a Subnet resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Subnet to import
    * @param importFromId The id of the existing Subnet that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/subnet#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Subnet to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/subnet azurerm_subnet} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SubnetConfig
    */
    constructor(scope: Construct, id: string, config: SubnetConfig);
    private _addressPrefixes?;
    get addressPrefixes(): string[];
    set addressPrefixes(value: string[]);
    get addressPrefixesInput(): string[] | undefined;
    private _defaultOutboundAccessEnabled?;
    get defaultOutboundAccessEnabled(): boolean | cdktf.IResolvable;
    set defaultOutboundAccessEnabled(value: boolean | cdktf.IResolvable);
    resetDefaultOutboundAccessEnabled(): void;
    get defaultOutboundAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privateEndpointNetworkPolicies?;
    get privateEndpointNetworkPolicies(): string;
    set privateEndpointNetworkPolicies(value: string);
    resetPrivateEndpointNetworkPolicies(): void;
    get privateEndpointNetworkPoliciesInput(): string | undefined;
    private _privateLinkServiceNetworkPoliciesEnabled?;
    get privateLinkServiceNetworkPoliciesEnabled(): boolean | cdktf.IResolvable;
    set privateLinkServiceNetworkPoliciesEnabled(value: boolean | cdktf.IResolvable);
    resetPrivateLinkServiceNetworkPoliciesEnabled(): void;
    get privateLinkServiceNetworkPoliciesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serviceEndpointPolicyIds?;
    get serviceEndpointPolicyIds(): string[];
    set serviceEndpointPolicyIds(value: string[]);
    resetServiceEndpointPolicyIds(): void;
    get serviceEndpointPolicyIdsInput(): string[] | undefined;
    private _serviceEndpoints?;
    get serviceEndpoints(): string[];
    set serviceEndpoints(value: string[]);
    resetServiceEndpoints(): void;
    get serviceEndpointsInput(): string[] | undefined;
    private _virtualNetworkName?;
    get virtualNetworkName(): string;
    set virtualNetworkName(value: string);
    get virtualNetworkNameInput(): string | undefined;
    private _delegation;
    get delegation(): SubnetDelegationList;
    putDelegation(value: SubnetDelegation[] | cdktf.IResolvable): void;
    resetDelegation(): void;
    get delegationInput(): cdktf.IResolvable | SubnetDelegation[] | undefined;
    private _timeouts;
    get timeouts(): SubnetTimeoutsOutputReference;
    putTimeouts(value: SubnetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SubnetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
