/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualMachinePacketCaptureConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/virtual_machine_packet_capture#id VirtualMachinePacketCapture#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/virtual_machine_packet_capture#maximum_bytes_per_packet VirtualMachinePacketCapture#maximum_bytes_per_packet}
    */
    readonly maximumBytesPerPacket?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/virtual_machine_packet_capture#maximum_bytes_per_session VirtualMachinePacketCapture#maximum_bytes_per_session}
    */
    readonly maximumBytesPerSession?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/virtual_machine_packet_capture#maximum_capture_duration_in_seconds VirtualMachinePacketCapture#maximum_capture_duration_in_seconds}
    */
    readonly maximumCaptureDurationInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/virtual_machine_packet_capture#name VirtualMachinePacketCapture#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/virtual_machine_packet_capture#network_watcher_id VirtualMachinePacketCapture#network_watcher_id}
    */
    readonly networkWatcherId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/virtual_machine_packet_capture#virtual_machine_id VirtualMachinePacketCapture#virtual_machine_id}
    */
    readonly virtualMachineId: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/virtual_machine_packet_capture#filter VirtualMachinePacketCapture#filter}
    */
    readonly filter?: VirtualMachinePacketCaptureFilter[] | cdktf.IResolvable;
    /**
    * storage_location block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/virtual_machine_packet_capture#storage_location VirtualMachinePacketCapture#storage_location}
    */
    readonly storageLocation: VirtualMachinePacketCaptureStorageLocation;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/virtual_machine_packet_capture#timeouts VirtualMachinePacketCapture#timeouts}
    */
    readonly timeouts?: VirtualMachinePacketCaptureTimeouts;
}
export interface VirtualMachinePacketCaptureFilter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/virtual_machine_packet_capture#local_ip_address VirtualMachinePacketCapture#local_ip_address}
    */
    readonly localIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/virtual_machine_packet_capture#local_port VirtualMachinePacketCapture#local_port}
    */
    readonly localPort?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/virtual_machine_packet_capture#protocol VirtualMachinePacketCapture#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/virtual_machine_packet_capture#remote_ip_address VirtualMachinePacketCapture#remote_ip_address}
    */
    readonly remoteIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/virtual_machine_packet_capture#remote_port VirtualMachinePacketCapture#remote_port}
    */
    readonly remotePort?: string;
}
export declare function virtualMachinePacketCaptureFilterToTerraform(struct?: VirtualMachinePacketCaptureFilter | cdktf.IResolvable): any;
export declare function virtualMachinePacketCaptureFilterToHclTerraform(struct?: VirtualMachinePacketCaptureFilter | cdktf.IResolvable): any;
export declare class VirtualMachinePacketCaptureFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualMachinePacketCaptureFilter | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualMachinePacketCaptureFilter | cdktf.IResolvable | undefined);
    private _localIpAddress?;
    get localIpAddress(): string;
    set localIpAddress(value: string);
    resetLocalIpAddress(): void;
    get localIpAddressInput(): string | undefined;
    private _localPort?;
    get localPort(): string;
    set localPort(value: string);
    resetLocalPort(): void;
    get localPortInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _remoteIpAddress?;
    get remoteIpAddress(): string;
    set remoteIpAddress(value: string);
    resetRemoteIpAddress(): void;
    get remoteIpAddressInput(): string | undefined;
    private _remotePort?;
    get remotePort(): string;
    set remotePort(value: string);
    resetRemotePort(): void;
    get remotePortInput(): string | undefined;
}
export declare class VirtualMachinePacketCaptureFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualMachinePacketCaptureFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualMachinePacketCaptureFilterOutputReference;
}
export interface VirtualMachinePacketCaptureStorageLocation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/virtual_machine_packet_capture#file_path VirtualMachinePacketCapture#file_path}
    */
    readonly filePath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/virtual_machine_packet_capture#storage_account_id VirtualMachinePacketCapture#storage_account_id}
    */
    readonly storageAccountId?: string;
}
export declare function virtualMachinePacketCaptureStorageLocationToTerraform(struct?: VirtualMachinePacketCaptureStorageLocationOutputReference | VirtualMachinePacketCaptureStorageLocation): any;
export declare function virtualMachinePacketCaptureStorageLocationToHclTerraform(struct?: VirtualMachinePacketCaptureStorageLocationOutputReference | VirtualMachinePacketCaptureStorageLocation): any;
export declare class VirtualMachinePacketCaptureStorageLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachinePacketCaptureStorageLocation | undefined;
    set internalValue(value: VirtualMachinePacketCaptureStorageLocation | undefined);
    private _filePath?;
    get filePath(): string;
    set filePath(value: string);
    resetFilePath(): void;
    get filePathInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    resetStorageAccountId(): void;
    get storageAccountIdInput(): string | undefined;
    get storagePath(): string;
}
export interface VirtualMachinePacketCaptureTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/virtual_machine_packet_capture#create VirtualMachinePacketCapture#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/virtual_machine_packet_capture#delete VirtualMachinePacketCapture#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/virtual_machine_packet_capture#read VirtualMachinePacketCapture#read}
    */
    readonly read?: string;
}
export declare function virtualMachinePacketCaptureTimeoutsToTerraform(struct?: VirtualMachinePacketCaptureTimeouts | cdktf.IResolvable): any;
export declare function virtualMachinePacketCaptureTimeoutsToHclTerraform(struct?: VirtualMachinePacketCaptureTimeouts | cdktf.IResolvable): any;
export declare class VirtualMachinePacketCaptureTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachinePacketCaptureTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualMachinePacketCaptureTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/virtual_machine_packet_capture azurerm_virtual_machine_packet_capture}
*/
export declare class VirtualMachinePacketCapture extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_virtual_machine_packet_capture";
    /**
    * Generates CDKTF code for importing a VirtualMachinePacketCapture resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VirtualMachinePacketCapture to import
    * @param importFromId The id of the existing VirtualMachinePacketCapture that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/virtual_machine_packet_capture#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VirtualMachinePacketCapture to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.1.0/docs/resources/virtual_machine_packet_capture azurerm_virtual_machine_packet_capture} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualMachinePacketCaptureConfig
    */
    constructor(scope: Construct, id: string, config: VirtualMachinePacketCaptureConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maximumBytesPerPacket?;
    get maximumBytesPerPacket(): number;
    set maximumBytesPerPacket(value: number);
    resetMaximumBytesPerPacket(): void;
    get maximumBytesPerPacketInput(): number | undefined;
    private _maximumBytesPerSession?;
    get maximumBytesPerSession(): number;
    set maximumBytesPerSession(value: number);
    resetMaximumBytesPerSession(): void;
    get maximumBytesPerSessionInput(): number | undefined;
    private _maximumCaptureDurationInSeconds?;
    get maximumCaptureDurationInSeconds(): number;
    set maximumCaptureDurationInSeconds(value: number);
    resetMaximumCaptureDurationInSeconds(): void;
    get maximumCaptureDurationInSecondsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkWatcherId?;
    get networkWatcherId(): string;
    set networkWatcherId(value: string);
    get networkWatcherIdInput(): string | undefined;
    private _virtualMachineId?;
    get virtualMachineId(): string;
    set virtualMachineId(value: string);
    get virtualMachineIdInput(): string | undefined;
    private _filter;
    get filter(): VirtualMachinePacketCaptureFilterList;
    putFilter(value: VirtualMachinePacketCaptureFilter[] | cdktf.IResolvable): void;
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | VirtualMachinePacketCaptureFilter[] | undefined;
    private _storageLocation;
    get storageLocation(): VirtualMachinePacketCaptureStorageLocationOutputReference;
    putStorageLocation(value: VirtualMachinePacketCaptureStorageLocation): void;
    get storageLocationInput(): VirtualMachinePacketCaptureStorageLocation | undefined;
    private _timeouts;
    get timeouts(): VirtualMachinePacketCaptureTimeoutsOutputReference;
    putTimeouts(value: VirtualMachinePacketCaptureTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VirtualMachinePacketCaptureTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
