# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc
import warnings

from . import query_pb2 as query__pb2
from . import response_pb2 as response__pb2
from . import transaction_pb2 as transaction__pb2
from . import transaction_response_pb2 as transaction__response__pb2

GRPC_GENERATED_VERSION = '1.68.1'
GRPC_VERSION = grpc.__version__
_version_not_supported = False

try:
    from grpc._utilities import first_version_is_lower
    _version_not_supported = first_version_is_lower(GRPC_VERSION, GRPC_GENERATED_VERSION)
except ImportError:
    _version_not_supported = True

if _version_not_supported:
    raise RuntimeError(
        f'The grpc package installed is at version {GRPC_VERSION},'
        + f' but the generated code in schedule_service_pb2_grpc.py depends on'
        + f' grpcio>={GRPC_GENERATED_VERSION}.'
        + f' Please upgrade your grpc module to grpcio>={GRPC_GENERATED_VERSION}'
        + f' or downgrade your generated code using grpcio-tools<={GRPC_VERSION}.'
    )


class ScheduleServiceStub(object):
    """*
    Transactions and queries for the Schedule Service

    The Schedule Service allows transactions to be submitted without all the required signatures and
    allows anyone to provide the required signatures independently after a transaction has already
    been created. The transactions can be executed immediately when all required signatures are received
    or at a future date if Long Term Scheduled Transactions are enabled.

    Execution:

    Scheduled Transactions are executed in two different modes.

    1. If Long Term Scheduled Transactions are enabled and <tt>wait_for_expiry</tt> was set to <tt>true</tt> on the
    <tt>ScheduleCreate</tt>, then the transaction will be executed at the <tt>expiration_time</tt> specified on the
    <tt>ScheduleCreate</tt>.

    2. Otherwise Scheduled Transactions are executed once all required signatures are collected and witnessed.
    Every time new signature is provided, a check is performed on the "readiness" of the execution.
    The Scheduled Transaction will be executed immediately after the transaction that triggered it.

    NOTICE:
    A Scheduled Transaction being ready to execute, or even not ready to execute, at the time a <tt>ScheduleCreate</tt> or
    <tt>ScheduleSign</tt> comes in does not guarantee it will stay that way. Any number of things can happen over time that
    impact the transaction.

    For example, account keys can change, accounts can be deleted, and account balances can change.

    A particularly noteworthy case is if Long Term Scheduled Transactions are enabled and signature requirements for a Scheduled
    Transaction change such that existing signatures become sufficient to allow the transaction to go through. In this case the transaction
    will execute at expiration_time unless a ScheduleSign comes in to push it through.

    Transaction Record:

    If a Scheduled Transaction is executed immediately following the transaction that provided all required signatures,
    the timestamp of the Scheduled Transaction will be equal to consensusTimestamp + 1 nano, where
    consensusTimestamp is the timestamp of the transaction that triggered the execution.

    The Transaction ID of the Scheduled Transaction will have the scheduled property set to true and
    inherit the <tt>transactionValidStart</tt> and <tt>accountID</tt> from the <tt>ScheduleCreate</tt> transaction.

    The <tt>scheduleRef</tt> property of the transaction record will be populated with the <tt>ScheduleID</tt> of the
    Scheduled Transaction.

    Post execution:

    After execution, a Scheduled Transaction will remain in state and can be queried using <tt>GetScheduleInfo</tt> until expiration.

    Expiry:

    The expiration time of a schedule is controlled by it's <tt>expiration_time</tt>. If Long Term Scheduled Transactions are disabled,
    the <tt>expiration_time</tt> is always 30 minutes in the future.

    Once a given Scheduled Transaction expires, it will be removed from the ledger and any upcoming
    operation referring the ScheduleID will resolve to INVALID_SCHEDULE_ID.

    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.createSchedule = channel.unary_unary(
                '/proto.ScheduleService/createSchedule',
                request_serializer=transaction__pb2.Transaction.SerializeToString,
                response_deserializer=transaction__response__pb2.TransactionResponse.FromString,
                _registered_method=True)
        self.signSchedule = channel.unary_unary(
                '/proto.ScheduleService/signSchedule',
                request_serializer=transaction__pb2.Transaction.SerializeToString,
                response_deserializer=transaction__response__pb2.TransactionResponse.FromString,
                _registered_method=True)
        self.deleteSchedule = channel.unary_unary(
                '/proto.ScheduleService/deleteSchedule',
                request_serializer=transaction__pb2.Transaction.SerializeToString,
                response_deserializer=transaction__response__pb2.TransactionResponse.FromString,
                _registered_method=True)
        self.getScheduleInfo = channel.unary_unary(
                '/proto.ScheduleService/getScheduleInfo',
                request_serializer=query__pb2.Query.SerializeToString,
                response_deserializer=response__pb2.Response.FromString,
                _registered_method=True)


class ScheduleServiceServicer(object):
    """*
    Transactions and queries for the Schedule Service

    The Schedule Service allows transactions to be submitted without all the required signatures and
    allows anyone to provide the required signatures independently after a transaction has already
    been created. The transactions can be executed immediately when all required signatures are received
    or at a future date if Long Term Scheduled Transactions are enabled.

    Execution:

    Scheduled Transactions are executed in two different modes.

    1. If Long Term Scheduled Transactions are enabled and <tt>wait_for_expiry</tt> was set to <tt>true</tt> on the
    <tt>ScheduleCreate</tt>, then the transaction will be executed at the <tt>expiration_time</tt> specified on the
    <tt>ScheduleCreate</tt>.

    2. Otherwise Scheduled Transactions are executed once all required signatures are collected and witnessed.
    Every time new signature is provided, a check is performed on the "readiness" of the execution.
    The Scheduled Transaction will be executed immediately after the transaction that triggered it.

    NOTICE:
    A Scheduled Transaction being ready to execute, or even not ready to execute, at the time a <tt>ScheduleCreate</tt> or
    <tt>ScheduleSign</tt> comes in does not guarantee it will stay that way. Any number of things can happen over time that
    impact the transaction.

    For example, account keys can change, accounts can be deleted, and account balances can change.

    A particularly noteworthy case is if Long Term Scheduled Transactions are enabled and signature requirements for a Scheduled
    Transaction change such that existing signatures become sufficient to allow the transaction to go through. In this case the transaction
    will execute at expiration_time unless a ScheduleSign comes in to push it through.

    Transaction Record:

    If a Scheduled Transaction is executed immediately following the transaction that provided all required signatures,
    the timestamp of the Scheduled Transaction will be equal to consensusTimestamp + 1 nano, where
    consensusTimestamp is the timestamp of the transaction that triggered the execution.

    The Transaction ID of the Scheduled Transaction will have the scheduled property set to true and
    inherit the <tt>transactionValidStart</tt> and <tt>accountID</tt> from the <tt>ScheduleCreate</tt> transaction.

    The <tt>scheduleRef</tt> property of the transaction record will be populated with the <tt>ScheduleID</tt> of the
    Scheduled Transaction.

    Post execution:

    After execution, a Scheduled Transaction will remain in state and can be queried using <tt>GetScheduleInfo</tt> until expiration.

    Expiry:

    The expiration time of a schedule is controlled by it's <tt>expiration_time</tt>. If Long Term Scheduled Transactions are disabled,
    the <tt>expiration_time</tt> is always 30 minutes in the future.

    Once a given Scheduled Transaction expires, it will be removed from the ledger and any upcoming
    operation referring the ScheduleID will resolve to INVALID_SCHEDULE_ID.

    """

    def createSchedule(self, request, context):
        """*
        Creates a new Schedule by submitting the transaction
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def signSchedule(self, request, context):
        """*
        Signs a new Schedule by submitting the transaction
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def deleteSchedule(self, request, context):
        """*
        Deletes a new Schedule by submitting the transaction
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getScheduleInfo(self, request, context):
        """*
        Retrieves the metadata of a schedule entity
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_ScheduleServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'createSchedule': grpc.unary_unary_rpc_method_handler(
                    servicer.createSchedule,
                    request_deserializer=transaction__pb2.Transaction.FromString,
                    response_serializer=transaction__response__pb2.TransactionResponse.SerializeToString,
            ),
            'signSchedule': grpc.unary_unary_rpc_method_handler(
                    servicer.signSchedule,
                    request_deserializer=transaction__pb2.Transaction.FromString,
                    response_serializer=transaction__response__pb2.TransactionResponse.SerializeToString,
            ),
            'deleteSchedule': grpc.unary_unary_rpc_method_handler(
                    servicer.deleteSchedule,
                    request_deserializer=transaction__pb2.Transaction.FromString,
                    response_serializer=transaction__response__pb2.TransactionResponse.SerializeToString,
            ),
            'getScheduleInfo': grpc.unary_unary_rpc_method_handler(
                    servicer.getScheduleInfo,
                    request_deserializer=query__pb2.Query.FromString,
                    response_serializer=response__pb2.Response.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'proto.ScheduleService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))
    server.add_registered_method_handlers('proto.ScheduleService', rpc_method_handlers)


 # This class is part of an EXPERIMENTAL API.
class ScheduleService(object):
    """*
    Transactions and queries for the Schedule Service

    The Schedule Service allows transactions to be submitted without all the required signatures and
    allows anyone to provide the required signatures independently after a transaction has already
    been created. The transactions can be executed immediately when all required signatures are received
    or at a future date if Long Term Scheduled Transactions are enabled.

    Execution:

    Scheduled Transactions are executed in two different modes.

    1. If Long Term Scheduled Transactions are enabled and <tt>wait_for_expiry</tt> was set to <tt>true</tt> on the
    <tt>ScheduleCreate</tt>, then the transaction will be executed at the <tt>expiration_time</tt> specified on the
    <tt>ScheduleCreate</tt>.

    2. Otherwise Scheduled Transactions are executed once all required signatures are collected and witnessed.
    Every time new signature is provided, a check is performed on the "readiness" of the execution.
    The Scheduled Transaction will be executed immediately after the transaction that triggered it.

    NOTICE:
    A Scheduled Transaction being ready to execute, or even not ready to execute, at the time a <tt>ScheduleCreate</tt> or
    <tt>ScheduleSign</tt> comes in does not guarantee it will stay that way. Any number of things can happen over time that
    impact the transaction.

    For example, account keys can change, accounts can be deleted, and account balances can change.

    A particularly noteworthy case is if Long Term Scheduled Transactions are enabled and signature requirements for a Scheduled
    Transaction change such that existing signatures become sufficient to allow the transaction to go through. In this case the transaction
    will execute at expiration_time unless a ScheduleSign comes in to push it through.

    Transaction Record:

    If a Scheduled Transaction is executed immediately following the transaction that provided all required signatures,
    the timestamp of the Scheduled Transaction will be equal to consensusTimestamp + 1 nano, where
    consensusTimestamp is the timestamp of the transaction that triggered the execution.

    The Transaction ID of the Scheduled Transaction will have the scheduled property set to true and
    inherit the <tt>transactionValidStart</tt> and <tt>accountID</tt> from the <tt>ScheduleCreate</tt> transaction.

    The <tt>scheduleRef</tt> property of the transaction record will be populated with the <tt>ScheduleID</tt> of the
    Scheduled Transaction.

    Post execution:

    After execution, a Scheduled Transaction will remain in state and can be queried using <tt>GetScheduleInfo</tt> until expiration.

    Expiry:

    The expiration time of a schedule is controlled by it's <tt>expiration_time</tt>. If Long Term Scheduled Transactions are disabled,
    the <tt>expiration_time</tt> is always 30 minutes in the future.

    Once a given Scheduled Transaction expires, it will be removed from the ledger and any upcoming
    operation referring the ScheduleID will resolve to INVALID_SCHEDULE_ID.

    """

    @staticmethod
    def createSchedule(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/proto.ScheduleService/createSchedule',
            transaction__pb2.Transaction.SerializeToString,
            transaction__response__pb2.TransactionResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def signSchedule(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/proto.ScheduleService/signSchedule',
            transaction__pb2.Transaction.SerializeToString,
            transaction__response__pb2.TransactionResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def deleteSchedule(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/proto.ScheduleService/deleteSchedule',
            transaction__pb2.Transaction.SerializeToString,
            transaction__response__pb2.TransactionResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def getScheduleInfo(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/proto.ScheduleService/getScheduleInfo',
            query__pb2.Query.SerializeToString,
            response__pb2.Response.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)
